;; Author: George-Alexandru Serea, Univeristy Politehnica of Bucharest, Romania, 2013
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;start
globals 
[
  ; butoane pentru interfata
  butoane
  ; cladiri monitorizate
  cladiri-monitorizate
  ; agenti pentru monitorizarea cladirilor => senzori
  senzori-monitorizare ;=> senzori
  ; elemente de monitorizare pentru interfata
  elemente-afisare
  ; cladiri
  cladiri
  spital
  baraj
  hidrocentrala
  centrala-nucleara
  gara-periferie
  gara-oras
  aeroport pista-aeroport pozitie-spawn-avioane
  ; sine si trenuri
  sina-1 sina-2 sina-3 sina-4 sine-tren
  tren-1 tren-2 tren-3 tren-4 ; trenuri ; nu este necesar deoarece toate au categoria feroviar
  
  ;setari pentru interfata
  limita-dreapta
  limita-jos
  ; variabile pentru trenuri
  timp-stationare-trenuri
  ; viteze:
  v-oameni v-masini v-autobuze v-camioane v-trenuri v-avioane 
  ; acceleratii:
  a-oameni a-masini a-autobuze a-camioane a-trenuri a-avioane
  ; distante dintre agenti
  d-oameni d-masini d-autobuze d-camioane d-trenuri d-avioane
  ; distante de franare
  df-oameni df-masini df-autobuze df-camioane df-trenuri df-avioane
  ; indici de virare
  vir-oameni vir-masini vir-autobuze vir-camioane vir-trenuri vir-avioane
  ; categorie
  cat-oameni cat-masini cat-autobuze cat-camioane cat-trenuri cat-avioane
  ; dimensiune
  dim-oameni dim-masini dim-autobuze dim-camioane dim-trenuri dim-avioane
  ; setari harta
  culoare-sosea culoare-trotuar latime-trotuar ; spatiu-cladiri marime-cladiri
  ; variabile plotare
  masini-plotate
  ; zona epicentru
  zona-epicentru
  ; pentru afisarea timpului de rulare
  timer-running
  timer-dummy
  last-tick-running
]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;breeds
; mobile agent types
breed [oameni om]
breed [masini masina]
breed [camioane camion]
breed [autobuze autobus]
breed [trenuri tren]
breed [avioane avion]
breed [copaci copac]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;agenti statici
; static agent types
breed [semafoare semafor]
breed [fiz-cladiri fiz-cladire] ;;overlay peste patch-uri?
breed [senzori senzor] ;; verifica starea unei anume cladiri

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;variabile agenti
; custom variables
patches-own
[
  nivel tip benzi id safe id-cladire stare alerta
  ; tip poate fi: interfata, iarba, cladire, aeroport, pista, sosea, trotuar
  ; safe va fi folosit pentru a restrictiona acesul masinilor pe anumite drumuri, i.e. drumurile de langa cladirile care ard
  ; id cladire este folosit de catre elementele din interfata pentru a identifica corect indicatorul
  ; stare este folosit pentru a detalia si mai mult indicatorul; exemple pentru campul stare: cutremur, incendiu, functional, etc...
  ; alerta este setat de catre senzori si este folosit pentru a aprinde 
]
turtles-own
[
  viteza acceleratie distanta distanta-franare virare categorie 
]
masini-own
[
  ales-viraj virez-stanga
]
autobuze-own
[
  ales-viraj virez-stanga
]
camioane-own
[
  ales-viraj virez-stanga
]
trenuri-own
[
  tren-id ; folosit pentru a identifica trenul. Locomotivele si vagoanele au id-ul acesta egal pentru fiecare tren in parte.
  timp-stationare ; exprimat in secunde, va fi folosit pentru oprirea trenului in gara
  timp-ajuns-gara ; momentul in care trenul a oprit in gara
  locomotiva ; este locomotiva?
  ;; pentru miscare se va folosi forward 1 sau forward -1. Heading ramane neschimbat.
]
avioane-own
[
  altitudine
  aterizeaza
  prabuseste
  tinta
]
senzori-own
[
  cladire-id
  eveniment-urmarit
  intensitate
  prag
  id-senzor
]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;setup;;
to setup
  clear-all  
  ; global variables setup:
  set butoane []
  set cladiri-monitorizate []
  set senzori-monitorizare []
  set-default-shape senzori "senzor"
  set-default-shape copaci "tree"
  set elemente-afisare []
  set cladiri []
  setup-globals
  ; environmental setup:
  setup-harta
  ; interface setup:
  setup-interfata
  ; agents setup:
  setup-agenti
  
  ;user-message (word "Nota: Trenurile sunt setate sa stationeze in gara " timp-stationare-trenuri " secunde si vor porni din starea de 'stationat'.\n\nTimpul se poate modifica pentru fiecare tren in parte folosind comanda in consola:\n\task tren-N [ set timp-stationare T ]")
  reset-timer
  reset-ticks
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;go;;
to go
  ; agent motion:
  orienteaza-agenti
  misca-agenti
  ; actualizeaza-monitorizarea ; ==> va fi apelat de catre functia generatoare de evenimente!
  tick
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;variabile globale
__includes ["_globals.nls"] ;; to setup-globals...

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;setup interfata;;
to setup-interfata
  
  ;adauga-elemente-monitorizare [ start-x-em start-y-em X-em Y-em dim-em spatiu-em id-em cladire-parinte stari-urmarite ]
  adauga-elemente-monitorizare -100 -36 6 1 3 2 ( [id] of one-of aeroport ) "Airport" [ "operating" "quarantine" "fire" "earthquake" "blackout" "threat" ]
  adauga-elemente-monitorizare  -60 -36 6 1 3 2 ( [id] of one-of gara-periferie ) "Railroad Station" [ "operating" "quarantine" "fire" "earthquake" "blackout" "threat" ]
  adauga-elemente-monitorizare  -20 -36 6 1 3 2 ( [id] of one-of gara-oras ) "City Train Station" [ "operating" "quarantine" "fire" "earthquake" "blackout" "threat" ]
  adauga-elemente-monitorizare   20 -36 5 1 3 2 ( [id] of one-of centrala-nucleara ) "Nuclear Plant" [ "operating" "quarantine" "fire" "earthquake" "threat" ]
  adauga-elemente-monitorizare   60 -36 5 1 3 2 ( [id] of one-of hidrocentrala ) "Hydro-electric Plant" [ "operating" "quarantine" "fire" "earthquake" "threat" ]
  adauga-elemente-monitorizare  100 -36 7 1 3 2 ( [id] of one-of spital ) "Hospital (yellow)" [ "operating" "quarantine" "fire" "earthquake" "robbery" "threat" "blackout" ]
  
  ;adauga-senzori-monitorizare [ cladire-parinte stari-urmarite praguri ]
  adauga-senzori-monitorizare ( [id] of one-of aeroport ) [ "quarantine" "fire" "earthquake" "blackout" "threat" ] [ 1 1 4 1 1 ]
  adauga-senzori-monitorizare ( [id] of one-of gara-periferie ) [ "quarantine" "fire" "earthquake" "blackout" "threat" ] [ 1 1 4 1 1 ]
  adauga-senzori-monitorizare ( [id] of one-of gara-oras ) [ "quarantine" "fire" "earthquake" "blackout" "threat" ] [ 1 1 4 1 1 ]
  adauga-senzori-monitorizare ( [id] of one-of centrala-nucleara ) [ "quarantine" "fire" "earthquake" "threat" ] [ 1 1 5.5 1 ]
  adauga-senzori-monitorizare ( [id] of one-of hidrocentrala ) [ "quarantine" "fire" "earthquake" "threat" ] [ 1 1 5 1 ]
  adauga-senzori-monitorizare ( [id] of one-of spital ) [ "operating" "quarantine" "fire" "earthquake" "robbery" "threat" "blackout" ] [ 1 1 1 6 1 1 1 ]
  
end

to actualizeaza-monitorizarea
  ; Din punct de vedere al cladirilor monitorizate:
  ;    - pentru fiecare cladire in parte actualizam senzorii si in functie de modificarile aduse setam alarma si starea de functionare
  ;
  ; Functionarea si alarma se seteaza in functie de citirile senzorilor astfel:
  ;    - functionarea inceteaza pentru orice eveniment ( jaf cutremur incendiu inundatie etc )
  ;    - alarma se activeaza pentru evenimente care necesita prezenta echipajelor de interventie ( jaf incendiu etc )
  foreach cladiri-monitorizate
  [
    let cladire-curenta ?
    let senzori-activi 0
    let senzori-interventie 0
    ask senzori with [ cladire-id = ( [id] of ( one-of ? ) ) ] ; ? este agentset de patch-uri
    [
      let senzor-curent self
      let element-afisare ( patches with [ ( tip = "interfata" ) and ( id-cladire = ( [cladire-id] of senzor-curent ) ) and ( stare = ( [eveniment-urmarit] of senzor-curent ) ) ] )
      ifelse ( intensitate >= prag )
      [
        ask element-afisare [ set pcolor red ]
        set senzori-activi ( senzori-activi + 1 )
        if ( position ( eveniment-urmarit ) [ "robbery" "fire" "quarantine" "threat" ] != false )
        [
          set senzori-interventie 1
        ]
      ]
      [
        ask element-afisare [ set pcolor green ]
      ]
    ]
    ;show (word "S-au activat " senzori-activi " senzori ")
    ifelse ( senzori-activi > 0 )
    [
      ask ( patches with [ ( tip = "interfata" ) and ( id-cladire = ( [id] of ( one-of cladire-curenta ) ) ) and ( stare = "operating" ) ] )
      [
        set pcolor red
        ;; verificari pentru trenuri!
        if ( [id] of one-of cladire-curenta = [id] of one-of aeroport )
        [
          ask trenuri with [ id = 1 or id = 2 ] [ set viteza 0 ]
        ]
        if ( [id] of one-of cladire-curenta = [id] of one-of gara-periferie )
        [
          ask trenuri [ set viteza 0 ]
        ]
        if ( [id] of one-of cladire-curenta = [id] of one-of gara-oras )
        [
          ask trenuri with [ id = 3 or id = 4 ] [ set viteza 0 ]
        ]
      ]
    ]
    [
      ask ( patches with [ ( tip = "interfata" ) and ( id-cladire = ( [id] of ( one-of cladire-curenta ) ) ) and ( stare = "operating" ) ] )
      [
        set pcolor green
        let g-p one-of ( patches with [ ( tip = "interfata" ) and ( id-cladire = ( [id] of ( one-of gara-periferie ) ) ) and ( stare = "operating" ) ] )
        let g-o one-of ( patches with [ ( tip = "interfata" ) and ( id-cladire = ( [id] of ( one-of gara-oras ) ) ) and ( stare = "operating" ) ] )
        let ae one-of ( patches with [ ( tip = "interfata" ) and ( id-cladire = ( [id] of ( one-of aeroport ) ) ) and ( stare = "operating" ) ] )
        ;; verificari pentru trenuri
        if ( ( [pcolor] of ae = green ) and ( [pcolor] of g-p = green ) )
        [
          ask tren-1 [ set viteza ( v-trenuri ) ]
          ask tren-2 [ set viteza ( - v-trenuri ) ]
        ]
        if ( ( [pcolor] of g-p = green ) and ( [pcolor] of g-o = green ) )
        [
          ask tren-3 [ set viteza ( v-trenuri ) ]
          ask tren-4 [ set viteza ( - v-trenuri ) ]
        ]
      ]
    ]
    ;show senzori-interventie
    ifelse ( senzori-interventie > 0 )
    [
      ask ( patches with [ ( tip = "interfata" ) and ( id-cladire = ( [id] of ( one-of cladire-curenta ) ) ) and ( stare = "quarantine" ) ] )
      [
        set pcolor red
      ]
      ; trebuie sa delimitez perimetrul
      seteaza-perimetru-cladire ( [id] of ( one-of cladire-curenta ) ) ( [tip] of ( one-of cladire-curenta ) )
    ]
    [
      ask ( patches with [ ( tip = "interfata" ) and ( id-cladire = ( [id] of ( one-of cladire-curenta ) ) ) and ( stare = "quarantine" ) ] )
      [
        set pcolor green
      ]
    ] 
  ]
  
  ; efect grafic pentru epicentru
  let magnitudine-actuala ( max [intensitate] of ( senzori with [ eveniment-urmarit = "earthquake" ] ) )
  ifelse ( magnitudine-actuala > 0 )
  [
    ask zona-epicentru [ set pcolor ( 65 - ( magnitudine-actuala / 2 ) ) ]
  ]
  [
    ask zona-epicentru [ set pcolor 65 ]
  ]
end

to actualizeaza-cutremur [ mag-cutremur ]
  ask senzori with [ eveniment-urmarit = "earthquake" ]
  [
    set intensitate ( mag-cutremur )
  ]
  ifelse ( mag-cutremur > 4 ) ; de la 4 grade un cutremur este simtit de catre toata lumea
  [
    ask turtles with [ categorie = "pietoni" or categorie = "rutier" or categorie = "feroviar" ]
    [
      set viteza 0
    ]
  ]
  [
    ; re-seteaza vitezele stabilite
    ; oameni
    ask oameni [ set viteza v-oameni ]
    ask masini [ set viteza v-masini ]
    ask autobuze [ set viteza v-autobuze ]
    ask camioane [ set viteza v-camioane ]
    ; fiecare tren in parte
    ask tren-1 [ set viteza ( v-trenuri ) ]
    ask tren-2 [ set viteza ( - v-trenuri ) ]
    ask tren-3 [ set viteza ( v-trenuri ) ]
    ask tren-4 [ set viteza ( - v-trenuri ) ]
  ]
  actualizeaza-monitorizarea
  print (word floor timer "s: Seismic Activity or magnitude set to " mag-cutremur " on the Richter Scale")
end

to reseteaza-lume
  ; elimina toate pericolele si readuce lumea la starea "pasnica"
  ; 1) elimina evenimentele din senzori
  ask senzori [ set intensitate 0 ]
  ; 2) refa soselele si trotuarele
  ask patches with [ tip = "sosea" ]
  [
    set pcolor culoare-sosea
    set safe true
  ]
  ask patches with [ tip = "trotuar" ]
  [
    set pcolor culoare-trotuar
    set safe true
  ]
  ; 3) oamenii nu mai sunt forte de interventie
  ask oameni [ set color black ]
  ; 4) anuleaza cutremurul
  actualizeaza-cutremur 0 ; actualizeaza si interfata
  ; 5) actualizeaza interfata
  ;actualizeaza-monitorizarea  
end

to aplica-eveniment-cladire [ cladire-tinta eveniment-propus ]
  ; selctia cladirii tinta
  if ( cladire-tinta = "The Airport" ) [ set cladire-tinta ( [id] of ( one-of aeroport ) ) ]
  if ( cladire-tinta = "The Railroad Station" ) [ set cladire-tinta ( [id] of ( one-of gara-periferie ) ) ]
  if ( cladire-tinta = "The city Train Station" ) [ set cladire-tinta ( [id] of ( one-of gara-oras ) ) ]
  if ( cladire-tinta = "The Hospital" ) [ set cladire-tinta ( [id] of ( one-of spital ) ) ]
  if ( cladire-tinta = "The Nuclear Plant" ) [ set cladire-tinta ( [id] of ( one-of centrala-nucleara ) ) ]
  if ( cladire-tinta = "The Hydro-electric Plant" ) [ set cladire-tinta ( [id] of ( one-of hidrocentrala ) ) ]
  
  let senzor-exista ( senzori with [ cladire-id = ( cladire-tinta ) and eveniment-urmarit = ( eveniment-propus ) ] )
  ifelse ( count senzor-exista < 1 )
  [
    user-message (word "Sorry, the selected building doesn't have a sensor for the " eveniment-propus " event.\n\nPlease select another event or building." )
    ;user-message (word "Imi pare rau, dar cladirea selectata nu are senzor pentru " eveniment-propus ".\n\nVa rog selectati alta cladire sau alt eveniment." )
  ]
  [
    ask senzor-exista [
      set intensitate prag
    ]
    actualizeaza-monitorizarea
  ]
end
  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;ADAUGAREA AGENTILOR
;; Adaugarea agentiilor ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;setup agenti;;
to setup-agenti
  create-oameni numpeople [
    set viteza v-oameni ;; viteza initiala acum este nula
    set acceleratie a-oameni
    set distanta d-oameni
    set distanta-franare df-oameni
    set virare vir-oameni
    set categorie cat-oameni
    set size dim-oameni
    set shape "person"
    set color brown - 3
    move-to one-of ( patches with [ tip = "trotuar" ] )
  ]
  create-masini numcars [
    set viteza v-masini ;; viteza initiala acum este nula
    set acceleratie a-masini
    set distanta d-masini
    set distanta-franare df-masini
    set virare vir-masini
    set categorie cat-masini
    set size dim-masini
    set shape "car"
    set color one-of [ red orange brown yellow green lime turquoise cyan sky blue violet magenta pink ]
    ;let pozitii ( patches with [ tip = "sosea"] )
    move-to one-of ( patches with [ tip = "sosea" and ( count turtles-here ) < 1 ] )
  ]
  create-autobuze numbuses [
    set viteza v-autobuze ;; viteza initiala acum este nula
    set acceleratie a-autobuze
    set distanta d-autobuze
    set distanta-franare df-autobuze
    set virare vir-autobuze
    set categorie cat-autobuze
    set size dim-autobuze
    set shape "bus"
    set color one-of [ red orange brown yellow green lime turquoise cyan sky blue violet magenta pink ]
    move-to one-of ( patches with [ tip = "sosea" and ( count turtles-here ) < 1 ] )
  ]
  create-camioane numtrucks [
    set viteza v-camioane ;; viteza initiala acum este nula
    set acceleratie a-camioane
    set distanta d-camioane
    set distanta-franare df-camioane
    set virare vir-camioane
    set categorie cat-camioane
    set size dim-camioane
    set shape "truck"
    set color one-of [ red orange brown yellow green lime turquoise cyan sky blue violet magenta pink ]
    move-to one-of ( patches with [ tip = "sosea" and ( count turtles-here ) < 1 ] )
  ]

  adauga-avioane 1 false false
  
  ;; creeaza trenurile:
  ; trenul 1:
  let start-x ([pxcor] of min-one-of sina-1 [pxcor] ) ; pozitie start X
  let start-y ([pycor] of min-one-of sina-1 [pycor] ) ; pozitie start Y
  set start-x ( start-x + floor ( v-trenuri * dim-trenuri ) )
  create-trenuri 8 [
    set tren-id 1
    set heading 90
    set viteza ( v-trenuri )
    move-to patch start-x ( start-y )
    set start-x ( start-x + dim-trenuri )
  ]
  set tren-1 ( trenuri with [ tren-id = 1 ] )
  ; trenul 2:
  set start-x ([pxcor] of max-one-of sina-2 [pxcor] ) ; pozitie start X
  set start-y ([pycor] of max-one-of sina-2 [pycor] ) ; pozitie start Y
  set start-x ( start-x - floor ( v-trenuri * dim-trenuri ) )
  create-trenuri 8 [
    set tren-id 2
    set heading 90
    set viteza ( - v-trenuri )
    move-to patch start-x ( start-y )
    set start-x ( start-x - dim-trenuri )
  ]
  set tren-2 ( trenuri with [ tren-id = 2 ] )
  ; trenul 3:
  set start-x ([pxcor] of max-one-of sina-3 [pxcor] ) ; pozitie start X
  set start-y ([pycor] of max-one-of sina-3 [pycor] ) ; pozitie start Y
  set start-y ( start-y - floor ( v-trenuri * dim-trenuri ) )
  create-trenuri 6 [
    set tren-id 3
    set heading 180
    set viteza ( v-trenuri )
    move-to patch start-x ( start-y )
    set start-y ( start-y - dim-trenuri )
  ]
  set tren-3 ( trenuri with [ tren-id = 3 ] )
  ; trenul 4:
  set start-x ([pxcor] of min-one-of sina-4 [pxcor] ) ; pozitie start X
  set start-y ([pycor] of min-one-of sina-4 [pycor] ) ; pozitie start Y
  set start-y ( start-y + floor ( v-trenuri * dim-trenuri ) )
  create-trenuri 6 [
    set tren-id 4
    set heading 180
    set viteza ( - v-trenuri )
    move-to patch start-x ( start-y )
    set start-y ( start-y + dim-trenuri )
  ]
  set tren-4 ( trenuri with [ tren-id = 4 ] )
  ;; seteaza locomitvele si trenurile
  ask trenuri [ 
    set locomotiva false 
    set shape "vagon"
    set categorie "feroviar"
    set color 95
    set size dim-trenuri
    set timp-stationare timp-stationare-trenuri
  ]
  ;; trenurile mai mari se incarca mai greu => 
  ask trenuri with [ tren-id = 1 or tren-id = 2 ] [ set timp-stationare ( timp-stationare + 1 ) ]
  ask tren-1 with [ xcor = max [xcor] of tren-1 or xcor = min [xcor] of tren-1 ] [ set locomotiva true ]
  ask tren-2 with [ xcor = max [xcor] of tren-2 or xcor = min [xcor] of tren-2 ] [ set locomotiva true ]
  ask tren-3 with [ ycor = max [ycor] of tren-3 or ycor = min [ycor] of tren-3 ] [ set locomotiva true ]
  ask tren-4 with [ ycor = max [ycor] of tren-4 or ycor = min [ycor] of tren-4 ] [ set locomotiva true ]
  ask trenuri with [ locomotiva = true ]
  [
    set shape "locomotiva"
    set color 137
  ]
  ; orientare
  orienteaza-agenti-spawn ; rezolva toate directiile posibile
end

to adauga-avioane [ nr ater prabu ] ; pot fi false false
  create-avioane nr [ ; numariplanes
    set viteza v-avioane ;; viteza ini tiala acum este nula
    set acceleratie a-avioane
    set distanta d-avioane
    set distanta-franare df-avioane
    set virare vir-avioane
    set categorie cat-avioane
    ;set size one-of n-values 4 [ ( 0.15 * ( ? + 6 )) * dim-avioane ]
    set size dim-avioane
    set shape "airplane"
    set color white
    set hidden? true
    set heading -90
    ;setxy random-xcor random-ycor
    ; move-to one-of ( patches with [ ( count turtles-here ) < 1 and tip != "interfata" ] ) ; avioanele apar doar in zona activa a lumii
    move-to pozitie-spawn-avioane
    ;speciale
    set altitudine ( floor size * 1000 )
    set aterizeaza ater
    set prabuseste prabu
    set tinta nobody
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;orienteaza agenti spawn;;
to orienteaza-agenti-spawn
  orienteaza-agenti-pietoni-spawn
  orienteaza-agenti-rutieri-spawn
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;orienteaza pietoni spawn;;
to orienteaza-agenti-pietoni-spawn
  ask turtles with [ categorie = "pietoni" ]
  [
    set color red
    let curent ( tip )
    let directie ( one-of neighbors4 with [ tip = curent ] )
    face directie
    set color black
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;orienteaza rutieri spawn;;
to orienteaza-agenti-rutieri-spawn
  ;ask one-of turtles [ setxy -22 -47 ] ;test and debug
  ask turtles with [ categorie = "rutier" ] [
    set color red ; neprelucrat
    let bun ( tip ) ; agent pe sosea, trotuar, iarba, etc ?
    
    let t1 ( [tip] of patch-at-heading-and-distance ( 0 ) ( benzi ) ) 
    let t2 ( [tip] of patch-at-heading-and-distance ( 0 ) ( benzi * 2 ) ) 
    let t3 ( [tip] of patch-at-heading-and-distance (   90 ) ( benzi ) ) 
    let t4 ( [tip] of patch-at-heading-and-distance (  -90 ) ( benzi ) ) 
    
    ifelse ( t1 = t2 and t2 = t3 and t3 = t4 and t4 = bun )
    [
      ;suntem in intersectie: => ne uitam la diagonale
      set t1 ( [tip] of patch-at-heading-and-distance (  -45 ) ( benzi ) ) 
      set t2 ( [tip] of patch-at-heading-and-distance (   45 ) ( benzi ) ) 
      set t3 ( [tip] of patch-at-heading-and-distance ( -135 ) ( benzi ) ) 
      set t4 ( [tip] of patch-at-heading-and-distance (  135 ) ( benzi ) )
      if ( t1 != bun )
      [
        set heading (  -90 )
        set color green
      ]
      if ( t2 != bun )
      [
        set heading (    0 )
        set color green
      ]
      if ( t3 != bun )
      [
        set heading (  180 )
        set color green
      ]
      if ( t4 != bun )
      [
        set heading (   90 )
        set color green
      ]
    ]
    [
      ; cazurile generale:
      if ( t1 = bun and t2 = bun ) ; drum vertical bun
      [
        ; sosea verticala
        if ( t4 = bun )
        [
          set heading (    0 )
          set color green
        ]
        if ( t3 = bun ) 
        [
          set heading (  180 )
          set color green
        ]
        if ( [tip] of ( patch-ahead 1 ) != tip ) ; rezolva coltul din stanga-jos
        [
          set heading (   90 )
        ]
      ]
      if ( t1 != bun and t2 != bun ) ;colt, trebuie sa virez la dreapta
      [
        ifelse ( t4 = bun ) ; orice colt mai putin stanga sus
        [
          set heading (  -90 )
          set color green
        ]
        [
          set heading (  180 )
          set color green
        ]
      ]
      if ( t1 = bun and t2 != bun ) ;va trebui sa viram la stanga ori la dreapta
      [
        if ( t3 != bun or t3 != t4 ) ; curba exterioara,inca nu am ajuns la curba
        [
          set heading 0
          set color green
        ]
        if ( t3 = t4 and t4 = bun ) ; putem fi in drum orizontal, ori curba interioara si orientati invers ori intersectie si trebuie sa facem dreapta
        [
          set t1 ( [tip] of patch-at-heading-and-distance (  -45 ) ( benzi ) ) 
          set t2 ( [tip] of patch-at-heading-and-distance (  -90 ) ( benzi ) ) 
          set t3 ( [tip] of patch-at-heading-and-distance (  135 ) ( benzi ) )
          ; t1, t2, t3 = tipul drumului de sub agent
          ifelse ( t1 != bun and t2 = t3 and t3 = bun ) ; interior intersectie
          [
            set heading (  180 )
            set color green
          ]
          [
            ;intersectie si facem dreapta sau drum orizontal si mergem spre dreapta
            set heading (  90 )
            set color green
          ]
        ]
      ]
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;orienteaza agenti;;
to orienteaza-agenti
  ; rezolva toate directiile rezultate
  ask turtles with [ categorie = "pietoni" ]
  [
    if ( [ tip ] of ( patch-ahead viteza ) != tip )
    [
      set heading ( heading + ( one-of [ 90 180 270 ] ) )
    ]
  ]
  
  ask turtles with [categorie = "rutier" and ales-viraj < 1 ]
  [
    let curent ( tip )
    ifelse ( [tip] of patch-ahead 1 != curent or ( ( safe = true ) and ([safe] of patch-ahead 1 != safe) ) ) ; nu vreau sa ies de pe un drum safe pe unul nesafe!
    [
      ; virez fortat stanga
      set heading ( heading - 90 )
      set ales-viraj 1
    ]
    [
      ; debugging pentru ambuteliaje frontale: daca cel din fata are heading = heading actual -180, fac stanga
      let orientare ( heading )
      let masina-din-fata one-of ( ( turtles-on patch-ahead 1 ) with [ ( categorie = "rutier" ) and ( heading != orientare  ) and ( ales-viraj < 1 ) ] )
      if ( masina-din-fata != nobody )
      [
        ask masina-din-fata
        [
          let turn one-of [ 90 -90 ]
          set heading ( heading + turn )
          set ales-viraj 1
        ]
      ]
        
      let t1 patch-at-heading-and-distance ( heading ) ( benzi * 2 )        ; 2 mai sus
      let t2 patch-at-heading-and-distance ( heading - 60 ) ( benzi * 2 )   ; 1 mai sus si 2 la stanga
      let t3 patch-at-heading-and-distance ( heading + 90 ) ( benzi )       ; 1 la dreapta
      
      ; verific drumurile posibile
      if ( [tip] of t1 != curent ) [ set t1 false ]
      if ( [tip] of t2 != curent ) [ set t2 false ]
      if ( [tip] of t3 != curent ) [ set t3 false ]
      
      ; verific drumurile safe 
      ifelse ( is-patch? t1 and ([safe] of t1 = true ) or ( is-patch? t2 and [safe] of t2 = true ) or ( is-patch? t3 and [safe] of t3 = true ) )
      [
        ; cel putin 1 drum este safe. Drumurile safe sunt true, cele nesafe sunt false
        ifelse ( is-patch? t1 and [safe] of t1 = true )
        [
          set t1 true
        ]
        [
          set t1 false
        ]
        ifelse ( is-patch? t2 and [safe] of t2 = true )
        [
          set t2 true
        ]
        [
          set t2 false
        ]
        ifelse ( is-patch? t3 and [safe] of t3 = true )
        [
          set t3 true
        ]
        [
          set t3 false
        ]
      ]
      [
        ; nici un drum dintre cele 3 nu este safe. Setez directia posibila dupa prioriatea: inainte-dreapta-stanga ; stanga oricum se face pentru evitari
        if ( is-patch? t1 )
        [
          set t1 true
          set t2 false
          set t3 false
        ]
        if ( is-patch? t3 )
        [
          set t1 false
          set t3 true
          ifelse ( is-patch? t2 ) [ set t2 true ]
                                  [ set t2 false ]
        ]
        if ( is-patch? t2 )
        [
          set t1 false
          ifelse ( is-patch? t3 ) [ set t3 true ]
                                  [ set t3 false ]
          set t2 true
        ]
      ]
      
      ifelse ( t1 = true and t2 = true and t3 = true )
      [
        ; toate cele 3 cazuri sunt posibile
        let intentie-viraj random 100
        ifelse ( intentie-viraj <= 33 )
        [
          ;merg inainte
          orienteaza-pentru-inainte
        ]
        [
          ifelse ( intentie-viraj <= 66 )
          [
            ; stanga
            orienteaza-pentru-stanga
          ]
          [
            ; dreapta
            orienteaza-pentru-dreapta
          ]
        ]
      ]
      [
        ; doar 2 din 3 sunt posibile
        ifelse ( t1 = true and t2 = true and t3 = false )
        [
          let intentie-viraj random 100
          ifelse ( intentie-viraj <= 50 )
          [
            orienteaza-pentru-stanga
          ]
          [
            orienteaza-pentru-inainte
          ]
        ]
        [
          ifelse ( t1 = false and t2 = true and t3 = true )
          [
            let intentie-viraj random 100
            ifelse ( intentie-viraj <= 50 )
            [
              ;orienteaza-pentru-stanga
              set virez-stanga ( benzi - 1 )
              set ales-viraj 3
            ]
            [
              orienteaza-pentru-dreapta
            ]
          ]
          [
            ifelse ( t1 = true and t2 = false and t3 = true )
            [
              let  intentie-viraj random 100
              ifelse ( intentie-viraj <= 50 )
              [
                orienteaza-pentru-inainte
              ]
              [
                orienteaza-pentru-dreapta
              ]
            ]
            [
              ;doar un caz posibil
              ifelse ( t2 = true )
              [
                orienteaza-pentru-stanga
              ]
              [
                if ( t3 = true )
                [
                  orienteaza-pentru-dreapta
                ]
              ]
            ]
          ]
        ]
      ]
    ]
  ]
  
  ;; pentru optimizare, trenurile au orientarea setata in miscare!
  ;; cod in misca-tren 
  
  
  ask avioane
  [
    ifelse ( prabuseste = false )
    [ ; ATERIZARE: 
      let da 1.5 ; multiplicator distanta aterizare
      ifelse ( tinta = nobody )
      [
        let teren-aterizare ( patches in-cone ( 44 * da ) 0 with [ tip = "pista" ] )
        if ( count teren-aterizare > 0 )
        [
          set tinta min-one-of teren-aterizare [ distance myself ]
          ifelse ( ( [pcolor] of ( one-of ( patches with [ tip = "interfata" and id-cladire = ( [id] of one-of aeroport ) and stare = "operating" ] ) ) ) != red )
          [
            set aterizeaza true
          ]
          [
            set aterizeaza false
          ]
        ]
      ]
      [
        ifelse ( aterizeaza = false )
        [
          set color pink
        ]
        [
          let pana-aterizez distance tinta
          ifelse ( altitudine <= 0 )
          [
            die
          ]
          [
            ; daca a inceput cutremurul, vrem sa ne ridicam iar la 1200m 
            ifelse ( ( [pcolor] of ( one-of ( patches with [ tip = "interfata" and id-cladire = ( [id] of one-of aeroport ) and stare = "operating" ] ) ) ) != red )
            [
              set size ( size - ( 0.2 * ( 1 / da ) ) )
              set altitudine floor ( altitudine - ( 300 * ( 1 / da ) ) )
              set viteza ( viteza  - ( 2 / ( da * 100 ) ) )
              if ( altitudine < 0 ) [ set altitudine 0 ]
            ]
            [
              if ( color != pink ) [ set color pink ]
              ; ne intereseaza dim!
              if ( altitudine < dim-avioane * 1000 ) [ set altitudine floor ( altitudine + ( 300 * ( 1 / da ) ) ) ]
              if ( altitudine > dim-avioane * 1000 ) [ set altitudine ( floor size * 1000 ) ]
              if ( viteza < v-avioane ) [ set viteza ( viteza  + ( 2 / ( da * 100 ) ) ) ]
              if ( viteza > v-avioane ) [ set viteza v-avioane ]
              if ( size < dim-avioane ) [ set size ( size + ( 0.2 * ( 1 / da ) ) ) ]
              if ( size > dim-avioane ) 
              [ 
                set size dim-avioane
                set altitudine ( dim-avioane * 1000 )
                set tinta nobody
              ]
            ]  
          ]
        ]
      ]
    ]
    [
      ; PRABUSIRE!
      set heading ( heading - 2 )
      set size ( size - 0.1 )
      set altitudine ( altitudine - 150 )
      if ( size < 6.5 ) [ set altitudine 0 ]
      if ( altitudine <= 0 )
      [ 
        let victime one-of ( patches with [ id >= 0 and ( tip != "interfata" and tip != "lac" and tip != "iarba" )] ) in-radius 2
        
        ;; caut cladirea sau soseaua cea mai apropiata ( in radius de 2 )
        ifelse ( any? patches with [ tip = "gara" or tip = "cladire" or tip = "aeroport" or tip = "centrala-nucleara" or tip = "hidrocentrala" or tip = "spital" ] in-radius 10 )
        [
          set victime min-one-of ( patches with [ tip = "gara" or tip = "cladire" or tip = "aeroport" or tip = "centrala-nucleara" or tip = "hidrocentrala" or tip = "spital" ] in-radius 10 ) [ distance myself ]
          ;print (word "distanta este " distance victime " si tipul este " [tip] of victime )          
          ;; avem o cladire sau structura :
          let id-victime [id] of victime
          seteaza-perimetru-cladire id-victime ( [tip] of one-of item id-victime cladiri )
          let senzor-incendiu ( senzori with [ eveniment-urmarit = "fire" and cladire-id = id-victime ] )
          if ( count senzor-incendiu > 0 )
          [
            ask senzor-incendiu [ set intensitate prag ] ; activez senzorul de incendiu
          ]
          ;wait 0.3
          actualizeaza-monitorizarea
        ]
        [
          ;; verificam soseaua
          set victime min-one-of ( patches with [ tip = "sosea" ] in-radius 10 ) [ distance myself ]
          if ( victime != nobody )
          [
            ask victime
            [
              ask patches in-radius 5 with [ tip = "sosea" ]
              [
                set safe false
                set pcolor red
              ]
            ]
          ]
        ]
        ask copaci in-radius 4 [ die ]
        die
      ]
    ]
  ]
  
  if ( count avioane < 1 ) [ adauga-avioane 1 false false ] ; adauga un nou avion pe ruta 
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;cazuri orientare agenti;;
; cazuri de orientare
to orienteaza-pentru-inainte
  set ales-viraj ( benzi * 2 + 1 )
end
to orienteaza-pentru-stanga
  set virez-stanga ( benzi * 2 + 1 )
  set ales-viraj ( benzi * 2 + 2 )
end
to orienteaza-pentru-dreapta
  set heading ( heading + 90 )
  set ales-viraj ( benzi + 1 )
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;miscare agenti;;
to misca-agenti 
  ask turtles with [ categorie = "rutier" ]
  [
    if (ales-viraj > 0 )
    [
      set ( ales-viraj ) ( ales-viraj - 1)
      if ( virez-stanga > 0 )
      [
        if ( virez-stanga = ( benzi * 2 - 1 ) )
        [
          set heading ( heading - 90 )
        ]
        set virez-stanga ( virez-stanga - 1 )
      ]
    ]
    if ( [tip] of patch-ahead 1 = tip and count turtles-on patch-ahead 1 < 1 )
    [
      
      if ( ( [safe] of patch-ahead 1 = true ) or ( [safe] of patch-ahead 1 = safe ) )
      [
        forward viteza
      ]
    ]
  ]
  ask oameni 
  [
    if ( [tip] of patch-ahead viteza = tip and [safe] of patch-ahead viteza = true )
    [
      forward viteza
    ]
  ]
  
  ; trenurile au o alta abordare: orientarea e inclusa in miscare si se face miscarea pentru fiecare tren in parte
  misca-tren tren-1
  misca-tren tren-2
  misca-tren tren-3
  misca-tren tren-4
  
  ask avioane
  [
    forward viteza
    ifelse (([tip] of patch-at-heading-and-distance ( heading  ) 2  = "interfata") and ([tip] of patch-at-heading-and-distance ( heading - 180 ) 2 = "interfata"))
    [
      hide-turtle
      if ( color = pink ) 
      [ 
        die
      ]
    ]
    [
      show-turtle
    ]
  ]
end
to misca-tren [ tren-x ]
  ask one-of tren-x with [ locomotiva = true ]
  [
    ifelse ( ( all? ( tren-x with [ locomotiva = true ] ) [ [tip] of patch-ahead ( viteza * size ) = "sina" ] )  )
    [
      if ( timer-running > ( timp-ajuns-gara + timp-stationare ) )
      [
        ask tren-x [ forward viteza ]
      ]
    ]
    [
      ask tren-x
      [
        set timp-ajuns-gara timer-running
        set viteza ( - viteza )
      ]
    ]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;CREAREA LUMII
;; Generarea spatiului modelat ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;setup HARTA;;
to setup-harta
  ;; relief intai:
  ask patches 
  [ 
    set pcolor 65
    set nivel 0
    set tip "iarba"
    set id -1
    set id-cladire -1
  ]
  ; lac acumulare
  let t1 -106
  let t2 32
  let lim-t1 ( 16 + t1 )
  ask patches with [ pxcor < t1 and abs ( pycor - t2 ) < 2 ]
  [
    set pcolor 87
    set tip "apa"
  ]
  while [ t1 <= lim-t1 ]
  [
    ask patch t1 t2
    [
      ask patches in-radius 10
      [
        set pcolor 87
        set tip "lac"
        set id 1
      ]
    ]
    set t1 ( t1 + 1 )
  ]
  ; lac varsare
  set t1 -38
  set t2 0
  set lim-t1 ( 16 + t1 )
  while [ t1 <= lim-t1 ]
  [
    ask patch t1 t2
    [
      ask patches in-radius 10
      [
        set pcolor 87
        set tip "lac"
        set id 2
      ]
    ]
    set t1 ( t1 + 1 )
  ]

  ;; interfata
  ask patches with [ pycor <= limita-jos or pxcor >= limita-dreapta ]
  [
    set pcolor white
    set nivel 0
    set tip "interfata"
    set id -2
  ]
  ;; pista aeroport
  set pista-aeroport patches with [((pycor >= 52 and pycor <= 60 ))and (pxcor >= -126 and pxcor <= -104)]
  ask pista-aeroport
  [
    set pcolor white
    set nivel 0
    set tip "iluminare-pista"
  ]
  ask pista-aeroport with [ pxcor <= -112 ]
  [
    set tip "pista"
  ]
  ;; gari si sine de tren
  ask patches with [(pycor >= 58) and (pxcor >= 50 and pxcor < limita-dreapta - 2)]
  [
    set pcolor 36
    set nivel 0
    set tip "gara"
    set id 1
  ]
  ask patches with [(pycor >= 44) and (pxcor >= 66 and pxcor < limita-dreapta - 2)]
  [
    set pcolor 36
    set nivel 0
    set tip "gara"
    set id 1
  ]
  set sina-1 patches with [(( pycor = 66 ) and (( pxcor >= -124 ) and ( pxcor <= limita-dreapta - 8 )))]
  ask sina-1
  [
    set pcolor 33
    set nivel 0
    set tip "sina"
    set id 1
  ]
  set sina-2 patches with [(( pycor = 64 ) and (( pxcor >= -124 ) and ( pxcor <= limita-dreapta - 8 )))]
  ask sina-2
  [
    set pcolor 33
    set nivel 0
    set tip "sina"
    set id 2
  ]
  ; aeroport
  set aeroport patches with [(pycor >= 50 and pxcor <= -100) and tip = "iarba"]
  ask aeroport
  [
    set pcolor 85
    set nivel 0
    set tip "aeroport"
    set id 0
  ]
  set sina-3 patches with [(( pxcor = 73) and (( pycor <= 60 ) and ( pycor >= limita-jos + 18 )))]
  ask sina-3
  [
    set pcolor 33
    set nivel 0
    set tip "sina"
    set id 3
  ]
  set sina-4 patches with [(( pxcor = 75 ) and (( pycor <= 60 ) and ( pycor >= limita-jos + 18 )))]
  ask sina-4
  [
    set pcolor 33
    set nivel 0
    set tip "sina"
    set id 4
  ]
  set sine-tren patches with [ tip = "sina" ]
  set gara-periferie patches with [ tip = "gara" ] ; doar gara asta s-a construit pana acum
  set gara-oras patches with [(pycor <= 4 and pycor > limita-jos + 14) and (pxcor >= 66 and pxcor < limita-dreapta - 2) and tip != "sina"]
  ask gara-oras 
  [
    set pcolor 36
    set nivel 0
    set tip "gara"
    set id 2
  ]
  set cladiri lput aeroport cladiri
  set cladiri lput gara-periferie cladiri
  set cladiri lput gara-oras cladiri
  ;; cartiere ( clustere de cladiri inconjurate de sosele de dimensiune data - 2 - si trotuare de latime 1 )
  let start-x 62  ;; Nota: Se precizeaza coltul din dreapta-sus al primei cladiri!
  let start-y 21  ;;       Prima cladire este tot in coltul din dreapta-sus!
  let size-x 7
  let size-y 4
  let latime-drum 2 ; cate benzi are drumul?
  let last-id 3 ; de la cat incep alocarea de id-uri => 0 = aeroport, 1 si 2 = gari, deci de la 3 incep cladirile
  ;set last-id construieste-cartier start-x start-y size-x size-y 6 4 latime-drum 1 id-cladiri ; apel cu parametrii
  set last-id construieste-cartier "cladire" start-x start-y size-x size-y 6 4 latime-drum 1 last-id
  set start-x 72
  set start-y -19
  set size-x 8
  set size-y 1
  set last-id construieste-cartier "cladire" start-x start-y size-x size-y 6 4 latime-drum 1 ( last-id + 1 )
  ;; 3 case langa gara ca sa fie incercuita
  set start-x 68
  set start-y 21
  set size-x 1
  set size-y 3
  set last-id construieste-cartier "cladire" start-x start-y size-x size-y 2 4 latime-drum 1 ( last-id + 1 )
  ;; centrala nucleara
  set start-x -104  ;; Nota: Se precizeaza coltul din dreapta-sus al primei cladiri!
  set start-y -5  ;;       Prima cladire este tot in coltul din dreapta-sus!
  set size-x 1
  set size-y 1
  set last-id construieste-cartier "centrala-nucleara" start-x start-y size-x size-y 20 4 latime-drum 1 ( last-id + 1 );
  ;print (word "Centrala are id-ul " last-id )
  set centrala-nucleara patches with [ tip = "centrala-nucleara" and id = last-id ]
  ;; spitalul
  let id-spital random ( length cladiri - 4 - 3 ) ; sad cladirile critice si cladirile mici ( vilele )
  set id-spital ( id-spital + 3 ) ; se sar primele cladiri
  set spital patches with [ tip = "cladire" and id = id-spital  ]
  ask spital [ set tip "spital" ]
  ;; barajul
  ask patches with [ ( pxcor >= -81 and pxcor <= -80 ) and ( pycor >= 26 and pycor <= 38 ) ]
  [
    set tip "baraj"
    set id length cladiri
    set pcolor ( gray + 3 )
    set safe false
  ]
  set baraj patches with [ tip = "baraj" ]
  set cladiri lput baraj cladiri
  ;; rauri de legatura intre lacuri si care ies din model
  set t1 -35
  set t2 32
  set lim-t1 ( -79 )
  ask patches with [ ( pxcor >= lim-t1 and pxcor <= t1 ) and abs ( pycor - t2 ) < 2 ]
  [
    set pcolor 87
    set tip "apa"
  ]
  set t1 -36
  set t2 11
  let lim-t2 ( 30 )
  ask patches with [ ( abs ( pxcor - t1 ) < 2 ) and ( pycor >= t2 and pycor <= lim-t2 ) ]
  [
    set pcolor 87
    set tip "apa"
  ]
  ; iesirea din lacul 2
  set t1 -20
  set t2 -10
  set lim-t1 ( 16 + t1 )
  ask patches with [ ( abs ( pxcor - t1 ) < 2 ) and ( pycor > limita-jos and pycor <= t2 ) ]
  [
    set pcolor 87
    set tip "apa"
  ]
  ;; hidrocentrala
  ask patches with [ ( pxcor >= -79 and pxcor <= -56 ) and ( pycor >= 20 and pycor <= 36 ) and tip != "apa" ]
  [
    set tip "hidrocentrala"
    set id length cladiri
    set pcolor ( 115 )
  ]
  ask patch -57 26 [ set plabel "Hydro-electric Plant" set plabel-color white ]
  set hidrocentrala patches with [ tip = "hidrocentrala" ]
  set cladiri lput hidrocentrala cladiri
  ;; drumuri de legatura
  construieste-drum "strada" -7 -16 -100 -16 2 ; caz x1 y1 x2 y2 latime
  construieste-drum "strada" 65 25 65 57 2
  construieste-drum "strada" 63 57 -99 57 2
  construieste-drum "strada" -98 55 -98 48 2
  construieste-drum "strada" -100 49 -120 49 2
  construieste-drum "strada" -119 47 -119 -1 2
  ; drumuri legatura cu hidrocentrala
  construieste-drum "strada" -50 19 -50 -16 2
  construieste-drum "strada" -119 19 -52 19 2
  
  ;; denumiri
  ask patch -110 62 [ set plabel "Airport" set plabel-color 9.9 ]
  ask patch 70 60 [ set plabel "Railroad Station" ]
  ask patch 72 -2 [ set plabel "City" ]
  ask patch 72 -5 [ set plabel "Train" ]
  ask patch 72 -8 [ set plabel "Station" ]
  ask patch -107 -14 [ set plabel "Nuclear Plant" set plabel-color 9.9 ] ; 9.9 = white
  ask spital [ set pcolor yellow ]
  ;; desenarea dungilor perpediculare pentru spital
  let spital-x-cord ( mean ( [pxcor] of spital ) )
  let spital-y-cord ( mean ( [pycor] of spital ) )
  ifelse ( floor spital-x-cord = spital-x-cord )
  [
    ask spital with [ pxcor = spital-x-cord ]
    [
      set pcolor red
    ]
  ]
  [
    ask spital with [ ( pxcor = floor spital-x-cord ) or ( pxcor = ( floor spital-x-cord ) + 1 ) ]
    [
      set pcolor red
    ]
  ]
  ifelse ( floor spital-y-cord = spital-y-cord )
  [
    ask spital with [ pycor = spital-y-cord ]
    [
      set pcolor red
    ]
  ]
  [
    ask spital with [ ( pycor = floor spital-y-cord ) or ( pycor = ( floor spital-y-cord ) + 1 ) ]
    [
      set pcolor red
    ]
  ]
  
  ;; copaci
  let nr-copaci ( floor ( ( count patches with [ tip = "iarba" and ( any? neighbors with [ tip = "sosea" ] ) and pycor <= 50 ] ) / 4 ) )
  create-copaci nr-copaci
  [
    move-to one-of ( patches with [ tip = "iarba" and ( any? neighbors with [ tip = "sosea" ] and pycor <= 50 ) and ( count copaci in-radius 2 < 1 ) ] )
    set color one-of [ 54 64 66 67 ]
  ]
  
  let padure ( patches with [ tip = "iarba" and ( count turtles-here < 1 ) and ( ( pxcor >= -119 and pxcor <= -54  ) and ( pycor >= -16 and pycor <= 19 ) ) ] )
  set nr-copaci ( floor ( ( count padure ) / 2 ) )
  create-copaci nr-copaci 
  [
    move-to one-of ( padure )
    set color one-of [ 54 64 66 67 ]
  ]
  
  ; zona epicentru
  set t1 -16
  set t2  36
  let latime 14
  ask patch t1 t2
  [
    set tip "zona-epicentru"
    ask patches in-radius latime
    [
      if ( random 6 < 1 ) ;and ( one-of neighbors with [ tip = "zona-epicentru" ] ) != nobody )
      [
        set tip "zona-epicentru"
      ]
    ]
  ]
  
  set zona-epicentru ( patches with [ tip = "zona-epicentru" ] )
  
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;construieste cartier;;
to-report construieste-cartier [ tip-cladiri start-x start-y size-x size-y marime-cladiri spatiu-cladiri latime-drum marime-trotuar id-cladiri]
  let last-id construieste-cladiri tip-cladiri start-x start-y size-x size-y marime-cladiri spatiu-cladiri id-cladiri
  ;; drumuri
  let x1-drum ( start-x + ( latime-drum + latime-trotuar )) 
  let y1-drum ( start-y + ( latime-drum + latime-trotuar ))
  let x2-drum ( x1-drum - (( size-x * marime-cladiri ) + (( size-x - 1 ) * spatiu-cladiri ) + ( 2 * ( latime-drum + latime-trotuar )) - 1 ))
  let y2-drum y1-drum
  ; construieste drumurile orizontale
  repeat ( size-y + 1 )
  [
    construieste-drum "strada" x1-drum y1-drum x2-drum y2-drum latime-drum
    set y1-drum ( y1-drum - ( marime-cladiri + spatiu-cladiri ))
    set y2-drum ( y2-drum - ( marime-cladiri + spatiu-cladiri ))
  ] 
  
  set x1-drum ( start-x + ( latime-drum + latime-trotuar ))
  
  set y1-drum ( start-y + ( latime-drum + latime-trotuar ))
  
  set x2-drum x1-drum
  
  set y2-drum ( y1-drum - (( size-y * marime-cladiri ) + (( size-y - 1) * spatiu-cladiri) + ( 2 * ( latime-drum + latime-trotuar )) - 1 ))
  ; construieste drumurile verticale
  repeat ( size-x + 1 )
  [
    construieste-drum "strada" x1-drum y1-drum x2-drum y2-drum latime-drum
    set x1-drum ( x1-drum - ( marime-cladiri + spatiu-cladiri ))
    set x2-drum ( x2-drum - ( marime-cladiri + spatiu-cladiri ))
  ]
  
  ;; trotuar
  ask patches [ if (( any? neighbors with [ tip = "sosea" ] ) and ( any? neighbors with [ tip = tip-cladiri ] )) [
      set pcolor ( culoare-trotuar )
      set tip "trotuar"
      set nivel 0
      set benzi 1
      set safe true
  ]]  
  
  report last-id ; returneaza ultimul id generat.
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;construieste cladiri;;
to-report construieste-cladiri [ tip-cladiri start-x-cladiri start-y-cladiri X-cladiri Y-cladiri marime-cladiri spatiu-cladiri id-start]
  let id-c id-start
  let i 0
  let dim marime-cladiri - 1     ; corectie !
  let spatiu spatiu-cladiri + 1  ; corectie !
  while [ i < Y-cladiri ]
  [
    ; fiecare rand in parte
   let j 0
   while [ j < X-cladiri ]
   [
     let t1 0
     let t2 0
     ; fiecare cladire in parte
     let cladire ( patches with [ (pxcor <= ( start-x-cladiri - ( j * dim )) and pxcor >= ( start-x-cladiri - ( ( j + 1 ) * dim )))
                  and   (pycor <= ( start-y-cladiri - ( i * dim )) and pycor >= ( start-y-cladiri - ( ( i + 1 ) * dim ))) ] )
     ask cladire
     [
       set pcolor blue
       set nivel 1
       set tip tip-cladiri
       set id id-c
     ]
     set cladiri lput cladire cladiri
     set id-c ( id-c + 1 )
     set j ( j + 1 )
     set start-x-cladiri ( start-x-cladiri - spatiu )
   ]
   set i ( i + 1 )
   set start-y-cladiri ( start-y-cladiri - spatiu)
   set start-x-cladiri ( start-x-cladiri + ( X-cladiri * spatiu ))
  ]
  report ( id-c - 1 ) ; returneaza ultimul id adaugat!
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;construieste drum;;
to construieste-drum [ caz x1 y1 x2 y2 latime]
  ;; DRUMUL construit contine extremitatile!
  ifelse (( x1 = x2 ) or ( y1 = y2 ))
  [
    let cale no-patches
    set latime ( latime - 1 ) ; trebuie modificat si corectat in calcule! :=> set latime ( latime / 2 )
    ifelse x1 = x2
    [
      ; luam patch-urile intre y1 si y2
      if y1 > y2 
      [
        let temp y1
        set y1 y2
        set y2 temp
      ]
      set cale ( patches with [( pxcor >= x1 - 1 ) and ( pxcor <= x1 + latime - 1 ) and ( pycor >= y1 ) and ( pycor <= y2 )])
      
    ]
    [
      ; luam patch-urile intre x1 si x2
      if x1 > x2 
      [
        let temp x1
        set x1 x2
        set x2 temp
      ]
      set cale ( patches with [( pycor >= y1 - latime ) and ( pycor <= y1 ) and ( pxcor >= x1 ) and ( pxcor <= x2 )])
    ]
    let construit 0
    if caz = "strada"
    [
      ask cale
      [
        set pcolor ( culoare-sosea )
        set nivel 0
        set tip "sosea"
        set benzi ( ( latime + 1 ) / 2 )
        set safe true
      ]
      set construit 1
    ]
    if caz = "trotuar"
    [
      ask cale [
        set pcolor ( culoare-trotuar )
        set nivel 0
        set tip "trotuar"
        set benzi ( ( latime + 1 ) / 2 )
        set safe true
      ]
      set construit 1
    ]
    if construit = 0
    [
      show "!Primul parametru trebuie sa fie ori <<strada>> ori <<trotuar>>!"
    ]
  ]
  [
    show "!Un drum poate fi construit doar pe o abscisa sau ordonata!"
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;SITUATII CRITICE
;; Gestiunea situatiilor critice ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;activeaza alarma;;
to activeaza-alarma
  if ( quarantine = "A Random Building" )
  [
    let target-cladire random ( length cladiri - 6 ) ; se scad cele 6 cladiri speciale: aeroportul, gara perif, gara oras, centrala nucleara, barajul si hidrocentrala
    set target-cladire ( target-cladire + 3 ) ; se adauga 3 ca sa se sara aeroportul si garile. Nu se adauga 4 pentru ca ultima e centrala!
    seteaza-perimetru-cladire target-cladire ( one-of [tip] of item target-cladire cladiri )
    show (word floor timer "s: The Building with the id " target-cladire " has been armed!" )
  ]
  if ( quarantine = "The Airport" )
  [
    seteaza-perimetru-cladire ( one-of [id] of aeroport ) ( one-of [tip] of aeroport )
    show (word floor timer "s: The Airport has been armed!" )
  ]
  if ( quarantine = "The Railroad Station" )
  [
    seteaza-perimetru-cladire ( one-of [id] of gara-periferie ) ( one-of [tip] of gara-periferie )
    show (word floor timer "s: The Railroad Station has been armed!" )
  ]
  if ( quarantine = "The city Train Station" )
  [
    seteaza-perimetru-cladire ( one-of [id] of gara-oras ) ( one-of [tip] of gara-oras )
    show (word floor timer "s: The city Train Station has been armed!" )
  ]
  if ( quarantine = "The Nuclear Plant" )
  [
    seteaza-perimetru-cladire ( one-of [id] of centrala-nucleara ) ( one-of [tip] of centrala-nucleara )
    show (word floor timer "s: The Nuclear Plant has been armed!" )
  ]
  if ( quarantine = "The Hydro-electric Plant" )
  [
    seteaza-perimetru-cladire ( one-of [id] of hidrocentrala ) ( one-of [tip] of hidrocentrala )
    show (word floor timer "s: The Hydro-electric Plant has been armed!" )
  ]
  if ( quarantine = "The Hospital" )
  [
    seteaza-perimetru-cladire ( one-of [id] of spital ) ( one-of [tip] of spital )
    show (word floor timer "s: The Hospital has been armed!" )
  ]
  if ( quarantine = "The City" )
  [
    let cladiri-oras ( length cladiri - 3 )
    let cladire-curenta 2
    user-message ( "Quarantining the City should take longer because of the large number of buildings.\nPlease be patient and refraim from issuing any other commands until you receive the confirmation notice!\n\nThe button will remain pressed during the command's execution." )
    ;user-message ( "Armarea orasului va dura datorita numarului mare de cladiri.\nNu alegeti alta comanda pana nu primiti mesajul de confirmare!\n\nButonul va fi apasat cat timp se executa comanda." )
    show (word "Quarantining the City:")
    while [ cladire-curenta < cladiri-oras ]
    [
      seteaza-perimetru-cladire cladire-curenta ( one-of [tip] of item cladire-curenta cladiri )
      set cladire-curenta ( cladire-curenta + 1 )
      show (word floor ( ( cladire-curenta / cladiri-oras ) * 100 ) "% quarantined" )
    ]
    show (word floor timer "s: The City has been completely quarantined!!! Evacuation has starded!")
  ]
  if ( quarantine = "Everything" )
  [
    let cladiri-oras ( length cladiri )
    let cladire-curenta 0
    user-message ( "Quarantining Everything should take longer because of the large number of buildings.\nPlease be patient and refraim from issuing any other commands until you receive the confirmation notice!\n\nThe button will remain pressed during the command's execution." )
    ;user-message ( "Armarea LUMII va dura datorita numarului mare de cladiri.\nNu alegeti alta comanda pana nu primiti mesajul de confirmare!\n\nButonul va fi apasat cat timp se executa comanda." )
    show (word "Quarantining every building present in the World Model:")
    while [ cladire-curenta < cladiri-oras ]
    [
      seteaza-perimetru-cladire cladire-curenta ( one-of [tip] of item cladire-curenta cladiri )
      set cladire-curenta ( cladire-curenta + 1 )
      show (word floor ( ( cladire-curenta / cladiri-oras ) * 100 ) "% quarantined" )
    ]
    show (word floor timer "s: Every building has been quarantined!")
  ]
  ; update pt senzori:
  actualizeaza-monitorizarea
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;seteaza perimetru cladire;;
to seteaza-perimetru-cladire [ id-cladire-tinta tip-cladire ]
  ask patches with [ id = id-cladire-tinta and ( tip = tip-cladire ) ]
  [
    ask patches at-points [[ 3 3 ][ -3 -3 ][ 3 -3 ][ -3 3 ]] with [ tip = "sosea" or tip = "trotuar" ] ; colturile
    [
      ifelse ( tip = "sosea" )
      [
        set pcolor red
      ]
      [
        set pcolor pink
      ]
      set safe false
      ask oameni-here [ set color 25 ] ;portocaliu => echipaj interventie!
    ]
    ask patches with [ distance myself < 4 and ( tip = "sosea" or tip = "trotuar" )]
    [
      ifelse ( tip = "sosea" )
      [
        set pcolor red
      ]
      [
        set pcolor pink
      ]
      set safe false
      ask oameni-here [ set color 25 ] ; portocaliu => echipaj interventie!
    ] 
  ]
  ; actualizeaza senzor
  ask senzori with [ eveniment-urmarit = "quarantine" and cladire-id = id-cladire-tinta ]
  [
    set intensitate 1
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;INTERFATA
;; INTERFATA: ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;adauga butoane;;
to adauga-butoane [ start-x-butoane start-y-butoane X-butoane Y-butoane dim-butoane spatiu-butoane id-butoane ] 
  let i 0
  let dim dim-butoane - 1     ; corectie !
  let spatiu spatiu-butoane + 1  ; corectie !
  while [ i < X-butoane ]
  [
    ; fiecare rand in parte
   let j 0
   while [ j < Y-butoane ]
   [
     ; fiecare buton in parte
     let buton ( patches with [ (pxcor <= ( start-x-butoane - ( j * dim )) and pxcor >= ( start-x-butoane - ( ( j + 1 ) * dim )))
                  and   (pycor <= ( start-y-butoane - ( i * dim )) and pycor >= ( start-y-butoane - ( ( i + 1 ) * dim ))) ] )
     ask buton
     [
       set pcolor red
       set nivel 1
       set tip "interfata"
       set id id-butoane
     ]
     set butoane lput buton butoane
     set id-butoane ( id-butoane + 1 )
     set j ( j + 1 )
     set start-x-butoane ( start-x-butoane - spatiu )
   ]
   set i ( i + 1 )
   set start-y-butoane ( start-y-butoane - spatiu)
   set start-x-butoane ( start-x-butoane + ( Y-butoane * spatiu ))
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;adauga elemente de monitorizare;;
to adauga-elemente-monitorizare [ start-x-em start-y-em X-em Y-em dim-em spatiu-em cladire-parinte nume-cladire-parinte stari-urmarite ] ; stari-urmarite este o lista cu starile, in ordine
  let i 0
  set dim-em dim-em - 1     ; corectie !
  let spatiu spatiu-em + 1  ; corectie !
  let id-em length elemente-afisare ; actualizare id curent
  ask patch ( start-x-em + 1 ) ( start-y-em + 3 )
  [
    set plabel nume-cladire-parinte
    set plabel-color black
  ]
  while [ i < X-em ]
  [
    ; fiecare rand in parte
   let j 0
   while [ j < Y-em ]
   [
     ; fiecare buton in parte
     let element-monitorizare ( patches with [ (pxcor <= ( start-x-em - ( j * dim-em )) and pxcor >= ( start-x-em - ( ( j + 1 ) * dim-em )))
                  and   (pycor <= ( start-y-em - ( i * dim-em )) and pycor >= ( start-y-em - ( ( i + 1 ) * dim-em ))) ] )
     ask element-monitorizare
     [
       set pcolor green
       set nivel 1
       set tip "interfata"
       set id id-em
       set stare ( item ( i * Y-em + j ) stari-urmarite )
       set id-cladire cladire-parinte
     ]
     set elemente-afisare lput element-monitorizare elemente-afisare
     set id-em ( id-em + 1 )
     set j ( j + 1 )
     set start-x-em ( start-x-em - spatiu )
     ; adaugare label
     ask element-monitorizare with [ ( pycor = (([pycor] of min-one-of element-monitorizare [pycor]) + 1 ) ) and ( pxcor = [pxcor] of min-one-of element-monitorizare [pxcor] ) ]
     [
       let eveniment stare
       ask patch-at-heading-and-distance -90 ( 2 ) 
       [
         set plabel eveniment
         set plabel-color black
       ] 
     ]
   ]
   set i ( i + 1 )
   set start-y-em ( start-y-em - spatiu)
   set start-x-em ( start-x-em + ( Y-em * spatiu ))
  ]
end

to adauga-senzori-monitorizare [ cladire-parinte stari-urmarite praguri ]
  let id-num length senzori-monitorizare
  let index-prag 0
  foreach stari-urmarite
  [
    let target-building item cladire-parinte cladiri
    create-senzori 1 [
      set hidden? true
      move-to one-of target-building with [ count turtles-here < 1 ]
      set id-senzor id-num
      set ( id-num ) ( id-num + 1 )
      set eveniment-urmarit ( ? )
      set cladire-id ( cladire-parinte )
      set intensitate 0
      set prag item index-prag praguri
      set color ( pcolor + 20 )
      set senzori-monitorizare lput ( self ) senzori-monitorizare
      set index-prag ( index-prag + 1 )
    ]
  ]
  ; adauga id-ul cladirea in lista
  set cladiri-monitorizate lput ( item cladire-parinte cladiri ) cladiri-monitorizate
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;RUNTIME
;; Slowmotion si teste: ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;incetineste tickuri;;
to slow-down-time
  wait 0.2
end

to-report afiseaza-timp-rulare
  ifelse ( ticks > last-tick-running )
  [
    set ( timer-running ) ( timer-running + ( timer - timer-dummy ) )
    set last-tick-running ticks
    set timer-dummy timer
    ;show "ON"
  ]
  [
    set timer-dummy timer
    ;show "OFF"
  ]
  report (word floor ( timer-running / 3600 ) " hours, " floor ( timer-running / 60 ) " minutes and " floor ( timer-running mod 60 ) " seconds ")
  ;report (word floor ( timer / 3600 ) " ore, " floor ( timer / 60 ) " minute si " floor ( timer mod 60 ) " secunde ")
end

to-report masini-in-oras
  report (word "There are " masini-plotate " vehicles in the City" )
end

to test-iduri-cladiri
  let maxt length cladiri
  let t 0
  while [ t < maxt ]
  [
    print (word "Building " t ": " mean [id] of item t cladiri )
    set t ( t + 1)
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
196
8
1250
603
130
70
4.0
1
10
1
1
1
0
1
1
1
-130
130
-70
70
1
1
1
ticks
30.0

BUTTON
6
32
61
65
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
66
32
121
65
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
4
104
181
137
numcars
numcars
0
300
160
1
1
cars
HORIZONTAL

SLIDER
6
68
182
101
numpeople
numpeople
0
300
190
1
1
people
HORIZONTAL

SLIDER
4
140
181
173
numbuses
numbuses
0
100
3
1
1
buses
HORIZONTAL

SLIDER
6
176
182
209
numtrucks
numtrucks
0
100
0
1
1
trucks
HORIZONTAL

TEXTBOX
56
10
154
28
World Setup
16
0.0
1

TEXTBOX
73
250
129
270
Events
16
0.0
1

SLIDER
7
305
182
338
earthquake-magnitude
earthquake-magnitude
0
7.9
4.7
0.1
1
NIL
HORIZONTAL

BUTTON
126
32
181
65
slow
slow-down-time
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
1044
36
1244
201
Vehicles state
ticks
number of vehicles
0.0
10.0
0.0
100.0
true
true
"" ""
PENS
"stopped" 1.0 0 -2674135 true "" "plot count turtles with [ categorie = \"rutier\" and ( count turtles-on patch-ahead 1 > 0 or viteza = 0 ) ]"
"in motion" 1.0 0 -13345367 true "" "plot count turtles with [ categorie = \"rutier\" and count turtles-on patch-ahead 1 < 1 and viteza > 0 ]"

BUTTON
6
424
183
458
Add Quarantine
activeaza-alarma
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

CHOOSER
7
376
184
421
quarantine
quarantine
"A Random Building" "The Airport" "The Railroad Station" "The city Train Station" "The Hospital" "The Nuclear Plant" "The Hydro-electric Plant" "The City" "Everything"
0

BUTTON
6
213
182
247
hide/show sensors
ask senzori [ set hidden? ( not hidden? ) ]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
7
340
183
374
Update Seismic Activity
actualizeaza-cutremur earthquake-magnitude
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
6
467
183
501
Reset events
reseteaza-lume
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

CHOOSER
5
505
122
550
target
target
"The Airport" "The Railroad Station" "The city Train Station" "The Hospital" "The Nuclear Plant" "The Hydro-electric Plant"
0

CHOOSER
5
557
123
602
event
event
"threat" "fire" "robbery" "blackout"
3

BUTTON
125
505
181
603
Update
aplica-eveniment-cladire target event
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
8
270
182
303
Crash Airplane
ask avioane [ set prabuseste true ]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
1045
205
1244
250
Simulation elapsed time
afiseaza-timp-rulare
17
1
11

PLOT
1045
253
1243
386
Vehicles in city
ticks
urban traffic
0.0
10.0
0.0
100.0
true
false
"set masini-plotate ( floor count turtles with [ categorie = \"rutier\" and ( xcor >= -6 and ycor <= 24 ) ] )" "set masini-plotate ( floor count turtles with [ categorie = \"rutier\" and ( xcor >= -6 and ycor <= 24 ) ] )"
PENS
"default" 1.0 0 -8630108 true "" "plot masini-plotate"

MONITOR
1045
389
1244
434
Vehicles in city
masini-in-oras
17
1
11

@#$#@#$#@
## What is this?

This Netlogo Simulation is the Thesis of George-Alexandru Serea, Bucharest, Romania.
You can use and modify this file as long as you contain a visible reference to its initial author.

## What does this Simulation accomplish?

This simulation generates the virtual World or World Model that consists of a city in which we have ongoing traffic, pedestrians as well as air and railroad traffic. The scope of this work is to illustrate the outcome of implementing critical systems protocols using the CitySCAPE framework.

## How to use this Simulation?

The User selects the desired number of people, cars, buses and trucks that will occupy the World Model and presses the "Setup" button. Afterwards, the User should press the "go" button to start the simulation.
At any time the User can slow down the world's pace in order to see more clearly what is happening at each tick. Please note that the Simulation's running time is always displayed on the right side of the interface and that the elapsed time is measured in real time, not in a Simulated fashion.
In this World Model, the User can deploy various events and see the World's critical response to those events. At any time the User can reset the World to it's initial state.

## Notes

- ongoing traffic is implemented in a minimal fashion, not including stop lights.
- there is only one Airport and one aerial route for the airplanes to follow
- the Hospital is always assigned a random building at Setup
- there is a slight delay between declaring a quarantine and setting up the quarantined area around a building
- crashing the Airplane affects only the closest building or road

## Possible improvements

Most improvements refer to the agents movement. We could add acceleration and deceleration, curved trajectories and so on and so forth.

## Presentation date

This thesis was presented at the Politehnica University of Bucharest on 11 July 2013 by George-Alexandru Serea.

## Usage

You may use and extend this model, but keep a reference to the original Author and University. Thank you!
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

bus
true
0
Circle -7500403 true true 90 227 58
Circle -7500403 true true 90 17 58
Rectangle -7500403 true true 90 45 150 255
Rectangle -7500403 true true 135 15 195 285
Circle -16777216 true false 174 219 42
Circle -16777216 true false 174 54 42
Rectangle -11221820 true false 120 15 150 30
Rectangle -11221820 true false 120 45 150 120
Rectangle -11221820 true false 120 180 150 255
Rectangle -11221820 true false 120 150 180 165
Rectangle -11221820 true false 120 135 180 150
Rectangle -1184463 true false 165 15 165 30
Rectangle -1184463 true false 165 15 180 30
Rectangle -2674135 true false 165 270 180 285
Rectangle -11221820 true false 120 270 150 285

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
true
0
Polygon -7500403 true true 180 0 164 21 144 39 135 60 132 74 106 87 84 97 63 115 50 141 50 165 60 225 150 300 165 300 225 300 225 0 180 0
Circle -16777216 true false 180 30 90
Circle -16777216 true false 180 180 90
Polygon -16777216 true false 80 138 78 168 135 166 135 91 105 106 96 111 89 120
Circle -7500403 true true 195 195 58
Circle -7500403 true true 195 47 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

locomotiva
true
0
Polygon -7500403 true true 150 300 150 0 45 30 45 270
Rectangle -13791810 true false 75 195 105 255
Rectangle -13791810 true false 75 120 105 180
Rectangle -13791810 true false 75 45 105 105
Circle -16777216 true false 150 240 30
Circle -16777216 true false 150 210 30
Circle -16777216 true false 150 30 30
Circle -16777216 true false 150 60 30
Line -7500403 true 75 60 105 60
Line -7500403 true 60 75 105 75
Line -7500403 true 60 90 105 90
Line -7500403 true 60 135 120 135
Line -7500403 true 75 150 105 150
Line -7500403 true 75 165 120 165
Line -7500403 true 60 210 105 210
Line -7500403 true 60 225 105 225
Line -7500403 true 75 240 105 240

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

semafor
true
15
Rectangle -7500403 true false 135 30 150 30
Rectangle -7500403 true false 105 30 195 210
Rectangle -7500403 true false 135 210 165 300
Circle -2674135 true false 129 39 42
Circle -955883 true false 129 99 42
Circle -13840069 true false 129 159 42

semafor_mono
true
1
Rectangle -7500403 true false 60 30 240 210
Rectangle -7500403 true false 120 195 180 300
Circle -2674135 true true 75 45 150
Rectangle -7500403 true false 90 285 210 315

semafor_mono_mic
true
1
Rectangle -11221820 true false 45 45 195 195
Rectangle -11221820 true false 90 195 150 270
Circle -2674135 true true 60 60 120
Rectangle -11221820 true false 60 255 180 270

senzor
false
0
Circle -7500403 false true -2 -2 302
Circle -7500403 false true 15 15 270
Circle -7500403 false true 30 30 240
Circle -7500403 false true 45 45 210
Circle -7500403 false true 60 60 180

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
true
0
Rectangle -7500403 true true 45 105 187 296
Polygon -7500403 true true 193 4 150 4 134 41 104 56 104 92 194 93
Rectangle -1 true false 60 105 105 105
Polygon -16777216 true false 112 62 141 48 141 81 112 82
Circle -16777216 true false 174 24 42
Rectangle -7500403 true true 185 86 194 119
Circle -16777216 true false 174 114 42
Circle -16777216 true false 174 234 42
Circle -7500403 false true 174 234 42
Circle -7500403 false true 174 114 42
Circle -7500403 false true 174 24 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

vagon
true
0
Polygon -7500403 true true 150 285 150 15 45 15 45 285
Rectangle -13791810 true false 75 195 105 240
Rectangle -13791810 true false 75 120 105 180
Rectangle -13791810 true false 75 60 105 105
Circle -16777216 true false 150 240 30
Circle -16777216 true false 150 210 30
Circle -16777216 true false 150 30 30
Circle -16777216 true false 150 60 30
Rectangle -6459832 true false 45 285 150 300
Rectangle -6459832 true false 45 0 150 15
Line -7500403 true 105 240 150 240
Line -7500403 true 75 225 120 225
Line -7500403 true 75 210 105 210
Line -7500403 true 75 165 105 165
Line -7500403 true 75 150 105 150
Line -7500403 true 60 135 120 135
Line -7500403 true 75 90 105 90
Line -7500403 true 60 75 105 75
Line -7500403 true 90 60 150 60
Rectangle -16777216 false false 60 255 135 285
Rectangle -16777216 false false 60 15 135 45
Line -16777216 false 60 270 135 270
Line -16777216 false 60 30 135 30

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
