globals [ count-of-turtles
patchset-A1
patchset-A2
patchset-B1
patchset-B2
patchset-C1
patchset-C2
patchset-D1
patchset-D2
patiencevalue
]

turtles-own [
 speed
 status
  speedlimit
 entry-point
  acceleration
  yellow-patch-count
  segment
  lane
  prime
  num1
  num2
  num3
  num4
  num5
  num6
  num7
  num8
  life

]

to setup
  ca
  ask patches [set pcolor green]

  ;; construct main approach roads
  ask patches [
    if pxcor > -82  and pxcor < 82 [ set pcolor black]
    if pycor > -82 and pycor < 82 [ set pcolor black]
    ;; draw central lines
    if pxcor > -1 and pxcor < 1 [set pcolor brown]
    if pycor > -1 and pycor < 1 [set pcolor brown]
    ;; draw lanes
    if pxcor > 25 and pxcor < 27 [ set pcolor white]
    if pxcor > 52 and pxcor < 54 [ set pcolor white]
    if pxcor > 79 and pxcor < 81 [ set pcolor white]
    if pxcor > -27 and pxcor < -25 [ set pcolor white]
    if pxcor > -54 and pxcor < -52 [ set pcolor white]
    if pxcor > -81 and pxcor < -79 [ set pcolor white]

    if pycor > 25 and pycor < 27 [ set pcolor white]
    if pycor > 52 and pycor < 54 [ set pcolor white]
    if pycor > 79 and pycor < 81 [ set pcolor white]
    if pycor > -27 and pycor < -25 [ set pcolor white]
    if pycor > -54 and pycor < -52 [ set pcolor white]
    if pycor > -81 and pycor < -79 [ set pcolor white]
  ]
  ;; Construct roundabout
  ask patches [
    if (distancexy 0 0)  < 30
   [ set pcolor white ]
    if (distancexy 0 0) > 30 and (distancexy 0 0) < 109
   [ set pcolor black ]
    if (distancexy 0 0) > 55 and (distancexy 0 0) < 57
   [ set pcolor white ]

    if (distancexy 0 0) > 82 and (distancexy 0 0) < 84
   [ set pcolor white ]

    if (distancexy 0 0) > 109 and (distancexy 0 0) < 111
   [ set pcolor white ]

  ]


  ;; Construct entry points for inner lane
  ask patches [
    if ((pxcor > 10 and pxcor < 25) and (pycor > -50 and pycor < -35))
    or ((pxcor > -25 and pxcor < -10) and (pycor < 50 and pycor > 35))
    or ((pxcor > -50 and pxcor < -35) and (pycor < -10 and pycor > -25))
    or ((pxcor < 50 and pxcor > 35) and (pycor > 10 and pycor < 25))
    [
      set pcolor green]
  ]

    ;; Construct exit points for inner lane
  ask patches [
    if ((pxcor < -10 and pxcor > -25) and (pycor > -45 and pycor < -30))
    or ((pxcor < 25 and pxcor > 10) and (pycor < 45 and pycor > 30))
    or ((pxcor > -50 and pxcor < -35) and (pycor > 10 and pycor < 25))
    or ((pxcor < 50 and pxcor > 35) and (pycor < -10 and pycor > -25))
    [
      set pcolor yellow
    ]
  ]

    ;; Construct entry points for middle lane
  ask patches [
    if ((pxcor > 35 and pxcor < 50) and (pycor > -65 and pycor < -50))
    or ((pxcor > -50 and pxcor < -35) and (pycor < 65 and pycor > 50))
    or ((pxcor > -65 and pxcor < -50) and (pycor < -30 and pycor > -45 ))
    or ((pxcor < 65 and pxcor > 50) and (pycor > 30 and pycor < 45))
    [
      set pcolor green]
  ]

    ;; Construct exit points for middle lane
  ask patches [
    if ((pxcor < -35 and pxcor > -50) and (pycor > -65 and pycor < -50))
    or ((pxcor < 50 and pxcor > 35) and (pycor < 65 and pycor > 50))
    or ((pxcor > -65 and pxcor < -50) and (pycor > 35 and pycor < 50))
    or ((pxcor < 65 and pxcor > 50) and (pycor < -35 and pycor > -50))
    [
      set pcolor yellow
    ]
  ]
;; Construct entry points for outer lane
  ask patches [
    if ((pxcor > 60 and pxcor < 70) and (pycor > -85 and pycor < -75))
    or ((pxcor > -70 and pxcor < -60) and (pycor < 85 and pycor > 75))
    or ((pxcor > -85 and pxcor < -75) and (pycor < -60 and pycor > -70 ))
    or ((pxcor < 85 and pxcor > 75) and (pycor > 60 and pycor < 70))
    [
      set pcolor green]
  ]

    ;; Construct exit points for outer lane
  ask patches [
    if ((pxcor < -60 and pxcor > -70) and (pycor > -85 and pycor < -75))
    or ((pxcor < 70 and pxcor > 60) and (pycor < 85 and pycor > 75))
    or ((pxcor > -85 and pxcor < -75) and (pycor > 60 and pycor < 70))
    or ((pxcor < 85 and pxcor > 75) and (pycor < -60 and pycor > -70))
    [
      set pcolor yellow
    ]

  ]

  ;; construct roundabout entry stop points
  ask patches [
    if ((pxcor > 10 and pxcor < 20) and (pycor < -110 and pycor > -112))
    or ((pxcor > -20 and pxcor < -10) and (pycor > 110 and pycor < 112))
    or ((pxcor > 35 and pxcor < 45) and (pycor < -104 and pycor > -106))
    or ((pxcor > 60 and pxcor < 70) and (pycor < -92 and pycor > -94))
    or ((pxcor > -45 and pxcor < -35) and (pycor > 104 and pycor < 106))
    or ((pxcor > -70 and pxcor < -60) and (pycor > 92 and pycor < 94))
    or ((pxcor > 110 and pxcor < 112) and (pycor > 10 and pycor < 20))
    or ((pxcor > 104 and pxcor < 106) and (pycor > 35 and pycor < 45))
    or ((pxcor > 92 and pxcor < 94) and (pycor > 60 and pycor < 70))
    or ((pxcor < -110 and pxcor > -112) and (pycor < -10 and pycor > -20))
    or ((pxcor < -104 and pxcor > -106) and (pycor < -35 and pycor > -45))
    or ((pxcor < -92 and pxcor > -94) and (pycor < -60 and pycor > -70))

    [set pcolor red]
  ]

  crt 1 [ setxy 15 -111 set heading 335 set prime 1]
  crt 1 [ setxy 40 -105 set heading 325 set prime 2]
  crt 1 [setxy 111 15 set heading 245 set prime 3 ]
  crt 1 [setxy 105 40 set heading 235 set prime 4 ]
  crt 1 [setxy -15 111 set heading 155 set prime 5 ]
  crt 1 [setxy -30 105 set heading 145 set prime 6 ]
  crt 1 [setxy -111 -15 set heading 65 set prime 7 ]
  crt 1 [setxy -105 -40 set heading 55 set prime 8 ]
    ask turtles [
    if prime = 1 [ set patchset-A1 patches in-cone 100 40] ; ask patchset-A1 [ set pcolor pink]]
    if prime = 2 [ set patchset-A2 patches in-cone 80 40 ] ;ask patchset-A2 [ set pcolor green]]
    if prime = 3 [ set patchset-B1 patches in-cone 100 40 ] ; ask patchset-B1 [ set pcolor pink]]
    if prime = 4 [ set patchset-B2 patches in-cone 80 40 ] ; ask patchset-B2 [ set pcolor green]]
    if prime = 5 [ set patchset-C1 patches in-cone 100 40 ] ; ask patchset-C1 [ set pcolor pink]]
    if prime = 6 [ set patchset-C2 patches in-cone 80 40 ] ; ask patchset-C2 [ set pcolor green]]
    if prime = 7 [ set patchset-D1 patches in-cone 100 40 ] ; ask patchset-D1 [ set pcolor pink]]
    if prime = 8 [ set patchset-D2 patches in-cone 80 40 ] ; ask patchset-D2 [ set pcolor green]]
    die
  ]
  reset-ticks

end

to go
  ;; create car in section A
  ask patch 15 -190 [
    if not any? turtles in-radius 10 and random int-arr-time = 1 [
      sprout 1 [set shape "car" set size 13 set entry-point "A1" set color red set heading 0 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "A" set lane 1 set life 0]

    ]
    ]
  ask patch 40 -190 [
    if not any? turtles in-radius 10  and random int-arr-time = 1 [
      sprout 1 [ set shape "car" set size 13 set entry-point "A2" set color red  set heading 0 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "A" set lane 2 set life 0]
    ]
    ]
  ask patch 65 -190 [
    if not any? turtles in-radius 10  and random int-arr-time = 1 [
      sprout 1 [ set shape "car" set size 13 set entry-point "A3" set color red  set heading 0 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "A" set lane 3 set life 0]
    ]
  ]
  ;; create car in section B
  ask patch 190 15 [
    if not any? turtles in-radius 10  and random int-arr-time = 1 [
      sprout 1 [set shape "car" set size 13 set entry-point "B1" set color blue set heading -90 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "B" set lane 1 set life 0]
    ]
    ]
  ask patch 190 40 [
    if not any? turtles in-radius 10  and random int-arr-time = 1 [
      sprout 1 [ set shape "car" set size 13 set entry-point "B2" set color blue  set heading -90 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "B" set lane 2 set life 0]
    ]
    ]
  ask patch 190 65 [
    if not any? turtles in-radius 10  and random int-arr-time = 1 [
      sprout 1 [ set shape "car" set size 13 set entry-point "B3" set color blue  set heading -90 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "B" set lane 3 set life 0]
    ]
  ]
  ;; create car in section C
  ask patch -15 190 [
    if not any? turtles in-radius 10  and random int-arr-time = 1 [
      sprout 1 [set shape "car" set size 13 set entry-point "C1" set color orange set heading 180 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "C" set lane 1 set life 0]
    ]
    ]
  ask patch -40 190 [
    if not any? turtles in-radius 10 and random int-arr-time = 1 [
      sprout 1 [ set shape "car" set size 13 set entry-point "C2" set color orange  set heading 180 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "C" set lane 2 set life 0]
    ]
    ]
  ask patch -65 190 [
    if not any? turtles in-radius 10 and random int-arr-time = 1 [
      sprout 1 [ set shape "car" set size 13 set entry-point "C3" set color orange  set heading 180 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "C" set lane 3 set life 0]
    ]
  ]
    ;; create car in section D
  ask patch -190 -15 [
    if not any? turtles in-radius 10 and random int-arr-time = 1 [
      sprout 1 [set shape "car" set size 13 set entry-point "D1" set color magenta set heading 90 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "D" set lane 1 set life 0]
    ]
    ]
  ask patch -190 -40 [
    if not any? turtles in-radius 10 and random int-arr-time = 1 [
      sprout 1 [ set shape "car" set size 13 set entry-point "D2" set color magenta  set heading 90 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "D" set lane 2 set life 0]
    ]
    ]
  ask patch -190 -65 [
    if not any? turtles in-radius 10 and random int-arr-time = 1 [
      sprout 1 [ set shape "car" set size 13 set entry-point "D3" set color magenta  set heading 90 set speed 0.2 set status "Entry" set yellow-patch-count 0 set segment "D" set lane 3 set life 0]
  ]
  ]
  ask turtles [ set speedlimit 0.6
  set acceleration 0.1
  move-on-road
  set life life + 1
  let-turtle-die]
  tick
end

;; procedure for turtle to move on the road i.e. approaching roundabout, entering roundabout, travelling in roundabout, exiting roundabout and onward travel
;;
to move-on-road

;; light red patch at the entrance of the roundabout is the location where each car has to stop and check for traffic before proceeding into the roundabout
  if [pcolor] of patch-here = red and lane != 3
  [ if any? other turtles-on patch-here [ die ]
    set speed 0.0
    set status "Stop"
    set num1 count turtles-on patchset-A1
    set num2 count turtles-on patchset-A2
    set num3 count turtles-on patchset-B1
    set num4 count turtles-on patchset-B2
    set num5 count turtles-on patchset-C1
    set num6 count turtles-on patchset-C2
    set num7 count turtles-on patchset-D1
    set num8 count turtles-on patchset-D2

    ;; if driver is patient, then she will wait for all cars to clear. If not, she will try to enter roundabout even with cars approaching from her left side.
    ifelse patience = "patient"
      [ set patiencevalue 2]
      [ set patiencevalue 5]

    if entry-point = "A1" and num1 < patiencevalue [ fd 2 set status "Go" ]
    if entry-point = "A2" [
      if  num2 < patiencevalue [ fd 2 set status "Go" ]
      if [ entry-point ] of turtles-on patchset-A2 = "A1" [ fd 2 set status "Go" ]]
    if entry-point = "B1" and num3 < patiencevalue [ fd 2 set status "Go" ]
    if entry-point = "B2" [
      if num4 < patiencevalue [ fd 2 set status "Go" ]
      if [ entry-point ] of turtles-on patchset-B2 = "B1" [ fd 2 set status "Go" ]]
    if entry-point = "C1" and num5 < patiencevalue [ fd 2 set status "Go" ]
    if entry-point = "C2" [
      if num6 < patiencevalue [ fd 2 set status "Go" ]
      if [ entry-point ] of turtles-on patchset-C2 = "C1" [ fd 2 set status "Go" ]]
    if entry-point = "D1" and num7 < patiencevalue [ fd 2 set status "Go" ]
    if entry-point = "D2" [
      if num8 < patiencevalue [ fd 2 set status "Go" ]
      if [ entry-point ] of turtles-on patchset-D2 = "B1" [ fd 2 set status "Go" ]
  ]
    set num1 0
    set num2 0
    set num3 0
    set num4 0
    set num5 0
    set num6 0
    set num7 0
    set num8 0
  ]

;; Green colored patch provides a circular motion for the cars within the roundabout
  if [pcolor] of patch-here = green
    [ if entry-point = "A1" or entry-point = "B1" or entry-point = "C1" or entry-point = "D1" and status = "Go"
      [ set speed 0.6 rt 50 set status "RAinner" fd 10  ]
    if entry-point = "A2" or entry-point = "B2" or entry-point = "C2" or entry-point = "D2" and status = "Go"
      [ set speed 0.6 rt 50 set status "RAmiddle" fd 10  ]
  if entry-point = "A3" or entry-point = "B3" or entry-point = "C3" or entry-point = "D3" and status = "Entry"
      [ set speed 0.6 rt 45 set status "RAouter" fd 7  ]]

  ;; Circular path for cars travelling the innermost lane
  if status = "RAinner"
  [ if speed != 0 [ lt 0.75 ]
    ;; Car stops if there is another car ahead and its color changes to yellow. Color changes back to original color once speed becomes more than 0
    let car-ahead-conei one-of turtles in-cone 20 90
    ifelse car-ahead-conei != nobody and car-ahead-conei != self
     [set speed 0 set color yellow]
     [if speed < speedlimit
      [set speed 0.6 if segment = "A" [ set color red ] if segment = "B" [ set color blue] if segment = "C" [ set color orange ] if segment = "D" [ set color magenta ]]
    ifelse [ pcolor]  of patch-here = yellow and yellow-patch-count > 200
    [ set status "Exit" rt 42]
    [ set yellow-patch-count yellow-patch-count + 1 ]
  ]]

  ;; Circular path for cars travelling in the middle lane
  if status = "RAmiddle"
  [if speed != 0 [lt 0.5]

    ;; Car stops if there is another car ahead and its color changes to yellow. Color changes back to original color once speed becomes more than 0
    let car-ahead-conem one-of turtles in-cone 20 90
    ifelse car-ahead-conem != nobody and car-ahead-conem != self
      [set speed 0 set color yellow ]
     [if speed < speedlimit
      [set speed 0.6 if segment = "A" [ set color red ] if segment = "B" [ set color blue] if segment = "C" [ set color orange ] if segment = "D" [ set color magenta ]]
   ifelse [ pcolor]  of patch-here = yellow and yellow-patch-count > 60
    [ set status "Exit" rt 55]
    [ set yellow-patch-count yellow-patch-count + 1 ]

  ]]

  ;; Path for cars travelling in the outermost lane
  if status = "RAouter"
  [lt 0.3
  ifelse [ pcolor]  of patch-here = yellow
    [ set status "Exit" rt 48]
    [ set yellow-patch-count yellow-patch-count + 1 ]

  ]
;; Forward motion of the car. When the car enters the roundabout (i.e. before Green patch), car is in "Go" state and checks for car ahead and stops if there are any.
  if status = "Entry" or status = "Exit" or status = "Go" [
    car-ahead-action
    if status = "Go" [ car-ahead-incone ]
  ]
  fd speed

end

;; procedure for turtle to enter the roundabout from the road
to car-ahead-action
let car-ahead one-of turtles-on patch-ahead 10
    ifelse car-ahead != nobody
     [set speed [ speed ] of car-ahead ]
     [if speed < speedlimit
      [set speed speed + 0.1 ]
   ]

end


;; procedure for turtle to move in the roundabout
to car-ahead-incone
let car-ahead one-of turtles in-cone 20 10
    ifelse car-ahead != nobody and car-ahead != self
     [set speed 0 set color yellow]
     [if speed < speedlimit
      [set speed 0.6 if segment = "A" [ set color red ] if segment = "B" [ set color blue] if segment = "C" [ set color orange ] if segment = "D" [ set color magenta ]]
   ]

end

;; procedure for turtle to die

to let-turtle-die
    if ((entry-point = "A1" or entry-point = "B2" or entry-point = "C3") and xcor < -170)
    or ((entry-point = "A2" or entry-point = "B3" or entry-point = "D1") and ycor > 170)
    or ((entry-point = "A3" or entry-point = "D2" or entry-point = "C1") and xcor > 170)
    or ((entry-point = "B1" or entry-point = "C2" or entry-point = "D3") and ycor < -170)
    [ die ]

end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
619
420
-1
-1
1.0
1
10
1
1
1
0
0
0
1
-200
200
-200
200
1
1
1
ticks
30.0

BUTTON
68
54
135
87
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
23
177
195
210
int-arr-time
int-arr-time
0
120
31.0
1
1
NIL
HORIZONTAL

BUTTON
69
109
132
142
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
39
222
177
267
patience
patience
"patient" "impatient"
0

PLOT
780
85
1228
393
Mean Life of Cars
Time
MeanLife
0.0
10.0
0.0
10.0
true
false
"plot 0" ""
PENS
"default" 1.0 0 -16777216 true "" "if count turtles > 0 [ plot mean [ life ] of turtles ]"

@#$#@#$#@
## WHAT IS IT?

This model shows a three lane roundabout traffic. The objective of the model is to highlight the emergent traffic patterns as a result of the driver's level of patience when trying to negotiate the roundabout.

## HOW IT WORKS
Cars from each of the four segments arrive at the roundabout. When the cars are over the thin red patches, they stop and look for traffic on their left side. If there is no traffic, the cars proceed into the roundabout.

Once on the green patch, their motion is changed into a circular motion taking them to the desired exit. The desired exit is pre-programmed for a car depending on from which segment it enters the roundabout and its lane.

The cars keep a count of the number of yellow patches traveresed. When the desired exit is reached, the yellow patch counts meets a criteria and the exit actions are performed.

Once they exit, they die after reaching end of the road.


## HOW TO USE IT

SETUP - Sets up the roundabout

GO - The go command sprouts cars based on the interarrival time. The interarrival time is not a distribution but only used in a proxy mode (by means of the random function) to replicate traffic density. 

Interarrival Time Slider - A lower interarrival time means more arrivals and vice versa. Rush hour will have a low interarrival time whereas off peak time will have large interarrival time

Patience Chooser - Two scenarios are provided. In one case, all drivers are patient and are therefore willing to wait for all cars to clear from their left side before they enter the roundabout. 

On the other hand, when drivers are impatient, they enter the roundabout about even if there are about 2 -3 cars arriving from their left side.

## THINGS TO NOTICE

Cars entering the roundabout will stop if there is any car in front of them. When they stop, their color changes to yellow. Once they start moving again, color changes back to their original color.

So when the cars stop and start moving again quite quickly, the color change appear as blinks. These blinks is similar to the application of brake lights and indicates that the car has slowed down.

It can be noticed that when the driver is impatient and it is rushour, the roundabout becomes increasingly choked since every one is trying to save on waiting time and trying to clear the roundabout.

On the other hand, when the driver is patient even during heavy traffic, the roundabout is less congested and traffic always clears.

## THINGS TO TRY

The two scenarios namely patient and impatient can be tried with multiple values of interarrival time. Significant increase in congestion can be observed only when the interarrival time is small.

It is aslo suggested to run the model with low interarrival time in the patient scenario mode and observe the roundabout traffic.  Now change scenario to impatient mode and observe the increased congestion and blocks. Now change scenario again to patient mode and observe how the block clears from the roundabout.

A plot of the mean car life time in the simulation is included. The variation of the mean life with different scenarios and settings can be explored. Some results can be counterintuitive. It is suggested that the user predict the expected outcome and compare it with the actuals.

## EXTENDING THE MODEL

Additional scenarios: The model can be extended with additional scenarios such as assigning random patience among drivers. Also the traffic flow can be different for each of the segments and see how it affects the traffic in the roundabout.

The level of patience can also be expanded and explored.

Plots: Additional plots can be added such as time spent waiting to enter roundabout and time spent for clearing roundabout

## NETLOGO FEATURES



## RELATED MODELS

Traffic Basic and Circular path example were referred to understand and code the car movement behavior

## CREDITS AND REFERENCES

1. Traffic Basic Netlogo model

2. Circular Path Example Netlogo model
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
