turtles-own [name nearest-Exit]
patches-own [exit]
globals [Armory suitor-Armory Ody-xcor Ody-ycor Tele-xcor Tele-ycor this-turn last-turn cards
  starting level-oneing dialogue-oneing tutorialing escapist transition level-twoing
  global-tick]
breed [suitors suitor]

; TO DO
; Create at least 1 map and a tutorial
; Start screen
; Back button
; Playtesting

to startup
  ca
  resize-world -14 14 -8 8
  set-patch-size 24
  THE-PALACE
  write-sentence "PRESS G TO BEGIN PLAYING" -11 0 green 1
  set global-tick 1
  reset-ticks
end

to go
  tick
  if global-tick = 0 [startup]
  if global-tick = 1 [start-screen]
  if global-tick = 2 [level-tutorial]
  if global-tick = 3 [level-one]
end

to start-screen
  while [starting != 1 and starting != 2] [cd clear-turtles clear-patches
    ask patches with [pycor = 8] [sprout 3 [set heading 180 setxy (pxcor + (random-float -2) + 1) (pycor + 0.25) set color (random 3) + 11
    set pen-size random 10 + 8 pd fd random-float 2 if pxcor > 10 or pxcor < -10 [fd (random-float 10) + 2] if pxcor = -3 or pxcor = -2 [fd random-float 3] die]]
  set starting 1]
  while [starting = 1 and starting != 2] [THE-PALACE
    write-sentence "TUTORIAL" -4 1 green 3
    write-sentence "LEVEL 1: SUITORS" -8 -1 yellow 3
    ask patches [if pxcor >= -4 and pxcor <= 3 and pycor = 1 [set pcolor 57]]
    ask patches [if pxcor >= -8 and pxcor <= 7 and pycor = -1 [set pcolor 27]]
  set starting 2]

  if mouse-down? and [pcolor] of patch round mouse-xcor round mouse-ycor = 57 [set global-tick global-tick + 1]
  if mouse-down? and [pcolor] of patch round mouse-xcor round mouse-ycor = 27 [set global-tick global-tick + 2]
end

to level-tutorial
  while [tutorialing = 0] [
  clear-patches
  clear-turtles
  clear-drawing
  set this-turn 1
  set last-turn 1
  set Armory false
  set suitor-Armory false
    set cards  0
    write-sentence (list this-turn) -8 8 white 3
  cro max-pxcor * 2 + 2 [setxy max-pxcor + who - 0.5 max-pycor set heading 180 set color black pd fd max-pycor * 2 + 2 die] ;down
  cro max-pycor * 2 + 2 [setxy max-pxcor + 1 max-pycor + who - 0.5 set heading 90 set color black pd fd max-pxcor * 2 + 2 die] ;side
  ask patches [set pcolor gray]
  ask patches with [pycor < min-pycor + 3 or pycor > max-pycor - 1] [set pcolor black]
  ask patch -6 8 [set pcolor green]
  ask patch -14 8 [set pcolor 15.5]
  write-sentence "TURN:" -13 8 white 3
  write-sentence "UNITS:" 4 8 white 3
    ask patches with [pycor = -3] [set pcolor white]
    ask patches with [pycor = 3] [set pcolor white]
    cro 1 [set name "Odysseus" set shape "person" set color cyan setxy -14 3]
    cro 1 [set name "Telemachus" set shape "person" set color red setxy -14 -3]
    create-suitors 1 [set name "Tutorial 1" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -8 3]
    create-suitors 1 [set name "Tutorial 2" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -9 -3]
    ask patch -12 -3 [Armory-patch]
    ask patch -3 3 [Exit-patch]
    ask patch -3 -3 [Exit-patch]
    set tutorialing 1
  ]

  while [this-turn = 1 and tutorialing = 1] [
    write-sentence "WELCOME TO THE TUTORIAL" -14 -6 green 3
    write-sentence "MOVE" -14 -7 white 3 write-sentence "ODYSSEUS" -9 -7 85 3 write-sentence "BY CLICKING A" 0 -7 white 3
    write-sentence "BLUE TILE" -14 -8 white 3
    set tutorialing 2
  ]
  while [this-turn = 1 and tutorialing = 2 and any? patches with [pcolor = 105]] [
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pd fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pd fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pd fd 30 die]
    write-sentence "MOVE" -14 -6 white 3 write-sentence "TELEMACHUS" -9 -6 15 3 write-sentence "BY CLICKING A" 2 -6 white 3
    write-sentence "RED TILE" -14 -7 white 3
    set tutorialing 3
  ]
  while [this-turn = 1 and tutorialing = 3 and any? patches with [pcolor = 15]] [
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pd fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pd fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pd fd 30 die]
    write-sentence "CLICK THE" -14 -6 white 3 write-sentence "GREEN BUTTON" -4 -6 green 3 write-sentence "TO" 9 -6 white 3
    write-sentence "ADVANCE THE TURN" -14 -7 white 3
    set tutorialing 4
  ]
  while [this-turn = 2 and tutorialing = 4] [
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patch -14 -6 [Armory-patch]
    write-sentence "IS AN ARMORY TILE." -12 -6 white 3
    write-sentence "MOVE ?????????? TO THE ARMORY" -14 -7 white 3 write-sentence "TELEMACHUS" -9 -7 15 3
    set tutorialing 5
  ]
  while [tutorialing = 5 and Armory = true] [
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patch -14 -6 [Armory-patch]
    write-sentence "IS AN ARMORY TILE." -12 -6 white 3
    write-sentence "MOVE ?????????? TO THE ARMORY" -14 -7 white 3 write-sentence "TELEMACHUS" -9 -7 15 3
    set tutorialing 6
  ]
  while [tutorialing = 6] [
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patch -14 -6 [set pcolor black ask turtles-here [die]]
    ask patch -14 -6 [sprout 1 [set shape "person" set color random-float 2 + 7]]
    write-sentence "IS A SUITOR. AN ENEMY." -12 -6 white 3
    write-sentence "MOVE ??? AND ???? TO THE" -14 -7 white 3 write-sentence "ODY" -9 -7 85 3 write-sentence "TELE" -1 -7 15 3
    write-sentence "SUITORS" -14 -8 white 3
    ask turtles with [name = "Telemachus"] [setxy -6 -3]
    set tutorialing 7
  ]
  while [tutorialing = 7 and count suitors < 2] [
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patch -14 -6 [set pcolor black ask turtles-here [die]]
    ask patch -14 -6 [Exit-patch]
    write-sentence "IS AN EXIT TILE" -12 -6 white 3
    write-sentence "IF ???????? GETS HERE YOU" -14 -7 white 3 write-sentence "A SUITOR" -11 -7 8 3
    write-sentence "LOSE" -14 -8 white 3
    set tutorialing 8
  ]
  while [tutorialing = 8 and count suitors = 0] [
    wait 2
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patch -14 -6 [set pcolor black ask turtles-here [die]]
    ask patch -14 -6 [Armory-patch]
    ask turtles with [name = "Odysseus"] [setxy -14 3]
    ask turtles with [name = "Telemachus"] [setxy -14 -3]

    write-sentence "GIVES YOU TWO UNITS. THEY " -12 -6 white 3
    write-sentence "ARE EUMAEUS AND PHILOITHOS" -14 -7 white 3
    write-sentence "THEY CLOSE ARMORY AND EXITS" -14 -8 white 3 write-sentence ".." 12 -8 yellow 3
    set tutorialing 9
  ]
  while [tutorialing = 9] [
    wait 6
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patch -14 -6 [set pcolor black ask turtles-here [die]]
    ask patch -8 -6 [Exit-patch]
    ask turtles with [name = "Odysseus"] [setxy -14 3]
    ask turtles with [name = "Telemachus"] [setxy -14 -3]
    create-suitors 1 [set name "Tutorial 3" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -9 3]
    create-suitors 1 [set name "Tutorial 4" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -9 -3]
    write-sentence "CLICK" -14 -6 white 3     write-sentence "TO CLOSE IT" -6 -6 white 3
    write-sentence "IT WILL BE CLOSED NEXT TURN" -14 -7 white 3
    set tutorialing 10
  ]
  while [any? turtles with [shape = "x"] and tutorialing = 10] [
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patch -14 -6 [set pcolor black ask turtles-here [die]]
    ask patch -8 -6 [set pcolor black ask turtles-here [die]]
    ask patch -10 -7 [Armory-patch]
    write-sentence "YOU CAN ALSO CLOSE" -14 -6 white 3
    write-sentence "THE ? USING YOUR UNITS," -14 -7 white 3
    write-sentence "TRAPPING SOMEONE INSIDE" -14 -8 white 3
    set tutorialing 11
  ]
  while [tutorialing = 11] [
    wait 6
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patches with [pycor <= -6] [set pcolor black ask turtles-here [die]]
    write-sentence "KILL THE SUITORS" -14 -6 white 3
    write-sentence "TO WIN!" -14 -7 white 3
    set tutorialing 12
  ]


  go-on
end

to tutorial-logic
  if global-tick = 2 [
    if any? turtles with [shape = "x"] [ask suitors [ifelse any? neighbors4 with [any? turtles-here with [shape = "x"]] [setxy pxcor - 1 pycor] [setxy pxcor + 1 pycor]]]
    if any? patches with [any? turtles-here with [shape = "flag"] and any? suitors-here] [ ;lose-screen for tutorial
      clear-patches clear-drawing clear-turtles
      ask patches with [pycor = 8] [sprout 3 [set heading 180 setxy (pxcor + (random-float -2) + 1) (pycor + 0.25) set color (random 3) + 11 ;the blood thingy
    set pen-size random 10 + 8 pd fd random-float 2 if pxcor > 12 or pxcor < -12 [fd (random-float 10) + 2] die]]
      write-sentence "YOU LOST THE TUTORIAL!" -11 4 red 3
      wait 3 startup
    ]
    if tutorialing = 12 and not any? suitors [ ;win-screen for tutorial
      clear-patches clear-drawing clear-turtles
      ask patches with [pycor = 8] [sprout 3 [set heading 180 setxy (pxcor + (random-float -2) + 1) (pycor + 0.25) set color (random 3) + 11 ;the blood thingy
    set pen-size random 10 + 8 pd fd random-float 2 if pxcor > 12 or pxcor < -12 [fd (random-float 10) + 2] die]]
      write-sentence "YOU WON THE TUTORIAL!" -10 4 green 3
      wait 3 startup
    ]
  ]
end

to create-map-one [x y]
    ask patch (-11 + x) (5 + y) [set pcolor white]
    ask patch (-11 + x) (4 + y)  [set pcolor white]
    ask patch (-11 + x) (3 + y)  [set pcolor white]
    ask patch (-11 + x) (2 + y)  [set pcolor white]
    ask patch (-12 + x) (2 + y)  [set pcolor white]
    ask patch (-10 + x) (2 + y)  [set pcolor white]
    ask patch (-13 + x) (1 + y)  [set pcolor white]
    ask patch (-13 + x) (0 + y)  [set pcolor white]
    ask patch (-9 + x) (5 + y)  [set pcolor white]
    ask patch (-8 + x) (5 + y)  [set pcolor white]
    ask patch (-8 + x) (4 + y)  [set pcolor white]
    ask patch (-8 + x) (3 + y)  [set pcolor white]
    ask patch (-8 + x) (2 + y)  [set pcolor white]
    ask patch (-8 + x) (1 + y)  [set pcolor white]
    ask patch (-7 + x) (5 + y)  [set pcolor white]
    ask patch (-6 + x) (5 + y)  [set pcolor white]
    ask patch (-5 + x) (5 + y)  [set pcolor white]
    ask patch (-4 + x) (5 + y)  [set pcolor white]
    ask patch (-3 + x) (5 + y)  [set pcolor white]
    ask patch (-2 + x) (5 + y)  [set pcolor white]
    ask patch (-1 + x) (5 + y)  [set pcolor white]
    ask patch (0 + x) (5 + y)  [set pcolor white]
    ask patch (1 + x) (5 + y) [set pcolor white]
    ask patch (2 + x) (5 + y)  [set pcolor white]
    ask patch (-4 + x) (4 + y)  [set pcolor white]
    ask patch (-6 + x) (3 + y)  [set pcolor white]
    ask patch (-5 + x) (3 + y)  [set pcolor white]
    ask patch (-3 + x) (3 + y)  [set pcolor white]
    ask patch (-6 + x) (1 + y)  [set pcolor white]
    ask patch (-6 + x) (0 + y)  [set pcolor white]
    ask patch (-6 + x) (-1 + y)  [set pcolor white]
    ask patch (-6 + x) (-2 + y) [set pcolor white]
    ask patch (-6 + x) (-3 + y)  [set pcolor white]
    ask patch (-5 + x) (1 + y)  [set pcolor white]
    ask patch (-4 + x) (1 + y)  [set pcolor white]
    ask patch (-2 + x) (1 + y)  [set pcolor white]
    ask patch (-1 + x) (1 + y)  [set pcolor white]
    ask patch (0 + x) (1 + y)  [set pcolor white]
    ask patch (1 + x) (1 + y)  [set pcolor white]
    ask patch (2 + x) (1 + y)  [set pcolor white]
    ask patch (-3 + x) (0 + y)  [set pcolor white]
    ask patch (-3 + x) (-1 + y)  [set pcolor white]
    ask patch (-3 + x) (-2 + y)  [Exit-patch]
    ask patch (-1 + x) (5 + y) [set pcolor white]
    ask patch (-1 + x) (4 + y)  [set pcolor white]
    ask patch (-1 + x) (3 + y)  [set pcolor white]
    ask patch (-1 + x) (2 + y)  [set pcolor white]
    ask patch (-1 + x) (1 + y)  [set pcolor white]
    ask patch (4 + x) (5 + y)  [set pcolor white]
    ask patch (5 + x) (5 + y)  [set pcolor white]
    ask patch (6 + x) (5 + y)  [set pcolor white]
    ask patch (7 + x) (5 + y)  [set pcolor white]
    ask patch (5 + x) (4 + y)  [set pcolor white]
    ask patch (5 + x) (3 + y)  [set pcolor white]
    ask patch (5 + x) (2 + y)  [set pcolor white]
    ask patch (5 + x) (1 + y)  [set pcolor white]
    ask patch (5 + x) (0 + y)  [set pcolor white]
    ask patch (5 + x) (-1 + y)  [set pcolor white]
    ask patch (6 + x) (3 + y) [set pcolor white]
    ask patch (7 + x) (3 + y)  [set pcolor white]
    ask patch (7 + x) (2 + y)  [set pcolor white]
    ask patch (7 + x) (1 + y)  [set pcolor white]
    ask patch (7 + x) (0 + y)  [set pcolor white]
    ask patch (6 + x) (0 + y)  [set pcolor white]
    ask patch (2 + x) (3 + y)  [set pcolor white]
    ask patch (2 + x) (2 + y)  [set pcolor white]
    ask patch (-10 + x) (6 + y)  [Exit-patch]
    ask patch (-10 + x) (1 + y)  [Exit-patch]
    ask patch (-6 + x) (-4 + y)  [Exit-patch]
    ask patch (-1 + x) (0 + y)  [Armory-patch]
    ask patch (3 + x) (6 + y)  [Exit-patch]
    ask patch (8 + x) (4 + y)  [Exit-patch]
    ask patch (-5 + x) (1 + y)  [Exit-patch]
    ask patch (-13 + x) (2 + y)  [set pcolor white]
    ask patch (-10 + x) (5 + y)  [set pcolor white]
    ask patch (-4 + x) (3 + y)  [set pcolor white]
    ask patch (-6 + x) (2 + y)  [set pcolor white]
    ask patch (-3 + x) (1 + y)  [set pcolor white]
    ask patch (2 + x) (4 + y)  [set pcolor white]
    ask patch (3 + x) (5 + y)  [set pcolor white]
    ask patch (7 + x) (4 + y)  [set pcolor white]
end

to level-one
  while [level-oneing = 0] [ ;this is the start
  clear-patches
  clear-turtles
  clear-drawing

  set this-turn 1
  set last-turn 1
  set Armory false
  set suitor-Armory false
  set cards 0
  cro max-pxcor * 2 + 2 [setxy max-pxcor + who - 0.5 max-pycor set heading 180 set color black pd fd max-pycor * 2 + 2 die] ;down
  cro max-pycor * 2 + 2 [setxy max-pxcor + 1 max-pycor + who - 0.5 set heading 90 set color black pd fd max-pxcor * 2 + 2 die] ;side
  ask patches [set pcolor gray]
  ask patches with [pycor < min-pycor + 3 or pycor > max-pycor - 1] [set pcolor black]
  ask patch -6 8 [set pcolor green]
  ask patch -14 8 [set pcolor 15.5]
  write-sentence "TURN:" -13 8 white 3
  write-sentence "UNITS:" 4 8 white 3
  write-sentence (list (floor (this-turn / 10)) (this-turn mod 10)) -8 8 white 3
  write-sentence (list (floor (cards / 10)) (cards mod 10)) 10 8 white 3
    create-map-one 0 0

    cro 1 [set name "Odysseus" set shape "person" set color cyan setxy -6 -3]
    cro 1 [set name "Telemachus" set shape "person" set color red setxy -3 -1]
    create-suitors 1 [set name "Antinous" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -6 -1]
    create-suitors 1 [set name "Eurymakhos" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -6 2]
    create-suitors 1 [set name "Amphinomos" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -1 1]
    create-suitors 1 [set name "Melanthios" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy 2 3]
    create-suitors 1 [set name "Agelaos" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -4 4]
    create-suitors 1 [set name "Euryades" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -3 5]
    create-suitors 1 [set name "Demoptolemos" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -8 1]
    create-suitors 1 [set name "Elatos" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -8 2]
    create-suitors 1 [set name "Penisandros" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy 5 0]

    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patches with [pycor <= -6] [set pcolor black ask turtles-here [die]]
    ask patch -14 -6 [sprout 1 [set shape "person" set color random-float 2 + 85]]
    write-sentence "ODYSSEUS" -13 -6 85 3
    write-sentence "{FIGHT YOUR WAY OUT" -4 -6 white 3
    write-sentence "OR RUN FOR IT, IF YOU" -14 -7 white 3
    write-sentence "THINK YOULL ESCAPE DEATH{" -14 -8 white 3
;  ask patches with [pxcor > -12 and pxcor < 7 and pycor = -1] [set pcolor white]
;  ask patches with [pxcor = -14 and pycor = -1] [set pcolor white]
;  ask patches with [pxcor = -13 and pycor = -1] [set pcolor white]
;  ask patches with [pxcor = -13 and pycor = 7] [set pcolor white]
;  ask patches with [pxcor > -14 and pxcor < -8 and pycor = 5] [set pcolor white]
;  ask patches with [pxcor = -13 and pycor = 3] [set pcolor white]
;  ask patches with [pxcor = -13 and pycor = 4] [set pcolor white]
;  ask patches with [pxcor = -12 and pycor < 6 and pycor > -1] [set pcolor white]
;  ask patches with [pxcor = -10 and pycor = 3] [set pcolor white]
;  ask patches with [pxcor = -5 and pycor > 2 and pycor < 8] [set pcolor white]
;  ask patches with [pxcor = -2 and pycor > 4 and pycor < 8] [set pcolor white]
;  ask patches with [pxcor = 5 and pycor = 1] [set pcolor white]
;  ask patches with [pxcor = 6 and pycor > -5 and pycor < 6] [set pcolor white]
;  ask patches with [pxcor > 5 and pxcor < 9 and pycor = 7] [set pcolor white]
;  ask patches with [pxcor < 10 and pxcor > 5 and pycor = 4] [set pcolor white]
;  ask patches with [pxcor > 10 and pxcor < 15 and pycor = 4] [set pcolor white]
;  ask patches with [pxcor > 5 and pxcor < 15 and pycor = 0] [set pcolor white]
;  ask patches with [pxcor < 11 and pxcor > 5 and pycor = 2] [set pcolor white]
;  ask patches with [pxcor = 10 and pycor = 3] [set pcolor white]
;  ask patches with [pxcor = 12 and pycor = 1] [set pcolor white]
;  ask patches with [pxcor = 14 and pycor = 1] [set pcolor white]
;  ask patches with [pxcor = 13 and pycor = 2] [set pcolor white]
;  ask patches with [pxcor = 14 and pycor = 2] [set pcolor white]
;    ask patch -13 6 [set pcolor white]
;    ask patch -11 3 [set pcolor white]
;    ask patch -12 -1 [set pcolor white]
;    ask patch -13 6 [set pcolor white]
;    ask patch 13 1 [set pcolor white]
;    ask patch 12 2 [set pcolor white]
;    ask patch 6 6 [set pcolor white]
;    ask patch 10 4 [set pcolor white]
;    ask patch 12 5 [set pcolor white]
;    ask patch 5 4 [set pcolor white]
;    ask patch 5 -3 [set pcolor white]
;    ask patch 6 -5 [set pcolor white]
;    ask patch -9 -2 [set pcolor white]
;    ask patch -14 3 [set pcolor white]
;    ask patch -5 2 [set pcolor white]
;    ask patch -8 5 [set pcolor white]
;    ask patch 0 7 [set pcolor white]
    set level-oneing 1
  ]
  while [Armory = true and level-oneing = 1] [
    ask turtles with [name = "Telemachus"] [setxy -1 5]
    set level-oneing 2
  ]

  while [level-oneing = 2 and count suitors = 1 and any? patches with [any? turtles-here with [shape = "x"] and any? suitors-here with [name = "Melanthios"]]] [;transition
    set transition 1
    repeat 7 [
      clear-turtles
      ask patches with [pycor <= 7 and pycor >= -5] [set pcolor 5]
      create-map-one 0 transition clear-turtles
      ask patches with [pycor = 8 or pycor <= -6] [set pcolor black]
      ask patches with [pycor = -4 or pycor = -5] [set pcolor 5]
      cro 1 [set color cyan set shape "person" setxy -13 transition]
      cro 1 [set color red set shape "person" setxy 5 (-1 + transition)]
      wait .5
      set transition transition + 1
    ]
    ask patch -14 8 [set pcolor 15.5]
    set level-oneing 3
  ]; win condition to next level

  while [level-oneing = 3] [ ;finishes creating the second part of the map
    ask turtles with [shape = "person"] [die]
    cro 1 [set name "Odysseus" set shape "person" set color cyan setxy -13 7]
    create-suitors 1 [set name "Leodes" set label name set label-color 100 set shape "person" set color random-float 2 + 7 setxy -13 2]
    ask patches with [pxcor = -13 and pycor <= 6 and pycor >= 1] [set pcolor white]
    set level-oneing 4
  ]

  if level-oneing = 4 and not any? turtles with [xcor = -13 and ycor = 7 and name = "Odysseus"] [
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patches with [pycor <= -6] [set pcolor black ask turtles-here [die]]
    ask patch -14 -6 [sprout 1 [set shape "person" set color random-float 2 + 7]]
    write-sentence "?Leodes" -14 -6 5 3
    write-sentence "???????? {Mercy, mercy" -14 -6 white 3
    write-sentence "on a suppliant, Odysseus!{"-14 -7 white 3
    set level-oneing 5
  ]
  if level-oneing = 5 and not any? suitors [
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patches with [pycor <= -6] [set pcolor black ask turtles-here [die]]
    ask patch -14 -6 [sprout 1 [set shape "person" set color random-float 2 + 85]]
    write-sentence "?Odysseus" -14 -6 85 3
    write-sentence "????????? {No plea like" -14 -6 white 3
    write-sentence "yours could save you."-14 -7 white 3
     write-sentence "Death it shall be!{"-14 -8 white 3
    wait 2
    set level-oneing 6
  ]

  if level-oneing = 6 [
    ask turtles [die]
    ask patches with [pycor = 8] [sprout 3 [set hidden? true set heading 180 setxy (pxcor + (random-float -2) + 1) (pycor + 0.25) set color (random 3) + 11 ;the blood thingy
      set pen-size random 10 + 8 pd]]
    repeat 250 [ask turtles [fd random-float 0.1] wait 0.01]
    set level-oneing 7
  ]

  if level-oneing = 7 [; win-screen
    clear-patches clear-drawing clear-turtles
    cro 1 [setxy -6 8 set pen-size 50 set color black pd fd 0.1 die]
    ask patches with [pycor = 8] [sprout 3 [set heading 180 setxy (pxcor + (random-float -2) + 1) (pycor + 0.25) set color (random 3) + 11 ;the blood thingy
    set pen-size random 10 + 8 pd fd random-float 2 if pxcor > 12 or pxcor < -12 [fd (random-float 10) + 2] die]]
      write-sentence "YOU WIN THE LEVEL!" -9 4 green 3
    wait 5
    startup
  ]
  go-on
end

to level1-logic
  if global-tick = 3 [
    if last-turn = 1 [
      ask turtles with [name = "Antinous"] [setxy xcor ycor + 1]
      ask turtles with [name = "Eurymakhos"] [setxy xcor ycor - 1]
      ask turtles with [name = "Amphinomos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Melanthios"] [setxy xcor ycor - 1]
      ask turtles with [name = "Agelaos"] [setxy xcor ycor + 1]
      ask turtles with [name = "Euryades"] [setxy xcor + 1 ycor]
      ask turtles with [name = "Demoptolemos"] [setxy xcor ycor + 1]
      ask turtles with [name = "Elatos"] [setxy xcor ycor + 1]
      ask turtles with [name = "Penisandros"] [setxy xcor ycor + 1]
      level-one-dialogue
    ]
    if last-turn = 2 [
      ask turtles with [name = "Antinous"] [setxy xcor ycor + 1]
      ask turtles with [name = "Eurymakhos"] [setxy xcor + 1 ycor]
      ask turtles with [name = "Amphinomos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Melanthios"] [setxy xcor ycor - 1]
      ask turtles with [name = "Agelaos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Euryades"] [setxy xcor + 1 ycor]
      ask turtles with [name = "Demoptolemos"] [setxy xcor ycor + 1]
      ask turtles with [name = "Elatos"] [setxy xcor ycor + 1]
      ask turtles with [name = "Penisandros"] [setxy xcor ycor + 1]
      level-one-dialogue
    ]
    if last-turn = 3 [
      ask turtles with [name = "Antinous"] [setxy xcor + 1 ycor]
      ask turtles with [name = "Eurymakhos"] []
      ask turtles with [name = "Amphinomos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Melanthios"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Agelaos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Euryades"] [setxy xcor + 1 ycor]
      ask turtles with [name = "Demoptolemos"] [setxy xcor ycor + 1]
      ask turtles with [name = "Elatos"] [setxy xcor ycor + 1]
      ask turtles with [name = "Penisandros"] [setxy xcor ycor + 1]
      level-one-dialogue
    ]
    if last-turn = 4 [
      ask turtles with [name = "Antinous"] []
      ask turtles with [name = "Eurymakhos"] []
      ask turtles with [name = "Amphinomos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Melanthios"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Agelaos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Euryades"] [setxy xcor + 1 ycor]
      ask turtles with [name = "Demoptolemos"] [setxy xcor ycor + 1]
      ask turtles with [name = "Elatos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Penisandros"] [setxy xcor ycor + 1]
      level-one-dialogue
    ]
    if last-turn = 5 [
      ask turtles with [name = "Antinous"] []
      ask turtles with [name = "Eurymakhos"] []
      ask turtles with [name = "Amphinomos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Melanthios"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Agelaos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Euryades"] [setxy xcor + 1 ycor]
      ask turtles with [name = "Demoptolemos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Elatos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Penisandros"] [setxy xcor ycor + 1]
      level-one-dialogue
    ]
    if last-turn = 6 [ ;enemy-armory is on
      ask turtles with [name = "Antinous"] []
      ask turtles with [name = "Eurymakhos"] []
      ask turtles with [name = "Amphinomos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Melanthios"] [ifelse any? neighbors4 with [any? turtles-here with [shape = "x"]] [setxy xcor - 1 ycor][setxy xcor ycor - 1]]
      ask turtles with [name = "Agelaos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Euryades"] [setxy xcor + 1 ycor]
      ask turtles with [name = "Demoptolemos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Elatos"] [ifelse any? neighbors4 with [any? turtles-here with [shape = "x"]] [setxy xcor - 1 ycor] [setxy xcor ycor + 1]]
      ask turtles with [name = "Penisandros"] [setxy xcor - 1 ycor]
      level-one-dialogue
    ]
    if last-turn = 7 [
      ask turtles with [name = "Antinous"] []
      ask turtles with [name = "Eurymakhos"] []
      ask turtles with [name = "Amphinomos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Melanthios"] [ifelse any? turtles-here with [shape = "x"] [setxy xcor ycor]
        [ifelse any? turtles-here with [shape = "arrow"] [setxy xcor ycor + 1] [setxy xcor - 1 ycor]]]
      ask turtles with [name = "Agelaos"] [setxy xcor - 2 ycor]
      ask turtles with [name = "Euryades"] [ifelse any? neighbors4 with [any? turtles-here with [shape = "x"]] [setxy xcor + 2 ycor] [setxy xcor ycor + 1]]
      ask turtles with [name = "Demoptolemos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Elatos"] [setxy xcor ycor - 2]
      ask turtles with [name = "Penisandros"] [setxy xcor + 2 ycor]
      level-one-dialogue
    ]
    if last-turn = 8 [
      ask turtles with [name = "Antinous"] []
      ask turtles with [name = "Eurymakhos"] []
      ask turtles with [name = "Amphinomos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Melanthios"] [ifelse any? turtles-here with [shape = "x"] [setxy xcor ycor]
        [ifelse suitor-Armory = true [setxy xcor - 2 ycor] [setxy xcor - 1 ycor]]]
      ask turtles with [name = "Agelaos"] [setxy xcor ycor - 1]
      ask turtles with [name = "Euryades"] [setxy xcor + 2 ycor]
      ask turtles with [name = "Demoptolemos"] [setxy xcor ycor - 2]
      ask turtles with [name = "Elatos"] [setxy xcor ycor - 1]
      ask turtles with [name = "Penisandros"] [setxy xcor + 1 ycor]
      level-one-dialogue
    ]
    if last-turn = 9 [
      ask turtles with [name = "Antinous"] []
      ask turtles with [name = "Eurymakhos"] []
      ask turtles with [name = "Amphinomos"] [setxy xcor - 1 ycor]
      ask turtles with [name = "Melanthios"] [ifelse any? turtles-here with [shape = "x"] [setxy xcor ycor]
        [ifelse suitor-Armory = true [setxy xcor - 2 ycor] [setxy xcor - 1 ycor]]]
      ask turtles with [name = "Agelaos"] [setxy xcor ycor - 2]
      ask turtles with [name = "Euryades"] [set xcor ycor - 1]
      ask turtles with [name = "Demoptolemos"] [setxy xcor ycor - 1]
      ask turtles with [name = "Elatos"] [setxy xcor + 1 ycor]
      ask turtles with [name = "Penisandros"] [setxy xcor ycor - 1]
      level-one-dialogue
    ]
    if last-turn = 10[
      ask turtles with [name = "Penisandros"] [setxy xcor + 1 ycor]
            ask turtles with [name = "Elatos"] [setxy xcor ycor - 1]
      level-one-dialogue
    ]

    if any? patches with [any? turtles-here with [shape = "flag"] and any? suitors-here] [
      set escapist [name] of one-of suitors with [any? turtles-here with [shape = "flag"]]
      clear-patches clear-drawing clear-turtles
      ask patches with [pycor = 8] [sprout 3 [set heading 180 setxy (pxcor + (random-float -2) + 1) (pycor + 0.25) set color (random 3) + 11 ;the blood thingy
    set pen-size random 10 + 8 pd fd random-float 2 if pxcor > 12 or pxcor < -12 [fd (random-float 10) + 2] die]]
      write-sentence "YOU LOST THE LEVEL!" -9 4 red 3
      write-sentence escapist -5 0 gray 3 write-sentence "ESCAPED" -4 -1 white 3
      wait 3 startup]
  ]
end

to level-one-dialogue
  if global-tick = 3 [
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patches with [pycor <= -6] [set pcolor black ask turtles-here [die]]

    if not any? suitors with [name = "Antinous"] and dialogue-oneing = 0 [ ;When Antinous dies
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patches with [pycor <= -6] [set pcolor black ask turtles-here [die]]
    ask patch -14 -6 [sprout 1 [set shape "person" set color random-float 2 + 7]]
    write-sentence "?ANTINOUS" -14 -6 5 3
    write-sentence "????????? BACKWARD AND DOWN" -14 -6 white 3
    write-sentence "HE WENT, LETTING THE WINECUP" -14 -7 white 3
    write-sentence "FALL FROM HIS SHOCKED HAND" -14 -8 white 3
      set dialogue-oneing dialogue-oneing + 1
    ]
    if (not any? suitors with [name = "Eurymakhos"]) and dialogue-oneing = 1 [ ;When Eurymakhos dies
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patches with [pycor <= -6] [set pcolor black ask turtles-here [die]]
    ask patch -14 -6 [sprout 1 [set shape "person" set color random-float 2 + 7]]
    write-sentence "?EURYMAKHOS" -14 -6 5 3
    write-sentence "??????????? {FIGHT, I SAY," -14 -6 white 3
    write-sentence "LETS REMEMBER" -14 -7 white 3
    write-sentence "THE JOY OF IT!{" -14 -8 white 3
      set dialogue-oneing dialogue-oneing + 1
    ]
    if Armory = true and dialogue-oneing = 2 [ ;When Telemachus goes on the armory
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patches with [pycor <= -6] [set pcolor black ask turtles-here [die]]
    write-sentence "ALL THREE TOOK THEIR STAND" -14 -6 white 3
    write-sentence "BESIDE" -14 -7 white 3
    write-sentence "?????? THE MASTER OF BATTLE." -14 -7 85 3
      set dialogue-oneing dialogue-oneing + 1
    ]
    if any? patches with [any? suitors-here with [name = "Melanthios"] and any? turtles-here with [shape = "x"]] and dialogue-oneing = 3 [ ;When Melanthios is trapped
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patches with [pycor <= -6] [set pcolor black ask turtles-here [die]]
    ask patch -14 -6 [sprout 1 [set shape "person" set color random-float 2 + 7]]
    write-sentence "?MELANTHIOS" -14 -6 5 3
    write-sentence "??????????? WITH A WHIP OF" -14 -6 white 3
    write-sentence "ROPE THEY HOISTED HIM IN"-14 -7 white 3
    write-sentence "AGONY UP A PILLAR TO THE BEAM" -14 -8 white 3
      set dialogue-oneing dialogue-oneing + 1
    ]
    if count suitors = 1 and any? suitors with [name = "Melanthios"] and dialogue-oneing = 4 [ ;when map switches
    cro 1 [setxy -14 -6 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -7 rt 90 set pen-size 25 set color black pe fd 30 die]
    cro 1 [setxy -14 -8 rt 90 set pen-size 25 set color black pe fd 30 die]
    ask patches with [pycor <= -6] [set pcolor black ask turtles-here [die]]
    write-sentence "AS THESE LAY DYING... THEIR" -14 -6 white 3
    write-sentence "FRIENDS GAVE WAY" -14 -7 white 3
      wait 1
    write-sentence "???????????????? AND BROKE" -14 -7 white 4
    write-sentence "FOR THE INNER WALL" -14 -8 white 4
      set dialogue-oneing dialogue-oneing + 1
    ]
  ]
end

to turn-count ;the green button! (advances the turn counter)
  if mouse-down? and round mouse-xcor = -6 and round mouse-ycor = 8 [ask patch -6 8 [set pcolor 53]]
  ask patch -6 8 [ifelse pcolor = 53 and mouse-down? and any? patches with [pcolor = 105] and any? patches with [pcolor = 15] ;when all moves have been made
    [set this-turn this-turn + 1 set pcolor green] [
      ifelse pcolor = 53 and (not any? turtles with [name = "Telemachus"]) and (any? patches with [pcolor = 105]) ;when its only odysseus
      [set this-turn this-turn + 1 set pcolor green] [set pcolor green]]]
end

to back-button ;the red button! (goes back to main menu)
  if mouse-down? and round mouse-xcor = -14 and round mouse-ycor = 8 [startup] ;15.5 -> 13.5
end

to turn-counter
  ask patch -8 8 [sprout 1 [set color black set pen-size 26 pe fd 0.001 die]]
  ask patch -7 8 [sprout 1 [set color black set pen-size 26 pe fd 0.001 die]]
  write-sentence (list (floor (this-turn / 10)) (this-turn mod 10)) -8 8 white 3

  ask patch 10 8 [sprout 1 [set color black set pen-size 26 pe fd 0.001 die]]
  ask patch 11 8 [sprout 1 [set color black set pen-size 26 pe fd 0.001 die]]
  write-sentence (list (floor (cards / 10)) (cards mod 10)) 10 8 white 3
end

to Ody-highlight
  ifelse Armory = true ;if true, move 3 / else move 2
  [;radius of 1, neighbors4
    ask patches with [pcolor = white and pxcor = Ody-xcor + 1 and pycor = Ody-ycor + 0] [set pcolor 88]
    ask patches with [pcolor = white and pxcor = Ody-xcor + -1 and pycor = Ody-ycor + 0] [set pcolor 88]
    ask patches with [pcolor = white and pxcor = Ody-xcor + 0 and pycor = Ody-ycor + 1] [set pcolor 88]
    ask patches with [pcolor = white and pxcor = Ody-xcor + 0 and pycor = Ody-ycor + -1] [set pcolor 88]
    ;radius of 2, neighbors4
    ask patches with [pcolor = white and pxcor = Ody-xcor + 2 and pycor = Ody-ycor + 0] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
    ask patches with [pcolor = white and pxcor = Ody-xcor + -2 and pycor = Ody-ycor + 0] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
    ask patches with [pcolor = white and pxcor = Ody-xcor + 0 and pycor = Ody-ycor + 2] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
    ask patches with [pcolor = white and pxcor = Ody-xcor + 0 and pycor = Ody-ycor + -2] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
  ;radius of 3, neighbors4
    ask patches with [pcolor = white and pxcor = Ody-xcor + 3 and pycor = Ody-ycor + 0] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
    ask patches with [pcolor = white and pxcor = Ody-xcor + -3 and pycor = Ody-ycor + 0] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
    ask patches with [pcolor = white and pxcor = Ody-xcor + 0 and pycor = Ody-ycor + 3] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
    ask patches with [pcolor = white and pxcor = Ody-xcor + 0 and pycor = Ody-ycor + -3] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
  ]
  [;radius of 1, neighbors4
    ask patches with [pcolor = white and pxcor = Ody-xcor + 1 and pycor = Ody-ycor + 0] [set pcolor 88]
    ask patches with [pcolor = white and pxcor = Ody-xcor + -1 and pycor = Ody-ycor + 0] [set pcolor 88]
    ask patches with [pcolor = white and pxcor = Ody-xcor + 0 and pycor = Ody-ycor + 1] [set pcolor 88]
    ask patches with [pcolor = white and pxcor = Ody-xcor + 0 and pycor = Ody-ycor + -1] [set pcolor 88]
  ;radius of 2, neighbors4
    ask patches with [pcolor = white and pxcor = Ody-xcor + 2 and pycor = Ody-ycor + 0] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
    ask patches with [pcolor = white and pxcor = Ody-xcor + -2 and pycor = Ody-ycor + 0] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
    ask patches with [pcolor = white and pxcor = Ody-xcor + 0 and pycor = Ody-ycor + 2] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
    ask patches with [pcolor = white and pxcor = Ody-xcor + 0 and pycor = Ody-ycor + -2] [if count neighbors4 with [pcolor = 88] > 0 [set pcolor 88]]
  ]
  ask turtles with [name = "Telemachus"] [ask patch-here [if pcolor = 88 [set pcolor white]]]
end

to Tele-highlight
  ifelse Armory = true ;if true, move 2 / else move 1
  [;radius of 1, neighbors4
    ask patches with [pcolor = white and pxcor = Tele-xcor + 1 and pycor = Tele-ycor + 0] [set pcolor 128]
    ask patches with [pcolor = white and pxcor = Tele-xcor + -1 and pycor = Tele-ycor + 0] [set pcolor 128]
    ask patches with [pcolor = white and pxcor = Tele-xcor + 0 and pycor = Tele-ycor + 1] [set pcolor 128]
    ask patches with [pcolor = white and pxcor = Tele-xcor + 0 and pycor = Tele-ycor + -1] [set pcolor 128]
    ;radius of 2, neighbors4
    ask patches with [pcolor = white and pxcor = Tele-xcor + 2 and pycor = Tele-ycor + 0] [if count neighbors4 with [pcolor = 128] > 0 [set pcolor 128]]
    ask patches with [pcolor = white and pxcor = Tele-xcor + -2 and pycor = Tele-ycor + 0] [if count neighbors4 with [pcolor = 128] > 0 [set pcolor 128]]
    ask patches with [pcolor = white and pxcor = Tele-xcor + 0 and pycor = Tele-ycor + 2] [if count neighbors4 with [pcolor = 128] > 0 [set pcolor 128]]
    ask patches with [pcolor = white and pxcor = Tele-xcor + 0 and pycor = Tele-ycor + -2] [if count neighbors4 with [pcolor = 128] > 0 [set pcolor 128]]
    ask patches with [pcolor = white and pxcor = Tele-xcor + 2 and pycor = Tele-ycor + 0] [if count neighbors4 with [pcolor = 35] > 0 [set pcolor 128]]
    ask patches with [pcolor = white and pxcor = Tele-xcor + -2 and pycor = Tele-ycor + 0] [if count neighbors4 with [pcolor = 35] > 0 [set pcolor 128]]
    ask patches with [pcolor = white and pxcor = Tele-xcor + 0 and pycor = Tele-ycor + 2] [if count neighbors4 with [pcolor = 35] > 0 [set pcolor 128]]
    ask patches with [pcolor = white and pxcor = Tele-xcor + 0 and pycor = Tele-ycor + -2] [if count neighbors4 with [pcolor = 35] > 0 [set pcolor 128]]
        ask patches with [pcolor = white and pxcor = Tele-xcor + 2 and pycor = Tele-ycor + 0] [if count neighbors4 with [pcolor = 123.1] > 0 [set pcolor 128]]
    ask patches with [pcolor = white and pxcor = Tele-xcor + -2 and pycor = Tele-ycor + 0] [if count neighbors4 with [pcolor = 123.1] > 0 [set pcolor 128]]
    ask patches with [pcolor = white and pxcor = Tele-xcor + 0 and pycor = Tele-ycor + 2] [if count neighbors4 with [pcolor = 123.1] > 0 [set pcolor 128]]
    ask patches with [pcolor = white and pxcor = Tele-xcor + 0 and pycor = Tele-ycor + -2] [if count neighbors4 with [pcolor = 123.1] > 0 [set pcolor 128]]
  ]
  [;radius of 1, neighbors4
    ask patches with [pcolor = white and pxcor = Tele-xcor + 1 and pycor = Tele-ycor + 0] [set pcolor 128]
    ask patches with [pcolor = white and pxcor = Tele-xcor + -1 and pycor = Tele-ycor + 0] [set pcolor 128]
    ask patches with [pcolor = white and pxcor = Tele-xcor + 0 and pycor = Tele-ycor + 1] [set pcolor 128]
    ask patches with [pcolor = white and pxcor = Tele-xcor + 0 and pycor = Tele-ycor + -1] [set pcolor 128]
  ]
  ask turtles with [name = "Odysseus"] [ask patch-here [if pcolor = 128 [set pcolor white]]]
end

to highlight
  ;Odysseus highlight
ask turtles with [name = "Odysseus"] [set Ody-xcor xcor set Ody-ycor ycor Ody-highlight]
  if mouse-down? [ask patch round mouse-xcor round mouse-ycor [if pcolor = 88 [set pcolor 105]] ;mouse-down -> 88 to 105
    ask patches with [pxcor != round mouse-xcor or pycor != round mouse-ycor
      and pcolor = 105 and count patches with [pcolor = 105] > 1] [set pcolor 88]]; mouse-down different, 105 to 88
  ;Telemachus highlight
 ask turtles with [name = "Telemachus"] [set Tele-xcor xcor set Tele-ycor ycor Tele-highlight]
  if mouse-down? [ask patch round mouse-xcor round mouse-ycor [if pcolor = 128 [set pcolor 15]] ;mouse-down -> 128 to 15
    ask patches with [pxcor != round mouse-xcor or pycor != round mouse-ycor
      and pcolor = 15 and count patches with [pcolor = 15] > 1 and count turtles-here with [shape = "arrow"] = 0] [set pcolor 128]]; mouse-down different, 15 to 128
  ;Telemachus-Armory interaction
  if mouse-down? [ask patch round mouse-xcor round mouse-ycor
    [if pcolor = 35 and any? neighbors4 with [any? turtles-here with [name = "Telemachus"]] and Armory != true [set pcolor 15]] ;Armory tile -> 35 to 15
    ask patches with [pxcor != round mouse-xcor or pycor != round mouse-ycor
      and pcolor = 15 and count patches with [pcolor = 15] > 1 and any? turtles-here with [shape = "arrow"]] [set pcolor 35]]; mouse-down different, 15 to 128

end

to movement
  if this-turn = last-turn + 1 [ ;detects if a turn has passed
    ;Odysseus Movement
    ask patches with [pcolor = 88] [set pcolor white] ;sets cyan 88 to normal
    ask turtles with [name = "Odysseus"] [die] ;gets rid of Odysseus
    ask patches with [pcolor = 105] [sprout 1 [set name "Odysseus" set shape "person" set color cyan]] ;creates a duplicate Odysseus, imitating movement
    ask patches with [pcolor = 105] [set pcolor white] ;sets blue 105 to normal
    ;Telemachus Movement
    ask patches with [pcolor = 128] [set pcolor white] ;sets pink 128 to normal
    ask turtles with [name = "Telemachus"] [die] ;gets rid of Odysseus
    ask patches with [pcolor = 15] [sprout 1 [set name "Telemachus" set shape "person" set color red]] ;creates a duplicate Odysseus, imitating movement
    ask patches with [pcolor = 15] [ifelse not any? turtles-here with [shape = "arrow"] [set pcolor white] [set pcolor 35]] ;sets red 15 to normal or Armory-patch
  ]
end

to Armory-patch ;creates a patch that is the Armory
  set pcolor 35
  sprout 1 [set color yellow set shape "arrow" set heading 0]
end

to detect-Armory ;if Armory patch detects Telemachus or Menelaus, it will set the corresponding armory global and give the Eumaios/Philoithios cards
  ask patches with [pcolor = 35] [if count turtles-here with [name = "Telemachus"] > 0 [set Armory true set cards 2]]
  ask patches with [pcolor = 35] [if count turtles-here with [name = "Melanthios"] > 0 [set suitor-Armory true]]
end

to Exit-patch ;creates a patch that is an Exit patch
  set pcolor 123 set exit true
  sprout 1 [set color 44 set shape "flag" set heading 0]
end

to use-cards
  ;Highlights the exit-patch or armory-patch if there is a card
  if mouse-down? and cards > 0 [every .5 [ifelse any? patches with [pcolor = 136]
    [ask patch round mouse-xcor round mouse-ycor [if pcolor = 136 [set pcolor 123]]] ;mouse-down -> 136 to 123 (in case of misclicks)
      [ifelse any? patches with [pcolor = 32 and any? turtles-here with [shape = "arrow"]]
      [ask patch round mouse-xcor round mouse-ycor [if pcolor = 32 and any? turtles-here with [shape = "arrow"] [set pcolor 35]]] ;mouse-down in armory -> 32 to 35 (i.n.o. misclics)
    [if mouse-down? and cards > 0 [ask patch round mouse-xcor round mouse-ycor [if pcolor = 123 [set pcolor 136] ;mouse-down -> 123 to 136
      if pcolor = 35 and any? turtles-here with [shape = "arrow"] [set pcolor 32]] ;mouse-down and armory patch -> 35 to 32
   ask patches with [pxcor != round mouse-xcor or pycor != round mouse-ycor
          and pcolor = 136 and count patches with [pcolor = 136] > 1] [set pcolor 123]]]]]]; mouse-down different, 136 to 123
  ;Uses the card and closes the exit-patch after the turn
  if this-turn = last-turn + 1 [ ;detects if a turn has passed
    ask patches with [pcolor = 136 or pcolor = 32] ;asks highlighted exit patch
      [set exit "closed"
      ask turtles-here with [shape = "flag" or shape = "arrow"] [set shape "x"]
      set pcolor 123.1 ;closes the exit patch
        set cards cards - 1]]
end

to kill-suitors
  ask turtles with [name = "Odysseus" or name = "Telemachus"] [if any? suitors-here [ask suitors-here [die]]]
end

to suitor-logic ;moves all suitors will make, currently a WIP
  if this-turn = last-turn + 1 [wait .5
    ;Test1 suitor
    ask suitors with [name = "Test1"]
    [if this-turn = 2 [setxy -10 0]
    if this-turn = 3 [setxy -11 0]
    if this-turn = 4 [setxy -12 0]
    if this-turn = 5 [setxy -13 0]
      if this-turn = 6 [ifelse count neighbors4 with [exit = true] > 0 [setxy -14 0] [setxy xcor ycor - 1]]
      if this-turn = 7 [setxy xcor + 1 ycor]
      if this-turn = 8 [setxy xcor + 1 ycor]
    ]
    ;Test2 suitor
    ask suitors with [name = "Test2"]
    [if this-turn = 2 [setxy xcor + 1 ycor]
      if this-turn = 3 [setxy xcor + 1 ycor]
      if this-turn = 4 [setxy xcor + 1 ycor]
      if this-turn = 5 [ifelse count neighbors4 with [exit = true] > 0 [setxy xcor + 1 ycor] [setxy xcor ycor - 1]]
      if this-turn = 6 [setxy xcor - 1 ycor]
      if this-turn = 7 [setxy xcor - 1 ycor]
      if this-turn = 8 [setxy xcor - 1 ycor]
    ]
      set last-turn last-turn + 1 ;sets last-turn to this-turn, ending the detection
  ]
end

;to pathfind ;WIP
;  let radar 0
;  ask suitors [let closest min-one-of patches with [pcolor = 123] [distance myself] show (list closest [pxcor] of patch-here [pycor] of patch-here)
;    if [pycor] of closest > [pycor] of myself and patch-at
;  ]
;end

to go-on
  back-button ;checks if back-button is pressed, goes to home screen if it is
  turn-count ;checks the turn
  use-cards ;highlights and uses cards
  highlight ;highlights the new tiles
  if this-turn = last-turn + 1 [ ;detects if turn has passed
    movement ;moves according to the highlighting
    detect-Armory ;finds if Telemachus or Menelaus enters the armory
    kill-suitors ;kills suitors on the same patch as Ody or Tele
    turn-counter ;writes the turn count and card count
    wait .5
    tutorial-logic ;moves Tutorial suitors
    level1-logic ;moves level 1 suitors
    kill-suitors ;kills suitors on the same patch as Ody or Tele
    set last-turn last-turn + 1 ;stops detection of turn pass
  ]
end

to THE-PALACE
  ask patch -9 5 [sprout 1 [set hidden? true set color 45 set heading 0 set pen-size 5 ;T
    bk 0.5 rt 90 fd 0.5 lt 90 bk 0.8 lt 90 fd 0.6 bk 1.2 fd 0.6 rt 90 pd fd 1.6 lt 90 fd 0.6 bk 1.2 die]]
  ask patch -7 5 [sprout 1 [set hidden? true set color 44 set heading 0 set pen-size 5 ;H
    bk 0.5 rt 90 fd 0.5 lt 90 bk 0.8 lt 90 fd 0.6 rt 90 pd fd 1.6 bk 0.8 rt 90 fd 1.2 rt 90 fd 0.8 bk 1.6 die]]
  ask patch -5 5 [sprout 1 [set hidden? true set color 43 set heading 0 set pen-size 5 ;E
  bk 0.5 rt 90 fd 0.5 lt 90 bk 0.8 lt 90 fd 0.5 rt 90 pd rt 90 fd 1 bk 1 lt 90 fd 0.8 rt 90 fd 0.6 bk 0.6 lt 90 fd 0.8 rt 90 fd 1 bk 1 lt 90 die]]

  ask patch -1 5 [sprout 1 [set hidden? true set color 25 set heading 0 set pen-size 5 ;P
  bk 0.5 rt 90 fd 0.5 lt 90 bk 0.8 lt 90 fd 0.6 rt 90 pd fd 1.6 rt 90 fd 0.8 repeat 180 [fd 1.25664 / 180 rt 1] fd 0.8 die]]
  ask patch 1 5 [sprout 1 [set hidden? true set color 24 set heading 0 set pen-size 5 ;A
  bk 0.5 rt 90 fd 0.5 lt 90 bk 0.8 lt 90 fd 0.8 rt 90 rt 90 - 63.435 pd fd 0.894 * 2 set heading 180 lt 26.565 fd sqrt 0.8 * 2 bk sqrt 0.8 set heading 270 fd 0.8 die]]
  ask patch 3 5 [sprout 1 [set hidden? true set color 23 set heading 0 set pen-size 5 ;L
  bk 0.5 rt 90 fd 0.5 lt 90 bk 0.8 rt 90 fd 0.6 rt 180 pd fd 1.2 rt 90 fd 1.6 die]]
  ask patch 5 5 [sprout 1 [set hidden? true set color 15 set heading 0 set pen-size 5 ;A
  bk 0.5 rt 90 fd 0.5 lt 90 bk 0.8 lt 90 fd 0.8 rt 90 rt 90 - 63.435 pd fd 0.894 * 2 set heading 180 lt 26.565 fd sqrt 0.8 * 2 bk sqrt 0.8 set heading 270 fd 0.8 die]]
  ask patch 7 5 [sprout 1 [set hidden? true set color 14 set heading 0 set pen-size 5 ;C
  bk 0.5 rt 90 fd 0.5 lt 90 rt 90 fd 0.8 lt 90 repeat 45 [fd 2.51327 / 180 lt 1] pd repeat 270 [fd 2.51327 / 180 lt 1] die]]
  ask patch 9 5 [sprout 1 [set hidden? true set color 13 set heading 0 set pen-size 5 ;E
  bk 0.5 rt 90 fd 0.5 lt 90 bk 0.8 lt 90 fd 0.5 rt 90 pd rt 90 fd 1 bk 1 lt 90 fd 0.8 rt 90 fd 0.6 bk 0.6 lt 90 fd 0.8 rt 90 fd 1 bk 1 lt 90 die]]
end

to write-sentence [string locationX locationY letter-color letter-size] ;string = phrase i want to display, location = coords of first letter
  let n 0
  while [length string != 0] [
    ask patch (locationX + n) locationY [
      write-word first string letter-color letter-size
      set n n + 1
      set string but-first string
  ]]
end


to write-word [letter letter-color letter-size]
  if letter = "A" or letter = "a" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.4 rt 90 rt 90 - 63.435 pd fd 0.894 set heading 180 lt 26.565 fd sqrt 0.8 bk sqrt 0.8 / 2 set heading 270 fd 0.4 die]]
  if letter = "B" or letter = "b" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.3 rt 90 pd fd 0.8 rt 90 fd 0.4 repeat 180 [fd 1.25664 / 360 rt 1] fd 0.4 bk 0.4 rt 180 repeat 180 [fd 1.25664 / 360 rt 1] fd 0.4 die]]
  if letter = "C" or letter = "c" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    rt 90 fd 0.4 lt 90 repeat 45 [fd 2.51327 / 360 lt 1] pd repeat 270 [fd 2.51327 / 360 lt 1] die]]
  if letter = "D" or letter = "d" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.3 rt 90 pd fd 0.8 rt 90 fd 0.3 repeat 180 [fd 1.275 / 180 rt 1] setxy [pxcor] of patch-here - 0.3 [pycor] of patch-here - 0.4 die]]
  if letter = "E" or letter = "e" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.25 rt 90 pd rt 90 fd 0.5 bk 0.5 lt 90 fd 0.4 rt 90 fd 0.3 bk 0.3 lt 90 fd 0.4 rt 90 fd 0.5 bk 0.5 lt 90 die]]
  if letter = "F" or letter = "f" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.25 rt 90 pd fd 0.4 rt 90 fd 0.3 bk 0.3 lt 90 fd 0.4 rt 90 fd 0.5 bk 0.5 lt 90 die]]
  if letter = "G" or letter = "g" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    rt 90 fd 0.5 lt 90 repeat 75 [fd 2.51327 / 360 lt 1] pd repeat 210 [fd 2.51327 / 360 lt 1] lt 75 fd 0.4 lt 90 fd 0.3 bk 0.4 die]]
  if letter = "H" or letter = "h" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
      bk 0.4 lt 90 fd 0.3 rt 90 pd fd 0.8 bk 0.4 rt 90 fd 0.6 rt 90 fd 0.4 bk 0.8 die]]
  if letter = "I" or letter = "i" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.3 pd bk 0.6 fd 0.3 rt 90 fd 0.8 lt 90 fd 0.3 bk 0.6 die]]
  if letter = "J" or letter = "j" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.4 lt 90 fd 0.3 pd bk 0.6 fd 0.3 lt 90 fd 0.6 repeat 180 [fd 0.94248 / 360 rt 1]]]
  if letter = "K" or letter = "k" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.2 rt 90 pd fd 0.8 bk 0.4 rt 45 fd 0.56569 bk 0.56569 set heading 135 fd 0.56569 die]]
  if letter = "L" or letter = "l" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 rt 90 fd 0.3 rt 180 pd fd 0.6 rt 90 fd 0.8 die]]
  if letter = "M" or letter = "m" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.4 rt 90 pd rt 90 - 75.964 fd 0.825 set heading 180 - 29.745 fd 0.403 set heading 0 rt 29.745 fd 0.403 set heading 180 lt 14.036 fd 0.825 die]]
  if letter = "N" or letter = "n" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.3 rt 90 pd fd 0.8 rt 90 + 53.13 fd 1 set heading 0 fd 0.8 die]]
  if letter = "O" or letter = "o" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    rt 90 fd 0.4 lt 90 pd repeat 360 [fd 2.51327 / 360 lt 1] die]]
  if letter = "P" or letter = "p" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.3 rt 90 pd fd 0.8 rt 90 fd 0.4 repeat 180 [fd 1.25664 / 360 rt 1] fd 0.4 die]]
  if letter = "Q" or letter = "q" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    rt 90 fd 0.4 lt 90 pd repeat 675 [fd 2.51327 / 360 lt 1] set heading 300 fd 0.3 bk 0.5 die]]
  if letter = "R" or letter = "r" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.3 rt 90 pd fd 0.8 rt 90 fd 0.4 repeat 180 [fd 1.25664 / 360 rt 1] fd 0.4 bk 0.1 set heading 135 fd 0.55 die]]
  if letter = "S" or letter = "s" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.4 rt 90 fd 0.2 lt 180 pd fd 0.2 repeat 180 [fd 1.25664 / 360 lt 1] repeat 180 [fd 1.25664 / 360 rt 1] fd 0.2 die  ]]
  if letter = "T" or letter = "t" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.3 bk 0.6 fd 0.3 rt 90 pd fd 0.8 lt 90 fd 0.3 bk 0.6 die]]
  if letter = "U" or letter = "u" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.4 lt 90 fd 0.3 rt 90 pd bk 0.5 repeat 180 [bk 1.88496 / 360 lt 1] bk 0.5 die]]
  if letter = "V" or letter = "v" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.4 lt 90 fd 0.4 rt 90 pd lt 26.565 bk 0.894 set heading 0 rt 90 - 63.435 fd 0.894 die]]
  if letter = "W" or letter = "w" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.4 lt 90 bk 0.4 rt 90 pd rt 90 - 75.964 bk 0.825 set heading 180 - 29.745 bk 0.403 set heading 0 rt 29.745 bk 0.403 set heading 180 lt 14.036 bk 0.825 die]]
  if letter = "X" or letter = "x" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.4 lt 90 fd 0.4 rt 45 pd bk 1.131 fd 1.131 / 2 rt 90 fd 1.131 / 2 bk 1.131 die]]
  if letter = "Y" or letter = "y" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.4 lt 90 fd 0.4 rt 45 pd bk 1.131 / 2 rt 90 fd 1.131 / 2 bk 1.131 / 2 lt 45 bk 0.4 die]]
  if letter = "Z" or letter = "z" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.4 lt 90 fd 0.4 pd bk 0.8 lt 45 fd 1.131 rt 45 bk 0.8 die]]
  if letter = "1" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.3 pd bk 0.6 fd 0.3 rt 90 fd 0.8 lt 135 fd sqrt 0.1 die]]
  if letter = "2" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    lt 90 fd 0.4 rt 90 fd 0.1 pd repeat 200 [fd 2.01327 / 360 rt 1] rt 30 fd 0.7 set heading 90 fd 0.5 die]]
  if letter = ":" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.3 pd fd 0.1 pu fd 0.4 pd fd 0.1 die]]
  if letter = "!" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 pd fd 0.1 pu fd 0.2 pd fd 0.5 die]]
  if letter = "." [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 pd fd 0.1 die]]
  if letter = "{" [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.3 set heading 180 pd repeat 30 [fd 0.3 / 30 lt 1] die]
                   sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.3 rt 90 fd 0.3 set heading 180 pd repeat 30 [fd 0.3 / 30 lt 1] die]]
  if letter = "," [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.1 set heading 180 pd repeat 30 [fd 0.3 / 30 lt 1] die]]
  if letter = 1 [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.4 lt 90 fd 0.3 pd bk 0.6 fd 0.3 rt 90 fd 0.8 lt 135 fd sqrt 0.1 die]]
  if letter = 2 [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    lt 90 fd 0.4 rt 90 fd 0.1 pd repeat 200 [fd 2.01327 / 360 rt 1] rt 30 fd 0.7 set heading 90 fd 0.5 die]]
  if letter = 3 [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.4 lt 90 fd 0.2 rt 180 pd fd 0.2 repeat 180 [fd 1.25664 / 360 rt 1] lt 180 repeat 180 [fd 1.25664 / 360 rt 1] fd 0.2 die]]
  if letter = 4 [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    bk 0.3 rt 90 fd 0.1 lt 90 pd fd 0.6 bk 0.4 rt 90 fd 0.2 bk 0.6 lt 45 fd sqrt (2 * (0.4 ^ 2)) die]]
  if letter = 5 [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.4 rt 90 fd 0.3 pd bk 0.6 rt 90 fd 0.3 lt 90 fd 0.3 repeat 180 [fd 1.25664 / 360 rt 1] fd 0.3 die]]
  if letter = 6 [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    rt 90 fd 0.5 lt 90 repeat 45 [bk 2.51327 / 360 rt 1] repeat 120 [fd 2.51327 / 360 lt 1] pd repeat 140 [fd 2.51327 / 360 lt 1] repeat 400 [fd 1.5 / 360 lt 1] die]]
  if letter = 7 [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    fd 0.3 lt 90 fd 0.25 pd bk 0.6 lt 60 fd 0.8 die]]
  if letter = 8 [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    rt 90 pd repeat 360 [fd 1.25664 / 360 lt 1] repeat 360 [fd 1.25664 / 360 rt 1] die]]
  if letter = 9 [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    rt 90 pd repeat 360 [fd 1.25664 / 360 lt 1] repeat 90 [fd 1.25664 / 360 lt 1] bk 0.6 die]]
  if letter = 0 [sprout 1 [set hidden? true set color letter-color set heading 0 set pen-size letter-size
    rt 90 repeat 90 [fd 1.25664 / 360 lt 1] pd repeat 180 [fd 1.25664 / 360 lt 1] fd 0.4 repeat 180 [fd 1.25664 / 360 lt 1] fd 0.4 lt 135 fd 0.56569 die]]
end
@#$#@#$#@
GRAPHICS-WINDOW
209
11
913
428
-1
-1
24.0
1
10
1
1
1
0
1
1
1
-14
14
-8
8
1
1
1
ticks
30.0

BUTTON
116
79
188
112
NIL
startup\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
60
125
190
158
NIL
go
T
1
T
OBSERVER
NIL
G
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
setup
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
