globals
[
  grid-x-inc             ;; the amount of patches in between two roads in the x direction
  grid-y-inc             ;; the amount of patches in between two roads in the y direction
  roads                  ;; agentset containing the patches that are roads
  colors
  done?
  tiffins-dest-list
  tiffins-collected
  model-station
  tiffins-count
  set-capacity
  collect-strategy
  delay
  time-taken
]

breed [dabbawalas dabbawala ]
breed [stations station ]
breed [tiffins tiffin ]

dabbawalas-own [ capacity carrying-count my-tiffins target-tiffin at-station? going-to-station? aloted?]
stations-own [ name ]
tiffins-own [ tiffin-start tiffin-dest tiffin-dest-cor chosen? ]

;;;;;;;;;;;;;;;;;;;;;;
;; Setup Procedures ;;
;;;;;;;;;;;;;;;;;;;;;;


to setup [ station-name dw-capacity tiffins-count-per-area collect-strategies]
  clear-all
  setup-globals dw-capacity tiffins-count-per-area collect-strategies
  setup-roads
  set model-station station-name
  setup-stations station-name
  setup-dabbawalas
  setup-tiffins station-name
  if collect-strategy = "regional-equi-load"
  or collect-strategy = "regional-max-capacity"
  [ setup-my-tiffins ]
  reset-ticks
end

;; Initialize the global variables to appropriate values
to setup-globals [ dw-capacity tiffins-count-per-area collect-strategies ]
  set grid-x-inc world-width / 21
  set grid-y-inc world-height / 21
  set colors [ red blue green pink yellow white brown grey orange lime turquoise sky violet magenta ]
  set done? False
  set tiffins-dest-list []
  set set-capacity dw-capacity
  set tiffins-count tiffins-count-per-area
  set collect-strategy collect-strategies
  set delay 0
  set time-taken 0
end

to setup-roads
  ask patches
  [
    set pcolor brown
    if random 100 < 5
    [ set pcolor green - 1 ]
  ]
  set roads patches with
    [(floor((pxcor + max-pxcor - floor(grid-x-inc - 1)) mod grid-x-inc) = 0) or
    (floor((pycor + max-pycor) mod grid-y-inc) = 0)]
  ask roads [ set pcolor black ]

end

to setup-stations [ station-name ]
  create-stations 1 [
    let xy one-of patches with [pxcor != [pxcor] of roads and pycor != [pycor] of roads]
    setxy [pxcor] of xy [pycor] of xy
    set shape "house two story"
    set size 2
    set name station-name
    set label name
]
end

to setup-dabbawalas
  let dw-count ceiling ( tiffins-count / set-capacity )
  create-dabbawalas dw-count [
    let xy one-of roads
    setxy [pxcor] of xy [pycor] of xy
    set shape "dabbawala"
    set color white
    set size 3
    set going-to-station? false
    set at-station? false
    set my-tiffins 0
    set target-tiffin 0
    set aloted? False
    let index who - 1
    set color item index colors
    set capacity set-capacity ]
end

to setup-tiffins [ station-name ]
  create-tiffins tiffins-count [
    set shape "dabba"
    set size 3
    set color black
    set chosen? false
    move-to one-of patches with [pcolor = brown]
    set tiffin-dest-cor one-of patches with [ pcolor = brown ]
    set tiffin-start station-name
  ]
end

to setup-my-tiffins
  ask dabbawalas
  [
    let dabbawala-color color
    ifelse count tiffins with [color = black]> set-capacity
    [
      if collect-strategy = "regional-equi-load"
      [ set my-tiffins min-n-of ceiling ( count tiffins with [color = black] / count dabbawalas with [ not aloted? ] ) (tiffins with [color = black]) [ distance myself ] ]
      if collect-strategy = "regional-max-capacity"
      [ set my-tiffins min-n-of ceiling ( count tiffins / count dabbawalas ) (tiffins with [color = black]) [ distance myself ] ]
    ]
    [ set my-tiffins min-n-of count tiffins with [color = black] (tiffins with [color = black]) [ distance myself ] ]
    ask my-tiffins
    [
      set color dabbawala-color
    ]
    set aloted? True
  ]
end

to go
  if count dabbawalas with [ at-station? ] = 1
  [ set delay ticks ]
  if not any? dabbawalas with [not at-station?]
  [ stop-condition  ]
  ask dabbawalas with [not at-station? and going-to-station?]
  [ go-to-station ]
  ask dabbawalas with [not at-station? and not going-to-station?]
  [
    ifelse carrying-count < set-capacity and count tiffins with [not hidden?] > 0
    [ collect-tiffins ]
    [ set going-to-station? true ]
  ]
  tick
end

;;;;;;;;;;;;;;;;;;;;;;
;;   Go Procedures  ;;
;;;;;;;;;;;;;;;;;;;;;;

to stop-condition
  set delay ticks - delay
  if time-taken = 0
  [ set time-taken ticks ]
  set tiffins-collected tiffins with [ any? stations in-radius 4 ]
  ask tiffins-collected
  [
    set tiffins-dest-list lput ( list [pxcor] of tiffin-dest-cor [pycor] of tiffin-dest-cor)  tiffins-dest-list
  ]
  set done? True
  stop
end

to collect-tiffins
  if target-tiffin = 0 or [hidden?] of target-tiffin
  [ choose-next-target ]
  if target-tiffin != nobody
  [ collect-target ]
end

to go-to-station
  ask dabbawalas with [ not at-station? and going-to-station? ]
  [
    let speed ( set-capacity + 1 - carrying-count ) / 16
    let to-move neighbors with [ pcolor = black ]
    face min-one-of to-move [ distance one-of [ stations ] of myself ]
    fd speed
    if any? stations in-radius 2
    [
      set going-to-station? false
      set at-station? true
    ]
  ]
end

to choose-next-target
  let my-color color
  (ifelse collect-strategy = "regional-equi-load"
    or collect-strategy = "regional-max-capacity"
    [ set target-tiffin min-one-of tiffins with [not chosen? and color = my-color ] [distance myself ]]
    collect-strategy = "serial"
    [ set target-tiffin min-one-of tiffins with [not chosen? ] [distance myself ]]
    collect-strategy = "random"
    [ set target-tiffin one-of tiffins with [not chosen? ]])
  ifelse target-tiffin = nobody
  [ set going-to-station? true ]
  [
    ask target-tiffin
    [ set chosen? true ]
  ]
end

to collect-target
  let speed ( set-capacity + 1 - carrying-count ) / ( 5 * set-capacity )
  let to-move neighbors with [ pcolor = black]
  face min-one-of to-move [ distance [ target-tiffin ] of myself ]
  fd speed
  let tiffins-taken one-of tiffins in-radius 2 with [not hidden?]
  if tiffins-taken != nobody and tiffins-taken = target-tiffin
  [
    set target-tiffin 0
    set carrying-count carrying-count + 1
    ask tiffins-taken
    [
      hide-turtle
      create-link-with myself [tie]
    ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
227
26
719
519
-1
-1
7.93443
1
10
1
1
1
0
0
0
1
-30
30
-30
30
1
1
1
ticks
30.0

MONITOR
10
28
203
73
Number of Dabbawalas assigned
count dabbawalas
17
1
11

MONITOR
9
79
204
124
Total number of lunch boxes
count tiffins
17
1
11

MONITOR
10
130
204
175
Capacity of Dabbawala
set-capacity
17
1
11

MONITOR
948
247
1067
292
Percentage collected
count tiffins with [hidden? ] / count tiffins * 100
17
1
11

PLOT
746
25
1066
242
Percentage Collected
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count tiffins with [hidden? ] / count tiffins * 100"

@#$#@#$#@
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dabba
false
0
Rectangle -13345367 true false 90 90 165 210
Rectangle -1 true false 90 120 165 135
Rectangle -1 true false 90 165 165 180
Rectangle -7500403 false true 90 45 165 90

dabbawala
false
15
Circle -7500403 true false 110 5 80
Polygon -7500403 true false 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true false 127 79 172 94
Polygon -7500403 true false 195 90 240 150 225 180 165 105
Polygon -7500403 true false 105 90 60 150 75 180 135 105
Rectangle -1 true true 120 -15 180 15
Polygon -1 true true 120 180 120 180 180 195 180 240 210 285 195 285 165 300 150 225 135 300 120 300 105 300 105 255 120 195 120 180 180 180 180 195 210 285 195 300 165 300 150 225 135 300 105 300 90 285 120 195 120 180 180 180 180 195 210 285 165 300 150 225 135 300 105 300 90 285 150 225 210 285 180 195 120 180 105 270 90 285 120 285 120 270 150 225 135 240 120 270 105 285 105 270 120 255 120 255 135 225 135 210 150 225 165 240 165 240 180 270 180 270 180 285 180 270 180 225 180 210 180 255 180 255 180 270 165 240 180 270 180 285 165 240 195 285 180 240 180 210 180 195 165 180

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

house two story
false
0
Polygon -7500403 true true 2 180 227 180 152 150 32 150
Rectangle -7500403 true true 270 75 285 255
Rectangle -7500403 true true 75 135 270 255
Rectangle -16777216 true false 124 195 187 256
Rectangle -16777216 true false 210 195 255 240
Rectangle -16777216 true false 90 150 135 180
Rectangle -16777216 true false 210 150 255 180
Line -16777216 false 270 135 270 255
Rectangle -7500403 true true 15 180 75 255
Polygon -7500403 true true 60 135 285 135 240 90 105 90
Line -16777216 false 75 135 75 180
Rectangle -16777216 true false 30 195 93 240
Line -16777216 false 60 135 285 135
Line -16777216 false 255 105 285 135
Line -16777216 false 0 180 75 180
Line -7500403 true 60 195 60 240
Line -7500403 true 154 195 154 255

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

train passenger car
false
0
Polygon -7500403 true true 15 206 15 150 15 135 30 120 270 120 285 135 285 150 285 206 270 210 30 210
Circle -16777216 true false 240 195 30
Circle -16777216 true false 210 195 30
Circle -16777216 true false 60 195 30
Circle -16777216 true false 30 195 30
Rectangle -16777216 true false 30 140 268 165
Line -7500403 true 60 135 60 165
Line -7500403 true 60 135 60 165
Line -7500403 true 90 135 90 165
Line -7500403 true 120 135 120 165
Line -7500403 true 150 135 150 165
Line -7500403 true 180 135 180 165
Line -7500403 true 210 135 210 165
Line -7500403 true 240 135 240 165
Rectangle -16777216 true false 5 195 19 207
Rectangle -16777216 true false 281 195 295 207
Rectangle -13345367 true false 15 165 285 173
Rectangle -2674135 true false 15 180 285 188

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

rail
0.0
-0.2 1 1.0 0.0
0.0 1 4.0 4.0
0.2 1 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
