globals
[
  time
  foxes-color
  rabbits-color
  grass-color
  dirt-color
  invasive-color
  rabbits-stride ;; how much a rabbi moves in each simulation step
  invaders-stride  ;; how much an invader moves in each simulation step
  foxes-stride ;;  how much a fox moves in each simulation step
  fox-size
  rabbit-reproduce-age
  invader-reproduce-age
  fox-reproduce-age
  rabbits-energy-gain-from-food
  foxes-energy-gain-from-rabbits
  foxes-energy-gain-from-invaders
  max-plant-energy
  max-rabbits-age
 ;; grass-delay
  min-reproduce-energy-rabbits ;; energy required for reproduction
  min-reproduce-energy-invaders  ;; energy required for reproduction
  min-reproduce-energy-foxes ;; energy required for reproduction
  invaded?
  max-foxes-age
  max-invaders-age
  max-rabbits-offspring
  max-foxes-offspring
  max-invaders-offspring
]

breed [ rabbits rabbit]
breed [ invaders invader]
breed [ foxes fox]

turtles-own [ energy current-age max-age female?]
patches-own [ fertile?  plant-energy ]


to setup
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  clear-all
  set time 0
  set invaded? false
  set max-plant-energy 100
  set rabbits-stride 0.3
  set invaders-stride 0.3
  set foxes-stride 0.4
  ;;  a larger foxes-stride than rabbits-stride leads to scenarios where less foxes
  ;;  can keep a larger number of rabbitss in balance.
  set rabbit-reproduce-age 20
  set invader-reproduce-age 20
  set fox-reproduce-age 40
  set max-foxes-age 100
  set max-invaders-age 100
  set max-rabbits-age 100
  set rabbits-energy-gain-from-food 4
  set foxes-energy-gain-from-rabbits 25
  set foxes-energy-gain-from-invaders 25
  set min-reproduce-energy-rabbits 10
  set min-reproduce-energy-invaders 10
  set min-reproduce-energy-foxes 10
  set max-rabbits-offspring 3
  set max-invaders-offspring 3
  set max-foxes-offspring 2
  set fox-size 1
  set foxes-color  (red - 1)
  set rabbits-color (gray - 1)
  set invasive-color (blue - 3)
  set grass-color (green)
  set dirt-color (white)
  set-default-shape rabbits "rabbit"
  set-default-shape foxes "fox"
  set-default-shape invaders "mouse"
  add-starting-grass
  add-rabbits
  add-foxes
  do-plots
end


to go
 if time >= 2500 [stop]
  ask rabbits [ rabbits-live reproduce-rabbits]
  ask foxes [ foxes-live reproduce-foxes]
  ask invaders [invaders-live reproduce-invaders]
  ask patches [grow-grass]   ;;only the fertile patches can grow grass

  do-plots  ;; plot populations
  set time time + 1

end


to add-starting-grass
  ask patches [
      ifelse random 100 < percent-grass    ;;student sets the maximum number of fertile patches
    [
      set fertile? true
      set plant-energy (max-plant-energy - random max-plant-energy)
    ]
    [
      set fertile? false
      set plant-energy 0
    ]
    color-grass
  ]
  reset-ticks
end


to add-rabbits
  create-rabbits initial-number-rabbits  ;; create the rabbits, then initialize their variables
  [
    set color rabbits-color
    set energy 20 + random 20 - random 20;;randomize starting energies
    set current-age 0  + random max-rabbits-age     ;;don't start out with everyone at the same age
    set max-age max-rabbits-age
    setxy random world-width random world-height
     ;;ifelse (random 2 = 0) [set female? true] [set female? false]
  ]
end


to add-invaders
  create-invaders number-invaders ;; create the rabbits, then initialize their variables
  [
    set color invasive-color
    set energy 20 + random 20 - random 20;;randomize starting energies
    set current-age 0  + random max-invaders-age     ;;don't start out with everyone at the same age
    set max-age max-invaders-age
    setxy random world-width random world-height
   ;;  ifelse (random 2 = 0) [set female? true] [set female? false]
  ]
end


to add-foxes
  create-foxes initial-number-foxes  ;; create the rabbits, then initialize their variables
  [
    set color foxes-color
    set energy 40 + random 40 - random 40 ;;randomize starting energies
    set current-age 0  + random max-foxes-age     ;;don't start out with everyone at the same age
    set max-age max-foxes-age
    set size fox-size
    setxy random world-width random world-height
   ;;  ifelse (random 2 = 0) [set female? true] [set female? false]
  ]

end



to rabbits-live
    move-rabbits
    set energy energy - 1  ;; rabbitss lose energy as they move
    set current-age current-age + 1
    rabbits-eat-grass
    death
end

to invaders-live
    move-invaders
    set energy energy - 1  ;; rabbitss lose energy as they move
    set current-age current-age + 1
    invaders-eat-grass
    death
end

to foxes-live
  move-foxes
  set energy energy - 1  ;; foxes lose energy as they move
  set current-age current-age + 1
  eat-prey
  death
end


to move-rabbits  ;; turtle procedure
  rt random 50 - random 50
  fd rabbits-stride
end


to move-invaders  ;; turtle procedure
  rt random 40 - random 40
  fd invaders-stride
end


to move-foxes  ;; turtle procedure
  rt random 50 - random 50
  fd foxes-stride
end

to rabbits-eat-grass  ;; rabbits procedure
  ;; if there is enough grass to eat at this patch, the rabbits eat it
  ;; and then gain energy from it.
  if plant-energy > rabbits-energy-gain-from-food  [
    ;; plants lose ten times as much energy as the rabbits gains (trophic level assumption)
    set plant-energy (plant-energy - (rabbits-energy-gain-from-food * 10))
    set energy energy + rabbits-energy-gain-from-food  ;; rabbits gain energy by eating
  ]
  ;; if plant-energy is negative, make it positive
  if plant-energy <=  rabbits-energy-gain-from-food  [set plant-energy 0]
end


to invaders-eat-grass  ;; invaders procedure
  ;; if there is enough grass to eat at this patch, the invaders eat it
  ;; and then gain energy from it.
  if plant-energy > food-invaders-eats  [
    ;; plants lose 10 * as much energy as the invader gains (trophic level assumption)
    set plant-energy (plant-energy - (food-invaders-eats * 10))
    set energy energy + food-invaders-eats  ;; rabbits gain energy by eating
  ]
  ;; if plant-energy is negative, make it positive
  if plant-energy <=  food-invaders-eats  [set plant-energy 0]
end

to eat-prey  ;; foxes procedure
    if (any? rabbits-here and not any? invaders-here)
        [ask one-of  rabbits-here  [die]
           set energy (energy + foxes-energy-gain-from-rabbits)
         ]
      if (any? invaders-here and not any? rabbits-here)
        [ask one-of  invaders-here  [die]
           set energy (energy + foxes-energy-gain-from-invaders)
         ]
      if (any? invaders-here and any? rabbits-here)
        [ifelse random 2 = 0   ;; 50/50 chance to eat an invader or a rabbit if both are on this patch
           [ask one-of  invaders-here  [die] set energy (energy + foxes-energy-gain-from-invaders)]
           [ask one-of  rabbits-here  [die] set energy (energy + foxes-energy-gain-from-rabbits)]
         ]
end


to reproduce-rabbits  ;; rabbits procedure
  let number-offspring (random (max-rabbits-offspring + 1)) ;; set number of potential offpsring from 1 to (max-rabbits-offspring)
  if (energy > ((number-offspring + 1) * min-reproduce-energy-rabbits)  and current-age > rabbit-reproduce-age)
  [
    if random 2 = 1           ;;only half of the fertile rabbitss reproduce (gender)
    [
      set energy (energy - (number-offspring  * min-reproduce-energy-invaders))      ;;loose energy when reproducing --- given to children
      hatch number-offspring
      [
        set size 1
        set color rabbits-color
        set energy min-reproduce-energy-rabbits ;; split remaining half of energy amongst litter
        set current-age 0
       ;; ifelse (random 2 = 0) [set female? true] [set female? false]
        rt random 360 fd rabbits-stride
      ]    ;; hatch an offspring set it heading off in a a random direction and move it forward a step
    ]
  ]
end


to reproduce-invaders  ;; rabbits procedure
  let number-offspring (random (max-invaders-offspring + 1)) ;; set number of potential offpsring from 1 to (max-invaders-offspring)
  if (energy > ((number-offspring + 1) *  min-reproduce-energy-invaders)  and current-age > invader-reproduce-age)
  [
    if random 2 = 1           ;;only half of the fertile invaders reproduce (gender)
    [
      set energy (energy - ( number-offspring * min-reproduce-energy-invaders))            ;;loose energy when reproducing --- given to children
      hatch number-offspring
      [
        set size 1
        set color invasive-color
        set energy min-reproduce-energy-invaders ;; split remaining half of energy amongst litter
        set current-age 0
       ;; ifelse (random 2 = 0) [set female? true] [set female? false]
        rt random 360 fd invaders-stride
      ]    ;; hatch an offspring set it heading off in a a random direction and move it forward a step
    ]
  ]
end



to reproduce-foxes  ;; rabbits procedure
  let number-offspring (random (max-foxes-offspring + 1)) ;; set number of potential offpsring from 1 to (max-invaders-offspring)
  if (energy > ((number-offspring + 1) * min-reproduce-energy-foxes)  and current-age > fox-reproduce-age)
  [
    if random 2 = 1           ;;only half of the fertile rabbitss reproduce (gender)
    [
      set energy (energy - (number-offspring * min-reproduce-energy-foxes))           ;;loose energy when reproducing --- given to children
      hatch number-offspring
      [
        ;;set breed eggs
        set current-age 0
        set size fox-size
        set color foxes-color
        set energy min-reproduce-energy-foxes ;; split remaining half of energy amongst litter
        set current-age 0
       ;; ifelse (random 2 = 0) [set female? true] [set female? false]
        rt random 360 fd foxes-stride
      ]    ;; hatch an offspring set it heading off in a a random direction and move it forward a step
    ]
  ]
end

to death  ;; turtle procedure
  ;; die when energy dips below zero (starvation), or get too old
  if (current-age > max-age) or (energy < 0)
  [ die ]

end

to grow-grass  ;; patch procedure

  ;; fertile patches gain 1 energy unit per turn, up to a maximum max-plant-energy threshold
  if fertile?
     [set plant-energy (plant-energy + 1) if plant-energy > max-plant-energy [set plant-energy max-plant-energy]]

  if not fertile?
     [set plant-energy 0]
  if plant-energy < 0 [set plant-energy 0]
  color-grass
end

to color-grass
  ifelse fertile? [
    ifelse plant-energy > 0
    ;; scale color of patch from whitish green for low energy (less foliage) to green - high energy (lots of foliage)
    [set pcolor (scale-color green plant-energy  (max-plant-energy * 2)  0)]
    [set pcolor dirt-color]
    ]
  [set pcolor dirt-color]
end


to do-plots
    set-current-plot "populations"
    set-current-plot-pen "rabbits"
    plot count rabbits
    set-current-plot-pen "invaders"
    plot count invaders
    set-current-plot-pen "foxes"
    plot count foxes
    set-current-plot-pen "grass"
    plot (sum [plant-energy] of patches / max-plant-energy)
end
@#$#@#$#@
GRAPHICS-WINDOW
539
12
957
431
-1
-1
10.0
1
10
1
1
1
0
1
1
1
-20
20
-20
20
0
0
1
ticks
30.0

SLIDER
6
126
215
159
initial-number-foxes
initial-number-foxes
0
200
50.0
1
1
NIL
HORIZONTAL

BUTTON
6
13
110
46
setup/reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
111
13
214
46
go/pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
5
170
531
429
populations
time
populations
0.0
2500.0
0.0
200.0
true
true
"" ""
PENS
"rabbits" 1.0 0 -7500403 true "" ""
"foxes" 1.0 0 -2674135 true "" ""
"invaders" 1.0 0 -16777216 true "" ""
"grass" 1.0 0 -10899396 true "" ""

MONITOR
248
16
325
61
rabbits
count rabbits
3
1
11

MONITOR
249
65
327
110
foxes
count foxes
3
1
11

SLIDER
6
91
214
124
initial-number-rabbits
initial-number-rabbits
0
200
100.0
1
1
NIL
HORIZONTAL

SLIDER
6
55
213
88
percent-grass
percent-grass
0
100
100.0
1
1
NIL
HORIZONTAL

SLIDER
342
63
515
96
number-invaders
number-invaders
0
100
100.0
1
1
NIL
HORIZONTAL

BUTTON
370
21
511
54
launch invasion
add-invaders
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
250
117
326
162
invaders
count invaders
0
1
11

SLIDER
342
101
516
134
food-invaders-eats
food-invaders-eats
0
8
4.0
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT? 

This model explores the stability of predator-prey ecosystems. 

Foxes and rabbits wander randomly around the landscape.  Each step costs both animals energy and they must consume a food source (rabbits must eat grass and foxes must eat rabbits) to replenish their energy - when they run out of energy they die. To allow the population to continue, each fox or rabbit must have enough energy to have a litter of offspring and the offspring and parent split the energy amongst themselves.  Grass grows at a fixed rate, and when it is eaten, a fixed amount of grass energy is deducted from the patch (square) where the grass was eaten. 

Different starting conditions for number of each species, amount of grass, maximum age of each species, number of offspring in a litter will lead to stable or unstable systems, depending on these values.

## SETTING UP 

1. Adjust the slider parameters (see below), or use the default settings.  
2. Press the SETUP button.  
4. Press the GO button to begin the simulation.  
5. View the POPULATIONS plot to watch the populations fluctuate over time  
6. View the rabbits/foxes monitors to view current population sizes.  
7. Adjust the NUMBER-INVASIVE and FOOD-INVASIVE-EATS and press LAUNCH INVASION  
5. View the POPULATIONS plot to watch the populations fluctuate over time  
6. View the rabbits/foxes/invaders monitors to view current population sizes.

Initial Settings:  
PERCENT-GRASS: The percentage of patches in the world & view that produce grass  
INITIAL-NUMBER-RABBITS: The initial size of rabbit population   
INITIAL-NUMBER-FOXES: The initial size of snake population

Other Settings:  
NUMBER-INVASIVE: The number of the invasive species introduced when LAUNCH INVASION is pressed.  
FOOD-INVASIVE-EATS: The amount of grass consumed each simulation step by one of the invasive species

Notes:  
- one unit of energy is deducted for every step a fox or rabbit.  In a step, each of these animals moves a different fraction of a patch (square).


## THINGS TO NOTICE 

Watch as the fox and rabbit populations fluctuate. Notice that increases and decreases in the sizes of each population are related. In what way are they related? 

Why do you suppose that some variations of the model might be stable while others are not?

When the model is run with rabbit and grass, but no foxes, the rabbit population only fluctuates a little bit, and does not show the large increases and decreases it did when foxes were included.  What causes this behavior?

## THINGS TO TRY

Try adjusting the parameters under various settings. How sensitive is the stability of the model to the particular parameters?

What parameters that eventually generate a stable ecosystem that includes only foxes and rabbits?  How about foxes and invasive only?  How about foxes, invasive, and rabbits?  Notice that under stable settings, the populations tend to fluctuation at a predictable pace. Can you find any parameters that will speed this up or slow it down?

## RELATED MODELS

Look at Wolf-Sheep and Rabbit Grass Weeds for other models of interacting populations with different rules. 

NetLogo Wolf Sheep Predation model. http://ccl.northwestern.edu/netlogo/models/WolfSheepPredation. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

aphid
true
0
Circle -7500403 true true 129 84 42
Circle -7500403 true true 96 126 108

aphid-with-parasite
true
0
Circle -7500403 true true 129 84 42
Circle -7500403 true true 96 126 108
Circle -2674135 false false 8 8 285

egg
true
0
Circle -1 true false 120 95 60
Circle -1 true false 105 142 90
Polygon -1 true false 195 180 180 120 120 120 105 180

fox
false
0
Polygon -7500403 true true 72 225 94 249 109 252 119 252 111 242 99 241 87 225 91 181 62 112 43 119 28 150 29 164 58 204 50 241 74 271 84 279 99 279 98 267 87 266 67 242
Polygon -7500403 true true 210 90 204 56 214 42 222 66 211 71
Polygon -7500403 true true 181 107 213 70 226 63 257 71 260 90 300 120 289 129 249 110 218 135 209 151 204 164 192 179 169 186 154 190 129 190 89 181 69 167 60 112 124 111 160 112 170 105
Polygon -6459832 true false 252 143 242 141
Polygon -6459832 true false 254 136 232 137
Line -16777216 false 80 159 89 179
Polygon -6459832 true false 262 138 234 149
Polygon -7500403 true true 50 121 36 119 24 123 14 128 6 143 8 165 8 181 7 197 4 233 23 201 28 184 30 169 28 153 48 145
Polygon -7500403 true true 171 181 178 263 187 277 197 273 202 267 187 260 186 236 194 167
Polygon -7500403 true true 223 75 226 58 245 44 244 68 233 73
Line -16777216 false 89 181 112 185
Line -16777216 false 31 150 41 130
Polygon -16777216 true false 230 67 228 54 222 62 224 72
Line -16777216 false 30 150 30 165
Circle -1184463 true false 225 76 22
Polygon -7500403 true true 225 121 258 150 267 146 236 112

fox3
false
3
Polygon -6459832 true true 90 105 75 81 60 75 44 83 36 98 38 120 38 136 37 152 15 180 53 156 58 139 60 124 58 108 90 120
Polygon -6459832 true true 196 106 228 69 240 60 263 63 275 89 300 110 285 135 240 120 233 134 225 150 225 165 207 178 184 185 169 189 144 189 104 180 84 166 78 113 139 110 175 111 185 104
Polygon -6459832 true true 252 143 242 141
Polygon -6459832 true true 254 136 232 137
Polygon -6459832 true true 262 138 234 149
Polygon -6459832 true true 195 165 180 210 143 247 144 263 159 267 164 253 195 225 225 165
Polygon -6459832 true true 238 75 240 45 255 30 259 68 248 73
Polygon -16777216 true false 285 135 297 116 285 111
Polygon -6459832 true true 135 210 151 181 119 165 105 165 73 184 31 183 -9 205 -9 226 6 231 7 214 38 198 75 225 120 210
Polygon -6459832 true true 218 80 203 50 233 65
Polygon -6459832 true true 195 180 240 210 270 240 293 246 297 231 283 226 240 180 210 165
Polygon -6459832 true true 94 112 76 119 60 151 60 165 79 197 78 239 100 279 121 279 126 264 109 263 93 232 120 195 105 150

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

mouse
false
0
Polygon -7500403 true true 38 162 24 165 19 174 22 192 47 213 90 225 135 230 161 240 178 262 150 246 117 238 73 232 36 220 11 196 7 171 15 153 37 146 46 145
Polygon -7500403 true true 289 142 271 165 237 164 217 185 235 192 254 192 259 199 245 200 248 203 226 199 200 194 155 195 122 185 84 187 91 195 82 192 83 201 72 190 67 199 62 185 46 183 36 165 40 134 57 115 74 106 60 109 90 97 112 94 92 93 130 86 154 88 134 81 183 90 197 94 183 86 212 95 211 88 224 83 235 88 248 97 246 90 257 107 255 97 270 120
Polygon -16777216 true false 234 100 220 96 210 100 214 111 228 116 239 115
Circle -16777216 true false 246 117 20
Line -7500403 true 270 153 282 174
Line -7500403 true 272 153 255 173
Line -7500403 true 269 156 268 177

rabbit
false
4
Polygon -1184463 true true 61 150 76 180 91 195 103 214 91 240 76 255 61 270 76 270 106 255 132 209 151 210 181 210 211 240 196 255 181 255 166 247 151 255 166 270 211 270 241 255 240 210 270 225 285 165 256 135 226 105 166 90 91 105
Polygon -1184463 true true 75 164 94 104 70 82 45 89 19 104 4 149 19 164 37 162 59 153
Polygon -1184463 true true 64 98 96 87 138 26 130 15 97 36 54 86
Polygon -1184463 true true 49 89 57 47 78 4 89 20 70 88
Circle -16777216 true false 29 110 32
Polygon -5825686 true false 0 150 15 165 15 150
Polygon -5825686 true false 76 90 97 47 130 32
Line -7500403 false 165 180 180 165
Line -7500403 false 180 165 225 165

wasp
true
0
Polygon -1184463 true false 195 135 105 135 90 150 90 210 105 255 135 285 165 285 195 255 210 210 210 150 195 135
Rectangle -16777216 true false 90 165 212 185
Polygon -16777216 true false 90 207 90 226 210 226 210 207
Polygon -16777216 true false 103 266 198 266 203 246 96 246
Polygon -6459832 true false 120 135 105 120 105 60 120 45 180 45 195 60 195 120 180 135
Polygon -6459832 true false 150 0 120 15 120 45 180 45 180 15
Circle -16777216 true false 105 15 30
Circle -16777216 true false 165 15 30
Polygon -7500403 true true 180 75 270 90 300 150 300 210 285 210 255 195 210 120 180 90
Polygon -16777216 true false 135 300 165 300 165 285 135 285
Polygon -7500403 true true 120 75 30 90 0 150 0 210 15 210 45 195 90 120 120 90

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
