;;Written by Pedro Romero, promeroec@gmail.com 2016
;;Inspired by Kiyotaki and Wright 89.
;;Universidad San Francisco de Quito! preliminary version

globals [
  ;;Cost of storage per good
  costGoodA costGoodB costGoodC
]

turtles-own[
  traderType partner partnered? myPartnerType
  goodA goodB goodC consume traded
]

to setup
  clear-all
  ask patches [ set pcolor white ]
  crt population [
    set shape "person"
    setxy random-xcor random-ycor

    set traderType random-float 1.0
    if (traderType <= 1.00) [
      ifelse (traderType > 0.67)
      [ set color yellow
        ] ;;type1 likes goodA prod B
      [ifelse (traderType > 0.33)
        [set color blue
          ]  ;;type2 likes goodB prod C
        [set color red
          ]   ;;type3 likes goodC prod A
        ]]
    set goodB 0 set goodC 0 set goodA 0

  ]
  ;;setting up variables
  ask turtles [
    set partner nobody
    set partnered? false
    set myPartnerType 0
    set consume false
    set traded false]
  set costGoodA 1 set costGoodB 4 set costGoodC 9
  reset-ticks
end

to go
  ask turtles [
  setxy random-xcor random-ycor  ;;search
  set goodA 0 set goodB 0 set goodC 0
  ]
  release-partners
  all-partnered
  init-production
  make-exchange
  tick
end

to rounds
  ask turtles [
  setxy random-xcor random-ycor  ;;search
  ]
  release-partners
  all-partnered
  make-exchange
  ;new-production
  tick
end

to release-partners
    ask turtles [
    if (partnered? = true) [
      set partner nobody
      set partnered? false
    ]
    ]
end

to all-partnered
  while [ (count turtles with [partner = nobody] > 0) ] [;move-turtles
  partnering]
end

to partnering
  ask turtles [
    if (partnered? = false) [
       setxy random-xcor random-ycor
       if (partner = nobody) and (any? other (turtles-at -1 0) with [partner = nobody]) [
         set partner one-of other (turtles-at -1 0) with [partner = nobody]
         set partnered? true
         ask partner [
           set partner myself
           set partnered? true

                     ]
                                              ]

                          ]

             ]

end

to init-production

    ask turtles [ifelse (color = yellow) [
        set goodB 1] [
        ifelse (color = blue) [
          set goodC 1] [
          set goodA 1]
        ]
    ]
end

to make-exchange

  ask turtles [ set consume false set traded false]

  ask turtles [ ifelse ((goodA + goodB + goodC) = 1) [
  ask turtles with [color = blue] [;;loop
    ;;Trade or swap 1 unit if it is the one type i likes
            ask partner [ if color != blue [
              ifelse (color = yellow) [
                 if (goodB = 1) and ([goodA = 1] of myself)[
                        set goodA 1 set goodB 0 set goodC 0 set-consume
                       ask myself [ set goodC 0 set goodA 0 set goodB 1 set-consume ]
                       ] ]
               [ if (goodA = 1) and ([goodC = 1] of myself) [ ;;begin red
                  set goodC 1 set goodA 0 set goodB 0 set-consume
                  ask myself [set goodC 0 set goodA 1 set goodB 0 set-exchange ]
                  ] ] ;;set-exchange before
                     ]
            ]
          set-surplus
          ask partner [ set-surplus] ]
  ]
  [ ;if (consume = false) and (traded = false)
                       set-surplusNoTrade ]
  ]
           ;ask partner [set-surplusNoTrade] ]
      ;]
  ;] ;;end ask TURTLES
end

to set-consume
  ;;agent i consumes and and produces
  ifelse color = yellow [
    set consume true
    set goodA 0 set goodB 1 set goodC 0
    show (list [color] of self partner myPartnerType goodA goodB goodC "con" ticks)
    ;
    ]
  [
  ifelse color = blue [
    set consume true
    set goodB 0 set goodC 1 set goodA 0
    show (list [color] of self partner myPartnerType goodA goodB goodC "con" ticks)
    ;
     ]
  [
    set consume true
    set goodC 0 set goodA 1 set goodB 0
    show (list [color] of self partner myPartnerType goodA goodB goodC "con" ticks)
    ;
    ]]
end

to set-exchange

        set traded true
        show (list [color] of self partner myPartnerType goodA goodB goodC "exc" ticks)

end

to new-production
  ask turtles with [consume = false and traded = false] [
  ifelse color = yellow [
    set goodB 1

    ]
  [
  ifelse color = blue [
    set goodC 1

     ]
  [
    set goodA 1

    ]] ]
end

;;The following does not alter the main algorithm to find good that becomes money
to set-surplus
  ;;Here code just to compute utilities after trading
end

to set-surplusNoTrade
  ;;here code just to compute utilities if no trade at all
end

;plots
@#$#@#$#@
GRAPHICS-WINDOW
7
10
252
251
10
10
10.0
1
10
1
1
1
0
1
1
1
-10
10
-10
10
1
1
1
ticks
30.0

SLIDER
240
12
412
45
population
population
0
100
50
2
1
NIL
HORIZONTAL

BUTTON
245
179
311
212
setup
setup
NIL
1
T
OBSERVER
NIL
E
NIL
NIL
1

BUTTON
473
180
536
213
go
rounds
T
1
T
OBSERVER
NIL
G
NIL
NIL
1

BUTTON
319
179
384
212
firstR
go
NIL
1
T
OBSERVER
NIL
O
NIL
NIL
1

BUTTON
391
180
468
213
rounds
repeat 24 [rounds]
NIL
1
T
OBSERVER
NIL
R
NIL
NIL
1

PLOT
7
311
330
528
Exchanged Goods
time
number
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"g1" 1.0 0 -15390905 true "" "plot count turtles with [traded = true and goodA = 1]"
"g2" 1.0 0 -2674135 true "" "plot count turtles with [traded = true and goodB = 1]"
"g3" 1.0 0 -955883 true "" "plot count turtles with [traded = true and goodC = 1]"

MONITOR
352
225
409
270
single
count turtles with [partner = nobody]
17
1
11

TEXTBOX
244
120
416
164
1. Press setup\n2. Press firstR\n3. Press rounds or go (forever).
11
0.0
1

TEXTBOX
252
231
340
259
any single agent at each time!
11
0.0
1

TEXTBOX
240
52
585
95
To see each pair of agents per time. Please, click the doble arrow below at the Command Center. This serves to check that there is only 1 good at inventory each period.\n
11
0.0
1

BUTTON
474
139
548
172
oncet1
rounds
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
416
226
509
271
moreThan1g
count turtles with [goodA + goodB + goodC > 1]
17
1
11

PLOT
341
310
640
529
Bartered Goods
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"g1" 1.0 0 -14439633 true "" "plot count turtles with [goodA > 0 and consume = true]"
"g2" 1.0 0 -13345367 true "plot count turtles with [goodB > 0 and consume = true]" "plot count turtles with [goodB > 0 and consume = true]"
"g3" 1.0 0 -2674135 true "" "plot count turtles with [goodC > 0 and consume = true]"

MONITOR
518
226
671
271
Any agent w/ C and T true
count turtles with [consume = true and traded = true]
17
1
11

MONITOR
573
169
709
214
any agents w/ 0 goods
count turtles with [goodA + goodB + goodC = 0]
17
1
11

@#$#@#$#@
## WHAT IS IT?

This model is an agent-based version inspired by the game theoretical model by Kiyotaki and Wright (1989). The model studies the emergence of money or a commodity money out of trading in consumption goods. It is, also, a search theoretical model based on a matching mechanism.

## HOW IT WORKS

In this enviroment, there three goods (g1, g2 ,g3) and a population of agents of three types: i) agent type I (yellow color) consumes good g1 and produces good g2; ii) agent type II(blue color) consumes g2 and produces good g3; and iii) agent type III(red color) consumes good g3 and produces good g1. Thus, trade is induced by consumption preferences and specialized production. Only one good can be stored from period to period, a no agent can hold more than one good at a time.
Agents move randomly to search for partners, each of them can only have one partner per tick. Every agent, also, produces its especialized production good. Once matched every pair of agents can barter if there is full coincide of preferences and production; or one of the agents will become a middleman who takes one of the goods not for consumption but for exchange; and finally nothin can happen if none of the two previuos cases occur.
Contrary to the original model, here agents are not maximizing on a rational basis to achieve this equilibrium. Thus, this parsimoniuos model shows that rationality assumption are not necessary to get the fundamental result of the original paper.


## HOW TO USE IT

This section could explain how to use the model, including a description of each of the items in the interface tab.

## THINGS TO NOTICE

Only good 2 arises as the commodity money or medium of exchange, and the middleman are agents type II.

## THINGS TO TRY

Try increasing population of agents. More interestingly, try to change the production technologies of the agents increasing how much can they produce, to see any changes.

## EXTENDING THE MODEL

One natural extension is to explicitly model the maximizing behavior of the agents. Other extension is to introduce a fiat money with zero storage cost. A more challenging extension is to make a model of the co-evolution of specialization and money.

## NETLOGO FEATURES

This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.

## RELATED MODELS

This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.

## CREDITS AND REFERENCES
Kiyotaki and Wright (1989): On money as a medium of exchange. Journal of Political Economy 97(4), http://www.jstor.org/stable/1832197?
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
