globals [
  percent-similar-
  quad1resources
  quad2resources
  quad3resources
  quad4resources
  quad5resources
  quad6resources
  quad7resources
  quad8resources
  quad9resources
  quad0turtles
  quad0turtles1
  quad0turtles2
  quad0turtles3
  quad0turtles4
  quad0turtles5
  quad0turtles6
  quad4classlow
  quad4classmid
  quad4classhigh
  quad7ethnicityorange
  quad7ethnicityblue
  quad1turtles
  quad2turtles
  quad3turtles
  quad4turtles
  quad5turtles
  quad6turtles
  quad7turtles
  quad8turtles
  quad1satis
  quad2satis
  quad3satis
  quad4satis
  quad5satis
  quad6satis
  quad7satis
  quad8satis
  quad9satis
]
  
  
turtles-own [
  satisfied   ;; for each turtle, indicates whether or not it is satisfied with its current position 
  racialsatisfaction
  classsatisfaction
  blue?    ;; for each tu
  orange?
  upper-class?
  middle-class?
  lower-class?
  group
  class
  resources
  similar-ethnicity-nearby
  other-ethnicity-nearby
  acceptable-resource-nearby
  desired-class-nearby
  total-nearby
  percent-ethnicity-nearby
  percent-class-nearby
  tquadrant
  destinationperc
  destination
  choice1hap
  choice2hap
  choice3hap
  income
]

patches-own [
  presources
  quadrant
  open?
]

to update-turtles
 
 ask turtles [
   if blue? 
    [set similar-ethnicity-nearby count (turtles in-radius 3)
     with [blue? = true]
     set other-ethnicity-nearby count (turtles in-radius 3)
     with [orange? = true]]
   if orange? 
    [set similar-ethnicity-nearby count (turtles in-radius 3)
     with [orange? = true]
    set other-ethnicity-nearby count (turtles in-radius 3)
     with [blue? = true]]
    set total-nearby (similar-ethnicity-nearby + other-ethnicity-nearby)
    set percent-ethnicity-nearby (similar-ethnicity-nearby / total-nearby)
     ifelse similar-ethnicity-wanted > percent-ethnicity-nearby
    [set racialsatisfaction 1 - (similar-ethnicity-wanted - percent-ethnicity-nearby)]
    [set racialsatisfaction 1]
    set percent-class-nearby (desired-class-nearby / total-nearby) 
     ifelse class-level-desired > percent-class-nearby
    [set classsatisfaction 1 - (class-level-desired - percent-class-nearby)]
    [set classsatisfaction 1]
  if upper-class?
  [set desired-class-nearby count (turtles in-radius 3)
    with [upper-class? = true]]
   if middle-class?
  [set desired-class-nearby count (turtles in-radius 3)
    with [upper-class? = true]]
  if lower-class?
  [set desired-class-nearby count (turtles in-radius 3)
    with [middle-class? = true]]
   set satisfied percent-ethnicity * racialsatisfaction + (1 - percent-ethnicity) * classsatisfaction
   set tquadrant quadrant
  
 ]
 end


to assign-quadrant
  ask patches [
  if pxcor <= -8 and pxcor > -25 and pycor <= 25 and pycor > 8 [set quadrant 0 set pcolor 1]
  if pxcor <= 8 and pxcor > -8 and pycor <= 25 and pycor > 8 [set quadrant 1 set pcolor 3]
  if pxcor <= 25 and pxcor > 8 and pycor <= 25 and pycor > 8 [set quadrant 2 set pcolor 1]
  if pxcor <= -8 and pxcor > -25 and pycor <= 8 and pycor > -8 [set quadrant 3 set pcolor 3]
  if pxcor <= 8 and pxcor > -8 and pycor <= 8 and pycor > -8 [set quadrant 4 set pcolor 1]
  if pxcor <= 25 and pxcor > 8 and pycor <= 8 and pycor > -8 [set quadrant 5 set pcolor 3]
  if pxcor <= -8 and pxcor > -25 and pycor <= -8 and pycor > -25 [set quadrant 6 set pcolor 1]
  if pxcor <= 8 and pxcor > -8 and pycor <= -8 and pycor > -25 [set quadrant 7 set pcolor 3]
  if pxcor <= 25 and pxcor > 8 and pycor <= -8 and pycor > -25 [set quadrant 8 set pcolor 1]]
end
       
       
to calc-quad-satis [quad groupnum]
  
end
  
to setup
  clear-all
  if number > count patches
   [ user-message (word "This city only has room for" count patches " turtles .")
      stop ]
   
   ;; create turtles on random patches.
   ask n-of number patches
    [ sprout 1
       [ set color 27] ]
    ;; turn
   ask turtles [
    if xcor <= 25 and xcor > 16 [set group 1 set color 27]
    if xcor <= 16 and xcor > 8 [set group 2 set color 25]
    if xcor <= 8 and xcor > 0 [set  group 3 set color 22]
    if xcor <= 0 and xcor > -8 [set group 4 set color 86]
    if xcor <= -8 and xcor > -16 [set group 5 set color 93]
    if xcor <= -16 and xcor >= -25 [set group 6 set color 102]
     find-fresh-patch
    set orange? color = 27 or color = 25 or color = 22   
    set blue?   color = 86 or color = 93 or color = 102
    set upper-class? color = 22 or color = 102
    set middle-class? color = 25 or color = 93
    set lower-class? color = 27 or color = 86
    if upper-class? [set resources 100]
    if middle-class? [set resources 50]
    if lower-class? [set resources 25]
    if color = 22 or color = 102 [set class 1]
    if color = 25 or color = 93 [set class 2]
    if color = 27 or color = 86 [set class 3]
   ]
   assign-quadrant
   reset-ticks
end

to go
  update-turtles
  update-patches
  update-globals
  move-turtles
  tick
end


to update-patches
 ask patches [
 set open? not any? turtles-here
 ]
end

to move-turtles
  ask turtles [
  let choice1 random 8
  let choice2 random 8
  let choice3 tquadrant;; generate 3 random quadrants that a turtle has knowledge of. these are candidates for movement (need to set choice 3 to own quadrant)
  set choice1hap .35
  if any? turtles with [group = [group] of myself and tquadrant = choice1]
  [set choice1hap mean [satisfied] of turtles with [group = [group] of myself and class = [class] of myself and tquadrant = choice1]] ;? true] ;and turtles-on patch with [quadrant = choice1]
  set choice2hap .35
  if any? turtles with [group = [group] of myself and tquadrant = choice2]
  [set choice2hap mean [satisfied] of turtles with [group = [group] of myself and class = [class] of myself and tquadrant = choice2]] ;and turtles-on patch with [quadrant = choice2]
  set choice1hap .35
  if any? turtles with [group = [group] of myself and tquadrant = choice3]
  [set choice3hap mean [satisfied] of turtles with [group = [group] of myself and class = [class] of myself and tquadrant = choice3]] ;and turtles-on patch with [quadrant = choice3]

  ifelse choice1hap >= choice2hap
  [ifelse choice1hap >= choice3hap 
    [set destination choice1 set destinationperc choice1hap]
    [set destination choice3 set destinationperc choice3hap]]
  [ifelse choice2hap >= choice3hap
    [set destination choice2 set destinationperc choice2hap]
    [set destination choice3 set destinationperc choice3hap]]
  let destinations destination
  
  if destinationperc > satisfied
   [let rangen random 6
  if rangen = 2 [
  if any? patches with [quadrant = destinations and open? = true]
  [move-to one-of patches with [quadrant = destinations and open? = true]
    if not open? [move-turtles]]
  if any? other turtles-here
      [find-fresh-patch2]
      move-to patch-here
    ]]]
  ;; move to the quandrant where turtles of the same kind are happiest
end


to find-fresh-patch
rt random-float 360
     fd random-float 100
     if any? other turtles-here
      [find-fresh-patch]
      move-to patch-here
end
   
to find-fresh-patch2
rt random-float 360
     fd random-float 5
     if any? other turtles-here
      [find-fresh-patch2]
      move-to patch-here
end

to update-globals 
 set quad0turtles1 count turtles with [group = 1] with [tquadrant = 0]
 set quad0turtles2 count turtles with [group = 2] with [tquadrant = 0]
 set quad0turtles3 count turtles with [group = 3] with [tquadrant = 0]
 set quad0turtles4 count turtles with [group = 4] with [tquadrant = 0]
 set quad0turtles5 count turtles with [group = 5] with [tquadrant = 0]
 set quad0turtles6 count turtles with [group = 6] with [tquadrant = 0]
 set quad4classlow count turtles with [group = 1 or group = 4] with [tquadrant = 4]
 set quad4classmid count turtles with [group = 2 or group = 5] with [tquadrant = 4]
 set quad4classhigh count turtles with [group = 3 or group = 6] with [tquadrant = 4]
 set quad7ethnicityorange count turtles with [group = 1 or group = 2 or group = 3] with [tquadrant = 7]
 set quad7ethnicityblue count turtles with [group = 4 or group = 5 or group = 6] with [tquadrant = 7]
end
@#$#@#$#@
GRAPHICS-WINDOW
329
73
829
594
24
24
10.0
1
10
1
1
1
0
1
1
1
-24
24
-24
24
1
1
1
ticks
30.0

SLIDER
45
81
250
114
number
number
20
1200
680
10
1
NIL
HORIZONTAL

BUTTON
508
27
574
60
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
602
25
665
58
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
42
240
248
273
percent-ethnicity
percent-ethnicity
0
100
0
1
1
NIL
HORIZONTAL

SLIDER
43
189
248
222
similar-ethnicity-wanted
similar-ethnicity-wanted
0
1
0.53
.01
1
NIL
HORIZONTAL

SLIDER
44
137
249
170
class-level-desired
class-level-desired
0
1
0.65
.01
1
NIL
HORIZONTAL

PLOT
7
314
307
540
quad0turtles1
time
number of turtles
0.0
50.0
0.0
50.0
true
false
"" "update-globals"
PENS
"" 1.0 0 -955883 true "" "plot quad0turtles2"
"" 1.0 0 -10146808 true "" "plot quad0turtles3"
"" 1.0 0 -8990512 true "" "plot quad0turtles4"
"pen-1" 1.0 0 -612749 true "" "plot quad0turtles1"
"pen-4" 1.0 0 -14985354 true "" "plot quad0turtles5"
"pen-5" 1.0 0 -15390905 true "" "plot quad0turtles6"

PLOT
877
75
1195
304
quad4class
time
number of each class
0.0
40.0
0.0
15.0
true
false
"" "update-globals"
PENS
"low" 1.0 0 -5509967 true "" "plot quad4classlow"
"middle" 1.0 0 -13840069 true "" "plot quad4classmid"
"upper" 1.0 0 -16375013 true "" "plot quad4classhigh"

PLOT
877
326
1193
570
quad7ethnicity
time
number of each race
0.0
50.0
0.0
50.0
true
false
"" "update-globals"
PENS
"default" 1.0 0 -955883 true "" "plot quad7ethnicityorange"
"pen-1" 1.0 0 -13791810 true "" "plot quad7ethnicityblue"

@#$#@#$#@
## WHAT IS IT?

This project models the behavior of six variations of turtles in a city that contains nine neighborhoods. It tracks movement of ethnicities and classes between neighborhoods, modeling shifts in neighborhood dynamics and gentrification. There are two ethnicities in the city: blue turtles and orange turtles. Within each ethnicity, members belong to either the lower, middle, or upper class. Turtles_ class is distinguishable by the shade of their color, with the lightest turtles belonging to the lower class, the medium shade representing the middle class, and the darkest turtles comprising the upper class. 

## HOW TO USE IT

Click the SETUP button to set up the turtles. A certain number of turtles are generated randomly and assigned a color based on their x and y coordinates. They then turn a random angle and move a random distance across the city until there is at most one turtle on a patch. Click GO to start the simulation. 

The NUMBER slider controls the total number of turtles. (It takes effect the next time you click SETUP.) The class-level-desired slider controls the percentage of turtles of the class above it that an individual would like in its neighborhood (as defined by a radius surrounding the individual). 

The similar-ethnicity-wanted slider controls the percentage of turtles of the same ethnicity that a turtle desires in its radius. 

The percent-ethnicity slider controls the weight each individual turtle gives to the class-level-desired and similar-ethnicity-wanted sliders in deciding its satisfaction. The number shown represents the percentage assigned to ethnicity, with the remainder designated to class desire.


## THINGS TO NOTICE

Notice both the class and ethnic dynamics that emerge as neighborhoods form according to the rules specified in the sliders.

## THINGS TO TRY

Adjust the sliders for number, class-level-desired, similar-ethnicity-wanted, and percent-ethnicity. Try to create scenarios in which turtles select neighborhoods based mostly on race and situations in which they make decisions based mostly on class. Then, investigate the results the simulation when individuals have more balanced preferences in terms of ethnicity and class.

## EXTENDING THE MODEL

Add incentives for movement while also providing constraints based on neighborhoods' barriers of entry, individuals "income," and other economic factors.  

## NETLOGO FEATURES

"ask n-of number patches [ sprout 1]" is used to generate turtles on the board

## RELATED MODELS

Segregation
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
