;  air traffic controller game     Jim Reierson   1/30/2014
;  this version _s controls aircraft with heading sliders
;  includes 11/26/2014 mods to allow compilation with tortoise
breed [airplanes airplane]
breed [halos halo]
globals [dist dist-flown prev_timer temp-dif]

to setup
  clear-all
  reset-ticks
  reset-timer 
  set prev_timer timer     ;  use timer intervals rather than ticks so aircraft movement not a function of cpu speed
  set-default-shape halos "circle" ;  "circle 2"
  
    grow-background
  ; draw a fix
  crt 1 [
    set color red
    set pen-size 3
    setxy 8 12
    pendown
    set heading 90
    fd 1
    left 120
    fd 1
    left 120
    fd 1
  ;;  die    ;  keeps default triangle in place when compiled with tortoise
  ]
  
  create-airplanes population
  [
    set shape "airplane"             ; shape size relative to patch size  shapes: airplane, circle 2, target
    set size 2
    make-halo
    ;;  set color who + 2   changed for compilation with tortoise
    set color who * 10 + 45
    set label who
    set label-color black
    set heading 20
       ; set dest to be x= 8, y= 12,   all turtles initially equidistant and heading to fix
    setxy (8 - 27 * sin (70 - who * 10 )) (12 - 27 * cos (70 - who * 10 ))
    set heading (70 - who * 10 )
   ; set heading atan (sin (70 - who * 10 )) (cos (70 - who * 10 ))
   set Heading_1  60
   set Heading_2  50   
   if population > 2 [ set Heading_3  40 ]       
   if population > 3 [ set Heading_4  30 ]
   if population > 4 [ set Heading_5  20 ]           
  ]
  
  ; create crossing traffic
  
    if Crossing_Traffic   [ create-airplanes 1
   [  set shape "airplane"             ; shape size relative to patch size  shapes: airplane, circle 2, target
    set size 2
    make-halo
    set color brown
    set label who
    set heading 270
    setxy 18 6
    
  ]]
    
  ;;  grow-background
  reset-timer
end

to go
  ;;   move-with-mouse    ;;  used for testing
  set dist max-step-size / 50
  tick 
  if (timer - prev_timer) > .1  
   [ask airplanes 
    [
      ; if (( [heading] of airplane 1 ) = Heading_1 ) [ask airplane 1 [set heading Heading_1]]  ;; errors
      ; if not Instant_Turn [ask airplane 1 [set heading heading + ((Heading_1 - heading) / 100 )]]   ;  needs work
      
      ifelse Instant_Turn 
        [
          ask airplane 1 [set heading Heading_1]
          ask airplane 2 [set heading Heading_2]       
          if population > 2 [ask airplane 3 [set heading Heading_3]]
          if population > 3 [ask airplane 4 [set heading Heading_4]]
          if population > 4 [ask airplane 5 [set heading Heading_5]]
        ]
       
        [ set temp-dif (subtract-headings Heading_1  [heading] of airplane 1 )   ;  simplify in future with procedure
           if ( abs temp-dif > 1 )
              [ask airplane 1 [set heading  (heading + (0.1 * max-step-size) * (temp-dif / (abs (temp-dif))))]]   
              
           set temp-dif (subtract-headings Heading_2  [heading] of airplane 2 )
           if ( abs temp-dif > 1 )
              [ask airplane 2 [set heading  (heading + (0.1 * max-step-size) * (temp-dif / (abs (temp-dif))))]] 
                
           if population > 2 [set temp-dif (subtract-headings Heading_3  [heading] of airplane 3 )
           if ( abs temp-dif > 1 )
              [ask airplane 3 [set heading  (heading + (0.1 * max-step-size) * (temp-dif / (abs (temp-dif))))]]]
              
           if population > 3 [set temp-dif (subtract-headings Heading_4  [heading] of airplane 4 )
           if ( abs temp-dif > 1 )
              [ask airplane 4 [set heading  (heading + (0.1 * max-step-size) * (temp-dif / (abs (temp-dif))))]]]
              
           if population > 4 [set temp-dif (subtract-headings Heading_5  [heading] of airplane 5 )
           if ( abs temp-dif > 1 )
              [ask airplane 5 [set heading  (heading + (0.1 * max-step-size) * (temp-dif / (abs (temp-dif))))]]]   
        ]
      pen-down
      forward  dist
      set dist-flown  dist-flown + dist
           ask other airplanes in-radius 3  [ set color black ] 
  ]
  set prev_timer timer
  ]
 

end

to-report coin-flip?     ; returns true or false at random   --- not used presently
  report random 2 = 0
end

to grow-background
  ask patches [set pcolor 59]
end



to make-halo  ;; turtle procedure
  ;; when you use HATCH, the new turtle inherits the
  ;; characteristics of the parent.  so the halo will
  ;; be the same color as the turtle it encircles (unless
  ;; you add code to change it
  hatch-halos 1
  [ set size 3
    ;; Use an RGB color to make halo three fourths transparent
    ;; set color lput 90 extract-rgb color    removed for compilation with tortoise
       set color lput 50 [100 0 0]
    ;; set thickness of halo to half a patch
   ; __set-line-thickness 0.1
    ;; We create an invisible directed link from the runner
    ;; to the halo.  Using tie means that whenever the
    ;; runner moves, the halo moves with it.
    create-link-from myself
    [ tie
      hide-link ] ]
end


  ;;to move-with-mouse      ;  used for testing
  ;;   if mouse-down? [
  ;;    let candidate min-one-of turtles [distancexy mouse-xcor mouse-ycor]
  ;;   if [distancexy mouse-xcor mouse-ycor] of candidate < 1 [
      ;; The WATCH primitive puts a "halo" around the watched turtle.
  ;;      watch candidate
  ;;      while [mouse-down?] [
        ;; If we don't force the view to update, the user won't
        ;; be able to see the turtle moving around.
  ;;        display
  ;;        ;; The SUBJECT primitive reports the turtle being watched.
  ;;        ask subject [ setxy mouse-xcor mouse-ycor ]
  ;;     ]
  ;;     ;; Undoes the effects of WATCH.  Can be abbreviated RP.
   ;;     reset-perspective
  ;;    ]
  ;;  ]
  ;;end
@#$#@#$#@
GRAPHICS-WINDOW
348
10
943
548
22
19
13.0
1
10
1
1
1
0
1
1
1
-22
22
-19
19
0
0
0
ticks
30.0

BUTTON
101
87
178
122
Initialize
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
219
87
296
122
Go/Stop
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
96
20
313
75
Mr. Jim's Air Traffic Controller Game
18
0.0
1

SLIDER
75
448
195
481
population
population
2
5
3
1
1
NIL
HORIZONTAL

SLIDER
208
448
326
481
max-step-size
max-step-size
1
10
2
1
1
NIL
HORIZONTAL

SLIDER
97
135
301
168
Heading_1
Heading_1
-180
180
60
2
1
deg
HORIZONTAL

SLIDER
96
180
302
213
Heading_2
Heading_2
-180
180
50
2
1
degrees
HORIZONTAL

SLIDER
95
223
302
256
Heading_3
Heading_3
-180
180
40
1
1
degrees
HORIZONTAL

SLIDER
93
269
302
302
Heading_4
Heading_4
-180
180
30
1
1
degrees
HORIZONTAL

SLIDER
90
314
301
347
Heading_5
Heading_5
-180
180
20
1
1
degrees
HORIZONTAL

MONITOR
84
368
211
413
Total Distance Flown
sum [dist-flown] of turtles
2
1
11

SWITCH
68
495
184
528
Instant_Turn
Instant_Turn
0
1
-1000

MONITOR
230
368
305
413
Time (secs)
timer
1
1
11

TEXTBOX
180
423
330
441
Options
14
0.0
1

SWITCH
190
496
328
529
Crossing_Traffic
Crossing_Traffic
1
1
-1000

@#$#@#$#@
## Jim's Air Traffic Control Game

Test your skill as an Air Traffic Controller.  
Adjust aircraft headings so they cross the fix (the triangle symbol) in an orderly line and then head for the upper right corner of the screen.
If halos touch, the aircraft are too close to each other and turn black -- try to avoid that. 
Maneuver the aicraft so that they cross the fix closely spaced, but with no black aircraft.

## HOW TO USE IT
1.  Press Initialize (if you don't see a halo around each aircraft, press initialize  again).
2.  Press Go/Stop to start the simulation.
3.  Turn an aircraft by moving its heading slider.
4.  Press Go/Stop to pause the simulation.

## CHALLENGES
 
If you want to keep score, try to get all aircraft across the fix with minimum distance flown or minimum time, as shown in the two status boxes.

Cross the fix in order -- 1,2,3,..  
Change things up by specifying a different order, for example, 2,1,3  


## OPTIONS

Select the aircraft population ( 2 - 5 ).
Speed up aircraft with the max-step-size slider.
Setting Instant_Turn OFF makes aircraft execute more realistic smooth turns.
Setting Crossing_Traffic ON adds a crossing aircraft to be avoided 

## EXTENDING THE MODEL

This is a very simple simulation.  Real air traffic controllers also issue instructions to change aircraft speed and altitude for spacing and traffic avoidance.  

If you want to suggest things to add or change email me at jim3311@gmail.com


## CREDITS AND REFERENCES

Jim Reierson  1/30/2014  and 11/26/2014
copyright 2014 James Reierson

This version includes 11/26/2014 mods to allow compilation with Tortoise  to produce a JavaScript-based HTML5 file that runs in a browser.
https://github.com/NetLogo/NetLogo/wiki/Tortoise and http://li425-91.members.linode.com:9000/create-standalone

I took the online course "Introduction to Complexity"
http://www.santafe.edu/education/schools/sfi-mooc/

The course uses NetLogo for examples and problems.  
NetLogo can be downloaded from http://ccl.northwestern.edu/netlogo/download.shtml
The download contains documation and a library of models and code examples, all very well done and easy to use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
