breed [fishers fisher]
breed [herrings herring]

globals [
    starvations
    kills 
    boat-deaths
    drag-factor
    safe
    mean-energy
    ]
    
patches-own [
    plankton
    zone
    ]
    
turtles-own [
    energy 
    cruise-speed
    wiggle-angle
    turn-angle 
    metabolism
    birth-energy
    age
   ]
    
fishers-own [
    fisher-field-of-view 
    fisher-sight-range 
    ]



to setup
    ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks
  set safe 1
    create-herrings herring-population [
        setxy random-xcor random-ycor
        set color grey
        set cruise-speed 1
        set shape "fish"
        set wiggle-angle 5
        set turn-angle 10 ;herring-turn-angle 
        set birth-energy 25 ;herring-birth-energy
        set energy random-float 100 
        set age random 200
        grow
    ]
    repeat fisher-population [make-fishers random-xcor random-ycor]
    ask patches [ set plankton random 3 ]
;; smooth out the plankton so the distribution is more homeogenous 
    repeat 5 [diffuse plankton 1 ]
    ask n-of zone_no patches [ set zone safe
                                      let targets patches in-radius zone_size
                                      ask targets [set zone safe]
                                      ]
    
;; scale the color of the patches to reflect the quantity of plankton on each patch
    ask patches [ set pcolor scale-color turquoise plankton 0 5 ]
    ;set fisher-deaths 0
    ;set starvations 0
    set drag-factor 0.5
    set kills 0
    set mean-energy 0
    
end
        
to go ;; main procedure
;;  plankton growth. If there is less than the threshold amount of plankton on a patch regrow it with a particular probability determined 
;; by the growth rate. We also diffuse the plankton to allow for the fact that plankton drift.
   ask patches [
       if (plankton < 5) [
           ;if ((random-float 100) < plankton-growth-rate) [ 
           ;   set plankton plankton  + 1  ] 
           set plankton plankton  + 1 ;plankton-growth-rate   ;growth rate on slider between 0 and 2 maybe
           ]  
       ]
   diffuse plankton 1        
;; scale the color of the patches to reflect the quantity of plankton on each patch
   ask patches [ ifelse (zone = safe) [
       set pcolor green
   ]
   [
     set pcolor scale-color turquoise plankton 6 0
   ]
     ] 

;; main minnow procedures   
    ask herrings [
        swim
        feed   ]
    ;if (herring-dynamics?) [
      ask herrings [ birth ] ;death ]
    ;]
    
 ;; main boat procedures
    ask fishers [ hunt ]
    ;if fisher-dynamics? [ ask fishers [ birth death ]]
    do-plots
    if kills > 2000 [stop]
    tick
end


;; create boats with the following paramter values. These values could be set with sliders
;; but it would make for crowded interface
to make-fishers [x y]
        create-fishers 1 [
            set heading random 360
            setxy x y
            set size 4
            set shape "boat"
            set wiggle-angle 5
            set turn-angle 10
            set fisher-sight-range 10
            set fisher-field-of-view 120
            set cruise-speed 1.5
            set energy 100
            set metabolism 0.3
            set birth-energy 25 ;fisher-birth-energy
            set color red
       ] 
end

;; main minnow procedure governing movement and loss of energy
to swim 
        set energy energy - metabolism
        let danger fishers in-cone sight-range field-of-view 
        ifelse ((any? danger) and escaping?)
          [set turn-angle herring-turn-angle * 3  ;; the turn angle for escaping is larger than normal by a factor of 3
           avoid min-one-of danger [distance myself ]
            fd escape-speed 
            set energy energy - escape-speed * drag-factor ]
          [ifelse schooling? [school][cruise]
      ]
end 


;; minnow or boat procedure which determines random motion when no predators or prey are near.
to cruise
   rt random wiggle-angle 
   lt random wiggle-angle
   fd cruise-speed
   set energy energy - cruise-speed * drag-factor
end


to hunt 
    set energy energy - metabolism
    let prey herrings in-cone fisher-sight-range fisher-field-of-view
    
    ifelse (([zone] of patch-here) = safe) 
    [
      
      
     
      cruise ]
    [
    ifelse ( any? prey )
        [ let targets prey in-radius 2 ;; minnows are eaten if they are with a radius of 2
          ifelse any? targets
          
              [ let totcatch sum [energy] of targets
                
                set kills kills + count targets 
                ask n-of (count targets) targets [die]
                set energy energy + totcatch  * 0.5 
                set mean-energy mean-energy + sum [energy] of fishers]
              [ ifelse hunting?  ;; if minnows are not close enough head towards them
                  [ approach min-one-of prey [distance myself] 
                    fd hunt-speed
                    set energy energy - hunt-speed * 4 ]
                  [ cruise ]  ;; if you are not hunting cruise around
               ] 
        ]  
        [ cruise ] ;; if you can't see any minnows just cruise around
    ]
end


;; minnow procedure governing schooling behaviour
to school
    let schoolmates herrings in-cone sight-range field-of-view with [distance myself > 0.1 ]
    ifelse any? schoolmates                                   ;; minnows you can see
        [let buddy min-one-of schoolmates [distance myself]   ;; closest minnow you can see
         ifelse distance buddy  < safety-range 
             [ set turn-angle herring-turn-angle           ;; avoid minnow if it is too slose
               avoid buddy  
             ]
 ;; if nobody is too close then turn towards each of the schoolmates in turn, by an angle that exponentially
 ;; decrease with distance. This ensures that the minnow is more influenced by closer minnows. After making these turns 
 ;; then try to align to the headings of each of the schoolmates in turn by an angle that exponentially 
 ;; decreases with distance.

             [ foreach sort schoolmates [  
                  set turn-angle herring-turn-angle * exp( ((distance buddy) - (distance ?) ) )
                  approach ?
                  align ? 
                  ]
             ]
          fd cruise-speed
          set energy energy - cruise-speed * drag-factor ] ;; after making adjustements in heading move
        [cruise]   ;; if you can't see any other minnows just cruise around
end

;; boat or minnow procedure to turn in the direction of a target turtle by at most the specified turn angle
to approach [target]
   let angle subtract-headings towards target heading
              ifelse (abs (angle) > turn-angle)
                  [ ifelse angle > 0 [right turn-angle ][left turn-angle] ]
                  [ right angle ] 
end

;; minnow procedure to turn in the direction of the heading of a target turtle by at most the specified turn angle
to align [target]
   let angle subtract-headings [heading] of target heading
              ifelse (abs (angle) > turn-angle)
                  [ ifelse (angle > 0) [right turn-angle ][left turn-angle] ]
                  [ right angle ] 
end

;; minnow procedure to turn in the direction away from a target turtle by at most the specified turn angle
to avoid [target]
   let angle subtract-headings ((towards target) + 180) heading
              ifelse (abs(angle) > turn-angle)
                  [ ifelse (angle > 0) [right turn-angle ][left turn-angle] ]
                  [ right angle ] 
end


;; minnow procedure. If there is plankton on the patch eat it to gain energy and reduce the plankton count on the patch.
to feed
    if (plankton > 1) [
        set energy energy + 1 ; herring-food-energy
        set plankton plankton - 3 ]
end

;; minnow and boat procedure if your enery exceeds a threshold hatch an offspring with energy = birth energy and
;; reduce your energy accordingly
to birth
    if (energy > 2 * birth-energy) [
        set energy energy - birth-energy
        hatch 1 [ 
           set energy birth-energy 
           set heading random 360
           fd cruise-speed ] ]
end


;; minnow and boat procedure for removing turtles with energy below zero
to death
    ;; first check for random deaths
    let mort_rate 0.0
    let mort_check random-float 1
        ifelse (breed = herrings)
            [set mort_rate herrings_mort_rate]
            [set mort_rate herrings_mort_rate]
        if (mort_rate > mort_check) [ die ]
    
    ;; now check for metabolic death
    if energy < 0 [ 
        if (breed = herrings)
            [set starvations starvations + 1]
        ;    [set fisher-deaths boat-deaths + 1]
        die ]
end

;; minnow procedure to color and size the minnows so that their age and energy are visually apparant
to grow
        ifelse (age > 300 )
           [set size 2 ]
           [set size 1 + age * 0.003 ]
       set color scale-color color (energy ) 0  (200 + birth-energy)
end

to do-plots
  set-current-plot "Population"
    set-current-plot-pen "herrings"
    plot count herrings
    set-current-plot-pen "fishers"
    plot count fishers
    ;set-current-plot-pen "plankton"
    ;plot sum [plankton] of patches
    
    set-current-plot "energy"
    set-current-plot-pen "energy"
    plot sum [energy] of fishers
    set-current-plot-pen "kill"
    plot sum [energy] of herrings
    set-current-plot-pen "pen-1"
    plot 0
end
@#$#@#$#@
GRAPHICS-WINDOW
309
10
729
451
20
20
10.0
1
10
1
1
1
0
1
1
1
-20
20
-20
20
0
0
1
ticks
30.0

BUTTON
737
10
817
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
5
33
146
66
herring-population
herring-population
0
100
84
1
1
NIL
HORIZONTAL

BUTTON
824
10
880
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
883
10
950
55
Herrings
count herrings
3
1
11

SLIDER
5
68
146
101
herring-food-energy
herring-food-energy
0
10
10
1
1
NIL
HORIZONTAL

MONITOR
951
10
1009
55
Fishers
count fishers
3
1
11

SLIDER
171
67
296
100
fisher-food-energy
fisher-food-energy
0
50
8
1
1
NIL
HORIZONTAL

SLIDER
169
256
298
289
field-of-view
field-of-view
0
360
360
1
1
NIL
HORIZONTAL

SWITCH
172
181
296
214
schooling?
schooling?
0
1
-1000

SLIDER
172
32
296
65
fisher-population
fisher-population
0
20
5
1
1
NIL
HORIZONTAL

PLOT
741
56
1008
232
Population
time
population
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"herrings" 1.0 0 -7500403 true "" ""
"fishers" 1.0 0 -2674135 true "" ""

SWITCH
5
178
146
211
hunting?
hunting?
0
1
-1000

SWITCH
6
140
147
173
escaping?
escaping?
0
1
-1000

SLIDER
5
104
146
137
herring-birth-energy
herring-birth-energy
0
50
8
1
1
NIL
HORIZONTAL

SLIDER
170
103
296
136
fisher-birth-energy
fisher-birth-energy
0
50
11
1
1
NIL
HORIZONTAL

SLIDER
172
140
297
173
escape-speed
escape-speed
0
4
0.8
0.1
1
NIL
HORIZONTAL

SLIDER
170
217
297
250
hunt-speed
hunt-speed
0
10
1.8
0.1
1
NIL
HORIZONTAL

SLIDER
168
296
296
329
herring-turn-angle
herring-turn-angle
0
20
14
1
1
NIL
HORIZONTAL

SLIDER
5
217
145
250
sight-range
sight-range
0
20
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 