extensions [ vid ]
Globals [ Normal
         Cardiogenic-Pulmonary-Edema
         ] ;; setting two states of the world - scenarios: (1) for Normal lung physiology and (2) for Pulmonary Edema formation

                               ;; setting agent breeds:
breed [ wmolecules wmolecule ] ;; water molecules, which are the ones who will extravasate and flood ACM and alveoli
breed [ fmolecules fmolecule ] ;; fluid molecules wich are to stay in the capillary
breed [ macromolecules macromolecule ] ;; macromolecules (albumine) which physiological keep wmolecules in the capillary
breed [ erythrocytes erythrocyte ] ;; Red Blood Cells which are to stay in the capillary
breed [ spinners spinner ]

patches-own ;; property of patches to form physiological space zones
[
  capillary
  ACM-alveoli
]

wmolecules-own [extravasated?] ;; property for water molecules to move outside capillary and to flood ACM and alveoli

to setup
  ca
  import-drawing "A11.png"
  create-spinner

  if (scenario = "Normal") ;; setting parameters for "Normal" scenario
  [
    set hydrostatic-pressure 18
    set oncotic-pressure 25
  ]
  if (scenario = "Cardiogenic-Pulmonary-Edema") ;; setting parameters for "Cardiogenic Pulmonary Edema" scenario
  [
    set hydrostatic-pressure 22
    set oncotic-pressure 24
  ]

  create-erythrocytes 5 ;; creating RBC with respective properties
   ask erythrocytes
  [
   set xcor random-xcor
   set color pink
   set size 3
   set shape "erythrocyte"
    set heading 90
  ]

  create-wmolecules 700 ;; creating water molecules with respective properties and which are to extravasate
  ask wmolecules
  [
   set extravasated? false
   set xcor random-xcor
   set color blue
   set shape "circle 2_w"
    set heading 0
  ]

   create-fmolecules 300 ;; creating fluid molecules with respective properties wich are to move along capillary
   ask fmolecules
  [
   set xcor random-xcor
   set color blue
    set size 1.1
   set shape "circle 2_w"
    set heading 90
  ]

   create-macromolecules 10 ;; creating macromolecules with respective properties wich are to move along capillary
   ask macromolecules
  [
   set xcor random-xcor
   set color yellow
   set size 1.5
   set shape "circle"
    set heading 90
  ]

  ask patches [ set pcolor white ] ;; setting preliminary conditions for the setup of 'extravascular space'
  ask patches [ setup-capillary ]
  ask patches [ setup-ACM-alveoli ]

   ask turtles [move-to one-of patches with [pycor < 5 and pycor > 1]] ;; moving created agents to their orginal
                                                                       ;; position (i.e. in the capillary)
  ask spinners [setxy 13 29]
  reset-ticks
  if vid:recorder-status = "recording" [ vid:record-interface ]
end

to setup-capillary ;; setting the capillary zone of pink color anf its walls of red color
  if (pycor < 6) and (pycor > 0) [set pcolor pink]
   ask patches with [ pycor = min-pycor]
    [ set pcolor red ]
   ask patches with [ pycor = 6 ]
    [ set pcolor red ]
end

to setup-ACM-alveoli ;; setting the extravascular space with ACM of grey color and alveola of white color
  if (pycor < 10) and (pycor > 6) [ set pcolor grey ]
  if (pycor < 22) and (pycor > 10) [ set pcolor white ]

end

to go

  let acm-patches patches with [pycor < 10 and pycor > 6] ;; procedure simulating water extravasation under
  ask one-of acm-patches                                  ;; physiological condition. This water is then removed
  [                                                       ;; by lymph drainage mechanism
    sprout 7
  ask turtles-here
    [
    set shape "circle 2_w"
    set color blue
    ]
  ]
  ask turtles-on patches with [pycor < 10 and pycor > 6] ;; initiation of the lymph drainage machanism
  [drain-acm]

  ask wmolecules [  ;; procedure for water molecules extravasation
  extravasate
  ]
  ask macromolecules ;; procedures that simulate blood movement along the capillary
   [ fd 3]
  ask fmolecules
   [ fd 10 ]
  ask erythrocytes
   [ fd 1 ]

  if count wmolecules with [ not extravasated?] < 50   ;; procedure for stopping the model when a certain number of
   [                                                   ;; water molecules extravasated
    stop ]

  if  (scenario = "Cardiogenic-Pulmonary-Edema") and oncotic-pressure >= 25 ;; procedure for stopping the model when
  [                                                                         ;; OP value is above normal range
    stop ]

   tick
  update-spinner
  if vid:recorder-status = "recording" [ vid:record-interface ]
end

to extravasate   ;; extravasation based on HP and OP values
  if ( random-float 25 > oncotic-pressure and random-float -6 < ( hydrostatic-pressure - oncotic-pressure))
  [
    set extravasated? true
    ask wmolecules [                                          ;; procedure simulating extravasation consis                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               