globals[
  hive-x hive-y
  flower-color-male flower-color-male-nectar
  flower-color-female flower-color-female-nectar
  ground-color
  energy-reduction-factor
  nectar-regeneration-freq
  bloom-factor
  spawn-factor
  hive-nectar
  bee-max-nectar
]
turtles-own[
  energy pollen-carried?
  nectar-carried
  curr-step curr-heading
  is-active?
]
patches-own[
  nectar flower-health
  is-flower? time-to-nectar-regeneration
  is-female? is-pollinated?
  time-to-bloom
]

to setup
  clear-all
  setup-flower-patches
  setup-bees
  reset-ticks
end

to setup-flower-patches
  ;;; Setup soil and flower patches
  init-globals
  setup-hive
  ask patches [
    set is-flower? false
    set is-female? false
    set is-pollinated? false
    if pxcor != hive-x or pycor != hive-y[
      set pcolor ground-color
      if random 100 < flower-spread [
        set flower-health random 100
        setup-flower-attr
      ]
    ]
  ]
end

to init-globals
  set flower-color-male 116
  set flower-color-male-nectar 114
  set flower-color-female 138
  set flower-color-female-nectar 135
  set energy-reduction-factor (no-of-ticks-per-day * 30) / 100
  set nectar-regeneration-freq (no-of-ticks-per-day / daily-nectar-generation)
  set bloom-factor (no-of-ticks-per-day * bloom-days)

  set-spawn-factor

  (
    ifelse ambient-temprature >= 18 [set ground-color 63]
    ambient-temprature > 10 [set ground-color 33]
    [set ground-color white]
  )

end

to set-spawn-factor
  ;;; Bee Spawnning changes according to the ambient temprature
  (
    ifelse ambient-temprature >= 18 [set spawn-factor no-of-ticks-per-day]
    [set spawn-factor (no-of-ticks-per-day * 5)]
  )

end

to setup-hive
  ;;; Setup a hive at a random location in the field
  set hive-x random max-pxcor
  set hive-y random max-pycor
  ask patch hive-x hive-y[
    set plabel "HV"
    set pcolor 15
    set plabel-color white
  ]
end

to setup-flower-attr
  ;;; Setup for flower attributes
  ifelse random flower-spread < (min (list nectar-ratio flower-spread)) [
     set nectar per-flower-nectar
  ][
    set time-to-nectar-regeneration random nectar-regeneration-freq
  ]
  set is-flower? true
  flower-to-female
  change-flower-color
end

to flower-to-female
  ;;; Randomizing the gender for a flower
  if random 2 > 0 [set is-female? true]
end

to change-flower-color
  ;;; Setting up the color of the flower according to the presence of nectar and gender
  ifelse is-female? = true [set pcolor flower-color-female]
      [set pcolor flower-color-male]

  if nectar > 0 [
    ifelse is-female? = true [set pcolor flower-color-female-nectar]
      [set pcolor flower-color-male-nectar]
  ]
end

to setup-bees
  ;;; Setup for bees
  create-turtles number-of-bees [
    set energy random 100
    create-bee
    set is-active? false
    (
      ifelse ambient-temprature >= 18 [
        set bee-max-nectar 100
      ]
      ambient-temprature > 10 [
        set bee-max-nectar 35
        set xcor hive-x
        set ycor hive-y
      ][
        set xcor hive-x
        set ycor hive-y
      ]
    )
  ]
end

to create-bee
  ;;; Setup for bee attributes like shape, color
  setxy random-xcor random-ycor
  set shape "bee"
  set curr-heading heading
  change-bee-color
end

to change-bee-color
  ;;; Change bee color according to energy
  ifelse  energy >= 20 [set color yellow]
    [set color red]
end

;;; Go Procedure starts here

to go
  activate-bees
  work-bees
  reduce-bee-energy
  reduce-flower-health
  regenerate-nectar
  regrow-flower
  spawn-bee

  tick
end

to activate-bees
  ;;; Bees movement from hive changes according to the ambient temprature
  ;;; They tend to be active during summer when tempratrue is around 18 to 30
  ;;; Moderately active durin spring or autumn when temprature is aorund 10 to 18
  ;;; Inactive during winter when temprature is leesere than 10
  (
    ifelse ambient-temprature >= 18 [
      ask turtles [
        set is-active? true
      ]
    ]
    ambient-temprature > 10 [
      if (ticks mod energy-reduction-factor) = 0 [
        let active-turtles n-of (floor (number-of-bees * .15)) turtles
        ask active-turtles [
          set is-active? true
        ]
      ]
    ]

  )
end

to work-bees
  ;;; Wroker bees go procedure, bees collect nectar only under 3 conditions
  ;;; 1. If it is a flower
  ;;; 2. If the flower has enough nectar [nectar]
  ;;; 3. If the bee has the carry capacity [nectar-carried]
  ;;; After the bees are full it goes straight the hive and drop them
  ;;; Bees also carry pollen from male flowers while picking nectar from male flower [pick-pollen] and
  ;;; while carrying nectar from female flowers they drop them, this causes fertilization [pollinate-flower]
  ask turtles with [is-active?][
    if [is-flower?] of patch-here[
      if nectar-carried < bee-max-nectar and [nectar] of patch-here > 0 [
        set nectar-carried nectar-carried + [nectar] of patch-here
        change-search-heading
        deplete-flower-nectar
      ]

      pick-pollen
      pollinate-flower
    ]

   (
      ifelse nectar-carried >= bee-max-nectar and patch-here = patch hive-x hive-y[
        set hive-nectar hive-nectar + nectar-carried
        set nectar-carried 0
        set pollen-carried? false
        if ambient-temprature < 18 [set is-active? false]
      ]
      nectar-carried >= bee-max-nectar [
        facexy hive-x hive-y
        fd 1
      ]
      [
        search-for-nectar
      ]
   )
  ]
end

to search-for-nectar
  ;;; Bees search for the flowers to pick nectar.
  ;;; Bees follow a short distance in same direction before changing its direction.
  ;;; Controlled using [search-steps]
  ifelse curr-heading = heading and curr-step <= search-steps [
    set curr-step curr-step + 1
    fd 1

  ][
    change-search-heading
    set curr-step 1
    fd 1
  ]
end

to change-search-heading
  ;;; Bees change the direction of search after few steps
  ;;; as explained in [search-for-nectar] go procedure.
  rt random 90
  set curr-heading heading
end


to deplete-flower-nectar
  ;;; Each time the bee picks nectar it is depleated and is set for regenration in future
  ask patch-here [
    set nectar 0
    change-flower-color
    set time-to-nectar-regeneration nectar-regeneration-freq
  ]
end

to pollinate-flower
  ;;; If Bee goes to a female flower and
  ;;; bee has pollen, it drops the pollen to polinate the female flower
  ;;; The no of seeds to drop by the female flower is controlled by [no-of-seeds-to-drop]
  ;;; seeds are dropped areound the female flower.
  if [is-female?] of patch-here and pollen-carried? = true [
    ask patch-here[
      let target-neigbhor n-of min(list no-of-seeds-to-drop (count neighbors)) neighbors
      ask target-neigbhor [
        if not (pxcor = hive-x and pycor = hive-y)[
          set is-pollinated? true
          set time-to-bloom bloom-factor
        ]
      ]
    ]
    set pollen-carried? false
  ]
end

to pick-pollen
  ;;; If the bee reaches a male flower it picks pollen
  if [not is-female?] of patch-here [
    set pollen-carried? true
  ]
end

to reduce-bee-energy
  ;;; Bees lose energy. The lifespan of bees are 30 days.
  ;;; [energ-reduction-factor] are calculated according to the ticks
  ;;; using [no-of-ticks-per-day].
  ask turtles [
    if (ticks mod energy-reduction-factor) = 0 [
    set energy energy - 1
    ]
    change-bee-color
    if energy <= 0 [
      die
    ]
  ]
end

to reduce-flower-health
  ;;; Flowers lose health. The lifespan of flowers are 30 days.
  ;;; [energ-reduction-factor] are calculated according to the ticks
  ;;; using [no-of-ticks-per-day].
  ask patches with [is-flower?][
    if (ticks mod energy-reduction-factor) = 0 [
      set flower-health flower-health - 1
    ]
    if flower-health <= 0 [
      flower-death
    ]
  ]
end

to flower-death
  ;;; Flowers are reset when they die, If the seeds are dropped in the place
  ;;; they are preserved and they are regrown.
  set pcolor ground-color
  set nectar 0
  set is-flower? false
  set is-female? false
end

to regenerate-nectar
  ;;; Nectar regeneration happens after the nectar is depleated
  ;;; Controlled using [daily-nectar-regeneration] slider.
  ask patches with[is-flower?][
    set time-to-nectar-regeneration time-to-nectar-regeneration - 1
    if time-to-nectar-regeneration <= 0 [
      set nectar per-flower-nectar
      change-flower-color
    ]
  ]
end

to regrow-flower
  ;;; FLowers are regrown from seeds. Flowers have bloom period.
  ;;; They are controlled by [bloom-days] slider.
  ask patches with [not is-flower? and is-pollinated?] [
    set time-to-bloom time-to-bloom - 1
    if time-to-bloom <= 0 [
      set is-pollinated? false
      set is-flower? true
      set flower-health 100
      set nectar per-flower-nectar
      flower-to-female
      change-flower-color
    ]
  ]
end

to spawn-bee
  ;;; Bees are spawned from the hive everyday.
  ;;; Spawning count is controlled by [bees-to-spawn] slider.

  if (ticks mod spawn-factor) = 0 [
    create-turtles bees-to-spawn [
      setxy hive-x hive-y
      facexy random-xcor random-ycor
      set shape "bee"
      set curr-heading heading
      set energy 100
      set is-active? false
    ]
  ]
end









@#$#@#$#@
GRAPHICS-WINDOW
210
10
647
448
-1
-1
13.0
1
10
1
1
1
0
0
0
1
-16
16
-16
16
1
1
1
ticks
30.0

SLIDER
8
86
180
119
flower-spread
flower-spread
0
100
19.0
1
1
NIL
HORIZONTAL

BUTTON
13
32
76
65
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
9
131
181
164
number-of-bees
number-of-bees
0
100
19.0
1
1
NIL
HORIZONTAL

SLIDER
9
186
181
219
nectar-ratio
nectar-ratio
0
100
8.0
1
1
NIL
HORIZONTAL

SLIDER
8
243
200
276
daily-nectar-generation
daily-nectar-generation
1
3
1.0
1
1
time
HORIZONTAL

BUTTON
92
32
155
65
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
8
294
180
327
search-steps
search-steps
0
10
3.0
1
1
NIL
HORIZONTAL

SLIDER
9
339
184
372
no-of-ticks-per-day
no-of-ticks-per-day
1
50
10.0
1
1
ticks
HORIZONTAL

SLIDER
664
16
836
49
per-flower-nectar
per-flower-nectar
0
30
30.0
1
1
NIL
HORIZONTAL

SLIDER
664
66
836
99
bloom-days
bloom-days
5
10
7.0
1
1
days
HORIZONTAL

SLIDER
668
125
840
158
bees-to-spawn
bees-to-spawn
1
10
2.0
1
1
NIL
HORIZONTAL

SLIDER
668
181
840
214
no-of-seeds-to-drop
no-of-seeds-to-drop
1
8
2.0
1
1
NIL
HORIZONTAL

SLIDER
668
233
840
266
ambient-temprature
ambient-temprature
0
30
21.0
1
1
C
HORIZONTAL

PLOT
674
292
1070
442
Bee - Flower Count
Bees
Lavendar Flowers
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Bees" 1.0 0 -4079321 true "" "plot count turtles"
"Lavender Flowers" 1.0 0 -10141563 true "" "plot count patches with [is-flower?]"

@#$#@#$#@
## WHAT IS IT?

This model simulates the dynamic interactions between a colony of honeybees and a field of lavender flowering plants, focusing on the process of pollination. It aims to demonstrate how bee foraging behaviour influences the reproductive success and population of lavender plants, and conversely how flower availability and characteristics (like nectar presence and gender) affect bee activity and survival.  The model also incorporates the influence of ambient temperature, on bee foraging efficiency and population growth, providing insights into the delicate balance required for a healthy bee-flower ecosystem.

## HOW IT WORKS

This model shows how bees (called agents) and lavender flowers (random spots on the ground) interact. A day in the model is set by the no-of-ticks-per-day slider. The default is 10 ticks to contribute for 1 day.

Agents move randomly in space. Bees collect nectar multiple times a day.  The default ticks give enough time for nectar and pollen collection, multiple times a day. 
Patches are lavender flowers, which are gendered as female and male. Flowers regenerate new nectar a few times a day after bees collect it.

Bees collect nectar from flowers. They also pick pollen from male flowers. When bees collect nectar from female flowers, they drop the pollen everytime, fertilizing the female flowers. Fertilized female flowers drop seeds around them randomly. Once the bee has collected enough nectar, it moves to the hive to drop them.

The average lifespan of a bee and a lavender flower is 30 days. Both bees and flowers have a maximum of 100 energy in them. They lose energy by 1 per day. Once their energy reaches 0, they die. Every day, new bees hatch from the hive. The spawning ratio is 15% of the bee population, matching the real world scenario.

After a flower dies, if there is a seed dropped in its place a flower bloom from there. The blooming period is 7 days, simulating the real world timeline.

The ambient temperature also affects the ecosystem. When the temperature increases (above 18), bees are very active, and the hive produces new bees every day. When its moderate (more than 10) bee movements reduce and new bees take more days to leave the hive. As the temperature becomes lesser (<10) there is not bee activity and the hive is dormant.


## HOW TO USE IT

### Interface Controls:

Here's a description of the purpose of each slider you can find in the Interface tab 

### Sliders:

-	**`no-of-ticks-per-day`**: Controls how many simulation steps (ticks) represent one conceptual "day" in the model. A higher number means more detailed daily actions. 

-	**`flower-spread`**: Determines the initial density of lavender flowers when the model starts. A higher value means more flowers will initially appear across the landscape. 

-	**`nectar-ratio`**: Influences the likelihood that an initially spawned flower will begin with nectar. Higher values mean more flowers start with nectar. Nectar ratio and flower-spread are used to create ratio of flowers with nectar during initial setup.

-	**`per-flower-nectar`**: Sets the maximum amount of nectar a single flower can hold when its nectar is fully regenerated. 

-	**`number-of-bees`**: Sets the total number of bees created at the very start of the simulation. 

-	**`search-steps`**: Defines how many steps a bee will move in a straight line before randomly changing its direction while searching for flowers. 

-	**`no-of-seeds-to-drop`**: Specifies how many nearby patches a fertilized female flower drop seeds onto for potential new flower growth. 

-	**`daily-nectar-generation`**: Controls how frequently (per conceptual day) depleted flowers will regenerate their nectar supply. 

-	**`bloom-days`**: The number of conceptual "days" it takes for a (seed-dropped) patch to fully develop and bloom into a new flower. 

-	**`bees-to-spawn`**: Sets the number of new bees that are added to the hive at the start of each new day. 

-	**`ambient-temprature`**: Simulates the overall environmental temperature. Temperature in degree celsius.

### Setting up the Model:

Adjust the sliders to set your initial conditions and environmental parameters.
Press the setup button. This will clear the world, create the initial landscape of flowers, set up the hive, and populate it with the starting number of bees.

    	
### Running the Simulation:

Press the go button. This will start the simulation, allowing bees to search and collect nectar, flowers to grow and die, and the ecosystem to evolve over time. You can press go again to pause the simulation and then again to resume.



## THINGS TO NOTICE

This section suggests what to observe while running the model to gain insights into bee-flower ecosystem.

* **Bee Behaviour and Paths:** Notice how bees move across the landscape. Bees move in a straight line to search for nectar. If they don't find a flower with nectar in their path, they switch direction randomly and move in a straight path. Once they've collected enough nectar, they follow a straight path to the hive.

 * **Flower Nectar Depletion and Regeneration:** Male flowers are dark purple and female flowers are light purple, to show the distinction. Observe the flowers changing color. When a bee collects nectar, the flower's color will likely change (e.g., from a nectar-rich color to a depleted color). Watch how long it takes for the flowers to regenerate their nectar and change back to their nectar-rich color.

 * **Pollination and Flower Growth:** Focus on the female flowers. When a bee carrying pollen lands on a female flower, notice how surrounding patches might be pollinated (meaning dropping seeds). Then, observe how these "seeded" patches eventually bloom into new flowers, replacing those that have died.

 * **Hive Behaviour:** Notice how new bees leave the hive at each conceptual day and how their behaviour changes with ambient temperature.

 * **Impact of Temperature:** Experiment with changing the `ambient-temperature` slider.
     * **Cold Temperatures:** Notice the background changes. Focus on the hive activity and flower spread.
     * **Moderate Temperatures (Spring/Autumn):** Observe the limited number of active bees and how this affects nectar collection and flower growth.
     * **Warm Temperatures (Summer):** Notice the high amount of bee activity and how quickly nectar is collected and flowers are pollinated, leading to more robust flower populations.

* **Population Dynamics:** Look at the Bee-Flower Count plot and check the total number of bees and flowers. How do their populations fluctuate over time under different temperature conditions (more than 18C, more than 10C, and less than 10C)?


## THINGS TO TRY

Here are some suggested experiments you can perform by adjusting the sliders and running the model:

* **Explore Temperature's Influence:**
    * Set `ambient-temprature` to a cold value (e.g., 5C). 
    * Run the model at a `ambient-temprature` (e.g., 14C) and check how does the limited number of active bees affect nectar accumulation in the hive and the growth of new flowers.
    * Switch to a warm `ambient-temprature` (e.g., 25C). Observe the rapid increase in bee activity and how quickly nectar is collected and flowers are pollinated, leading to more robust flower populations.

* **Impact of Initial Populations:**
    * Start with a very low `number-of-bees` (e.g., 10-20).  Or Start with a very high `number-of-bees` (e.g., 50 to 100). Observe the bee population become too large or small. Check, how does this impact the flower population.

* **Resource Scarcity vs. Abundance:**
    * Reduce `flower-spread` and `per-flower-nectar` to low values. How does this challenge the bee colony's survival and growth?
    * Increase `flower-spread` and `per-flower-nectar` to high values. How quickly does the hive accumulate nectar? Observe, how does the flower population boom indefinitely.

* **Nectar Regeneration Speed:**
    * Adjust `daily-nectar-generation`. Observe how does making nectar regenerate very slowly or very quickly affect the bees' ability to collect enough food, especially in warmer temperatures.

* **Bee Population Growth Rate:**
    * Change `bees-to-spawn`. Check, how does spawning many bees each day compare to very few. 

* **Flower Bloom Time:**
    * Experiment with `bloom-days`. If it takes a very long time for new flowers to bloom, how does this affect the recovery of flower populations.

* **Pollination Efficiency:**
    * Change `no-of-seeds-to-drop`. Observe, If bees drop very few seeds, does the flower population struggle to reproduce or If they drop many, does the flower population expand rapidly.


## EXTENDING THE MODEL

Here are some of the suggestions to improve the model further:

**Implement Bee Communication :**
Improve bee behaviour where they can communicate and share information about nectar and pollen in the surrounding.

**Vary Flower Types and Nectar Quality:**
Introduce different flower types and nectar quality. Make bees to be attracted to some set of flowers over other.

**Dynamic Ambient Temperature and Seasons:**
Instead of fixed temperatures through slider, add features to automate temperature and seasons for a year, impacting bees activity and flower blooms.

**Hive Internal Dynamics:**
Improve hive dynamics like hive swarming, where a new colony is created if the number of bees grows.


## CREDITS AND REFERENCES

This model was conceived and developed by **Raaja Selvanaathan Datchanamourthy** as an end-of-term project for the Agent-Based Modeling course at **DSTI School Of Engineering, Paris, France.**


## Copyright and License Information

This model is licensed under a Creative Commons Attribution-NonCommercial 4.0 International License (CC BY-NC 4.0).

For non-commercial use, you are free to share and adapt this work as long as you provide appropriate attribution.

For commercial use, please contact **Raaja Selvanaathan Datchanamourthy** at **raaja.snd@gmail.com** to discuss a separate commercial license.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bee
true
0
Polygon -1184463 true false 152 149 77 163 67 195 67 211 74 234 85 252 100 264 116 276 134 286 151 300 167 285 182 278 206 260 220 242 226 218 226 195 222 166
Polygon -16777216 true false 150 149 128 151 114 151 98 145 80 122 80 103 81 83 95 67 117 58 141 54 151 53 177 55 195 66 207 82 211 94 211 116 204 139 189 149 171 152
Polygon -7500403 true true 151 54 119 59 96 60 81 50 78 39 87 25 103 18 115 23 121 13 150 1 180 14 189 23 197 17 210 19 222 30 222 44 212 57 192 58
Polygon -16777216 true false 70 185 74 171 223 172 224 186
Polygon -16777216 true false 67 211 71 226 224 226 225 211 67 211
Polygon -16777216 true false 91 257 106 269 195 269 211 255
Line -1 false 144 100 70 87
Line -1 false 70 87 45 87
Line -1 false 45 86 26 97
Line -1 false 26 96 22 115
Line -1 false 22 115 25 130
Line -1 false 26 131 37 141
Line -1 false 37 141 55 144
Line -1 false 55 143 143 101
Line -1 false 141 100 227 138
Line -1 false 227 138 241 137
Line -1 false 241 137 249 129
Line -1 false 249 129 254 110
Line -1 false 253 108 248 97
Line -1 false 249 95 235 82
Line -1 false 235 82 144 100

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

hex
false
0
Polygon -7500403 true true 0 150 75 30 225 30 300 150 225 270 75 270

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.4.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
