extensions [ csv ]

globals [
  grim-multiplier
  fertility-chance
  population
  total-men
  total-women
  hair-red
  hair-black
  hair-brown
  hair-blonde
  red-pct
  black-pct
  brown-pct
  blonde-pct
  eyes-blue
  eyes-brown
  eyes-brown-pct
  eyes-blue-pct
  total-infected
  male-infected
  female-infected
  infected-pct
]

breed [ men man ]
breed [ women woman ]

men-own [
  eyes
  hair
  age
  gender
  coupled?
  partner
  f-hair
  f-eyes
  mother
  infected?
  infectable?
  time-left
]

women-own [
  eyes
  hair
  age
  gender
  coupled?
  partner
  f-hair
  f-eyes
  o-hair
  pregnant?
  mother
  infected?
  infectable?
  time-left
]

to setup
  clear-all
  random-seed model-seed
  setup-men
  setup-women
  assign-shape
  set grim-multiplier [ 0.0004 0.0003 0.0002 0.0002 0.0002 0.0001 0.0001 0.0001 0.0001 0.0001 0.0001 0.0002 0.0002 0.0003 0.0004 0.0006 0.0009 0.0011 0.0013 0.0014 0.0015 0.0016 0.0017 0.0018 0.0020 0.0021 0.0022 0.0023 0.0025 0.0026 0.0027 0.0028 0.0029 0.0030 0.0031 0.0032 0.0033 0.0034 0.0036 0.0038 0.0040 0.0041 0.0043 0.0045 0.0048 0.0051 0.0054 0.0058 0.0062 0.0067 0.0072 0.0077 0.0084 0.0090 0.0098 0.0106 0.0114 0.0123 0.0132 0.0143 0.0154 0.0165 0.0176 0.0188 0.0199 0.0211 0.0224 0.0238 0.0254 0.0271 0.0290 0.0312 0.0338 0.0367 0.0406 0.0443 0.0485 0.0532 0.0588 0.0646 0.0709 0.0778 0.0857 0.0948 0.1051 0.1166 0.1293 0.1427 0.1576 0.1745 0.1930 0.2129 0.2327 0.2518 0.2709 0.2898 0.3080 0.3254 0.3417 0.3587 0.3767 0.3955 0.4153 0.4361 0.4579 0.4808 0.5048 0.5300 0.5565 0.5844 0.6136 0.6443 0.6765 0.7103 0.7458 0.7831 0.8223 0.8634 0.9065 ]
  set fertility-chance [ 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00137 0.00137 0.00137 0.00137 0.00137 0.01555 0.01555 0.00777 0.06219 0.16434 0.20759 0.21624 0.48438 0.21350 0.94770 0.15175 0.37076 0.16861 0.13139 0.18066 0.02464 0.02201 0.02201 0.00734 0.01839 0.00307 0.00307 0.00307 0.00613 0.00613 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 0.00000 ]
  ask patches [ set pcolor white ]
  reset-ticks
  count-globals
  initialize-infection
end

to initialize-infection
  set total-infected 0
  ask turtles [
    set infected? false
    set time-left 100
    set infectable? false
  ]
  infect
end

to count-globals
  set total-men ( count men )
  set total-women ( count women )
  set population ( total-men + total-women )
  set hair-black ( count men with [ hair = "black" ] + count women with [ hair = "black" ] )
  set hair-brown ( count men with [ hair = "brown" ] + count women with [ hair = "brown" ] )
  set hair-blonde ( count men with [ hair = "yellow" ] + count women with [ hair = "yellow" ] )
  set hair-red ( count men with [ hair = "red" ] + count women with [ hair = "red" ] )
  set eyes-blue ( count men with [ eyes = "blue" ] + count women with [ eyes = "blue" ] )
  set eyes-brown ( count men with [ eyes = "brown" ] + count women with [ eyes = "brown" ] )
  if population > 0 [
    set black-pct ( hair-black / population * 100 )
    set brown-pct ( hair-brown / population * 100 )
    set blonde-pct ( hair-blonde / population * 100 )
    set red-pct ( hair-red / population * 100 )
    set eyes-brown-pct ( eyes-brown / population * 100 )
    set eyes-blue-pct ( eyes-blue / population * 100 )
  ]
end

;;; WHEN GO IS PRESSED:
to go
  count-globals
  assign-shape
  set male-infected count men with [ infected? ]
  set female-infected count women with [ infected? ]
  set total-infected ( male-infected + female-infected )
  set infected-pct ( total-infected / population * 100 )
  ask men [
    overpopulation
    if age > 100 [ die ]                                       ; for simplicity, if older than 100, die
    uncouple
    if not coupled? [ move ]                                                       ; move
    grim-reaper
  ]
  ask women [
    overpopulation
    if age > 100 [ die ]                                       ; for simplicity, if older than 100, die
    uncouple
    if not coupled? [ move ]                                                       ; move
    make-couple
    pregnancy
    grim-reaper
  ]
  ask turtles with [ infected? ] [
    transmit-infection
    ifelse time-left = 0 [ die ]  [set time-left ( time-left - 1 ) ]
    set shape "face sad"
  ]
  if stop-when = "Population = 0" [ if population = 0 [ stop ] ]
  if stop-when = "Total Infected = 0" [ if total-infected = 0 [ stop ] ]
  if ticks = max-time [ stop ]
  tick
end

to setup-men
  create-men 500 [
    setxy random-xcor random-ycor
    set coupled? false
    set partner nobody
    set age ( 5 + ( random (75 - 5) + 1 ) )
    set gender "M"
    assign-haircolor
    assign-eyecolor
  ]
end

to setup-women
  create-women 500 [
    setxy random-xcor random-ycor
    set coupled? false
    set partner nobody
    set age ( 5 + ( random (75 - 5) + 1 ) )
    set gender "F"
    assign-haircolor
    assign-eyecolor
    set pregnant? false
  ]
end

to assign-haircolor
  let x random-float 1.0
  if x <= 1.0   [ set hair "red" set color red ]
  if x <= 0.989 [ set hair "yellow" set color yellow ]
  if x <= 0.965 [ set hair "brown" set color brown ]
  if x <= 0.855 [ set hair "black" set color black ]
end

to assign-eyecolor
  let x random 100 + 1
  if x <= 100 [ set eyes "blue" ]
  if x <= 59  [ set eyes "brown" ]
end

to assign-shape
  ask men [
    set shape ( ifelse-value
      age <= 16 [ "turtle" ]
      age >= 65 [ "bug" ]
      [ "circle" ])
  ]
  ask women [
    set shape ( ifelse-value
      age <= 16 [ "star" ]
      age >= 46 [ "flower" ]
      [ "square" ])
  ]
end

to move
  rt random-float 360
  fd random 5 + 1
end

to grim-reaper
  let idx ( age - 1 )                                        ; we need this for indexing
  let comparison ( item idx grim-multiplier )                ; find the death probability
  let grim random-float 1.0                                  ; generate a random float; if the death probability
  ifelse comparison > grim [ die ] [ set age ( age + 1 ) ]   ; is greater, die; else grow older one year
end

to pregnancy
  ifelse pregnant? [
    make-child
    set shape "square"
  ] [
    let idx ( age - 1 )
    let comparison ( item idx fertility-chance )
    let fertile random-float 1.0
    if comparison > fertile and coupled? [
      set pregnant? true
      set shape "person"
    ]
  ]
end

to make-child
  let set-gender one-of [1 -1]
  if set-gender = 1 [
    hatch-men 1 [
      set shape "circle"
      set age 1
      set gender "M"
      set partner nobody
      set coupled? false
      set infected? false
      ask myself [
        haircolor
        eyecolor
      ]
    ]
  ]
  if set-gender = -1 [
    hatch-women 1 [
      set shape "square"
      set age 1
      set gender "F"
      set partner nobody
      set coupled? false
      set infected? false
      ask myself [
        haircolor
        eyecolor
      ]
    ]
  ]
  set pregnant? false
end

to make-couple
  let potential-partner one-of men-here with [ not coupled? and age > 16 ]
  if potential-partner != nobody [
    set partner potential-partner
    set coupled? true
    set f-hair ( [ hair ] of potential-partner )
    set f-eyes ( [ eyes ] of potential-partner )
    ask partner [ set coupled? true ]
    ask partner [ set partner myself ]
    move-to patch-here
    ask potential-partner [ move-to patch-here ]
    set pcolor gray - 3
    ask ( patch-here ) [ set pcolor gray - 3 ]
  ]
end

to transmit-infection
  let potential-host one-of turtles-here with [ not infected? ]
  if potential-host != nobody [
    if ( [ hair ] of potential-host ) = ( [ hair ] of self ) and ( [ eyes ] of potential-host ) = ( [ eyes ] of self ) [
      let transmit random 100
      if transmit < 60 [
        ask potential-host [
          set infected? true
          set time-left years-until-death
        ]
      ]
    ]
    if ( [ hair ] of potential-host ) = ( [ hair ] of self ) or ( [ eyes ] of potential-host ) = ( [ eyes ] of self ) [
      let transmit random 100
      if transmit < 15 [
        ask potential-host [
          set infected? true
          set time-left years-until-death
        ]
      ]
    ]
  ]
end

to uncouple
  if partner = nobody [ set coupled? false ]
  set pcolor white
  ask ( patch-here ) [ set pcolor white ]
end

to overpopulation
  if population > max-population [
    let migrate random 100
    if migrate = 1 [ die ]
  ]
end

to haircolor
  ask myself [
    let hair1 [ hair ] of self
    let hair2 [ f-hair ] of self
    if ( hair1 = "black" and hair2 = "black" ) or ( hair2 = "black" and hair1 = "black" ) [
      let tmpvar ( random 8 + 1 )
      let hairtype ( ifelse-value
        tmpvar = 1 [ "yellow" ]
        tmpvar = 2 [ "red" ]
        [ "black" ])
      set hair hairtype
      set color read-from-string hairtype
    ]
    if ( hair1 = "black" and hair2 = "yellow" ) or ( hair2 = "black" and hair1 = "yellow" ) [
      set hair "black"
      set color black
    ]
    if ( hair1 = "black" and hair2 = "red" ) or ( hair2 = "black" and hair1 = "red" ) [
      let tmpvar ( random 4 + 1 )
      let hairtype ( ifelse-value
        tmpvar = 1 [ "red" ]
        [ "black" ])
      set hair hairtype
      set color read-from-string hairtype
    ]
    if ( hair1 = "black" and hair2 = "brown" ) or ( hair2 = "black" and hair1 = "brown" ) [
      let tmpvar ( random 8 + 1 )
      let hairtype ( ifelse-value
        tmpvar = 1 [ "yellow" ]
        tmpvar = 2 [ "red" ]
        tmpvar = 3 [ "black" ]
        [ "brown" ])
      set hair hairtype
      set color read-from-string hairtype
    ]
    if ( hair1 = "yellow" and hair2 = "yellow" ) or ( hair2 = "yellow" and hair1 = "yellow" ) [
      set hair "yellow"
      set color yellow
    ]
    if ( hair1 = "yellow" and hair2 = "red" ) or ( hair2 = "yellow" and hair1 = "red" ) [
      set hair "yellow"
      set color yellow
    ]
    if ( hair1 = "yellow" and hair2 = "brown" ) or ( hair2 = "yellow" and hair1 = "brown" ) [
      let tmpvar one-of [1 -1]
      ifelse tmpvar = 1 [
        set hair "yellow"
        set color yellow
      ] [
        set hair "brown"
        set color brown
      ]
    ]
    if ( hair1 = "brown" and hair2 = "red" ) or ( hair2 = "brown" and hair1 = "red" ) [
      let tmpvar one-of [1 -1]
      ifelse tmpvar = 1 [
        set hair "brown"
        set color brown
      ] [
        set hair "red"
        set color red
      ]
    ]
    if ( hair1 = "brown" and hair2 = "brown" ) or ( hair2 = "brown" and hair1 = "brown" ) [
      let tmpvar ( random 8 + 1 )
      let hairtype ( ifelse-value
        tmpvar = 1 [ "yellow" ]
        tmpvar = 2 [ "red" ]
        [ "brown" ])
      set hair hairtype
      set color read-from-string hairtype
    ]
    if ( hair1 = "red" and hair2 = "red" ) or ( hair2 = "red" and hair1 = "red" ) [
      set hair "red"
      set color red
    ]
  ]
end

to eyecolor
  ask myself [
    let eyes1 [ eyes ] of self
    let eyes2 [ f-eyes ] of self
    if ( eyes1 = "brown" and eyes2 = "brown" ) or ( eyes2 = "brown" and eyes1 = "brown" ) [
      let tmpvar ( random 8 + 1 )
      let eyetype ( ifelse-value
        tmpvar = 1 [ "blue" ]
        [ "brown" ])
      set eyes eyetype
    ]
    if ( eyes1 = "blue" and eyes2 = "blue" ) or ( eyes2 = "blue" and eyes1 = "blue" ) [
      set eyes "blue"
    ]
    if ( eyes1 = "blue" and eyes2 = "brown" ) or ( eyes2 = "blue" and eyes1 = "brown" ) [
      let tmpvar ( random 4 + 1 )
      let eyetype ( ifelse-value
        tmpvar = 1 [ "blue" ]
        [ "brown" ])
      set eyes eyetype
    ]
  ]
end

to infect
  if hair-eye-combo = "Black Hair, Blue Eyes" [
    let m-potential-infect men with [ hair = "black" or eyes = "blue" ]
    let f-potential-infect women with [ hair = "black" or eyes = "blue" ]
    let m-tgt ( round ( total-men * 0.1 ))
    let f-tgt ( round ( total-women * 0.1 ))
    ask m-potential-infect [ set infectable? true ]
    ask f-potential-infect [ set infectable? true ]
    ask n-of m-tgt m-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    ask n-of f-tgt f-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    set total-infected ( count men with [ infected? ] + count women with [ infected? ] )
  ]
  if hair-eye-combo = "Brown Hair, Blue Eyes" [
    let m-potential-infect men with [ hair = "brown" or eyes = "blue" ]
    let f-potential-infect women with [ hair = "brown" or eyes = "blue" ]
    let m-tgt ( round ( total-men * 0.1 ))
    let f-tgt ( round ( total-women * 0.1 ))
    ask m-potential-infect [ set infectable? true ]
    ask f-potential-infect [ set infectable? true ]
    ask n-of m-tgt m-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    ask n-of f-tgt f-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    set total-infected ( count men with [ infected? ] + count women with [ infected? ] )
  ]
  if hair-eye-combo = "Blonde Hair, Blue Eyes" [
    let m-potential-infect men with [ hair = "yellow" or eyes = "blue" ]
    let f-potential-infect women with [ hair = "yellow" or eyes = "blue" ]
    let m-tgt ( round ( total-men * 0.1 ))
    let f-tgt ( round ( total-women * 0.1 ))
    ask m-potential-infect [ set infectable? true ]
    ask f-potential-infect [ set infectable? true ]
    ask n-of m-tgt m-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    ask n-of f-tgt f-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    set total-infected ( count men with [ infected? ] + count women with [ infected? ] )
  ]
  if hair-eye-combo = "Red Hair, Blue Eyes" [
    let m-potential-infect men with [ hair = "red" or eyes = "blue" ]
    let f-potential-infect women with [ hair = "red" or eyes = "blue" ]
    let m-tgt ( round ( total-men * 0.1 ))
    let f-tgt ( round ( total-women * 0.1 ))
    ask m-potential-infect [ set infectable? true ]
    ask f-potential-infect [ set infectable? true ]
    ask n-of m-tgt m-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    ask n-of f-tgt f-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    set total-infected ( count men with [ infected? ] + count women with [ infected? ] )
  ]
  if hair-eye-combo = "Black Hair, Brown Eyes" [
    let m-potential-infect men with [ hair = "black" or eyes = "brown" ]
    let f-potential-infect women with [ hair = "black" or eyes = "brown" ]
    let m-tgt ( round ( total-men * 0.1 ))
    let f-tgt ( round ( total-women * 0.1 ))
    ask m-potential-infect [ set infectable? true ]
    ask f-potential-infect [ set infectable? true ]
    ask n-of m-tgt m-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    ask n-of f-tgt f-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    set total-infected ( count men with [ infected? ] + count women with [ infected? ] )
  ]
  if hair-eye-combo = "Brown Hair, Brown Eyes" [
    let m-potential-infect men with [ hair = "brown" or eyes = "brown" ]
    let f-potential-infect women with [ hair = "brown" or eyes = "brown" ]
    let m-tgt ( round ( total-men * 0.1 ))
    let f-tgt ( round ( total-women * 0.1 ))
    ask m-potential-infect [ set infectable? true ]
    ask f-potential-infect [ set infectable? true ]
    ask n-of m-tgt m-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    ask n-of f-tgt f-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    set total-infected ( count men with [ infected? ] + count women with [ infected? ] )
  ]
  if hair-eye-combo = "Blonde Hair, Brown Eyes" [
    let m-potential-infect men with [ hair = "yellow" or eyes = "brown" ]
    let f-potential-infect women with [ hair = "yellow" or eyes = "brown" ]
    let m-tgt ( round ( total-men * 0.1 ))
    let f-tgt ( round ( total-women * 0.1 ))
    ask m-potential-infect [ set infectable? true ]
    ask f-potential-infect [ set infectable? true ]
    ask n-of m-tgt m-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    ask n-of f-tgt f-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    set total-infected ( count men with [ infected? ] + count women with [ infected? ] )
  ]
  if hair-eye-combo = "Red Hair, Brown Eyes" [
    let m-potential-infect men with [ hair = "red" or eyes = "brown" ]
    let f-potential-infect women with [ hair = "red" or eyes = "brown" ]
    let m-tgt ( round ( total-men * 0.1 ))
    let f-tgt ( round ( total-women * 0.1 ))
    ask m-potential-infect [ set infectable? true ]
    ask f-potential-infect [ set infectable? true ]
    ask n-of m-tgt m-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    ask n-of f-tgt f-potential-infect [
      set infected? true
      set time-left years-until-death
    ]
    set total-infected ( count men with [ infected? ] + count women with [ infected? ] )
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
265
25
868
629
-1
-1
9.7541
1
10
1
1
1
0
1
1
1
-30
30
-30
30
1
1
1
Years
30.0

BUTTON
65
25
260
58
Reset Simulation
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
155
60
260
93
Go Forever
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
20
445
135
490
Total Population
population
17
1
11

PLOT
875
25
1295
230
Hair Color (Percentage of Population)
Time (Years)
% of Population
0.0
10.0
0.0
100.0
true
true
"" ""
PENS
"Black" 1.0 0 -16777216 true "" "if population > 0 [ plot ( hair-black / population * 100 ) ]"
"Brown" 1.0 0 -6459832 true "" "if population > 0 [ plot ( hair-brown / population * 100 ) ]"
"Blonde" 1.0 0 -1184463 true "" "if population > 0 [ plot ( hair-blonde / population * 100 ) ]"
"Red" 1.0 0 -2674135 true "" "if population > 0 [ plot ( hair-red / population * 100 ) ]"

BUTTON
65
60
152
93
Go Once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
1310
25
1730
230
Population with Hair Color
Time (Years)
Population
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Black" 1.0 0 -16777216 true "" "plot hair-black"
"Brown" 1.0 0 -6459832 true "" "plot hair-brown"
"Blonde" 1.0 0 -1184463 true "" "plot hair-blonde"
"Red" 1.0 0 -2674135 true "" "plot hair-red"
"Total Population" 1.0 0 -7500403 true "" "plot population"

MONITOR
20
490
77
535
Male
total-men
17
1
11

MONITOR
75
490
135
535
Female
total-women
17
1
11

SLIDER
65
215
260
248
max-population
max-population
0
8000
2047.0
1
1
NIL
HORIZONTAL

MONITOR
20
535
135
580
Years Elapsed
ticks
17
1
11

MONITOR
875
230
980
275
Black Hair (%)
black-pct
2
1
11

MONITOR
980
230
1085
275
Blonde Hair (%)
blonde-pct
2
1
11

MONITOR
1085
230
1190
275
Brown Hair (%)
brown-pct
2
1
11

MONITOR
1190
230
1295
275
Red Hair (%)
red-pct
2
1
11

MONITOR
1310
230
1415
275
Black Hair (#)
hair-black
17
1
11

MONITOR
1415
230
1520
275
Blonde Hair (#)
hair-blonde
17
1
11

MONITOR
1520
230
1625
275
Brown Hair (#)
hair-brown
17
1
11

MONITOR
1625
230
1730
275
Red Hair (#)
hair-red
17
1
11

MONITOR
1085
475
1190
520
Blue Eyes (%)
eyes-blue-pct
2
1
11

MONITOR
1190
475
1295
520
Brown Eyes (%)
eyes-brown-pct
2
1
11

PLOT
875
285
1295
475
Eye Color (Percentage of Population)
Time (Years)
% of Population
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Blue" 1.0 0 -13345367 true "" "plot eyes-blue-pct"
"Brown" 1.0 0 -6459832 true "" "plot eyes-brown-pct"

PLOT
1310
285
1730
475
Population with Eye Color
Time (Years)
Population
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Blue" 1.0 0 -13345367 true "" "plot eyes-blue"
"Brown" 1.0 0 -6459832 true "" "plot eyes-brown"

MONITOR
1520
475
1625
520
Blue Eyes (#)
eyes-blue
17
1
11

MONITOR
1625
475
1730
520
Brown Eyes (#)
eyes-brown
17
1
11

CHOOSER
25
335
255
380
hair-eye-combo
hair-eye-combo
"None" "Black Hair, Blue Eyes" "Brown Hair, Blue Eyes" "Blonde Hair, Blue Eyes" "Red Hair, Blue Eyes" "Black Hair, Brown Eyes" "Brown Hair, Brown Eyes" "Blonde Hair, Brown Eyes" "Red Hair, Brown Eyes"
8

MONITOR
145
445
255
490
Total Infected (#)
total-infected
17
1
11

SLIDER
25
385
255
418
years-until-death
years-until-death
5
25
10.0
1
1
Years
HORIZONTAL

CHOOSER
65
100
260
145
stop-when
stop-when
"None" "Population = 0" "Total Infected = 0"
2

INPUTBOX
65
150
260
210
max-time
10000.0
1
0
Number

MONITOR
145
535
255
580
Infected [F] (#)
female-infected
17
1
11

MONITOR
145
490
255
535
Infected [M] (#)
male-infected
17
1
11

MONITOR
145
580
255
625
Total Infected (%)
infected-pct
2
1
11

INPUTBOX
65
255
260
315
model-seed
12345.0
1
0
Number

@#$#@#$#@
## WHAT IS IT?

This project is a simulation of a small town or population of 1000 that encounters a foreign virus. This virus targets traits like hair or eye color. I created this simulation in hopes of seeing a rough idea of what would occur to a poulation if they were to come across this virus, in case a similar pathogen were to break out in the future. This imulation strives to show how our population would be affected over time, and how our appearences would change out of necessity.

## HOW IT WORKS

All people move randomly around their world. When a woman and a man are on the same patch of the world, they have a chance of coupling. Once they couple, they no longer move, and they have a chance to produce a child. The probability of becoming pregnant is based on a random variable compared against fertility rates and the desired age at which women in developed countries consider having children. Women in this model are most likely to get pregnant if coupled and at the age of 30.

The hair color of people's offspring is dependent on the parent's hair coloring. It's based on which traits are dominant to other traits, and helped decide the percentage chance for a child to have a certain hair color.  

In this simulation, the maximum age is 100. Also, after each year the person has a random chance of death based on mortality rates from the Social Security Administration.

The simulation starts with an initial population of 1000, and you can use the *population* slider to designate a maximum population that this world can support. The simulation then randomly migrates people away until the population drops below the maximum.

In my simulation, there is a rampant infection spreading that will kill off people within a certain amount of years. This number is customizable using the *years-until-death* slider. The virus first spawns in with 10% of the population, and is spread by being at the same location as an infected person. This virus targets physical traits, or your appearence, and targets people with a combination of two traits that you can select. 

If a person has both traits, they have a higher chance of infection (60%), and if they only have one trait, they have a much lower chance of infection (15%). If they do not have either of the traits in your selected combination, they have no chance to get infected.

## HOW TO USE IT

To setup the simulation, press the button at the top named **Reset Simulation**. This will load an initial population of 1000 people. To run the simulation one year at a time, press the button named **Go Once**. To run it for an infinite amount of time, press **Go Forever**. This button also pauses the simulation.

### REPRODUCING SIMULATIONS

Use the *model-seed* input to reproduce simulations. 

## THINGS TO NOTICE

Icons represent the gender, age group, and hair color of each person. 

* Star = Female under 17
* Square = Female between 17 and 45
* Flower = Female older than 45
* Turtle = Male under 17
* Circle = Male betwen 17 and 65
* Bug = Male over 65

When a Woman is pregnant, her shape changes to a person.

When a person is infected, their shape changesd to a sad face. 

## THINGS TO TRY

One of the options to change in my simulation is to press **Stop When**. This will give you the option to choose out of three choices: **None**, if you want it to go until you manually stop it; **Population = 0**, if you want to run the simulation until all people are dead; or **Infected = 0**, if you want to run the simulation until all infected persons are dead.

Another thing to change is the **Maximum Population** slider. With this, you can designate the maximum number of people who can live in this area at any time.

The **Years Until Death** slider designates the amount of time the infected have left to live before they die due to complications with their illness. Note how a longer **Years Until Death** value requires a much longer period for the virus to be eradicated as it has more time to spread to more of the population.

In this simulation, you can also choose which combination of traits is most likely to be infected. You can do this by clicking on the chooser titled **Hair Eye Combo**. If you want to run this simulation without any infected, you can choose to do so as well. 

The last option to change about this simulation is to designate the amount of time the simulation runs for. You can do this by enering a number into the input box labelled **Max Time**. you can also choose to leave this box blank if you wish to see this simulation run indefinetely.

One thing that you can do in this simulation as an additional feature is view an individual person. You can do this by selecting the person you wish to follow, press **Inspect** to view their traits and other details, or press **Watch** to see them move around the map.

## EXTENDING THE MODEL

Many variables in this simulation had to be simplified. For example, once a couple is formed, they stay together until one of the couple dies. Also, hair color inheritance is not only determined by the hair color of their parents. All pregnancies in this model result in a successful birth. I also only included heterosexual relationships. 

## CREDITS AND REFERENCES

* ***Death probabilities***: https://www.ssa.gov/oact/STATS/table4c6.html
* ***Desire for children***: https://pmc.ncbi.nlm.nih.gov/articles/PMC9619608/
* ***Fertility rates at different ages***: https://www.babycenter.com/getting-pregnant/preparing-for-pregnancy/chart-the-effect-of-age-on-fertility_6155

The base population (in terms of ages and genders in particular) was modelled after the *Renton, Washington* population in 2020 as this city had 100,000 people in that year's Census, and it would be easy to scale down to a population of 1000. Demographic characteristics were taken from https://en.wikipedia.org/wiki/Renton,_Washington
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.4.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
