globals [artifact_count sample_size positives negatives percentage_found percentage_positive extrapolated_count num_patches]
breed [artifacts artifact]

to setup_artifacts
  clear-all
  ask patches [ set pcolor brown ]
  ifelse artifact_clustering = 0 [
    crt num_artifacts [ setxy random-xcor random-ycor ]
  ] [
    ask n-of artifact_clustering patches
     [
     sprout ( num_artifacts / artifact_clustering )
        [
        set xcor xcor + random-float 5.
        set ycor ycor + random-float 5.
        ]
     ]
    set num_artifacts count turtles
  ]
  ask turtles [ set shape "default" set size 0.6 set color black]
  reset-ticks
end

to hide_some_artifacts
  ask turtles [ set color black ]
  ask n-of (num_artifacts * proportion_hid) turtles [ set color brown ]
end

to show_artifacts
  ask turtles [ set color black ]
end

to random_patches
  ask n-of n patches [
   set pcolor blue
  ]
end

to systematic_patches
  let Grid grid_size
  ask patches with [pxcor mod Grid = 0 and pycor mod Grid = 0] [ set pcolor blue ]
end

to judgemental_patches
  if mouse-down?
    [ask patch mouse-xcor mouse-ycor
        [ set pcolor blue]
  ]
  display
end

to reset_patches
  ask patches [ set pcolor brown ]
end

to count_patches
  set num_patches count patches with [ pcolor = blue ]
end

to get_results
    set artifact_count count turtles-on patches with [ pcolor = blue ]
    ask patches [
      if (pcolor = blue) and (any? turtles-here)
        [ set pcolor green]
      if pcolor = blue
        [ set pcolor red]
      ]
  set positives count patches with [ pcolor = green ]
  set negatives count patches with [ pcolor = red ]
  set sample_size ( (positives + negatives) / (count patches) ) * 100
  set percentage_found ( artifact_count / num_artifacts ) * 100
  set percentage_positive ( positives / ( positives + negatives ) ) * 100
  set extrapolated_count ( artifact_count / (sample_size / 100) )
end
@#$#@#$#@
GRAPHICS-WINDOW
562
13
1335
787
-1
-1
15.0
1
10
1
1
1
0
1
1
1
0
50
0
50
0
0
0
ticks
30.0

BUTTON
19
99
212
132
1) Setup Artifact Distribution
setup_artifacts
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
15
223
255
256
2a) Select n random survey patches
random_patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
16
313
315
346
2b) Setup a systematic grid of survey patches
systematic_patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
16
397
379
430
2c) Select survey patches judgementally (interactive)    
judgemental_patches
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
272
224
481
257
n
n
0
100
50.0
1
1
NIL
HORIZONTAL

SLIDER
220
100
374
133
num_artifacts
num_artifacts
0
1000
500.0
1
1
NIL
HORIZONTAL

TEXTBOX
35
268
185
286
or...
14
15.0
1

TEXTBOX
31
358
181
376
or...
14
15.0
1

BUTTON
16
557
198
615
3) Display Results!
get_results
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
384
100
533
133
artifact_clustering
artifact_clustering
0
100
0.0
1
1
NIL
HORIZONTAL

MONITOR
22
632
250
677
# of artifacts discovered
artifact_count
17
1
11

MONITOR
22
685
249
730
# of postive survey patches
positives
17
1
11

MONITOR
22
739
252
784
# of negative survey patches
negatives
17
1
11

TEXTBOX
17
434
442
464
(If you use this button, don't forget to \"unclick\" it when you are done!)
11
0.0
1

MONITOR
264
633
522
678
% of all artifacts discovered
percentage_found
2
1
11

MONITOR
263
688
532
733
Positivity rate (% of all survey patches)
percentage_positive
2
1
11

MONITOR
262
739
523
784
Extrapolated number of artifacts
extrapolated_count
0
1
11

MONITOR
263
580
521
625
Sample size (% of landscape covered)
sample_size
2
1
11

BUTTON
45
160
184
193
Hide some artifacts
hide_some_artifacts
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
191
160
297
193
Show artifacts
show_artifacts
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
303
160
475
193
proportion_hid
proportion_hid
0
1
0.75
0.05
1
NIL
HORIZONTAL

SLIDER
323
314
479
347
grid_size
grid_size
0
25
10.0
1
1
NIL
HORIZONTAL

BUTTON
28
467
216
500
Count survey patches
count_patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
237
464
424
509
Number of survey patches
num_patches
17
1
11

BUTTON
27
508
216
541
Reset Survey Patches!
reset_patches
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
14
25
558
76
READ THE \"MODEL INFO\" TAB AT THE BOTTOM OF THE PAGE FOR INSTRUCTIONS ON HOW TO USE THIS MODEL.
18
15.0
1

TEXTBOX
249
562
543
583
Total number of landscape patches is 2500.
12
0.0
1

@#$#@#$#@
## WHAT IS IT?

This is a very simple interactive tool for setting up experiments about sampling strategies for archaeological survey and prospection. 

## HOW IT WORKS

You first seed the landscape with a random or clustered set of "artifacts" (but these could be sites or anything else in practice). You then create a set of sampling patches either by randomly distributing them, uniformly laying out on a grid, or by judgmentally placing them by clicking on the map. You can combine techniques for a "stratified" approach as well. Finally, the program will then count up the number of "artifacts" that were detected and calculate the positivity rate and the statistically extrapolated estimate of the total number of "artifacts" that would be predicted from the sample. A "good" sampling strategy for a given distribution of artifacts would predict an extrapolated count that closely matches the actual total number of artifacts that were seeded across the landscape. 

The landscape consists of a 50 x 50 grid of survey patches (2500 total landscape patches). The simulated survey landscape is scale-free, so there is no specific spatial scale to the patches. It may, however, be useful to imagine the landscape at a familiar scale, such as a series of 1x1 meter grid squares, to help you visualize these results in a "real world" context.

## HOW TO USE IT

First, set up the artifact distribution. The *num_artifacts* sets the total number of artifacts, and the *artifact_clustering* slider sets up the way they are distributed across the landscape. If *artifact_clustering* is set to 0, then a true Gaussian random distribution of artifacts is used. If set to 1 or higher, then artifacts are randomly distributed within a 5-cell radius of a set of cluster centers. The number of cluster centers is the same as the value set by *artifact_clustering* (i.e., *artifact_cluster* of 5 will make 5 clusters, etc.). Use the *Setup Artifact Distribution* button to place the artifacts. Clicking this button will erase any previous distributions or results, and reset the experiment. Note that for some values of *artifact_clustering*, the actual number of artifacts may be automatically adjusted to evenly divide artifacts across clusters. In these cases you will see the value of *num_artifacts* change after you click the *Setup Artifact Distribution" button.

Once the artifacts are distributed, you can optionally use the *hide some artifacts* button in conjunction with the *proportion_hid* slider to hid a portion of the artifacts from view. This simulates, for example, the difference between artifacts that are on the surface, and those that may be buried. It is useful for removing bias when setting up your survey patches.

Next you will need to set up your survey patches. There are three tools that you can use for this, and they can be used separately or in any combination. As you add survey patches, they will turn blue on the map.

The *Select n random survey patches* tool works in conjunction with the *n* slider to randomly distribute some number of survey patches around the landscape. 

The *Setup a systematic grid of survey patches* button is used in conjunction with the *grid_size* slider to create an evenly distributed sampling grid with survey patches at the grid intersections. The value of *grid_size* is the number of patches between each survey patch. 

The *Select survey patches judgmentally (interactive)* button is used to interactively click on patches on the map to select them as survey patches. This is a "latching" button, so you must "unclick" it once you've finished your selection. 

Once you have selected your patches, you can optionally click the *Count survey patches* button to quickly count the number of survey patches you've created. This is useful if you need to constrain the number of patches for your experiment (e.g., you are limited by time or budget to a set maximum number of survey patches). You can also use the *Reset survey patches* button to blank out all previously selected patches. This is useful if you've made a mistake, gone over your survey patch limit, or if you want to keep the same artifact distribution, but test different survey patch arrangements.

Once your survey patches are set up, you can use the *Display Results!* button to quickly calculate a series of summary statistics and to change the color of the positive survey patches to green, and negative patches to red. Summary statistics include:

- The sample size (% of the total landscape that was surveyed)
- The raw count of discovered artifacts (artifacts that fell inside a survey patch)
- The number of survey patches that contained some artifacts (positive patches)
- The number of survey patches that had no artifacts (negative patches)
- The percentage of the total number of artifacts that were discovered 
- The positivity rate (% of survey patches with artifacts in them)
- The extrapolated estimate of the total number of artifacts based on the sampling proportion and the number of artifacts discovered in the survey patches. 

This last figure is calculated as the number of artifacts discovered divided by the sample size (percent of landscape covered). If this number is close to the actual number of seeded artifacts (*num_artifacts*), then it can be concluded that the sampling strategy is effective.

## THINGS TO NOTICE

Try increasing the cluster size. As it gets larger and large, the distribution of seed artifacts approaches a uniform distribution.

Try combining survey sampling strategies. You can, for example, create a "stratified random" sampling strategy by combining an overall random distribution with some interactive (but randomly chosen) "clicked" sampling patches in a specific part of th map.

## THINGS TO TRY

Set up an artifact distribution, and then using the "Reset survey patches" button to iteratively test through several different types of sampling strategies. This is especially useful if you used a random sampling strategy, as the placement of the actual sampling patches will be different each time. 

Try iteratively increasing the number of survey patches, and note how the extrapolated prediction changes. Is it possible to "under sample" and get a prediction that is too small? Is it possible to "oversample" and get a prediction that is too large? Are you ever able to predict the exact number of artifacts? How big is the window of sample sizes where predicted results are reasonably accurate? 

## EXTENDING THE MODEL

At the moment, the gridded sampling frame is only available as a symmetric square grid. It would be useful to add the functionality for rectangular, triangular, and hexagonal grids as well.


## RELATED MODELS

The DIDI and DICI models (www.DigItTools.net) are also NetLogo models developed for survey experiments. This model is much simpler, and is aimed more at education than true statistical analysis of real survey strategies.

## CREDITS AND REFERENCES

This model was created by Isaac I.T. Ullah, PhD, 2021, at San Diego State University. It is intended for educational purposes only, and comes with no warantee or guarantee of accuracy. The model derives from an analog sampling experiment lab created as part of ANTH 302 "Principles of Archaeology." It is available under the GNU public license, and is published on the web at http://isaacullah.github.io/models/Sampling_Experiment.html. Please cite the author if you use this model in any publication.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

projectile point
false
0
Polygon -7500403 true true 150 15 30 240 270 240
Polygon -7500403 true true 150 180 60 285 150 270 240 285

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
