globals [ day ]

turtles-own [
  speed
  bspeed
  neighbor
  move-countdown
  rest-countdown
  movement
  sync
  energy
  reward
  shelters
  nearest-shelter ]


breed [ fishes fish ]

to setup
  clear-all
  reset-ticks
  set day 1

  ;;to randomly create food patches with given density
  ask patches [
    if random-normal 50 50 > (200 - (food-density)) [
        set pcolor green ] ]

  ;;set 5 brown shelters with yellow boundaries
  ask n-of 5 patches [ set pcolor brown
    ask neighbors [ set pcolor yellow ] ]

  ;;for spatial restriction of food to the corner
  ;ask patches [
  ;  if (pxcor > 40 * corner and pycor > 25 * corner) [
  ;    if random-normal (50 + (5 * corner)) 20 > 90 [
  ;      set pcolor green ] ] ]

  ;;create 10 agents with baseline average speed 2, assigned sync-factors, and variable values of initial move and rest times (with averages of 100), at random starting locations
  create-fishes 10 [
    set size 5
    set bspeed boldness1 + random-normal 0 0.1
    set speed bspeed
    set sync sync-factor
    set move-countdown 100 + random-normal 0 50
    set rest-countdown 100 + random-normal 0 50
    setxy random-xcor random-ycor ]

end

to go

  if ticks > day * 400 [ set day day + 1 ]  ;;each day is 400 timesteps long

 ;;to alternate colour to represent day and night (daylength is 400, 200:200 day-night)
  ifelse ticks > (day * 400) - 200 and ticks < (day)  * 400
    [ ask patches [ if pcolor = 55 [ set pcolor 52 ] ] ]
    [ ask patches [ if pcolor = 52 [ set pcolor 55 ] ] ]

  ask turtles [

    set neighbor min-one-of other turtles [ distance myself ]  ;;Set the nearest agent as neighbor

    ;;Move with constant speed and variable direction, try to synchronize with neighbors, consume food, have a start-stop motion, and update synchrony factor according to reward.
    move
    synchronize
    eat-grass
    stop-start
    update-sync

    ;;Move towards shelter before dusk and restrict activity at dusk/dawn
    find-shelter
    if ticks = (day * 400) - 200 [ adjust-movement2 ]
    if ticks = (day * 400) [ adjust-movement1 ]

    ;;While moving, shoal with neighbors and bounce off walls; also check whether each individual is in motion or at rest at the end of the procedures
    if speed > 0 [
      interact
      bounce-off-walls ]

    check-move ]

  tick
end



;;When agent is at half the maximum speed or greater (i.e. is starting motion or slowing down), move at the max speed with slightly variable direction
to move
  ifelse speed > 0.9 [
    rt random 10
    lt random 10
    fd 1 * bspeed ]
  [ fd 1 * speed ]
end

;;Adjust the move-time and rest-time to synchronize with the neighbour
to synchronize
  if [ movement ] of neighbor = 0 and movement = 1
    [ set move-countdown move-countdown - sync ]
  if [ movement ] of neighbor = 0 and movement = 0
    [ set rest-countdown rest-countdown + sync ]
  if [ movement ] of neighbor = 1 and movement = 0
    [ set rest-countdown rest-countdown - sync ]
  if [ movement ] of neighbor = 1 and movement = 1
    [ set move-countdown move-countdown + sync ]
end

;;Agent gets reward according to whether neighbor is moving
to eat-grass
  set reward 0

  if pcolor = 55 or pcolor = 52 [ ;;green patches during the day or night
    set pcolor black
    set energy energy + 1
    if [movement] of neighbor = 1 [
      set reward 1 ]
    if [movement] of neighbor = 0 [
      set reward 1 * comp-cost ] ]
end

;;For cyclic start-stop motion
to stop-start
  ;;While fish is moving, move-time (move-countdown) ticks down, otherwise rest-time ticks down.
  ifelse movement = 1
    [ set move-countdown move-countdown - 1 ]
    [ set rest-countdown rest-countdown - 1 ]

  ;;Accelerate or decelerate (by 0.1) to initiate movement or come to rest when move-time or  ticks down to 0
  if move-countdown < 0 [ set speed speed - 0.1 ]
  if rest-countdown < 0 [ set speed speed + 0.1 ]

  ;;Reset move-time when agent comes to rest, reset rest-time when agent reaches half maximum speed
  if speed < 0 [
    set speed 0
    set move-countdown 200 + random-normal 0 50]
  if speed > 0.9 [
    set rest-countdown 200 + random-normal 0 50]
end


;;Reinforcement learning of synchronous or asynchronous strategy
to update-sync
  ;;Increase or decrease sync-factor based on whether agent is synchronous or asynchronous with neighbour
  if reward > 0 [
    if movement = 1 and [movement] of neighbor = 1 [
      set sync sync + reward * 0.01 ]
    if movement = 1 and [movement] of neighbor = 0 [
      set sync sync - reward * 0.01 ] ]

  ;;Set maximum and minimum sync-factor as 0.9 and -0.9
  if sync > 0.9 [ set sync 0.9 ]
  if sync < -0.9 [ set sync -0.9 ]
end



;;Move towards nearest unoccupied shelters 25 steps before dusk
to find-shelter
  if ticks > (day * 400) - 225 and ticks < (day * 400) - 175 [
      set shelters (patches with [pcolor = brown])
    let empty-shelters shelters with [pcolor = brown and not any? turtles-here ]
    set nearest-shelter min-one-of empty-shelters [distance myself]
    if any? empty-shelters [
        set heading towards nearest-shelter ] ]
end

;;Adjust the move-time and rest-time of individuals at dawn and dusk
to adjust-movement1
  if movement = 1 [ set move-countdown move-countdown + restrict ]
  if movement = 0 [ set rest-countdown rest-countdown - restrict ]
end

to adjust-movement2
  if movement = 1 [ set move-countdown move-countdown - restrict ]
  if movement = 0 [ set rest-countdown rest-countdown + restrict ]
end


;;Shoaling rules
to interact
  if distance neighbor < 2
    [ set heading towards neighbor
      set heading heading + random-normal 180 10 ]
  if distance neighbor < 10 and distance neighbor > 2
    [ set heading [heading] of neighbor + random-normal 0 10 ]
  if distance neighbor > 10 and any? other turtles in-cone 15 60 [
    set heading towards neighbor
    set heading heading + random-normal 0 10 ]
end

;;Bouncing off the walls
to bounce-off-walls
  if abs pxcor = max-pxcor [ set heading (heading + 90) ]
  if abs pycor = max-pycor [ set heading (heading + 90) ]
end

;;Check whether each individual is moving
to check-move
  ifelse speed > 0
    [ set movement 1 ]
    [ set movement 0 ]
end

;;Report the number of individuals moving at any given time
to-report active-fish
  report count turtles with [ movement = 1 ]
end

;;Report the average sync-factor of the 10 individuals in the population
to-report avg-sync
  report mean [sync] of turtles
end
@#$#@#$#@
GRAPHICS-WINDOW
221
10
873
423
-1
-1
4.0
1
10
1
1
1
0
0
0
1
0
160
0
100
1
1
1
ticks
30.0

BUTTON
32
64
96
97
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
103
64
166
97
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
23
128
195
161
boldness1
boldness1
1
2
2.0
0.5
1
NIL
HORIZONTAL

SLIDER
23
161
195
194
sync-factor
sync-factor
-1
1
-0.8
0.1
1
NIL
HORIZONTAL

PLOT
226
300
400
422
Synchrony
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot active-fish"
"pen-1" 1.0 0 -7500403 true "" "plot (count patches with [pcolor = 52]) / 50"

MONITOR
796
378
874
423
Sync-factor
[sync] of turtle 0
17
1
11

MONITOR
705
378
796
423
Food consumed
[energy] of turtle 0
17
1
11

SLIDER
24
258
196
291
food-density
food-density
0
200
50.0
25
1
NIL
HORIZONTAL

SLIDER
23
193
195
226
comp-cost
comp-cost
0
20
10.0
5
1
NIL
HORIZONTAL

MONITOR
804
422
874
467
Total food
count patches with [pcolor = green or pcolor = 52]
17
1
11

SLIDER
24
290
196
323
corner
corner
1.5
4.5
4.0
0.5
1
NIL
HORIZONTAL

SLIDER
24
225
196
258
restrict
restrict
0
200
100.0
25
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="30" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="5000"/>
    <metric>[ bspeed ] of fish 0</metric>
    <metric>[ bspeed ] of fish 1</metric>
    <metric>[ cohesion ] of fish 0</metric>
    <metric>[ cohesion ] of fish 1</metric>
    <metric>[ leadership ] of fish 0</metric>
    <metric>[ leadership ] of fish 1</metric>
    <metric>[ totaldist ] of fish 0</metric>
    <metric>[ totaldist ] of fish 1</metric>
    <metric>[ spaceuse ] of fish 0</metric>
    <metric>[ spaceuse ] of fish 1</metric>
    <enumeratedValueSet variable="boldness1">
      <value value="1"/>
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="boldness2">
      <value value="1"/>
      <value value="2"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="20" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="5000"/>
    <metric>avg-sync</metric>
    <enumeratedValueSet variable="boldness1">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="boldness2">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="sync-factor">
      <value value="-0.75"/>
      <value value="-0.5"/>
      <value value="-0.25"/>
      <value value="0"/>
      <value value="0.25"/>
      <value value="0.5"/>
      <value value="0.75"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="food-density">
      <value value="0"/>
      <value value="25"/>
      <value value="50"/>
      <value value="75"/>
      <value value="100"/>
      <value value="125"/>
      <value value="150"/>
      <value value="175"/>
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="comp-cost">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
      <value value="15"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-randomness" repetitions="20" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="5000"/>
    <metric>avg-sync</metric>
    <metric>count patches with [pcolor = green]</metric>
    <enumeratedValueSet variable="boldness1">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="boldness2">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="sync-factor">
      <value value="-0.8"/>
      <value value="-0.4"/>
      <value value="0"/>
      <value value="0.4"/>
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="food-density">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="comp-cost">
      <value value="1"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="corner">
      <value value="1.5"/>
      <value value="2"/>
      <value value="2.5"/>
      <value value="3"/>
      <value value="3.5"/>
      <value value="4"/>
      <value value="4.5"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-temporal" repetitions="20" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="5000"/>
    <metric>avg-sync</metric>
    <metric>count active-fish</metric>
    <enumeratedValueSet variable="boldness1">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="boldness2">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="sync-factor">
      <value value="-0.8"/>
      <value value="-0.4"/>
      <value value="0"/>
      <value value="0.4"/>
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="food-density">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="comp-cost">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="restrict">
      <value value="0"/>
      <value value="50"/>
      <value value="100"/>
      <value value="150"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-temporal" repetitions="20" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="5000"/>
    <metric>avg-sync</metric>
    <metric>actives</metric>
    <metric>count patches with [pcolor = green or pcolor = 52]</metric>
    <enumeratedValueSet variable="boldness1">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="boldness2">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="sync-factor">
      <value value="-0.8"/>
      <value value="-0.4"/>
      <value value="0"/>
      <value value="0.4"/>
      <value value="0.8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="food-density">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="comp-cost">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="restrict">
      <value value="0"/>
      <value value="50"/>
      <value value="100"/>
      <value value="150"/>
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="predation-pressure">
      <value value="5"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
