; by pressing setup, the initial values will be plotted and other procedures will run.

to setup
  clear-all                         ; clear the graph and reset it to its initial values that the observer began with
  system-dynamics-setup             ; defined in system dynamics modeler code
  system-dynamics-do-plot           ; defined in system dynamics modeler code
  do-plot                           ; this one is specific for total Variable that is not defined in system-dynamics-do-plot procedure
end

; The go button will give you the graph of the functions P, Q , D , and Total as time passes

to go
  system-dynamics-go                ; defined in system dynamics modeler code
  system-dynamics-do-plot           ; defined in system dynamics modeler code
  do-plot
end

; adding Total variable to the plot

to do-plot
  if plot-pen-exists? "Total" [
    set-current-plot-pen "Total"
    plotxy ticks Total
  ]
end

; we need to add a therapy so that it killes the cancer cells.
; if you press forever = this means that you are giving a continuous injection
; if you are not = this means that you are giving a periodic infusion. (This one is preffered for observation )

to Add-Drug-Injection
  set P P - 100                     ; using the fact that the cytotoxic drugs work primerly on P-cells, their number will be reduced dramatically upon injection.
  set Q Q - 45                      ; cytotoxic drugs can also cause damage to the non dividing cells Q-cells but the damage is lower compared with damage of P-cells
 set D D + 100 + 45                 ; the number of dead cells is equal to the number of already existing D-cells plus the number of cells that are killed by a cytotoxic drug.
end
@#$#@#$#@
GRAPHICS-WINDOW
1211
169
1252
211
-1
-1
1.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
43
27
106
60
setup
setup ; see code for more details
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
113
27
176
60
go
go ; see code for more details
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
42
150
142
183
P-i
P-i
0
1000
400.0
1
1
NIL
HORIZONTAL

SLIDER
41
187
144
220
Q-i
Q-i
0
1000
261.0
1
1
NIL
HORIZONTAL

SLIDER
41
223
144
256
D-i
D-i
0
1000
182.0
1
1
NIL
HORIZONTAL

INPUTBOX
181
148
261
208
Kpp
0.06
1
0
Number

INPUTBOX
262
148
335
208
Kpq
0.0567
1
0
Number

INPUTBOX
182
210
261
270
Kqp
0.05
1
0
Number

INPUTBOX
264
210
337
270
Kpd
0.007
1
0
Number

INPUTBOX
182
272
261
332
Kqd
0.005
1
0
Number

INPUTBOX
265
272
337
332
L
0.07
1
0
Number

TEXTBOX
52
130
202
148
Initial Populations
11
0.0
1

TEXTBOX
232
131
382
149
Parameters
11
0.0
1

MONITOR
394
149
500
194
proliferating cells
P
17
1
11

MONITOR
393
199
500
244
quiescent cells
Q
17
1
11

MONITOR
393
251
500
296
dead cells
D
17
1
11

MONITOR
392
301
547
346
Total number of Cells
P + Q + D
17
1
11

PLOT
655
10
1305
494
Heterogenous Growth of Cancer
time
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"P" 1.0 0 -13791810 true "" ""
"Q" 1.0 0 -2674135 true "" ""
"D" 1.0 0 -955883 true "" ""
"Total" 1.0 0 -7500403 true "" ""

INPUTBOX
219
337
294
397
Theta
1000.0
1
0
Number

BUTTON
328
33
546
66
administration of a cytotoxic drug
; see code for more details\nAdd-Drug-Injection 
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
384
128
534
146
Monitors (P , Q , D , Total )
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

This system dynamics model shows a growth behavior of a cancer which will be composed from more than one cell in a body.

The Heterogenous cancer model assumes that the cancer is composed from 3 main types of cells: the cells that divide (proliferating cells or P-cells), the cells that don't divide (quiescent cells or Q-cells), and The cells that will die (dead cells or D-cells).

Note that this model is more advanced and complex than the Homogenous model, which assumes that the cancer is composed from one cell that divides forever and grow exponentially.

This model is a modefied version of model found in [1].

## HOW IT WORKS

The body first produces the P-cells. some of these cells will produce other P-cells while the others will stop dividing  (converting to Q-cells or becomes dead due to treatment or other factors). The production of P-cells is controlled by the Capacity (that is why it is called logistic growth). 

Q-cells that are produced from P-cells will convert to P-cells again because there are mutuations in genes that regulate the growth and apoptosis of these cells. Some of Q-cells will also die due to various reasons (e.g. Tissue hypoxia or treatment).

The treatment is added to the model. when presseing the administration of a cytotoxic drug button, the cytotoxic drug will kill P-cells and Q-cells (at some extended) and the number of dead cells will be increased.

The D-cells then are removed from the body.

## HOW TO USE IT

Press the SETUP button to initialize the model.
To run the model continuously, press GO.
The administration of a cytotoxic drug button can be used once or pressed many times or you can run it continuously.
Adjust the initial populations of the cells and the parameters.

## THINGS TO NOTICE

Let the model run and see what will happen to these cells. what will happen to the Total, P, Q , and D  if you press the administration of a cytotoxic drug button multiple times?

## THINGS TO TRY

Try to play with initial populations and change the parameters then observe what will happen.

## EXTENDING THE MODEL

try to add other variables such as oxygen delivery to the tumor side, presence of immune cells , metastasis.... and so on.
If you are good in netlogo coding, try to make agent-based simulation of this model featuring P, Q, and D cells with treatment, angiogenesis then metastasis and so on.

## NETLOGO FEATURES

system dynamics modeler

## RELATED MODELS

Cancer growth, Logistic growth, Exponential growth

## CREDITS AND REFERENCES

[1] Luigi Preziosi. Cancer modelling and simulation. CRC Press, 2003.

[2] Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.1
@#$#@#$#@
@#$#@#$#@
0.001
    org.nlogo.sdm.gui.AggregateDrawing 38
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 513 104 60 40
            org.nlogo.sdm.gui.WrappedStock "P" "; Proliferating cells\n\nP-i" 1
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 990 96 60 40
            org.nlogo.sdm.gui.WrappedStock "Q" "; Quiescent cells\n\nQ-i" 1
        org.nlogo.sdm.gui.RateConnection 3 585 123 781 119 978 116 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.nlogo.sdm.gui.WrappedRate "; The dividing cells will reach a state that -\n; they will stop dividing.\n; They will convert to a type of cells called -\n; quiescent cells.\n\nStopRate * P" "P-becomes-Q" REF 2 REF 4 0
        org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 391 108 30 30
        org.nlogo.sdm.gui.RateConnection 3 421 123 461 123 501 123 NULL NULL 0 0 0
            org.jhotdraw.figures.ChopEllipseConnector REF 9
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.nlogo.sdm.gui.WrappedRate "; The proliferating cells are first produced, \n; However, their growth is restricted.\n; Because the other cells depends on P-cells,\n; their growth will also be restricted.\n\nProductionRate * P * (1 - P / Capacity )" "NewCells"
                org.nlogo.sdm.gui.WrappedReservoir  REF 2 0
        org.nlogo.sdm.gui.RateConnection 3 978 116 781 119 585 123 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.nlogo.sdm.gui.WrappedRate "; Because there are a mutations in genes-\n; that control the growth of Q-cells,\n; they can be converted to P-cells and begin-\n; proliferation again.\n\nConversionRate * Q" "Q-becomes-P" REF 4 REF 2 0
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 690 341 60 40
            org.nlogo.sdm.gui.WrappedStock "D" "; Dead cells\n\nD-i" 1
        org.nlogo.sdm.gui.RateConnection 3 566 156 630 242 695 329 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.jhotdraw.standard.ChopBoxConnector REF 19
            org.nlogo.sdm.gui.WrappedRate "; P-cells can die due to external( therapy ) -\n; or internal(action of immune cells) factors.\n\nDeathRate1 * P" "Death-of-P" REF 2 REF 20 0
        org.nlogo.sdm.gui.RateConnection 3 980 148 869 238 758 329 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.jhotdraw.standard.ChopBoxConnector REF 19
            org.nlogo.sdm.gui.WrappedRate "; Not all Q-cells will be converted to P-cells,\n; Some of them may stay as they are or Die -\n; because of various reasons ( Tissue hypoxia,\n; Tissue malnutrition..etc).\n\nDeathRate2 * Q" "Death-of-Q" REF 4 REF 20 0
        org.nlogo.sdm.gui.RateConnection 3 689 393 661 423 634 454 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 19
            org.jhotdraw.figures.ChopEllipseConnector
                org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 609 449 30 30
            org.nlogo.sdm.gui.WrappedRate "; Death cells are removed from the body.\n\nlambda * D" "Remove-D" REF 20
                org.nlogo.sdm.gui.WrappedReservoir  0   REF 32
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 684 4 50 50
            org.nlogo.sdm.gui.WrappedConverter "; Rate at which the P-cells stop dividing.\n\nKpq" "StopRate"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 691 166 50 50
            org.nlogo.sdm.gui.WrappedConverter "; Rate at which Q-cells become P-cells\n\nKqp" "ConversionRate"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 303 97 50 50
            org.nlogo.sdm.gui.WrappedConverter "; Rate at which the proliferating cells -\n; are produced from the body.\n\nKpp" "ProductionRate"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 400 247 50 50
            org.nlogo.sdm.gui.WrappedConverter "; Rate at which P-cells dies.\n\nKpd" "DeathRate1"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 944 301 50 50
            org.nlogo.sdm.gui.WrappedConverter "; Rate at which Q-cells dies.\n\nKqd" "DeathRate2"
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 421 477 50 50
            org.nlogo.sdm.gui.WrappedConverter "; Rate of dead cells removal\nL" "lambda"
        org.nlogo.sdm.gui.BindingConnection 2 352 122 461 123 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 39
            org.nlogo.sdm.gui.ChopRateConnector REF 10
        org.nlogo.sdm.gui.BindingConnection 2 501 123 461 123 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.nlogo.sdm.gui.ChopRateConnector REF 10
        org.nlogo.sdm.gui.BindingConnection 2 585 123 781 119 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.nlogo.sdm.gui.ChopRateConnector REF 5
        org.nlogo.sdm.gui.BindingConnection 2 978 116 781 119 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.nlogo.sdm.gui.ChopRateConnector REF 15
        org.nlogo.sdm.gui.BindingConnection 2 980 148 869 238 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.nlogo.sdm.gui.ChopRateConnector REF 25
        org.nlogo.sdm.gui.BindingConnection 2 566 156 630 242 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.nlogo.sdm.gui.ChopRateConnector REF 21
        org.nlogo.sdm.gui.BindingConnection 2 720 42 781 119 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 35
            org.nlogo.sdm.gui.ChopRateConnector REF 5
        org.nlogo.sdm.gui.BindingConnection 2 727 177 781 119 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 37
            org.nlogo.sdm.gui.ChopRateConnector REF 15
        org.nlogo.sdm.gui.BindingConnection 2 955 314 869 238 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 43
            org.nlogo.sdm.gui.ChopRateConnector REF 25
        org.nlogo.sdm.gui.BindingConnection 2 446 268 630 242 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 41
            org.nlogo.sdm.gui.ChopRateConnector REF 21
        org.nlogo.sdm.gui.BindingConnection 2 689 393 661 423 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 19
            org.nlogo.sdm.gui.ChopRateConnector REF 29
        org.nlogo.sdm.gui.BindingConnection 2 464 495 661 423 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 45
            org.nlogo.sdm.gui.ChopRateConnector REF 29
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 379 28 50 50
            org.nlogo.sdm.gui.WrappedConverter "; This is also called carrying capacity\n; This constant will restrict the growth of tumor\n\nTheta" "Capacity"
        org.nlogo.sdm.gui.BindingConnection 2 415 66 461 123 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 83
            org.nlogo.sdm.gui.ChopRateConnector REF 10
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 908 405 50 50
            org.nlogo.sdm.gui.WrappedConverter "; Total number of cells.\n; Note that Total => capacity or \n; Total =< capacity\n\nP + Q + D" "Total"
        org.nlogo.sdm.gui.BindingConnection 2 425 56 781 119 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 83
            org.nlogo.sdm.gui.ChopRateConnector REF 15
        org.nlogo.sdm.gui.BindingConnection 2 425 56 781 119 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 83
            org.nlogo.sdm.gui.ChopRateConnector REF 5
        org.nlogo.sdm.gui.BindingConnection 2 781 119 924 413 NULL NULL 0 0 0
            org.nlogo.sdm.gui.ChopRateConnector REF 15
            org.jhotdraw.contrib.ChopDiamondConnector REF 88
        org.nlogo.sdm.gui.BindingConnection 2 630 242 917 420 NULL NULL 0 0 0
            org.nlogo.sdm.gui.ChopRateConnector REF 21
            org.jhotdraw.contrib.ChopDiamondConnector REF 88
        org.nlogo.sdm.gui.BindingConnection 2 869 238 926 411 NULL NULL 0 0 0
            org.nlogo.sdm.gui.ChopRateConnector REF 25
            org.jhotdraw.contrib.ChopDiamondConnector REF 88
        org.nlogo.sdm.gui.BindingConnection 2 461 123 917 420 NULL NULL 0 0 0
            org.nlogo.sdm.gui.ChopRateConnector REF 10
            org.jhotdraw.contrib.ChopDiamondConnector REF 88
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
