globals [ ; general globals
  healthy
  infected
  dead
  total-infected
]
breed [people person]
breed [cities city] ; megacities with over 10 million people
breed [infecthalo infects] ; highlights patient zero
people-own [
  mode ; 0 (human) or "plane" (plane)
  destination ; for when mode = "plane", decides what city to land at
  ; infection variables
  infected? ; true (yes) or 0 (no)
  time-till-symptoms ; decided by avg.-incubation-period and incubation-period-range
  symptom-length ; days till recover or die, decided by symptom-length-(lowest/highest)
  reproductive-ratio ; how many people someone with the disease can spread it to? decided by avg.-reproductive-ratio and reproductive-ratio-range
  die-from-disease? ; how long till die? true or false (will recover)
  got-disease? ; if someone gets and recovers from disease, true or 0 (false)
]
cities-own [
  name
  population
]

extensions [import-a fetch]

to Setup
  ca ; clears everything
  reset-ticks ; resets clock
  decide-disease-variables
  make-cities
  import-pcolors "oly.png"; image seen in background gets loaded in (must be in same folder)
  ask patches with [pcolor >= 8.1 and pcolor <= 8.3] [set pcolor 7.8] ; make more patches land
  ask patches with [pcolor >= 7.2 and pcolor <= 7.5] [set pcolor 7.8] ; make more patches land
  ask patches with [pcolor = 7.8] [if count neighbors with [pcolor = 7.8] = 0 [set pcolor 7]] ; so turtles don't get stuck on single patches of land
  ask patches with [pxcor > max-pxcor - 4 or pxcor < min-pxcor + 4 or pcolor = 39.9] [set pcolor 9.9] ; so more of white is water
  set-default-shape people "person"
  set-default-shape infecthalo "thin ring"
  let pre-move 100
  while [pre-move > 0] [ ; people move out from cities for (pre-move) number of cycles
    ask people [move]
    set pre-move pre-move - 1
  ]
  set healthy count people
  first-infected ; patient zero setup
end

to decide-disease-variables ; depending on disease, inputs variables automatically
  if disease-variables = "COVID-19" [
    set patient0-x 0
    set patient0-y 0
    set fatality-rate 2
    set avg.-reproductive-ratio 6
    set reproductive-ratio-range 1
    set avg.-incubation-period 5      ;
    set incubation-period-range 5
    set symptom-length-lowest 14
    set symptom-length-highest 21
    set get-again? true
  ]
  if disease-variables = "Measles" [
    set patient0-x -254
    set patient0-y 5
    set fatality-rate 10
    set avg.-reproductive-ratio 15
    set reproductive-ratio-range 3
    set avg.-incubation-period 14
    set incubation-period-range 14
    set symptom-length-lowest 7
    set symptom-length-highest 14
    set get-again? false
  ]
  if disease-variables = "Ebola" [
    set patient0-x -9
    set patient0-y -55
    set fatality-rate 50
    set avg.-reproductive-ratio 2
    set reproductive-ratio-range .5
    set avg.-incubation-period 10
    set incubation-period-range 8
    set symptom-length-lowest 8
    set symptom-length-highest 10
    set get-again? false
  ]
end

to make-cities
  create-cities 43 [
    set size 3
    set shape "circle"
    set color black
    set label-color black
    if who = 0 [ set name "School" set population .0002 setxy 0 0] ; populations rounded to nearest half million
    if who = 1 [ set name "Armington" set population .0001 setxy 45 -13]
    if who = 2 [ set name "Seoul" set population .0001 setxy 67 77]
    if who = 3 [ set name "Shanghai" set population .0001 setxy 86 -37]
    if who = 4 [ set name "Mumbai" set population .0001 setxy 57 -33]
    if who = 5 [ set name "Mexico City" set population .0001 setxy -61 -28]
    if who = 6 [ set name "Beijing" set population .0001 setxy 28 -84]
    if who = 7 [ set name "Sao Paulo" set population .0001 setxy -42 -33]
    if who = 8 [ set name "Jakarta" set population .0001 setxy 94 -85]

  ]
  let citypop sum [population] of cities
  let worldpop 7300 / #-people-per-agent ; 7.30 billion people, if each agent = 5mil people, then 1460 agents
  ask cities [
    hatch-people (round ((population / citypop * worldpop) + .02)) [ ; each city creates proportional amount of people based on population
      set infected? false
      set color green
      set size 10
      set heading random 360
    ]
  ]
end

to first-infected
  ifelse patient0-x = 0 and patient0-y = 0 ; if no patch chosen,
  [
    ask one-of people [ ; ask random person to be infected
      become-infected
      make-infecthalo
    ]
  ]
  [
    ask patch patient0-x patient0-y [ ; else, ask person closest to patch chosen
      ask min-one-of people [distance myself] [
        become-infected
        make-infecthalo
      ]
    ]
  ]
end

to make-infecthalo
  hatch-infecthalo 1 [
    set size 20
    ;; Use an RGB color to make halo three fourths transparent
    set color lput 64 extract-rgb color
    ;; set thickness of halo to half a patch
    ;; We create an invisible directed link from the runner
    ;; to the halo.  Using tie means that whenever the
    ;; runner moves, the halo moves with it.
    create-link-from myself [
      tie
      hide-link
    ]
  ]
end

;;=========================================;;

to become-infected
  set infected? true
  set infected infected + 1 ; updates appropriate globals
  if got-disease? != true [set total-infected total-infected + 1]
  set healthy healthy - 1
  set color red
  set time-till-symptoms round (avg.-incubation-period + random-float (.5 * incubation-period-range) - random-float (.5 * incubation-period-range)) ; days until can spread disease
  set symptom-length symptom-length-highest - round (random-float symptom-length-lowest) ; how long symptoms last until heal or die
  set reproductive-ratio round (avg.-reproductive-ratio + random-float (.5 * reproductive-ratio-range) - random-float (.5 * reproductive-ratio-range)) ; number of people that infected can infect
  ifelse random 100 < fatality-rate ; determines if will die from disease
  [
    set die-from-disease? true
  ]
  [
    set die-from-disease? false
  ]
end

to become-healthy
  set infected? false
  set healthy healthy + 1 ; updates appropriate globals
  set infected infected - 1
  set color green
  set got-disease? true
end

to become-dead
  set dead dead + 1 ; updates appropriate globals
  set infected infected - 1
  die ; a dead agent ceases to exist
end

;;=========================================;;

to StartVirus
  city-selector ; visual to show city name
  ask people with [mode = 0] [
    move
    if infected? [ ; red person
      if time-till-symptoms = 0 [
        infect
        if symptom-length = 0 [
          ifelse die-from-disease?
          [
            become-dead
          ]
          [
            become-healthy
          ]
        ]
        if symptom-length > 0 [
          set symptom-length symptom-length - 1
        ]
      ]
      if time-till-symptoms > 0 [
        set time-till-symptoms time-till-symptoms - 1
      ]
    ]
  ]
  ask people with [mode = "plane"] [
    fd 10
    if distance destination <= 5 [ ; turn into person if close to city
      set mode 0
      set size 4
      move-to destination
      set destination 0
      set shape "person"
      set heading random 360
    ]
  ]
  ask cities [
    attract
    airport-run
  ]
  ask infecthalo [
    if infected != 1 [
      die
    ]
  ]
  tick
  wait .005
end

to city-selector
  ask patch mouse-xcor mouse-ycor [ ; if mouse is over city, display name
    let x (cities in-radius 3)
    if any? x [
      ask x [
        set label name
        if mouse-down? [; if mouse clicks on city, displays city info
          clear-output
          output-print name
          output-type "Population = " output-type population output-print " million"
        ]
      ]
    ]
    ask cities with [label != "" and distance myself > 3] [ ; if mouse goes off city that is displaying info, resets
      set label ""
      clear-output
    ]
  ]
end

to move
  if random 2 = 0 [ ; 50% chance to change direction
    set heading heading + random 20 - random 20 ; change direction
  ]
  while [patch-ahead 1 = nobody or [pcolor] of patch-ahead 1 = 9.9] [ ; change direction if water is ahead
    set heading heading + random 20 - random 20
  ]
  fd 1 ; moves forword a patch per day
  if distance min-one-of cities [distance myself] > 50 [ ; if too far from cities, face closest city
    face min-one-of cities [distance myself]
  ]
end

to infect
  let x people in-radius 2 with [infected? = false and mode = 0] ; who can be infected
  if get-again? = false [ ; if disease cannot infect a person more than once, new restraint
    set x people in-radius 2 with [infected? = false and mode = 0 and got-disease? = 0]
  ]
  if any? x and reproductive-ratio > 0 [ ; if any people to infect and can infect more people
    ifelse count x <= reproductive-ratio ; if less people to infect than can infect
    [ ; infect those people and reduce reproductive-ratio
      set reproductive-ratio reproductive-ratio - count x
      ask x [
        become-infected
      ]
    ]
    [ ; else infect all people possible and set reproductive ratio 0
      ask n-of reproductive-ratio x [
        become-infected
      ]
      set reproductive-ratio 0
    ]
  ]
end

to attract
  if count people with [mode = 0] in-radius 5 < population / 10  and count people with [mode = 0] > population / 10[ ; if less people in-radius than population,
    ask min-n-of (population / 10 - count people with [mode = 0] in-radius 5) people with [mode = 0] [distance myself] [ ; ask closest people to face city
      face myself
    ]
  ]
end

to airport-run
  if random 175 = 0 and count people with [mode = 0] in-radius 5 > population / 40 [ ; random chance to create airplane
    ask one-of people with [mode = 0] in-radius 5 [
      set mode "plane"
      set shape "airplane"
      set size 5
      set destination one-of cities
      face destination
    ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
623
424
-1
-1
1.0113
1
10
1
1
1
0
1
0
1
-200
200
-200
200
0
0
1
Days
30.0

BUTTON
10
10
74
43
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
95
10
182
43
Run
if ticks < 1825[startvirus]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
945
250
1085
295
Healthy
Healthy * #-people-per-agent
17
1
11

MONITOR
945
300
1085
345
Infected
Infected * #-people-per-agent
17
1
11

PLOT
945
10
1380
245
Healthy VS Infected
Time (days)
Number People (millions)
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Healthy" 1.0 0 -10899396 true "" "plot healthy * #-people-per-agent"
"Infected" 1.0 0 -2674135 true "" "plot infected * #-people-per-agent"
"Dead" 1.0 0 -7500403 true "" "plot dead * #-people-per-agent"
"Total Infected" 1.0 0 -955883 true "" "plot total-infected * #-people-per-agent"

MONITOR
1095
250
1152
295
Years
ticks / 365
3
1
11

MONITOR
945
350
1085
395
Dead
dead * #-people-per-agent
17
1
11

MONITOR
5
580
120
625
Total Turtles
count people + dead
17
1
11

INPUTBOX
10
400
75
460
patient0-x
0.0
1
0
Number

INPUTBOX
85
400
150
460
patient0-y
0.0
1
0
Number

CHOOSER
10
60
115
105
Disease-Variables
Disease-Variables
"COVID-19" "Measles" "Ebola"
0

SLIDER
10
115
205
148
fatality-rate
fatality-rate
0
100
2.0
1
1
%
HORIZONTAL

SLIDER
10
155
205
188
avg.-reproductive-ratio
avg.-reproductive-ratio
0
25
6.0
.5
1
NIL
HORIZONTAL

SLIDER
10
235
205
268
avg.-incubation-period
avg.-incubation-period
0
15
5.0
.1
1
days
HORIZONTAL

SLIDER
10
275
205
308
incubation-period-range
incubation-period-range
0
20
5.0
.5
1
days
HORIZONTAL

SLIDER
10
315
205
348
symptom-length-lowest
symptom-length-lowest
0
20
14.0
1
1
days
HORIZONTAL

SLIDER
10
355
205
388
symptom-length-highest
symptom-length-highest
0
30
21.0
1
1
days
HORIZONTAL

SLIDER
10
195
205
228
reproductive-ratio-range
reproductive-ratio-range
0
5
1.0
.5
1
NIL
HORIZONTAL

SWITCH
10
470
115
503
get-again?
get-again?
0
1
-1000

SLIDER
5
540
192
573
#-people-per-agent
#-people-per-agent
1
10
10.0
1
1
NIL
HORIZONTAL

MONITOR
945
400
1085
445
Total Infected
total-infected * #-people-per-agent
17
1
11

@#$#@#$#@
It's important to note that the time metric is not very useful for this specific metric - the model only provides examples of how COVID spreads on a network.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

thin ring
true
0
Circle -7500403 false true 0 0 300

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
