;;;;;;;;;;;;;set breeds and global variables;;;;;;;;;;
breed [females female]
breed [males male]


turtles-own [age]
globals [
  attribute
  isolation?
         environ?
          iso-position ]


;;;;;;;;;;;;;reporter;;;;;;;;;;;;;;;;;;

to-report years
  report ticks / 100
end

to-report front-color
  report [pcolor] of (patch-ahead 1)
end

to-report upper-tt-color
ifelse any? turtles with [ycor > iso-position] [report mean [color] of turtles with [ycor > iso-position]][report 0]
end

to-report down-tt-color
ifelse any? turtles with [ycor < iso-position] [report mean [color] of turtles with [ycor < iso-position]][report 0]
end

to-report diff-bk
report abs (color - pcolor)
end

;to-report max-tt
;report (max-pxcor * max-pycor)
;end


;;;;;;;;;;;;;;;;;set up;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to reset
 set Number-of-visual-predators 0
 set heritable-color? true
 set Initial-fish-color-variation 7
 set mutation-rate 1
 set Strength-of-mating-preference 0
 set Dispersal 0.01
end

to setup
clear-all
set iso-position 0
setup-patches

set-default-shape females "fish-2"
set-default-shape males "fish-2"
create-females 50
[set size 1.75
 set color 81 + random-float Initial-fish-color-variation
 set age random 10
 setup-position]
create-males 50
[set size 1.75
 set color 81 + random-float Initial-fish-color-variation
 set age random 10
 setup-position]

set isolation? false
set environ? false
reset-ticks
do-plot1
;do-plots
end

to setup-patches
ask patches [set pcolor 82.5]
;ask patches with [abs pxcor = max-pxcor]  [set pcolor 35]
;ask patches with [abs pycor = max-pycor]  [set pcolor 35]

end

to setup-position
setxy random-xcor random-ycor
if pcolor = 35
[setup-position]
end

to set-isolation
ask patches [if (abs pycor = max-pycor) or (abs pxcor = max-pxcor) or (pycor = iso-position) or (pycor = iso-position - 1 ) or (pycor = iso-position )  [set pcolor 35]]
set isolation? true
;do-plots
end

to set-environ
ask patches
[if isolation? [if abs pxcor < max-pxcor and abs pycor < max-pycor and pycor > iso-position    [set pcolor 87.5]
                if abs pxcor < max-pxcor and abs pycor < max-pycor and pycor < iso-position - 1   [set pcolor 82.5]]]
set environ? true
end

to set-environ-1
ask patches
[if abs pxcor <= max-pxcor and abs pycor <= max-pycor and pycor >= iso-position    [set pcolor 87.5]
                if abs pxcor <= max-pxcor and abs pycor <= max-pycor and pycor <= iso-position - 1   [set pcolor 82.5]]
set environ? true
end

to initial
setup-patches
set isolation? false
set environ? false
if abs (upper-tt-color - down-tt-color) > 3.5
[let mid-color (upper-tt-color + down-tt-color) / 2
  ask turtles with [color > (mid-color - 1.75) and color < (mid-color + 1.75 )] [die]]
end


;;;;;;;;;;;;;go;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to go
  tick

if (count turtles > max-lake-capacity * 3) or (not any? turtles) [stop]

ask turtles
[move
  if pcolor = 35 [die]]
growth
mating
over-repro
diff-survival
if ticks > years-to-run * 100  [user-message "The year has reached the defined value. Click 'setup' to restart the experiment or extend the number of years." stop]

if isolation? [if (count turtles with [pycor > iso-position]) = 0 [user-message "One of the subpopulation has gone extinct." stop]
               if (count turtles with [pycor < iso-position]) = 0 [user-message "One of the subpopulation has gone extinct." stop]
                              ]

;if isolation? [do-plots]
do-plot1
end




to diff-survival
ask turtles
 [if random 20 = 0 [if random-float 1000 < (diff-bk * Number-of-visual-predators * 0.5) ^ 2  [die]]]
end

to move
    ifelse front-color = 35 [rt random 360]
                            [ifelse random 50 = 0 [rt random 90 lt random 90 ifelse front-color = 35 [rt random 360]
                                                                                                 [;fd 0.05
                                                                                                   fd Dispersal]]
                                              [;fd 0.05
                                                fd Dispersal]]

end

to growth
ask turtles
[ifelse age > 20
  [die]
  [set age age + 0.01]
  if pcolor = 35 [die]]
end

to mating
ask females with [age > 1]
[if random 30 = 0

[let partner one-of males-on neighbors                     ;;find a male adult turtle here
   if (partner != nobody) and ([age] of partner > 1) and (abs (color - [color] of partner) <= (3.5 - Strength-of-mating-preference))      ;;if there is one and same species
       [ifelse random 2 = 0
         [hatch-females 1 [ifelse heritable-color?
                           [set age 0
                           ifelse random-float 200 < mutation-rate [ifelse random 2 = 0 [set color ((color + [color] of partner) / 2) + random-float 2]
                                                                                        [set color ((color + [color] of partner) / 2) - random-float 2] ]
                                                                   [set color (color + [color] of partner) / 2]
                           if color >= 89 [set color 88.5]
                           if color <= 81 [set color 81.5]
                                 ]
                           [set age 0 set color 81 + random-float Initial-fish-color-variation]
                           move
                           ]]
         [hatch-males 1 [ifelse heritable-color?
                          [set age 0
                         ifelse random-float 200 < mutation-rate [ifelse random 2 = 0 [set color ((color + [color] of partner) / 2) + random-float 2]
                                                                                      [set color ((color + [color] of partner) / 2) - random-float 2] ]
                                                                 [set color (color + [color] of partner) / 2]
                         if color >= 89 [set color 88.5]
                         if color <= 81 [set color 81.5]
                           ]
                          [set age 0 set color 81 + random-float Initial-fish-color-variation]
                        move
                         ]]]]
  ]
end

to over-repro
ifelse (isolation? or environ?) ;if barrier or different environments, no compete between different geo population
       [ask turtles with [ycor > iso-position]
             [if count turtles with [ycor > iso-position] > (max-lake-capacity / 2) [if random 2 = 0 [die]]]
        ask turtles with [ycor < iso-position]
             [if count turtles with [ycor <= iso-position] > (max-lake-capacity / 2) [if random 2 = 0 [die]]]]
       [ask turtles [if count turtles > max-lake-capacity [if random 2 = 0 [die]]]]
ifelse (Strength-of-mating-preference > 0)               ;if sexual selection, no compete between different color population
       [ask turtles with [color > 84.5]
         [if count turtles with [color > 84.5] > (max-lake-capacity / 2) [if random 2 = 0 [die]]]
        ask turtles with [color <= 84.5]
         [if count turtles with [color <= 84.5] > (max-lake-capacity / 2) [if random 2 = 0 [die]]]]
       [ask turtles [if count turtles > max-lake-capacity [if random 2 = 0 [die]]]]
end

to do-plots
set-current-plot "Average Fish Colors in Upper & Lower Areas"
set-current-plot-pen "upper area"
plot upper-tt-color
set-current-plot-pen "lower area"
plot down-tt-color
end

to do-plot1
set-current-plot "Fish Color Distribution"
set-plot-x-range 80 90
set-plot-y-range 0 round (count turtles / 5)
histogram [color] of turtles
end

;Developed by Lin Xiang  contact info:lin.xiang@uky.edu
@#$#@#$#@
GRAPHICS-WINDOW
8
10
376
379
-1
-1
8.0
1
10
1
1
1
0
1
1
1
-22
22
-22
22
0
0
0
Years
20.0

BUTTON
388
294
491
362
Set up/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
495
294
611
327
Run/Pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
386
151
578
184
mutation-rate
mutation-rate
0
20
7.0
1
1
/200
HORIZONTAL

SLIDER
387
220
615
253
Number-of-visual-predators
Number-of-visual-predators
0
10
5.0
1
1
NIL
HORIZONTAL

PLOT
8
382
377
589
Fish Color Distribution
Color
Number of fish
80.0
90.0
0.0
200.0
true
false
"" ""
PENS
"color" 0.05 1 -5825686 true "" ""

BUTTON
589
150
736
185
Isolate populations
set-isolation
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
386
115
578
148
Initial-fish-color-variation
Initial-fish-color-variation
0
7
7.0
1
1
NIL
HORIZONTAL

MONITOR
606
382
707
427
Total # of Fish
count turtles
1
1
11

TEXTBOX
34
589
77
607
Darker
12
0.0
0

TEXTBOX
335
590
384
608
Lighter
12
0.0
0

BUTTON
495
329
611
362
Run a year
repeat 100 [go]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
385
42
551
75
max-lake-capacity
max-lake-capacity
0
600
200.0
10
1
NIL
HORIZONTAL

MONITOR
710
382
807
427
Years
ceiling ticks / 100
1
1
11

BUTTON
746
113
908
148
Differentiate environment
ifelse isolation? [set-environ][set-environ-1]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SWITCH
565
42
727
75
heritable-color?
heritable-color?
0
1
-1000

BUTTON
746
150
908
184
Reassemble Populations
initial
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
589
114
736
147
Dispersal
Dispersal
0.01
0.08
0.01
0.01
1
NIL
HORIZONTAL

SLIDER
624
220
853
253
Strength-of-mating-preference
Strength-of-mating-preference
0
3
0.0
0.5
1
NIL
HORIZONTAL

INPUTBOX
745
23
848
83
Years-to-run
100.0
1
0
Number

BUTTON
615
294
720
363
Clear settings
reset
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
387
96
575
114
Variation:
11
105.0
1

TEXTBOX
565
26
646
44
Heritability:
11
105.0
1

TEXTBOX
387
203
575
221
Nature Selection:
11
105.0
1

TEXTBOX
624
201
812
219
Sexual selection:
11
105.0
1

TEXTBOX
590
96
676
114
Gene flow:
11
105.0
1

TEXTBOX
746
10
805
28
Time:
11
105.0
1

TEXTBOX
384
10
717
28
Factors:---------------------------------------
12
13.0
1

MONITOR
607
477
807
522
Average Lower Fish Color
mean [color] of turtles with [pycor < 0]
2
1
11

MONITOR
607
430
807
475
Average Upper Fish color
mean [color] of turtles with [pycor > 0]
2
1
11

TEXTBOX
746
97
896
115
Environment:
11
105.0
1

TEXTBOX
385
269
724
287
Control:-----------------------------------------
12
13.0
1

PLOT
380
382
604
589
Population Size
Years
Number of Fish
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -13791810 true "" "plotxy years count turtles"

BUTTON
725
294
868
327
Watch a fish agent
let me one-of turtles\nset attribute [color] of me\nwatch me\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
607
543
806
588
Color of watched fish
attribute
2
1
11

BUTTON
725
329
868
362
Stop watching
set attribute 0\nrp
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

@#$#@#$#@
## WHAT IS IT?

This module simulates the coloration evolution of a fish population influenced by various factors. You can create a boundary to divide the population, differentiate the environment, as well as adjust various factors, and then observe what happens to the fish color distribution over time.    (Refined 15th March 2019)

## HOW IT WORKS

First, press on the "setup" button, then press on "run/pause" button to run the simulation. When the simulation starts, you should see a population of fish swimming in a lake, represented by a dark blue background. The fish are given a random age from 0 to 9. Each fish executes the same set of behavioral rules: 1) moving, 2) growth and death, 3) reproduction, and 4) survival.

Rule 1-Moving: Fish swims in the simulated lake. When fish encounters a boundary, it resets its direction and moves away. 

Rule 2-Growth and death: Fish's age increases every hypothetic year. The fish older than 20 disappear from the simulation; namely, they die.

Rule 3-Reproduction: In each "year," each female RANDOMLY chooses a male from the adjacent area as the mate and reproduces offspring. Most of the offspring fish's color is the average of their parents. In a chance determined by the slider "mutation-rate," a mutant is produced with either a lighter or darker color in comparison with the average parent color. The female preference is controlled by "strength-of-preference." The higher is the preference strength, the more does the female prefers a male with a color similar to her. 

Rule 4-Survival: In this module, the more different is the fish color from the background, the more likely is it to become prey. The slider "number-of-visual-predators" enables you to adjust the strength of predation pressure.

Rule 5-Overpopulation: The maximum capacity of the lake is determined by the slider "max-lake-capacity." If the number of fish exceeds the maximum, every fish has a 50% chance of dying regardless of its gender, age, or color.


## HOW TO USE IT

1- Setup the starting conditions of the simulation.  By pulling the bar of the corresponding sliders, you may set or adjust five conditions of the simulation.

    fish-color-variation:	The initial variation range of fish coloration
    heritable-color?		Whether the fish color is heritable
    mutation-rate:		The mutation rate of fish population
    max-lake-capacity:		The maximum number of fish held by the lake
    Dispersal: 			Fish's ability to disperse in the lake per year
    number-of-visual-predators:		The environment selection rate
    Strength-of-mating-preference:	The strength that a female chooses a male with similar color
</blockquote>
2- After setting the starting conditions press the "set up/Reset" button.

3- Press the "Run/Pause" button to continuously run the simulation or pause it. Press the "Run by clicking" if you want to run simulation year by year.

4- While running the simulation, you may either 1) press the "Isolate population" button to create boundaries to divide the simulation window into upper and lower areas, or 2) press the "differentiate environments" button to set different environment colors for the upper and lower areas, or 3) press both buttons to introduce both situations at the same time.

5-You may take off boundaries and/or recover the background by pressing the "Resemble populations" button.

6-You may adjust different factor(s) while running the simulation to investigate the impact on fish color divergence.


## Related Models

Find related models at http://3dsciencemodeling.com


## CREDITS AND REFERENCES
This module is made by Dr. Lin Xiang at the University of Kentucky. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2017). Speciation mechanisms. Department of STEM Education, University of Kentucky, Lexington, KY.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123
Line -16777216 false 18 89 45 60
Line -16777216 false 45 60 105 75
Line -16777216 false 103 75 181 65
Line -16777216 false 181 66 197 68
Line -16777216 false 197 68 249 55
Line -16777216 false 250 53 298 98
Line -16777216 false 298 98 297 104
Line -16777216 false 299 97 285 129
Line -16777216 false 285 128 253 127
Line -16777216 false 253 127 246 125
Line -16777216 false 245 124 229 170
Line -16777216 false 229 169 205 194
Line -16777216 false 205 194 200 254
Line -16777216 false 200 253 174 253
Line -16777216 false 173 252 171 199
Line -16777216 false 170 198 163 195
Line -16777216 false 164 194 93 198
Line -16777216 false 93 198 82 190
Line -16777216 false 82 190 79 209
Line -16777216 false 78 207 93 253
Line -16777216 false 93 254 55 251
Line -16777216 false 54 250 40 208
Line -16777216 false 39 208 40 178
Line -16777216 false 39 177 35 165
Line -16777216 false 34 161 24 221
Line -16777216 false 19 90 19 111
Line -16777216 false 20 112 10 192
Line -16777216 false 22 221 2 203
Line -16777216 false 2 202 11 191

cow 1
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123
Line -16777216 false 18 89 45 60
Line -16777216 false 45 60 105 75
Line -16777216 false 103 75 181 65
Line -16777216 false 181 66 197 68
Line -16777216 false 197 68 249 55
Line -16777216 false 250 53 298 98
Line -16777216 false 298 98 297 104
Line -16777216 false 299 97 285 129
Line -16777216 false 285 128 253 127
Line -16777216 false 253 127 246 125
Line -16777216 false 245 124 229 170
Line -16777216 false 229 169 205 194
Line -16777216 false 205 194 200 254
Line -16777216 false 200 253 174 253
Line -16777216 false 173 252 171 199
Line -16777216 false 170 198 163 195
Line -16777216 false 164 194 93 198
Line -16777216 false 93 198 82 190
Line -16777216 false 82 190 79 209
Line -16777216 false 78 207 93 253
Line -16777216 false 93 254 55 251
Line -16777216 false 54 250 40 208
Line -16777216 false 39 208 40 178
Line -16777216 false 39 177 35 165
Line -16777216 false 34 161 24 221
Line -16777216 false 19 90 19 111
Line -16777216 false 20 112 10 192
Line -16777216 false 22 221 2 203
Line -16777216 false 2 202 11 191

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

fish-1
true
0
Polygon -16777216 true false 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Polygon -6459832 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -6459832 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -6459832 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 29 133 150 74 225 78 279 116 291 143 291 157 286 167 269 192 194 207 150 209 29 163
Circle -16777216 true false 215 106 30

fish-2
true
0
Polygon -16777216 true false 154 14 139 29 124 59 109 104 109 134 154 269 199 134 199 104 184 59 169 29 154 14
Polygon -7500403 true true 150 15 135 30 120 60 105 105 105 135 150 270 195 135 195 105 180 60 165 30 150 15
Polygon -16777216 true false 153 80 139 174 151 156
Polygon -1 true false 195 105 210 165 195 135
Polygon -1 true false 105 105 90 165 105 135
Polygon -1 true false 150 211 111 294 142 270 154 281 150 211

fish-3
true
0
Polygon -7500403 true true 151 21 135 30 120 60 105 105 105 135 150 269 195 135 195 105 180 60 165 30 151 22
Polygon -1 true false 195 105 210 165 195 135
Polygon -1 true false 105 105 90 165 105 135
Polygon -1 true false 150 211 111 294 142 270 154 281 150 211
Polygon -6459832 true false 148 83 148 68 176 77 148 82
Polygon -6459832 true false 152 83 152 68 124 77 152 82
Polygon -6459832 true false 150 116 150 101 182 109 150 115
Polygon -6459832 true false 150 115 150 101 119 110 149 114
Polygon -6459832 true false 150 145 150 130 181 139 150 144
Polygon -6459832 true false 151 145 151 130 120 139 151 144
Polygon -6459832 true false 149 172 150 160 171 167 149 172
Polygon -6459832 true false 151 172 150 160 129 167 151 172
Polygon -16777216 true false 151 66 140 198 150 164

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

frog 1
true
0
Polygon -7500403 true true 146 18 135 30 119 42 105 90 90 150 105 195 135 225 165 225 195 195 210 150 195 90 180 41 165 30 155 18
Polygon -7500403 true true 91 176 67 148 70 121 66 119 61 133 59 111 53 111 52 131 47 115 42 120 46 146 55 187 80 237 106 269 116 268 114 214 131 222
Polygon -7500403 true true 185 62 234 84 223 51 226 48 234 61 235 38 240 38 243 60 252 46 255 49 244 95 188 92
Polygon -7500403 true true 115 62 66 84 77 51 74 48 66 61 65 38 60 38 57 60 48 46 45 49 56 95 112 92
Polygon -7500403 true true 200 186 233 148 230 121 234 119 239 133 241 111 247 111 248 131 253 115 258 120 254 146 245 187 220 237 194 269 184 268 186 214 169 222
Circle -16777216 true false 157 38 18
Circle -16777216 true false 125 38 18
Polygon -16777216 false false 60 30 76 34 79 38 84 46 90 60 107 59 117 37 150 8 184 38 191 58 210 60 217 48 227 37 232 32 239 32 247 41 254 44 260 51 247 100 204 97 214 128 218 135 226 116 236 105 255 106 264 119 251 189 224 245 194 278 176 275 166 233 133 234 131 234 123 273 102 277 73 240 46 188 33 119 44 104 62 105 75 119 82 135 97 98 52 99 39 50 51 40

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="3" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="500"/>
    <metric>mean [color] of turtles</metric>
    <enumeratedValueSet variable="num-fish">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="selection-rate">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fish-color-variation">
      <value value="1"/>
      <value value="2"/>
      <value value="3"/>
      <value value="4"/>
      <value value="5"/>
      <value value="6"/>
      <value value="7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="8"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
