breed [roads road]
breed [households household]

households-own [ income ]

globals [
  formal-patches          ;; agentset of green patches representing the formal sites
  informal-patches        ;; agentset of blue patches representing the informal site
  mainways                ;; agentset for roads surronding informal-patches
]


to setup
  ca
  set-default-shape households "house"
  set-default-shape roads "square 2"


  set formal-patches patches with [pxcor < 3]
  ask formal-patches [ set pcolor green ]

  set informal-patches patches with [pxcor > 3 and pycor > 0 and pxcor < 36 and pycor < 36]
  ask informal-patches [ set pcolor blue ]

  set mainways patches with [pcolor = black]
                                      ;; creating formal patches and informal patches and boundary roads patches

  create-roads 138 [move-to-empty-one-of mainways]
  create-roads 5 [setxy 4 random 36]
  create-roads 5 [setxy 35 random 36]
  create-roads 5 [setxy random 36 1]
  create-roads 5 [setxy random 36 35]
  ask roads [if pcolor = green [die]]
  ask roads [set color grey]
                                       ;; creating roads agents as single line

  create-households initial-population [ set color brown
    move-to-empty-one-of informal-patches
    set income random 30 + 15
  ]                                  ;; creating intial houses as slider
                                     ;; creating inital income for households

  display-labels
  reset-ticks

end

to move-to-empty-one-of [locations]                  ;; turtle procedure
  move-to one-of locations
  while [any? other turtles-here] [
    move-to one-of locations
  ]
end

to go


  ask households [
    set income income + income-growth + 2 - random 5   ;distributing growth in range of numbers
  ]                                                   ;; distribute income in household as per income gowth

  ask households [
    if income > rich-person [
      die]
  ]                                                    ;; remove rich households from model


  ask households [if count roads-on neighbors4 >= 1 [set color pink]]



  ifelse (111 - count turtles-on formal-patches) > (count households with [income > income-threshold and color = 35])  [
    ask households [if color = brown [
      if income > income-threshold  [
        set color pink
        move-to-empty-one-of formal-patches]
  ]]]
  [ask n-of (111 - count turtles-on formal-patches) (households with [income > income-threshold and color = 35])
      [
        set color pink
          move-to-empty-one-of formal-patches]]   ; move household to formal patch acc to income threshold


  ask roads [if pcolor = blue [
    if count turtles-on neighbors4 < 4 [
      if count roads-on neighbors4 <= 3 [
        hatch-roads 1 [
          move-to-empty-one-of neighbors4
          set color grey
        ]
      ] ] ] ]


  ask roads [
    if pcolor = blue [
      if (count roads-on neighbors > 5) [die]
    ]
  ]


 ifelse in-rate < (1120 - count turtles-on informal-patches) [             ;; in-rate is less than vacant place
    create-households in-rate [
    set color brown
    move-to-empty-one-of informal-patches
    set income random 15 + 15                                                ;; add household from in rate
  ]] [ create-households (1120 - count turtles-on informal-patches) [
    set color brown
    move-to-empty-one-of informal-patches
    set income random 15 + 15                                               ;; add household from in rate
  ]]

  ask households [if count roads-on neighbors4 >= 1 [set color pink]]
  ask households [if pcolor = blue [
    if count roads-on neighbors4 = 0 [set color brown]]]

  if count households with [color = 35] = 0 [stop]


  display-labels

  tick
end



to display-labels
  ask households [ set label "" ]
  if show-income [
    ask households [ set label round income ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
403
10
892
500
-1
-1
13.0
1
10
1
1
1
0
0
0
1
0
36
0
36
0
0
1
ticks
30.0

BUTTON
60
15
123
48
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
155
15
232
48
Go once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
15
55
187
88
initial-population
initial-population
10
1100
755.0
5
1
NIL
HORIZONTAL

SLIDER
15
95
187
128
in-rate
in-rate
0
100
40.0
1
1
NIL
HORIZONTAL

SLIDER
15
135
187
168
income-growth
income-growth
2
20
20.0
1
1
NIL
HORIZONTAL

SLIDER
15
175
187
208
income-threshold
income-threshold
50
200
80.0
10
1
NIL
HORIZONTAL

PLOT
8
259
393
454
Neighborhood Stats
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"houses formal" 1.0 0 -13840069 true "" "plot count households-on formal-patches"
"roads" 1.0 0 -14477296 true "" "plot count roads"
"house brown" 1.0 0 -6459832 true "" "plot count households with [color = brown]"
"house pink" 1.0 0 -5825686 true "" "plot count households with [color = pink]"

BUTTON
265
15
328
48
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
225
195
352
228
show-income
show-income
0
1
-1000

SLIDER
15
215
187
248
rich-person
rich-person
200
2000
320.0
10
1
NIL
HORIZONTAL

MONITOR
195
65
388
110
Houses not connected to Infrastucture
count households with [color = 35]
17
1
11

MONITOR
195
130
388
175
Average income of neighborhood
mean [income] of households
2
1
11

@#$#@#$#@
## MODEL SCOPE
This is an exploratory model to show how houses in the informal settlement can become better by connecting to the infrastructure network. Income is taken as property for households to choose to move to some affordable housing or move out from the place, creating space for building infrastructure networks and serving growing populating. The dynamics of growth, migration, and choices by income are explored in this model.

This is a model simulates the way to create access networks (i.e creating roads) without evicting any single household for better distribution of urban services in the neighborhood. This model assumes income as people's choice to move to an affordable house on formal land and move out of the neighborhood when becoming rich.

This model allows you to input initial houses and their income growth per tick and growth of houses per tick and income-threshold for moving to affordable formal land. And at what income household will be called a rich person.

## Agents and their properties and their action

There are two breeds of agents in the model with the following properties

### Roads :
 Roads create more roads to its left, right, top, bottom patches and remove itself if there are more than 5 road units in its neighboring patches.

### Households :
 Households are houses in the model, households have properties as
#### a. income : 
income make choice to move to affordable housing (income-threshold) or move out from neighborhood (rich-person)
#### b. color  :
 brown color denotes houses not connected to roads(i.e infrastructure network) and pink color denoted houses connected to infrastructure network or in affordable housing and pink houses don't move to affordable housing

## Environment

 The environment is created by setting up formal patches (for affordable housing) in green, informal patches in blue, boundary roads (mainways) patches in black, roads in informal patches creates a road unit to its left or right or top or bottom creating a network of roads to reach more houses inside the neighborhood, and houses turn their color pink (removes its choice to move to affordable housing) when connected to roads.

## Order of Events

In SETUP Procedure 

0. Creating everything previously on world
1. Setting formal patches with color green
2. Setting informal patches with the color blue
3. Setting boundary roads (mainways) with color black
4. Creating roads on all mainway patches
5. Creating some road units inside the boundary of informal patches
6. Creating an initial number of houses in informal settlement by taking input form slider and setting their income between 15 to 45
7. Setting labels for show-income switch
8. Resetting tick to 0

In GO procedure

1. Households increase income as income-growth ranging from -2 to +2
2. Rich households are removed from the neighborhood
3. Households connected to roads are turned pink
4. Households connected to roads are turned pink
5. Households move to formal patch if they cross income-thresholds and place is available
6. roads created roads on their right, left, top, bottom empty patches
7. roads remove itself if there are more than 5 road units on its neighbors
8. More households are being added from in-rate as space available
9. houses connected to roads turn pink
10. houses not connected to roads are turned brown

## Inputs and Outputs

### Inputs

**initial-population** creates initial number of housholds in the neighborhood

**income-growth** increases income ranging from -2 to +2

**income-threshold** Income above which households move to affordable Housing (formal-patches)

**rich-person** Income at which households move out form neighborhood (i.e die in NetLogo language)

**show-income** switch displays income labels of each households

### Outputs

Initially, there will be no houses on formal patches as many households haven't reached income-threshold to afford to move to these patches

There won't be many roads build for few steps if the initial population is too high.

There will period of bumps that stimulate road growth as a large set of households became rich together and in-rate don't fill that gap

Lower in-rate and higher income-growth completes the model faster.

There will be a period of a constantcy when formal-patches are filled and many of their household hasn't become rich enough to move out in a big bunch.

## ...
## ...
## ...
## ...



## WHAT IS IT?

This is a model simulates the way to create access networks (i.e creating roads) without evicting any single household for better distribution of urban services in the neighborhood. This model assumes income as people's choice to move to an affordable house on formal land and move out of the neighborhood when becoming rich.

This model allows you to input initial houses and their income growth per tick and growth of houses per tick and income-threshold for moving to affordable formal land. And at what income household will be called a rich person.

## HOW IT WORKS?

There is a total of 1120 informal patches surrounded by roads and 111 formal patches for affordable housing.

Initial no. of houses are created from the initial-population slider and with their income ranging between 15 and 45 in the informal settlement and some units of roads randomly on borders in informal settlement to start building road inside the place.

At each time step 

1. Household updates their income according to income-growth input. This income growth is distributed randomly between -2 to +2 of income growth to households.
2. Households whose income is greater than rich-person move out from this place (i.e. die in NetLogo language)
3. Households who are adjacent to roads turn their color pink as they are connected to an infrastructure network 
4. Households whose income is greater than income-threshold and not connected to infrastructure (i.e roads) decides to move to formal patches and turns their color pink as they are connected to an infrastructure network for urban services
5. Roads on the informal patches create a unit of the road on their empty one of the neighboring left, right, top, down patch
6. Roads remove itself if there are more than 5 road units on its neighboring patches
7. New Households takes empty places in the neighborhood according to in-rate input (no. of new houses build on each tick ) with their income range between 15 to 45 and turns their color pink if they are connected to infrastructure network (i.e roads)

 
## HOW TO USE IT

Please ensure origin is set at the bottom left corner with max-pxcor max-pycor as 36 36 respectively.

Set initial-population to create an initial number of houses on Setup
 
Press SETUP to create an initial state of the neighborhood.

Press Go Once to go one tick forward.

Press Go to completely stimulate code forever.

The income-growth slider inputs income growth of each household on each tick

The income-threshold slider input sets threshold income for entering affordable housing place (i.e formal-patches)

The rich-person slider input sets income at which household will move out of the place (i.e removes itself) (i.e die in NetLogo language)

Show-Income switch shows the income of each household

 

## THINGS TO NOTICE

Initially, there will be no houses on formal patches as many households haven't reached income-threshold to afford to move to these patches

There won't be many roads build for few steps if the initial population is too high.

There will period of bumps that stimulate road growth as a large set of households became rich together and in-rate don't fill that gap

Lower in-rate and higher income-growth completes the model faster.

There will be a period of a constant when formal-patches are filled and their household hasn't become rich enough to move out.



## THINGS TO TRY

Try increasing income-growth to see how faster it increases roads (infrastructure network)
Try reducing income-threshold with and without changing rich-person value.
Try with lower and higher initial-population and see how it affects dynamics.
Try lower and higher in-rate to see how it affects overall dynamics

## EXTENDING THE MODEL

You may have noticed the model is resulted in making more roads than needed. If you find a way to solve this you can mail me at aashish436521@gmail.com


## RELATED MODELS

This model is inpired by Schellings Segregation model, El Farol bar model.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
