 globals [ category-count
  student-to-watch
  successful-popular-students
  successful-unpopular-students
  popular-student-count
  unpopular-student-count
]

breed [ students student ]
breed [ clubs club ]
undirected-link-breed [social-links social-link]

extensions [Nw]

students-own [
  sociability
  percieved-skill
  highest-rank
  club-list
  class
  category
  skill
  popular?
  unpopular?
]

clubs-own [
  rank
  member-count
  open-spots
  max-members
  category
]


to setup
  create-initial-students
  ask students [ create-network ]

  ;set popular? and unpopular? tags for students with most and least links respectively
  ;This is used later to track liklihood of success for different types of students
  ask one-of students with [class = 0 and count link-neighbors = max [count link-neighbors] of students with [class = 0]] [set popular? true]
  ask one-of students with [class = 0 and count link-neighbors = min [count link-neighbors] of students with [class = 0]] [set unpopular? true]

  set-clubs
  populate-clubs
  ask students [ generate-club-links ]
  move-turtles
  ask links [set hidden? true]
  plot-skill-vs-rank
  reset-ticks
end

to create-initial-students
  clear-all

  ;;Set global constants
  set category-count 5
  set successful-popular-students 0
  set successful-unpopular-students 0
  set popular-student-count 0
  set unpopular-student-count 0

  ;Create 4 years of students with a attributes
  create-students student-count / 4 [
    set class 0

  ]
  create-students student-count / 4 [
    set class 1
  ]
  create-students student-count / 4 [
    set class 2
  ]
  create-students student-count / 4 [
    set class 3
  ]
  ask students [
    set heading 0
    set skill random-float 10
    set category random category-count
    set highest-rank 0
    set club-list []
    set sociability random-float 1
  ]
end


to create-network ; Trutle Procedure
  ask n-of random 5 other students with [class = [class] of myself] [ ;Create links with people in the same class
    create-social-link-with myself [hide-link]
  ]
  ask n-of ((random 2) + 1) other students with [class != [class] of myself] [ ;Create less links with people in other classes
    create-social-link-with myself [hide-link]
  ]
end

;This function creates the clubs
to set-clubs ;Observer Procedure
             ;create clubs for each category
  let club-count 30
  let x 0
  while [ x < category-count ]
  [
    let y 0
    while [y < club-count]
    [
      create-clubs 1 [
        ifelse random-float 1 < .10 [set rank 4] [set rank random 4] ; set rank of club (only 10 percent of clubs should be highest rank)
        set max-members ((random 20) + 5) ;Set club range 5 - 24
        set open-spots max-members
        set member-count 0
        set category x
        set color red
        set hidden? true
      ]
      set y y + 1
    ]
    set x x + 1
  ]
end

;This function randomly assigns students to different clubs in their preferred category
to populate-clubs
  ask clubs with [member-count < max-members] [
    if any? students with [category = [category] of myself] [
      let c max-members - member-count
      ask n-of c other students with [category = [category] of myself] [
        ask myself [set member-count member-count + 1]
        if class != 3 [ ask myself [set open-spots open-spots - 1]]
        set club-list lput myself club-list
        if [rank] of myself > highest-rank [ set highest-rank [rank] of myself]
      ]
    ]
  ]
end

;This function generates links with members in the same category and in the same club, based on percentages set in the interface
to generate-club-links ;Turtle Procedure
  let cat category
  let student-list get-clubmates club-list
  let category-list other students with [category = cat and club-list != []]
  ask category-list [
    if random-float 1 < propensity-to-befriend-groupmates [create-social-link-with myself] ;Generate links based on propensity-to-befriend-groupmates for those who share a club category
  ]
  foreach student-list [ [agentset] ->
    ask agentset [
      if random-float 1 < propensity-to-befriend-clubmates [create-social-link-with myself] ;Generate links based on propensity-to-befriend-clubmates for those who are in the same club
    ]
  ]
end

;for all clubs that have open spots (number of seniors that are about to graduate) pick new members to fill their spots
;Students apply to clubs that are in their category with a rank equal to or higher than their higest rank club
;Students with highest percieved skill make it to the club
to select-new-students ;Observer Procedure
  ask clubs with [open-spots > 0] [
    ;Students who know someone in the club can apply (do not need to be in the same category
    let recruited-students [link-neighbors] of students with [member? myself club-list] with [class != 3 and not member? myself club-list and length club-list < 6]
    ;Students will apply to clubs in their category if the club is greater than or equal to their higest-rank club
    ;6 clubs is the max amount of clubs someone can be in at once
    let applicants students with [category = [category] of myself and not member? myself club-list and highest-rank <= [rank] of myself and class != 3 and length club-list < 6]

    let possible-students turtle-set sentence recruited-students applicants
    if possible-students != NOBODY [
      let top-applicants pick-top-applicants possible-students self open-spots
      ask top-applicants [
        set club-list lput myself club-list
        ask myself [set open-spots open-spots - 1]
        if [rank] of myself > highest-rank [ set highest-rank [rank] of myself]
      ]
    ]
  ]
end

;; returns a list of applicants sorted by a calculated "percieved skill"
to-report pick-top-applicants [applicants cl number]
  ask applicants [

    ifelse not third-party-selection-committee? [
      let link-count count link-neighbors with [member? cl club-list]
      set percieved-skill link-count * link-count
      set percieved-skill percieved-skill + skill
      set percieved-skill percieved-skill + highest-rank
      set percieved-skill percieved-skill + length club-list
      set percieved-skill percieved-skill - (class * 3)
      ;      if unpopular? = true [show self show percieved-skill]
    ]
    [
      set percieved-skill skill
    ]

  ]
  ifelse number > count applicants [ report turtle-set sort-on [ (- percieved-skill)] applicants]
  [report turtle-set sublist sort-on [ (- percieved-skill)] applicants 0 number]
end

;Moves turtles on the screen based on what clubs they are in and how many connections they have
to move-turtles
  ask students [
    setxy min-pxcor min-pycor
    foreach club-list [[cl] ->
      set heading 0
      fd 1 * [rank] of cl
    ]
    set heading 90
    fd count link-neighbors

  ]
end


;Tick
;Represents a year
to go
  remove-seniors
  add-year
  generate-freshman
  generate-new-social-links
  select-new-students
  ask students [ generate-club-links ]
  plot-skill-vs-rank
  move-turtles
  plot-popular-students
  ask links [set hidden? true]
  ;  ask students with [unpopular? = true] [show club-list]
  tick
end


;Remove Seniors from the pool of students
to remove-seniors
  ask students with [class = 3] [
    die ;The students graduate (but coming from an outgoing senior, whats the difference?)
  ]
end
;Add a year to each student, update clubs that have outgoing seniors
to add-year
  ask students[
    set class class + 1
  ]
  ;Clubs that have seniors now have open spots for an incoming class
  ask students with [class = 3] [
    foreach club-list [[cl] ->
      ;      show cl
      ask cl [
        set open-spots open-spots + 1
      ]
    ]
  ]
end

;;Generate a new set of freshman
to generate-freshman
  create-students student-count / 4 [
    setxy min-pxcor min-pycor
    ;    set label who
    set class 0
    set heading 0
    set skill random-float 10
    set category random 5
    set club-list []
    set sociability random-float 1
    ;Generate links to some other people in the class
    ask n-of random 5 other students with [class = 0] [
      create-social-link-with myself
    ]
    ;Generate links with some people in other classes
    ask n-of ((random 2) + 1) other students with [class != 0] [
      create-social-link-with myself
    ]
  ]
  ;Record a popular student and unpopular student for data purposes
  ask one-of students with [class = 0 and count link-neighbors = max [count link-neighbors] of students with [class = 0]] [set popular? true ]
  ask one-of students with [class = 0 and count link-neighbors = min [count link-neighbors] of students with [class = 0]] [set unpopular? true ]
end



;;Generate some new friends and lose some new friends based sociability and propensity-to-lose-friends, respectively
to generate-new-social-links ; Observer Procedure
  ask students [
    ask n-of ((random 3) + 1) other students with [not member? myself link-neighbors] [
      if random-float 1 < sociability [create-social-link-with myself]
    ]
    ask n-of random 3 links [
      if random-float 1 < propensity-to-lose-friends [ask self [die]]
    ]
  ]

end

;;This reports a list of students who are in clubs listed in the input
to-report get-clubmates [arr]
  let final-list []
  foreach arr [ [cl] ->
    set final-list sentence final-list other students with [ member? cl club-list]
  ]
  report final-list
end


;Some students are assigned popular? and unpopular? attributes when they are first created based on how many (random) links they create
;When they are about to graduate the model records if they had success based on if they are in a high ranking club
;Students who are in a rank 4 club are considered successful
to plot-popular-students
  if ticks > 6 [
    ;It takes some time for the model to stabalize because initial clubs selections are randomly assigned
    ;This is done so the data isnt skewed
    ask students with [popular? = true and class = 3] [
      ;    show self
      if highest-rank = 4 [
        set successful-popular-students successful-popular-students + 1
      ]
      set popular-student-count popular-student-count + 1

    ]
    ask students with [unpopular? = true and class = 3] [
      ;    show self
      if highest-rank = 4 [
        set successful-unpopular-students successful-unpopular-students + 1
      ]
      set unpopular-student-count unpopular-student-count + 1
    ]
  ]
end

;This function reports the global-clustering-coefficient
to-report global-clustering-coefficient
  let closed-triplets sum [ nw:clustering-coefficient * count my-links * (count my-links - 1) ] of turtles
  let triplets sum [ count my-links * (count my-links - 1) ] of turtles
  report closed-triplets / triplets
end


;This procedure generates the High Rank Student Skill Level plot
;and the Degree Vs. Highest rank plot
to plot-skill-vs-rank

  set-current-plot "High Rank Student Skill Level"
  clear-plot
  set-current-plot-pen "test"
  ask students with [club-list != []] [
    plotxy skill highest-rank
  ]

  set-current-plot "Degree Vs. Highest Rank"
  clear-plot
  set-current-plot-pen "test"
  ask students with [club-list != []] [
    plotxy count link-neighbors highest-rank
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
449
17
1445
359
-1
-1
5.46
1
10
1
1
1
0
0
0
1
-90
90
-30
30
1
1
1
ticks
30.0

BUTTON
2
197
68
230
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
2
17
174
50
student-count
student-count
300
2000
1100.0
1
1
NIL
HORIZONTAL

BUTTON
150
235
266
268
advance-year
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
2
54
289
87
propensity-to-befriend-groupmates
propensity-to-befriend-groupmates
0
1
0.1
.01
1
NIL
HORIZONTAL

SLIDER
2
89
271
122
propensity-to-befriend-clubmates
propensity-to-befriend-clubmates
0
1
0.8
.01
1
NIL
HORIZONTAL

PLOT
5
272
243
438
Degree Histogram
Degree
Count
0.0
10.0
0.0
10.0
true
false
"set-plot-y-range 0 100\nset-plot-x-range min [count link-neighbors] of students max [count link-neighbors] of students\n" "set-plot-x-range min [count link-neighbors] of students max [count link-neighbors] of students"
PENS
"pen-0" 1.0 1 -7500403 true "" "histogram [count link-neighbors] of students"

PLOT
249
274
444
438
Percentage of Students in clubs
tick
Percentage
0.0
100.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count students with [club-list != []] / count students"

PLOT
4
442
444
690
High Rank Student Skill Level
skill
highest-rank
0.0
5.0
0.0
10.0
true
false
"\nset-plot-x-range min [skill] of students max [skill] of students\nset-plot-y-range min [highest-rank] of students max [highest-rank] of students" "\nset-plot-x-range min [skill] of students max [skill] of students\nset-plot-y-range min [highest-rank] of students max [highest-rank] of students;"
PENS
"test" 1.0 2 -8053223 true "" ""

SLIDER
2
124
224
157
propensity-to-lose-friends
propensity-to-lose-friends
0
1
0.1
.01
1
NIL
HORIZONTAL

PLOT
-10
695
260
940
Degree vs. Highest Rank
Degree
Highest Tier
0.0
10.0
0.0
10.0
true
false
"\nset-plot-x-range min [count link-neighbors] of students max [count link-neighbors] of students\nset-plot-y-range min [highest-rank] of students max [highest-rank] of students" "\nset-plot-x-range min [count link-neighbors] of students max [count link-neighbors] of students\nset-plot-y-range min [highest-rank] of students max [highest-rank] of students"
PENS
"test" 1.0 2 -7500403 true "" ""

SWITCH
2
160
264
193
third-party-selection-committee?
third-party-selection-committee?
1
1
-1000

MONITOR
265
697
469
742
Average Skill Clubless Students
mean [skill] of students with [club-list = []]
3
1
11

MONITOR
267
750
507
795
Average Degree of Clubless Students
mean [count link-neighbors] of students with [club-list = []]
3
1
11

MONITOR
265
797
525
842
Average Degree of "Successful" Students
mean [count link-neighbors] of students with [length club-list > 5 or highest-rank = 4]
3
1
11

MONITOR
265
847
513
892
Avereage Sklil of "Successful" Students
mean [skill] of students with [length club-list > 5 or highest-rank = 4]
3
1
11

BUTTON
2
234
147
269
advance-one-year
go\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
262
899
578
944
Liklihood of Success for Well Connected Students
successful-popular-students / popular-student-count
3
1
11

MONITOR
199
949
584
994
Liklihood of Success for Poorly Connected Students
successful-unpopular-students / unpopular-student-count
3
1
11

MONITOR
2
942
142
987
Liklihood of Success
count students with [highest-rank = 4 and class = 3] / (student-count / 4)
3
1
11

@#$#@#$#@
## WHAT IS IT?

When interviewing or auditioning for a student group on a college campus, it is impossible to disregard past relationships with that person. This model attempts to show how a social network can impact the selection procceses of competitive student groups on a college campus. 

## HOW IT WORKS

Agents are created to represent students on a college campus as well as student groups on a college campus. Each tick students act as how students in real life would during a given school year. The students make new friends, lose some friends, and apply to student groups. 

Student groups each tick select new students who are qualifed to join their group. Depending on the setting, students will be selected on a given criteria. 

Depending on which groups the students are selected into, this affects who they make friends with as well as which groups they will apply to the next year.

Students move up based on their success of getting into clubs and right the numnber of connections they make.

## HOW TO USE IT

To use the model you can tinker with some of the settings to see how things chage. The most important parameter is THIRD-PARTY-SELECTION-COMMITTEE?. This Determines how student groups select new students. If this is set to true, student groups select students based soley on their skill. If it is false then student groups give advantages to students who have friends in their group, success with other clubs, and high skill.

Other sliders include PROPENSITY-TO-BEFRIEND-CLUBMATES, PROPENSITY-TO-BEFRIEND-GROUPMATES, and PROPENSITY-TO-LOSE-FRIENDS. Each of these determines how the network changes each tick.

Finally the student count can be moved which changes the number of students in the model.


## THINGS TO NOTICE

Watch the graphs and see whar are some common distributions.

See what common layouts occur with the turtles. 

## THINGS TO TRY


See which graphs change when the THIRD-PARTY-SELECTION-COMMITTEE? boolean is changed. Notice how they change and think about why that happens. 

Notice how the degree distribution changes has you change the different sliders determining friend generation and loss. 
(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

For this model, links are very one dimensional. In reality a relationships is not a boolean but a more complex item. Future versions of the model could give weightings to relationsihps, negative aspects to relationsihps and different types of relationships.

Future versions of the model could also play with the interface tab giving more relevance to the layout of the turtles. 


## NETLOGO FEATURES


## RELATED MODELS

This model uses the Team Assembly model as inspiration.

## CREDITS AND REFERENCES
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="10" sequentialRunOrder="false" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>advance-year</go>
    <timeLimit steps="35"/>
    <metric>(successful-popular-students / popular-student-count) - (successful-unpopular-students / unpopular-student-count)</metric>
    <metric>(successful-popular-students / popular-student-count)</metric>
    <metric>(successful-unpopular-students / unpopular-student-count)</metric>
    <enumeratedValueSet variable="propensity-to-befriend-groupmates">
      <value value="0.2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="student-count">
      <value value="1000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="propensity-to-lose-friends">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="high-sociability?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="third-party-selection-committee?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="propensity-to-befriend-clubmates">
      <value value="0.8"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="third-party" repetitions="15" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>advance-year</go>
    <timeLimit steps="25"/>
    <metric>mean [skill] of students with [club-list = []]</metric>
    <metric>mean [count link-neighbors] of students with [club-list = []]</metric>
    <metric>mean [count link-neighbors] of students with [length club-list &gt; 5 or highest-rank = 4]</metric>
    <metric>mean [skill] of students with [length club-list &gt; 5 or highest-rank = 4]</metric>
    <metric>successful-popular-students / popular-student-count</metric>
    <metric>successful-unpopular-students / unpopular-student-count</metric>
    <metric>count students with [club-list != []] / count students</metric>
    <metric>count students with [highest-rank = 4 and class = 3] / (student-count / 4)</metric>
    <enumeratedValueSet variable="propensity-to-befriend-groupmates">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="student-count">
      <value value="1100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="propensity-to-lose-friends">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="third-party-selection-committee?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="propensity-to-befriend-clubmates">
      <value value="0.8"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="clustering" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>advance-year</go>
    <timeLimit steps="25"/>
    <metric>global-clustering-coefficient</metric>
    <enumeratedValueSet variable="propensity-to-befriend-groupmates">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="student-count">
      <value value="1100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="propensity-to-lose-friends">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="high-sociability?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="third-party-selection-committee?">
      <value value="true"/>
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="propensity-to-befriend-clubmates">
      <value value="0.8"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="8" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>advance-year</go>
    <timeLimit steps="25"/>
    <metric>mean [skill] of students with [count link-neighbors &lt; 43]</metric>
    <metric>mean [sociability] of students with [count link-neighbors &lt; 43]</metric>
    <enumeratedValueSet variable="propensity-to-befriend-groupmates">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="student-count">
      <value value="1100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="propensity-to-lose-friends">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="high-sociability?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="third-party-selection-committee?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="propensity-to-befriend-clubmates">
      <value value="0.8"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
