;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%%%%%%%%%%%%%%%%%%%%%%%%% Experimention for SCARS %%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;%%%%% SCARS == SPATIO-TEMPORAL COGNITIVE AGENT-BASED RECOMMENDER SYSTEM %%%%%%
__includes
[
  "communication.nls"     ;; Library for ACL exchanging messages
  "bdi.nls"               ;; Library for Beliefs-desire-intention architecture
  "UserAgent.nls"        ;; Cars BDI behavior
]

extensions [gis array table]
globals
[
autobleue_data            ;; GIS dataset about electric recharge points in Nice
streets_data              ;; GIS dataset about streets in Nice Ville
nice_buildings            ;; GIS dataset about touristic POI in Nice Ville
center-x                  ;; center of the map
center-y                  ;; center of the map
mean-wait-time
number
random-accident-place
counter
]
breed [cars car]
breed [workPlaces workPlace]
breed [vertices vertice]
cars-own
[
   speed         ;; speed (optional in this demo)
   myposition    ;; my actual position
   last-stop     ;; last item in my path
   destination   ;; a destination where to go
   mypath        ;; a list of vertices to go to a destination
   step-in-path  ;; steps in the path
   destination-entrance
   beliefs       ;; information about their environment
   desires       ;; state of affairs that an agent want to accomplish
   intentions    ;; plan that allow an agent to achive its goals
   goals         ;; list of possible desires that an agent want to achieve
   trust         ;; the confidence degree
   distrust      ;; the non-confidence degree
   incoming-queue;; exchanged messages with others agents
   wait-time     ;; time waiting in traffic congestion
   time-of-simulation
]
patches-own[road? distance-work distance-home centroid? id entrance]
vertices-own [
  myneighbors          ;;agentset of neighboring vertices
  entrance?            ;;if it is an entrance to a building
  test                 ;;used to delete in test
  ;;the follwoing variables are used and renewed in each path-selection
  dist                 ;;distance from original point to here
  doone                 ;;1 if has calculated the shortest path through this point, 0 otherwise
  lastnode             ;;last node to this point in shortest path
  ]


;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Setup%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
to setup
  ca
  reset-ticks
  load-data
  make-streets
 ;; setup-destinations
  add-agents
  set number 15

end

to load-data

  ask patches [set pcolor white]
  set streets_data gis:load-dataset "paca/gis.osm_roads_free_1.shp";;;route sur Nice Ville
  set autobleue_data gis:load-dataset "Nice_shapefile/autobleue/autobleue.SHP";; Cartographie de point de recharge des autobleue sur Nice et environs
  ; set nice_buildings gis:load-dataset "Nice_shapefile/POI/export_musees_galeries_RGF93L93_shapefile.shp"
  draw

end
to draw
  setup-world-envelope
   gis:set-drawing-color white  gis:draw streets_data 1
   gis:set-drawing-color blue     foreach gis:feature-list-of autobleue_data [ gis:draw ? 1]
    ;gis:set-drawing-color black  gis:draw nice_buildings 1



 ;gis:set-drawing-color 25  gis:draw gmu-walkway 1.0

 ;identify centroids and assign IDs to centroids
 foreach gis:feature-list-of autobleue_data[
      let  center-point gis:location-of gis:centroid-of ?
      if not empty? center-point [
        ask patch item 0 center-point item 1 center-point
         [
        set centroid? true
        set id gis:property-value ? "IDENT"
        ]

 ]]

end

to setup-world-envelope
  gis:set-world-envelope gis:envelope-of autobleue_data
  let world gis:world-envelope
  let x0 (item 0 world + item 1 world) / 2  + center-x; center
  let y0 (item 2 world + item 3 world) / 2  + center-y
  let W0 zoom * (item 1 world - item 0 world) / 2 ; half-widths
  let H0 zoom * (item 3 world - item 2 world) / 2
  set world (list (x0 - W0) (x0 + W0) (y0 - H0) (y0 + H0))
  gis:set-world-envelope world
end

to center
  while [not mouse-down?] [wait .01]
  set center-x center-x + (mouse-xcor * gis-patch-size)
  set center-y center-y + (mouse-ycor * gis-patch-size)
  draw
end

to-report gis-patch-size ;; note: assume width & height same
  let world gis:world-envelope
  report (item 1 world - item 0 world) / (max-pxcor - min-pxcor)
end

to zoom-in  set zoom max list .01 precision (zoom - .1) 2  draw end
to zoom-out set zoom min list 1.2 precision (zoom + .1) 2  draw end


to make-streets
foreach gis:feature-list-of streets_data[

  foreach gis:vertex-lists-of ? ; for the road feature, get the list of vertices
       [
        let previous-node-pt nobody

        foreach ?  ; for each vertex in road segment feature
         [
          let location gis:location-of ?

          if not empty? location
           [
            ;ifelse any? vertices with [(xcor = item 0 location and ycor = item 1 location) ] ; if there is not a road-vertex here already
             ;[]
             ;[
             create-vertices 1
               [set myneighbors n-of 0 turtles ;;empty
                set xcor item 0 location
                set ycor item 1 location
                ask patch xcor ycor [set road? true]
                set size 0.2
                set shape "circle"
                set color brown
                set hidden? true


              ;; create link to previous node
              ifelse previous-node-pt = nobody
                 [] ; first vertex in feature
                 [create-link-with previous-node-pt] ; create link to previous node
                  set previous-node-pt self]
               ;]
           ]]] ]
  ;;delete duplicate vertices (there may be more than one vertice on the same patch due to reducing size of the map). therefore, this map is simplified from the original map.

  delete-duplicates

  ;;delete some nodes not connected to the network
  ask vertices [set myneighbors link-neighbors]
  delete-not-connected
  ask vertices [set myneighbors link-neighbors]


  ;;find nearest node to become entrance
  ask patches with [centroid? = true][set entrance min-one-of vertices in-radius 5 [distance myself]
    ask entrance [set entrance? true]]
   ; if show_nodes? [ask vertices [set hidden? false]]
   ; if show_entrances? [ask entrance [set hidden? false set shape "star" set size 0.5]]]

  ask links [set thickness 0.1 set color orange]

end

to delete-duplicates
    ask vertices [
    if count vertices-here > 1[
      ask other vertices-here [

        ask myself [create-links-with other [link-neighbors] of myself]
        die]
      ]
    ]

end
to delete-not-connected
 ask vertices [set test 0]
 ask one-of vertices [set test 1]
 repeat 500 [
   ask vertices with [test = 1]
   [ask myneighbors [set test 1]]]
 ask vertices with [test = 0][die]

end

to add-agents
   create-cars cars_number[
    set shape "car"
    set destination nobody
    set last-stop nobody
    set myposition one-of vertices
    move-to myposition
    set intentions []
    set desires table:make
    table:put desires "go-to-dest" 0.6
    set beliefs table:make
    set trust precision(random-float 1) 1 ;;random value in [0 1] interval
    set wait-time 0
    set incoming-queue []

   ]
;   create-cars 1[
;     set shape "car"
;     set label "BOB" set label-color black
;     set myposition one-of vertices
;     move-to myposition
;     set destination nobody
;     set last-stop nobody
;     set beliefs table:make
;     set desires table:make
;     table:put desires "go-to-dest" 0.9
;     set intentions []
;     set trust precision(random-float 1) 1 ;;random value in [0 1] interval
;     set wait-time 0
;     set incoming-queue []
;
;     ]

end

;%%%%%%%%%%%%%%%%%%%%% To Go %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

to shortest-path-select[todest]

     ;;use the A-star algorithm to find the shortest path (shortest in terms of distance)

     set mypath [] set step-in-path 0

     ask vertices [set dist 9999 set doone 0 set lastnode nobody set color brown]

     ask myposition [set dist 0 ] ;;distance to original node is 0


    while [count vertices with [doone = 0] > 0][
      ask vertices with [dist < 9999 and doone = 0][
         ask myneighbors [
           let dist0 distance myself + [dist] of myself    ;;renew the shorstest distance to this point if it is smaller
           if dist > dist0 [set dist dist0 set doone 0 ;;done=0 if dist renewed, so that it will renew the dist of its neighbors
             set lastnode myself]  ;;record the last node to reach here in the shortest path
           ;set color red  ;;all roads searched will get red
           ]
         set doone 1  ;;set done 1 when it has renewed it neighbors
      ]]
     ;;put nodes in shortest path into a list
     let x todest

     while [x != myposition] [
       if show_path? = true  [ask x [set color black] ] ;;highlight the shortest path
       set mypath fput x mypath
       add-intention (word "move-to" word "" x) (word "true")
       set x [lastnode] of x ]
       set last-stop last mypath


end
to go-to-dest
      if destination = nobody or destination = 0 [
       set destination one-of patches with [centroid? = true]
       set destination-entrance [entrance] of destination
       shortest-path-select destination-entrance
      ]
end
to go
  ask cars [
             move-forward listen-to-messages
             set goals objectives beliefs desires
             get-recommendation(goals)
             execute-intentions
             random-event
            if (speed = 0) and  (not any? patches with [centroid? = true] in-radius 3) [ set wait-time wait-time + 1]
            if not any? patches with [centroid? = true] in-radius 3   [set time-of-simulation ticks ]

  ]
     ask cars  [if not empty? table:to-list beliefs [send-messages(one-of table:to-list beliefs)]
                listen-to-messages]
   tick
end

to random-event
               if (ticks > 15) [set number number - 1
                             if number >= 0 [
                             set random-accident-place one-of vertices
                             ask random-accident-place [set pcolor red  set entrance? false]

                             if  (any? patches with [pcolor = red] in-radius 10) [ ;print "An accident just occured nearby"
                                                                                   table:put beliefs (word "" random-accident-place ) 0.7
                                                                                   set trust 0.7
                                                                                   ]
                                             ]
                                ]
               ;min-one-of vertices in-radius 100 [distance myself]
end

to move-forward
 let turtles-ahead turtles in-cone 2 45
             ifelse any? turtles-ahead
             [ slow
               rt 7 + random-float 3 ]
             [speed-up]
end

to slow
  if (speed > 0)
  [set speed speed - 1]
end

to speed-up
  let turtles-ahead turtles-at 0 1
  if (not any? turtles-ahead) [ set speed speed + 1]
  ;if ([road?] of patch-ahead 1 = true) and (not any? turtles-ahead) [ set speed speed + 1]
end
to draw-plots
  set mean-wait-time mean [wait-time] of cars
  set-current-plot-pen "mean-wait-time"
  plot mean-wait-time
end

to close-street[identifier]
  ask vertice identifier [die]
end
to compute-new-path-to-dest[dest]
  set destination-entrance [entrance] of dest
  shortest-path-select destination-entrance

end

to-report meters-per-patch ;; maybe should be in gis: extension?
  let world gis:world-envelope ; [ minimum-x maximum-x minimum-y maximum-y ]
  let x-meters-per-patch (item 1 world - item 0 world) / (max-pxcor - min-pxcor)
  let y-meters-per-patch (item 3 world - item 2 world) / (max-pycor - min-pycor)
  report mean list x-meters-per-patch y-meters-per-patch
end

;%%%%%%%%%%%%%%%%%%%%%%%%% Cars BDI Behavior %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

to-report objectives[B D]
;; input: beliefs and desires
;; output : goals which are the most desired and possible set of desires
let gamma 0
let g possible-desires B D gamma
report g stop
;;while [gamma < 1][
ifelse empty? table:to-list g [report g]
[
  let alpha min(map [last ?] table:to-list B)
   if alpha <= gamma [
     set alpha 1
     set gamma alpha]
   ]
;;]

end
;;;;;Elect a list of possible and coherent desires as goals ragrding a list of beliefs
to-report possible-desires [B D x]

loop [
let delta max(map [last ?] table:to-list D)
let Des table:make
foreach  table:keys D [
  if table:get D ? = delta
  [ let i ?
    table:put Des ? (table:get D ?)
   ;; if empty? table:to-list B [report Des]
   foreach table:keys B
     [ ;;print word "Not-"i
     if ? = word "Not-" i and table:get B  ? > x [table:remove Des i
                                                  table:remove D i
                                                 ]


     ]
  ]
  ]  if not empty? table:to-list Des [report Des  stop]]
end

 to get-recommendation [g]
   ifelse (member? "go-to-dest" map first table:to-list g)[go-to-dest]
                                                            [do-nothing]
 end

to evaluate-proposal[msg]
;send add-receiver get-sender msg add-content msg create-message "Accept proposal"
   ifelse (([trust] of turtle read-from-string get-sender msg) >= 0.5);; and (item 3 get-content msg > 0.5)
    [send add-receiver get-sender msg add-content msg create-message "Accept proposal"]
    [send add-receiver get-sender msg  create-message "Reject proposal"]

 end
  ;;sending a proposal for similar agents
 to send-messages [msg]
   broadcast-to other cars add-content msg create-message "proposal"
 end

 ;;;to keep Listening to messages when running
 to listen-to-messages
   let msg 0
   let performative 0
   while [not empty? incoming-queue ][
     set msg get-message
     set performative get-performative msg
     if performative = "proposal" [evaluate-proposal(msg)]
     if performative = "Accept proposal" [
                                          ;; update-intentions(msg)
                                          update-beliefs(msg)
                                          ;; update-desires(msg)
                                         ]
     if performative = "Reject proposal" [do-nothing]

     ]
 end

  to update-beliefs [msg]

  let proposal item 3 get-content msg
  let trustee  item 0 get-receivers msg
  ;;;;;;;;;;;;;;;;;;;;;;;;;Re-compute the recommandation if the proposal is accepted;;;;;;;;
  ask cars [
          ifelse table:has-key? beliefs item 0 proposal[do-nothing]  [
          table:put beliefs item 0 proposal min list (item 1 proposal) ([trust] of turtle read-from-string trustee)
          foreach intentions [if item 0 ? = word "move-to" word "" item 0 proposal [
           set speed 0
           set intentions []
           compute-new-path-to-dest destination
           execute-intentions] ;[let confiance [trust] of car read-from-string trustee set confiance 0 ]
          ]
          ]



  ]
;;;with Trust
  end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
909
496
26
17
13.0
1
10
1
1
1
0
0
0
1
-26
26
-17
17
1
1
1
ticks
30.0

BUTTON
49
43
115
76
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
25
312
110
345
NIL
zoom-in
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
111
313
195
346
NIL
zoom-out
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
26
266
196
299
zoom
zoom
0
1.5
0.48
0.01
1
NIL
HORIZONTAL

BUTTON
134
45
197
78
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
29
94
201
127
cars_number
cars_number
0
150
58
1
1
NIL
HORIZONTAL

SWITCH
29
138
200
171
show_path?
show_path?
1
1
-1000

SWITCH
28
179
200
212
show-intentions
show-intentions
1
1
-1000

SWITCH
26
220
197
253
show_messages
show_messages
1
1
-1000

PLOT
916
12
1249
244
Average wait & simulation time of cars
Time
mean
0.0
100.0
0.0
50.0
true
false
"" ""
PENS
"mean-wait-time" 1.0 0 -5298144 true "" "if ticks > 0 [plot mean [wait-time] of cars]"
"mean-simulation-time" 1.0 0 -12087248 true "" "if ticks > 0 [plot mean [time-of-simulation] of cars]"

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.3.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
