;; LOGISTIC - Note that dt = 0.001 by default, but here it is initialized to 1 dt = 1 tick = 1 year.

;; system-dynamics-setup, system-dynamics-do-plot, and system-dynamics-go are automatically
;; generated by the System Dynamics Modeler.  The code can be viewed in the
;; Code Tab of the System Dynamics Modeler.

globals ;those not set in SD
[
   counter
   multiplier
   minmax
   pop-previous
   pop-change
   pop-plot
   old-pop
   upper-x
   upper-y
   predecessor
]
   
to setup
   ca
  
   system-dynamics-setup
   system-dynamics-do-plot
   set pop-change 0
   set pop-plot 0
   set old-pop init-pop
   set counter 0
   set multiplier 1
   set minmax 1.0E10  ;+/-9007199254740992 is range
   
   ;set graph display bounds assuming non-chaotic behavior   
   ifelse init-pop > carrying-capacity
   [ 
     set upper-y init-pop 
   ]
   [ 
     let uy list carrying-capacity (( birth-rate - death-rate ) * carrying-capacity )
     set upper-y max uy
   ]
   
   set upper-x Simlength
   
   set predecessor nobody
   
   print ( word "dt: " dt " Upper-x: " upper-x " Upper-y: " upper-y )
  
end

to update-display1
  
  crt 1 [
    
    ;normalize to plot boundaries: min_range + (( current - min-data ) ( max-pxcor - min-pxcor)) / ( max-data - min-data)
    ;Max data range for x is length of simulation.  Max data range for y is carrying-capacity +- a buffer to show overshooet
    ;Max plot range for x is 1 less than max-pxcor to prevent last point from overshooting plot.  For y, 
   
    let x int ( ( ticks * ( max-pxcor - 1 ) ) / upper-x )
    let y int ( ( population * ( max-pycor - 1 ) ) / upper-y )

    set shape "circle"
    set size 1
    set color blue    
    set label ( precision pop-plot 0 ) 

    if pop-plot < 0 [ set color orange ]

    ;keep graphics on screen if chaotic behavior leads to wild fluctuations     
    if y < 0 [ set y 0 ] 
    if y > max-pycor - 1 [ set y max-pycor - 1 ]
    
    print ( word "         x: " x " y: " y " predecessor: " predecessor " at tick: " precision ticks 0 )
    setxy x y    
    if ticks >= 2.0 [ create-link-with predecessor ]
    set predecessor self

    
  ]
  
end

to update-display2

  ;Depict individuals up to 100 tick units of time
    
  ifelse count turtles < 0 
  [ 
    crt 1 [
      let x ticks
      let y 2
      setxy x y
      set size 1
      set shape "circle"
      set color black
      ;set label count turtles
      print ( word "         population: " count turtles " births: " births " deaths: " deaths )
    ]
  ]
  [  
      ifelse births > 0
      [
        crt int births [
    
          let x random  ( max-pxcor - 1 )
          let y ( random  ( max-pycor - 11 ) ) + 10 
          setxy x y
    
          set size 1
          set shape "circle"
          print ( word "         turtle " who " born at x: " x " y: " y " at tick: " precision ticks 0 )
        ]
      ]
      [
        crt 1
        [
           let x ticks
           let y 4
           setxy x y
           set size 1
           set shape "circle"
           set color green
           ;set label precision births 1
        ]
      ]
    
      ifelse deaths > 0 
      [
        ask n-of int deaths turtles [
          print ( word "         turtle " who " died at at tick: " precision ticks 0 )
          die
        ]
      ]
      [
        crt 1
        [
          let x ticks
          let y 6
          set size 1
          set shape "circle"
          set color red
          ;set label precision deaths 1
        ]
      ]
  ]
  
  
end

to update-plot
  
   set-current-plot "Population Size"
   system-dynamics-do-plot
   set-current-plot-pen "limit"
   plotxy ticks carrying-capacity
   
   set-current-plot "r"
   set-current-plot-pen "births"
   plotxy ticks births
   set-current-plot-pen "deaths"
   plotxy ticks deaths

   set-current-plot "dN"
   set-current-plot-pen "default"
   plotxy population pop-change
  
   set-current-plot "N2N1"
   set-current-plot-pen "default"
   plotxy pop-previous population 

end

to go
  
  let mult multiplier / dt
  
  ;check status of simulation
  if ( ticks > SimLength ) [ stop ]
  if ( abs population >= minmax ) [ stop ]
 
  ;iterate 
  set counter counter + 1.0                ;number of iterations - i.e., "dt"
  set pop-previous population              ;record previous population in last dt
  system-dynamics-go                       ;one unit of dt
  set pop-change population - pop-previous ;change over 1 unit of dt
  
  if ( counter mod ( mult ) = 0 ) 
  [ 
    set multiplier multiplier + 1
    set pop-plot population - old-pop
    print ( word "Dt count: " counter " Tick count: " precision ticks 0 " Change per dt: " precision pop-change 3 " Change per tick: " precision pop-plot 3 " Population: " precision population 3 )
    
    ;combo box controls which way the main display is depicted - ON means population size over time with change as label.  OFF means individuals created and eliminated in a "network."
    if display-type = "display-population" [ update-display1 ]
    if display-type = "display-individuals" [ if ticks < max-pxcor - 1 [ update-display2 ]]
    
    set old-pop population

  ]
  
  update-plot

end
@#$#@#$#@
GRAPHICS-WINDOW
476
12
1398
775
-1
-1
12.0
1
10
1
1
1
0
1
1
1
0
75
0
60
0
0
1
ticks
30.0

MONITOR
27
482
238
555
Population Size
population
2
1
18

BUTTON
29
273
152
306
NIL
setup\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
29
434
149
467
NIL
go\n
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
1404
16
1874
274
Population Size
Simulated Time
Number
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"population" 1.0 0 -14737633 true "" ""
"limit" 1.0 0 -5987164 true "" ""

SLIDER
178
353
453
386
birth-rate
birth-rate
0
5
2.538
0.001
1
1/Tick
HORIZONTAL

SLIDER
177
394
452
427
death-rate
death-rate
0
5
0.135
0.001
1
1/Tick
HORIZONTAL

SLIDER
178
313
450
346
init-pop
init-pop
1
1000
1
1
1
Units
HORIZONTAL

SLIDER
179
274
450
307
SimLength
SimLength
0
500
100
1
1
Ticks
HORIZONTAL

SLIDER
178
436
453
469
carrying-capacity
carrying-capacity
1
1000
700
1
1
Units
HORIZONTAL

TEXTBOX
29
17
312
61
LOGISTIC GROWTH MODEL
18
15.0
1

TEXTBOX
30
64
456
272
Models S-shaped population curve based on:\n\n(1) user-selected birth and death rates.\n(2) initial population size\n(3) upper limit to growth.\n\nPressing SHIFT-CTRL-B opens the \"BehaviorSpace\" table that lets user select a range of values to simulate. Sample scenario illustrates simple logistic ranging towards periodicity and eventually chaos that may lead to \"extinction\" of the population.\n\ndt should be set to 1.0
13
0.0
1

MONITOR
242
483
455
556
Population T-1
pop-previous
2
1
18

BUTTON
29
311
153
344
Step 1 dt
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
244
561
455
634
dT set in SD
dt
4
1
18

PLOT
1403
535
1644
775
dN
N
dN
0.0
10.0
0.0
1.0
true
false
"set-plot-y-range 0.000 0.010" ""
PENS
"default" 1.0 2 -16777216 true "" ""

MONITOR
26
561
239
634
Change per tick
pop-plot
2
1
18

PLOT
1649
535
1879
775
N2N1
N(t-1)
N(t)
0.0
0.1
0.0
0.1
true
false
"set-plot-x-range 0.000 0.010\nset-plot-y-range 0.000 0.010" ""
PENS
"default" 1.0 2 -16777216 true "" ""

MONITOR
26
640
239
713
Births per tick
births
2
1
18

MONITOR
243
640
456
713
Deaths per tick
deaths
2
1
18

BUTTON
29
351
154
384
Step 100 dt
go go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
29
392
153
425
Step 1000 dt
go go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go\ngo go go go go go go go go go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

CHOOSER
27
722
194
767
display-type
display-type
"no-display" "display-population" "display-individuals"
0

TEXTBOX
203
717
463
781
Recommendation:\n(1) Set to \"no-display\" if dt < 1.0\n(2) Don't use \"display-individuals\" if N is periodic or chaotic.
13
0.0
1

PLOT
1402
279
1876
527
r
Simulated Time
Number
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"births" 1.0 0 -14070903 true "" ""
"deaths" 1.0 0 -2674135 true "" ""

@#$#@#$#@
## WHAT IS IT?

This is a model of logistic growth using the System Dynamics Modeler.

## HOW IT WORKS

Variables

1. Birth Rate is chosen by modeler.
2. Death Rate = 1 / Lifespan in Years.  So if the Life Span is 10 years, the death rate is 0.1 with 1/Years as the units.  This is a change from the original model as a build-up for converting the logistic from a population model into a form for studies of chaos.

At each step, the value of INFLOW is added to STOCK.  The value of INFLOW is always the previous value of STOCK times a specified growth rate.  The growth rate for an exponential model of population growth is the BirthRate.  However, in a logistic model, the rate of change is reduced by (K - N)/K, where N is the population size and K is an upper limit - i.e., the carrying capacity.  So the rate equation for logistic growth is rN(K-N/K).  But r = b - d, so if we split up the rate in and rate out, we have bN(K-N/K) on the birth side and dN(K-N/K) on the death side (as the OUTFLOW for the system). We usually think of deaths in terms of life span of an individual, so the death rate, d,  becomes 1/life-span.

## HOW TO USE IT

Press the SETUP button, then press the GO button to run the model.  The "Step 1 Year" button repeats the GO command 1000 times because "dt" in the System Dynamics model is set to 0.001.  Note that the simulation length can be set by the user but increased during a model run if needed.

## THINGS TO NOTICE

View the STOCK monitor to see the current value of STOCK.

View the plot to observe the growth of STOCK over time.

## THINGS TO TRY

Use the System Dynamics Modeler to add an outflow.

Try different growth-rate values.

## EXTENDING THE MODEL

Create a new stock that grows linearly.  Try having the level of one stock influence the growth rate of the other.  This would be a model useful for all sorts of problems, like infection rates on the INFLOW side and recovery rates on the OUTFLOW.  Or diffusion of innovations (i.e., BASS Model of Diffusion).

## NETLOGO FEATURES

This model uses the System Dynamics Modeler.  Interesting to compare with the standard ABM model.

## RELATED MODELS

System Dynamics -> Exponential Growth


## HOW TO CITE

If you mention this model in a publication, we ask that you include these citations for the model itself and for the NetLogo software:

* Wilensky, U. (2005).  NetLogo Exponential Growth model.  http://ccl.northwestern.edu/netlogo/models/ExponentialGrowth.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

## COPYRIGHT AND LICENSE

Copyright 2005 Uri Wilensky.

![CC BY-NC-SA 3.0](http://i.creativecommons.org/l/by-nc-sa/3.0/88x31.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Uri Wilensky at uri@northwestern.edu.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.3
@#$#@#$#@
need-to-manually-make-preview-for-this-model
@#$#@#$#@
1.0 
    org.nlogo.sdm.gui.AggregateDrawing 14 
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 175 311 120 60 40 
            org.nlogo.sdm.gui.WrappedStock "population" "init-pop" 0   
        org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 121 124 30 30  
        org.nlogo.sdm.gui.RateConnection 3 151 139 225 139 299 139 NULL NULL 0 0 0 
            org.jhotdraw.figures.ChopEllipseConnector REF 3  
            org.jhotdraw.standard.ChopBoxConnector REF 1  
            org.nlogo.sdm.gui.WrappedRate ";Birth rate impacted by K, as well as Death Rate\nBirthRate * Population * (( CarryingCapacity - Population ) / CarryingCapacity )" "births" 
                org.nlogo.sdm.gui.WrappedReservoir  REF 2 0   
        org.nlogo.sdm.gui.BindingConnection 2 299 139 225 139 NULL NULL 0 0 0 
            org.jhotdraw.standard.ChopBoxConnector REF 1  
            org.nlogo.sdm.gui.ChopRateConnector REF 4   
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 120 188 182 110 216 50 50 
            org.nlogo.sdm.gui.WrappedConverter "birth-rate" "BirthRate"   
        org.nlogo.sdm.gui.BindingConnection 2 146 227 225 139 NULL NULL 0 0 0 
            org.jhotdraw.contrib.ChopDiamondConnector REF 12  
            org.nlogo.sdm.gui.ChopRateConnector REF 4   
        org.nlogo.sdm.gui.RateConnection 3 383 140 471 140 559 140 NULL NULL 0 0 0 
            org.jhotdraw.standard.ChopBoxConnector REF 1  
            org.jhotdraw.figures.ChopEllipseConnector 
                org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 558 125 30 30   
            org.nlogo.sdm.gui.WrappedRate ";DeathRate is Population Size divided by Life Span\nDeathRate * Population * (( CarryingCapacity - Population ) / CarryingCapacity )" "deaths" REF 2 
                org.nlogo.sdm.gui.WrappedReservoir  0   REF 20 
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 503 219 50 50 
            org.nlogo.sdm.gui.WrappedConverter "death-rate" "DeathRate"   
        org.nlogo.sdm.gui.BindingConnection 2 519 227 471 140 NULL NULL 0 0 0 
            org.jhotdraw.contrib.ChopDiamondConnector REF 23  
            org.nlogo.sdm.gui.ChopRateConnector REF 17   
        org.nlogo.sdm.gui.BindingConnection 2 383 140 471 140 NULL NULL 0 0 0 
            org.jhotdraw.standard.ChopBoxConnector REF 1  
            org.nlogo.sdm.gui.ChopRateConnector REF 17   
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 307 227 50 50 
            org.nlogo.sdm.gui.WrappedConverter "carrying-capacity" "CarryingCapacity"   
        org.nlogo.sdm.gui.BindingConnection 2 345 240 471 140 NULL NULL 0 0 0 
            org.jhotdraw.contrib.ChopDiamondConnector REF 31  
            org.nlogo.sdm.gui.ChopRateConnector REF 17   
        org.nlogo.sdm.gui.BindingConnection 2 319 239 225 139 NULL NULL 0 0 0 
            org.jhotdraw.contrib.ChopDiamondConnector REF 31  
            org.nlogo.sdm.gui.ChopRateConnector REF 4
@#$#@#$#@
<experiments>
  <experiment name="Logistic Growth Leading Towards Chaos" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="100"/>
    <metric>population</metric>
    <enumeratedValueSet variable="death-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="birth-rate">
      <value value="0.25"/>
      <value value="0.5"/>
      <value value="0.75"/>
      <value value="1"/>
      <value value="1.25"/>
      <value value="1.5"/>
      <value value="1.75"/>
      <value value="2"/>
      <value value="2.25"/>
      <value value="2.5"/>
      <value value="2.75"/>
      <value value="3"/>
      <value value="3.25"/>
      <value value="3.5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-pop">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="SimLength">
      <value value="200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="carrying-capacity">
      <value value="700"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="75"/>
    <metric>population</metric>
    <enumeratedValueSet variable="SimLength">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="death-rate">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="init-pop">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="carrying-capacity">
      <value value="700"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="birth-rate">
      <value value="0.154"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
