breed [ people person]
breed [ points point]
breed [ tsunamis tsunami]
breed [ waves wave]
people-own [ target]
tsunamis-own [ start-time
end-time]
globals [ destroyed-buildings initial-buildings]

to setup
  show date-and-time
  clear-all
  create-random-building
  set-default-shape tsunamis "square"                        ;; default shape untuk tsunami yang dimodelkan
  set-default-shape points "house"                           ;; default shape untuk exit point yang dimodelkan, berbentuk house
  create-ordered-points jumlah-exit-point
  [ setxy random max-pxcor random max-pycor                  ;; menentukan letak exit point, posisi exit point berada pada koordinat x positif
    set color red                                            ;; exit point ditentukan berwarna merah
    set size 5                                               ;; agar lebih mudah terlihat
  ]
  create-people initial-people [
    set shape "person"
    set size 0.75
    set color white 
    setxy random-xcor random-ycor                            ;; peletakan turtle secara random, berada disebagian sumbu y (> -80) menuju menuju 100
    if xcor < -95 [ die]                                    
    set target one-of points
    face target                                               ;; menetukan arah turtle ke exit point ( posisi tujuan)
    ]
  
  ask patches with [ pxcor = min-pxcor]                       ;; membuat awal pergerakan dari tsunami
  [ ignite]
  
  set initial-buildings patches with [ pcolor = black]        ;; menginisialisasikan bangunan
  set destroyed-buildings 0
  plot count turtles with [ color = white]
    
end

;; membuat building 
to create-random-building
  ask patches [  set pcolor brown ] 
  ask patches [ if random-float 1.0  < 0.04 [ set pcolor black]]                                  ;; dibuat secara random
  ask patches with [ pcolor = black] [ ask patches in-radius random-float 2 [ set pcolor black]]
  ask patches with [ count neighbors4 with [ pcolor = black] = 4] [ set pcolor black]
  ask patches with [ pcolor = black] [ ask turtles-here [ die]]                                   ;; menghilangkan turtles di patches hitam
end

;; memulai simulasi  
to go
  if ticks = 100 [ stop]
  ask people
  [ if distance target = 0                                   ;; menggerakkan agent human menuju exit point
  [ set target one-of points
    face target
    die]  
  ifelse distance target < 1
  [ move-to target]
  [ face target]
  ifelse [ pcolor] of patch-ahead 1 = black
  [ lt random-float 360]
  [ fd 1]]
  
 move-tsunamis
 fade-waves
 update-plots 
end

;; memulai gerak model tsunami
to move-tsunamis    
  ask tsunamis [ ask neighbors4 with [pcolor = brown]
        [ ignite]                                            ;; membuat menyala di bagian depan
      set breed waves]                                       ;; membuat model gelombang
  stop-tsunamis
  update-plots
  tick
end

to ignite                                                    ;; memulai nyala gelombang tsunami
  sprout-tsunamis 1
  [ set color blue
    fd speed]                                                ;; mengatur kecepatan gelombang tsunami berdasarkan speed
  set pcolor brown
  set destroyed-buildings destroyed-buildings + 1
  trapped-people
end

to stop-tsunamis
  ask turtles with [ color = blue] [ 
  if pxcor > 80 [ die] ]
  stop
  tick
end

to fade-waves                                                ;; mengatur gelombang yang memudar setelah bergerak
  ask waves
    [ set color color - white  
      if color < blue - 3.5    
        [ set pcolor color
          die ]]
end

to trapped-people                                            ;; menginisialisasikan agent human yang berada dalam tsunami
  let prey one-of people-here
  if prey != nobody 
  [ ask prey [ die]]
end

to update-plots
  set-current-plot "Grafik"                                 ;; menentukan plot yang akan ditampilkan
  set-current-plot-pen "people"                             ;; menentukan pen plot yang ingin ditampilkan
  plot count turtles with [ color = white]                  ;; yang akan ditampilkan dengan pen yang disebut sebelumnya
  set-current-plot-pen "building"                           ;; menentukan pen plot yang ingin ditampilkan
  plot count patches with [pcolor = black]                  ;; yang akan ditampilkan dengan pen yang disebut sebelumnya
end







  
  
@#$#@#$#@
GRAPHICS-WINDOW
20
73
512
506
120
100
2.0
1
10
1
1
1
0
0
0
1
-120
120
-100
100
0
0
1
ticks

BUTTON
543
162
649
195
pengaturan
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
664
163
734
196
mulai
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
541
243
713
276
jumlah-exit-point
jumlah-exit-point
1
10
4
1
1
NIL
HORIZONTAL

SLIDER
541
202
808
235
initial-people
initial-people
0
10000
4000
500
1
NIL
HORIZONTAL

TEXTBOX
546
122
696
174
for the first step, choose the count of agent and exit point that used in simulation. 
10
41.0
1

BUTTON
750
164
805
197
jalur
pen-down
NIL
1
T
TURTLE
NIL
NIL
NIL
NIL

CHOOSER
541
279
679
324
model-bencana
model-bencana
"tsunami" "earthquake"
0

PLOT
540
330
811
507
grafik
tsunamis
human
0.0
1000.0
0.0
1000.0
true
true
PENS
"people" 1.0 0 -2674135 true
"building" 1.0 0 -13345367 true

SLIDER
686
285
810
318
speed
speed
0
2
1
.05
1
NIL
HORIZONTAL

MONITOR
757
438
808
483
building
count patches with [ pcolor = black]
1
1
11

MONITOR
758
381
810
426
human
count turtles with [ color = white]
2
1
11

TEXTBOX
546
71
802
121
Model Simulasi Evakuasi \\nBencana Tsunami
20
15.0
1

@#$#@#$#@
WHAT IS IT?
-----------
Sebuah Model Simulasi Sederhana dari Evakuasi Ebncana Tsunami Berbasis Agent Based Modeling


HOW IT WORKS
------------
Simulasi ini menampilakn sebuah skenario bencana tsunami yang terjadi
dan agent human yang bergerak menuju exit point.


HOW TO USE IT
-------------
prosedur menjalankan Simulasi evakuasi bencana tsunami ini adalah :
1. Tentukan jumlah agent human, jumlah exit point dan kecepatan dari agent tsunami yang bergerak.
2. setelah dilakukan pengaturan seperti yang diinginkan, tekan tombol "mulai", dan simulasi akan berjalan.

 

THINGS TO NOTICE
----------------
proses simulasi akan berlangsung dalam hitungan ticks Netlogo ini. Simulasi akan berhenti ketika ticks mencapai 100 (bisa bisa diatur nilai lain) atau mencapai titik tertentu dari koordinat X. selama 
proses simulasi berlangsung, dapat dilihat jumlah kerusakan black patches (bangunan) dan jumlah agent human yang terus berkurang sampai berakhirnya proses simulasi berlangsung. kemudian juga dihasilkan sebuah grafik yang menunjukkan penurunan nilai jumlah agent tsunami dan human.


THINGS TO TRY
-------------
selain dengan simulasi yang dilakukan diawal,
user dapat melakukan beberapa model simulasi lainnya untuk melihat beberapa perbedaan yang dihasilkan. misalnya dengan mengubah jumlah exit point, mengubah kecepatan pergerakan tsunami dan mengubah jumlah agent human.


EXTENDING THE MODEL
-------------------
Pengembangan yang dapat dilakukan  untuk membuat simulasi ini menjadi lebih baik diantaranya adalah: 
1. Menampilkan karakter fisik yang lebih baik dari area bencana dan model bencana.
2. Menambahkan start-time pada awal model simulasi
3. Menggabungkan dengan beberapa tools GIS untuk dapat memberikan data valid pada model



NETLOGO FEATURES
----------------
terdapat banyak fiture yang belum berhasil ditampilkan dalam proses pengerjaan penelitian tugas akhir ini. yang terdapat saat ini hanya fiture dasar dan masih dikembangkan oleh penulis. penulis dapat dihubungi via email : rizqiya.ws@elektro-unsyiah.net


RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.


CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
