turtles-own [ risk-situation in-degree out-degree M psi_0 psi_1 fitness_0 fitness_1 occurrence]
globals [ path-one-chain path-two-chain path-three-chain total-links clock number-of-occurrences]

to setup
  ca
  set-default-shape turtles "circle"
  draw-network
  setup-quantum-game
end


to draw-network
  create-nodes
  create-links
  calculate-statistics
end

to setup-quantum-game
  ask turtles [ set psi_1 random-float 0.01 ] ; low initial quantum amplitude for occurrence of risk situation
  ask turtles [ set psi_0 sqrt(1 - abs(psi_1) ^ 2) ] ; psi(0) = (1 - |psi(1)| ^ 2) ^ 0.5
end



to play-quantum-game
   set clock clock + 1
   if clock mod updating-frequency = 0 
   [
    ask turtles [ set color blue ]
    update-qubit
    possible-world-configurations 
    actualization
    ask turtles [set size 1 + fitness_1 * 3]
    set number-of-occurrences sum [occurrence] of turtles
    do-plot ]
  
end


to update-qubit
  ask turtles [ set M b * psi_1 - b * abs(psi_1) ^ 2 ] ; logistic map: b * psi(1) - b * |psi(1)| ^ 2
  ask turtles 
  [ 
    ifelse (any? in-link-neighbors) 
    [ set psi_1 (1 - epsilon) * M + epsilon * mean [M] of in-link-neighbors ]
    [ set psi_1 M ]
  ]
  
  ask turtles [ set psi_0 sqrt( 1 - abs(psi_1) ^ 2) ]
end


to possible-world-configurations
  ask turtles 
  [  set fitness_0 abs(psi_0) ^ 2 ; proportion of possible world configurations in which the risk situation does not occur
     set fitness_1 abs(psi_1) ^ 2 ] ; proportion of possible world configurations in which the risk situation occurs
end



to actualization
  ask turtles [ ifelse random-float 1.000 <= fitness_1 [ set occurrence 1 ] [ set occurrence 0 ] ]
  ask turtles [ ifelse (occurrence = 1) [ set color red ] [ set color blue ] ]
end

to do-plot
  set-current-plot "Number of Occurrences"
  plot number-of-occurrences
 
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Morphic Web Drawing Procedures ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; UTOW (Up-to-Object Web) | UTOS (Up-to-Object Scenarios)

; Turtle 0 : geostrategic disruption
; Turtle 1 : hacktivism
; Turtle 2 : leakism
; turtle 3 : cyber attacks
; Turtle 4 : critical systems failure
; Turtle 5 : massive incident of data fraud or theft
; Turtle 6 : massive digital misinformation
; Turtle 7 : terrorism
; Turtle 8 : failure of diplomatic conflict resolution
; Turtle 9 : cyber war

; AOW (After-Object Web) | AOS (After-Object-Scenarios)


; Turtle 10 : social and political infrastructures disruption
; Turtle 11 : armed forces and internal security disruption
; Turtle 12 : intelligence infrastructure disruption
; Turtle 13 : business structures disruption
; Turtle 14 : financial disruption


to create-nodes
  create-ordered-turtles 15 [fd 15 rt 180]
  ask turtle 0 [ set risk-situation "geostrategic disruption" ]
  ask turtle 1 [ set risk-situation "hacktivism" ]
  ask turtle 2 [ set risk-situation "leakism" ]
  ask turtle 3 [ set risk-situation "cyber attacks" ]
  ask turtle 4 [ set risk-situation "critical systems failure" ]
  ask turtle 5 [ set risk-situation "massive incident of data fraud or theft" ]
  ask turtle 6 [ set risk-situation "massive digital misinformation" ]
  ask turtle 7 [ set risk-situation "terrorism" ]
  ask turtle 8 [ set risk-situation "failure of diplomatic conflict resolution" ]
  ask turtle 9 [ set risk-situation "cyber war" ]
  ask turtle 10 [ set risk-situation "social and political infrastructures disruption" ]
  ask turtle 11 [ set risk-situation "armed forces and internal security disruption" ]
  ask turtle 12 [ set risk-situation "intelligence infrastructure disruption" ]
  ask turtle 13 [ set risk-situation "business structures disruption" ]
  ask turtle 14 [ set risk-situation "financial disruption" ]
  ask turtles [ set label risk-situation ]
end


to create-links
  create-UTOW
  create-AOW
  
end




to create-UTOW
  ask turtle 1 ; hacktivism
  [ 
    create-link-to turtle 0 ; geostrategic disruption - related to targeting and immitation effects
    create-link-to turtle 2 ; leakism - by stimulating "leakism" movements
    create-link-to turtle 3 ; cyber attacks - by stimulating cyberattacks
    create-link-to turtle 7 ; terrorism - appearance of new hacktivist movements radicalized around massive 
                            ; disruption of critical infrastructures and supporting cyber terrorism
    create-link-to turtle 8 ; failure of diplomatic conflict resolution - by being a factor of failure of diplomatic conflict resolution
     ]
  
  ask turtle 2 ; leakism
  [ create-link-to turtle 0 ; geostrategic disruption - related to damaging critical armed forces, geopolitical 
                            ; and economic infrastructures leaks
    create-link-to turtle 1 ; hacktivism - by stimulating "hacktivism" movements
    create-link-to turtle 3 ; cyber attacks - by stimulating cyber attacks
    create-link-to turtle 7 ; terrorism - leaks of sensitive information influencing terrorist attacks including conventional terrorism and cyber terrorism
                            ; in particular regarding disclosure of critical information on exploitable vulnerabilities
    create-link-to turtle 8 ; failure of diplomatic conflict resolution - by being a factor of failure of diplomatic conflict resolution
  ]
  
  
  ask turtle 3 ; cyber attacks
  [ create-link-to turtle 0 ; geostrategic disruption - related to attacks aimed at specific geostrategic disruption
    create-link-to turtle 1 ; hacktivism - by stimulating hacktivist-related cyber attacks
    create-link-to turtle 2 ; leakism - by allowing access to information that can be disclosed
    create-link-to turtle 4 ; critical systems failure - by targeting key systems and their vulnerabilities
    create-link-to turtle 5 ; massive incident of data fraud or theft - by targeting data for criminal purposes
    create-link-to turtle 6 ; massive digital misinformation - as a measure of propaganda, prior to conventional state-related attack or prior to a cyber terrorist strike
    create-link-to turtle 7 ; terrorism - influencing both cyberterrorism and conventional attacks
    create-link-to turtle 8 ; failure of diplomatic conflict resolution - leading to failure of diplomatic conflict resolution as a form of attack to a state or region
  ]
  
  ask turtle 4 ; critical systems failure
  [ create-link-to turtle 0 ; geostrategic disruption - resulting from critical infrastructures failure linked to critical cyber systems failure
    create-link-to turtle 7 ; influencing windows of opportunity for terrorism, both in the form of unrelated opportunistic attacks, and planned synchronized attacks 
                            ; with cyber attack-induced critical systems failure
  ]
  
  ask turtle 5 ; massive incident of data fraud or theft 
  [
    create-link-to turtle 0 ; geostrategic disruption - theft of strategic-valued information and massive fraud that is damaging from an economic perspective
    create-link-to turtle 2 ; leakism - theft of sensitive data for disclosure purposes
    create-link-to turtle 7 ; terrorism - backing up of terrorist movements by theft of critical strategic-valued data
  ]
  
  
  ask turtle 6 ; massive digital misinformation
  [  
    create-link-to turtle 0 ; geostrategic disruption - if the misinformation targets key strategic dynamics including social and political dynamics in contexts of social, economic 
                            ; and political crises
    ]
    
  ask turtle 7 ; terrorism
  [
    create-link-to turtle 0 ; geostrategic disruption - related to conventional and cyber terrorist attacks 
    create-link-to turtle 3 ; cyber attacks - cyber terrorist-related attacks and sophisticated combination of cyber terrorism and conventional terrorism
    create-link-to turtle 8 ; failure of diplomatic conflict resolution - due to terrorist operations that disrupt negotiation
    create-link-to turtle 9 ; cyber war - cyber war between states triggered by a previous dynamics of terrorist attacks
  ]
  
  ask turtle 8 ; failure of diplomatic conflict resolution
  [
    create-link-to turtle 0 ; geostrategic disruption - due to conflict resolution failure
    create-link-to turtle 1 ; hacktivism - influencing hacktivism
    create-link-to turtle 3 ; cyber attacks - influencing cyber attacks
    create-link-to turtle 7 ; terrorism - due to conflict resolution failure
    create-link-to turtle 9 ; cyber war - failure o diplomatic conflict resolution influencing cyber war
  ]
  
  ask turtle 9 ; cyber war
  
  [
    create-link-to turtle 0 ; geostrategic disruption - due to cyber war-related strategies and resulting actions

    ; Following are links related to possible cyber war actions undertaken by conflicting factions:

    create-link-to turtle 1 ; hacktivism - possible state-sponsored hacktivism
    create-link-to turtle 2 ; leakism - possible state-sponsored leakism to provoke social and political disruption
    create-link-to turtle 3 ; cyber attacks - main actions of cyber warfare
    create-link-to turtle 4 ; critical systems failure - due to targeting within the context of cyber warfare manouvers
    create-link-to turtle 5 ; massive incident of data fraud or theft - as an integrating part of cyber war operations
    create-link-to turtle 6 ; massive digital misinformation - as an integrating part of cyber war operations
  ]
    
  
end



to create-AOW
  
  ask turtle 10 ; social and political infrastructures disruption
  [ create-link-from turtle 0 ; geostrategic disruption - as a post-event disruption
    create-link-from turtle 1 ; hacktivism - targeting social and political infrastructures' disruption
    create-link-from turtle 2 ; leakism - disclosure of sensitive information that leads to social and political infrastructures disruption
    create-link-from turtle 3 ; cyber attacks - attacks that disrupt social and political infrastructures
    create-link-from turtle 4 ; critical systems failure - social and political disruption caused by failure of critical systems
    create-link-from turtle 7 ; terrorism - by targeting social and political infrastructures
    create-link-from turtle 9 ; cyber war - by targeting social and plolitical infrastructures

    create-link-to turtle 0 ; can be a source of geostrategic disruption: UTOW link
  ]
  
   
  ask turtle 11 ; armed forces and internal security disruption
  [ create-link-from turtle 0 ; geostrategic disruption - as a post-event disruption
    create-link-from turtle 1 ; hacktivism - targeting armed forces and internal security
    create-link-from turtle 2 ; leakism - disclosure of sensitive armed forces information that places at risk internal security and/or armed forces' infrastructures
    create-link-from turtle 3 ; cyber attacks - attacks that target armed forces and internal security
    create-link-from turtle 4 ; critical systems failure - social and political disruption caused by failure of critical systems
    create-link-from turtle 5 ; massive incident of data fraud or theft - theft of critical internal security and armed forces information
    create-link-from turtle 7 ; terrorism - by targeting social and political infrastructures
    create-link-from turtle 9 ; cyber war - by targeting social and plolitical infrastructures

    create-link-to turtle 0 ; can be a source of geostrategic disruption: UTOW link
     ]
  
  
  ask turtle 12 ; intelligence infrastructure disruption
  
  [ create-link-from turtle 0 ; geostrategic disruption - as a post-event disruption
    create-link-from turtle 1 ; hacktivism - targeting intelligence-related infrastructures
    create-link-from turtle 2 ; leakism - disclosure of sensitive intelligence information that places at risk intelligence infrastructure
    create-link-from turtle 3 ; cyber attacks - attacks to sensitive areas and strategic intelligence targets, paid for attacks (cyber-espionage)
    create-link-from turtle 5 ; massive incident of data fraud or theft - theft of critical intelligence information
    create-link-from turtle 7 ; terrorism - by targeting intelligence-related infrastructures
    create-link-from turtle 9 ; cyber war - by attacking the intelligence infrastructure as a strategic target
  ]
  
  
  
  
  ask turtle 13 ; business structures disruption
  [ create-link-from turtle 0 ; geostrategic disruption - as a post-event disruption
    create-link-from turtle 1 ; hacktivism - targeting business structures disruption
    create-link-from turtle 2 ; leakism - disclosure of leaks damaging to the business structures
    create-link-from turtle 3 ; cyber attacks - attacks targeting business targets and damaging to the business structure
    create-link-from turtle 4 ; critical systems failure - leading to disruption of business-related infrastructures
    create-link-from turtle 5 ; massive incident of data fraud or theft - leading to business-related disruption
    create-link-from turtle 7 ; terrorism - targeting business-related targets
    create-link-from turtle 8 ; failure of diplomatic conflict resolution - affecting business relations between countries
    create-link-from turtle 9 ; cyber war - by attacking business as a strategy for business disruption
    
    
    create-link-to turtle 0 ; can be a source of geostrategic disruption: UTOW link
    
     ]
  
  
  ask turtle 14  ; financial disruption
  [ 
    create-link-from turtle 0 ; geostrategic disruption - as a post-event disruption
    create-link-from turtle 1 ; hacktivism - targeting financial structures disruption
    create-link-from turtle 2 ; leakism - massive disclosure leading to financial scandals producing a financial disruption
    create-link-from turtle 3 ; cyber attacks - attacks to financial centers towards disruption of the global financial web
    create-link-from turtle 4 ; critical systems failure - leading to disruption of finance-related infrastructures
    create-link-from turtle 5 ; massive incident of data fraud or theft - leading to finance-related disruption
    create-link-from turtle 7 ; terrorism - targeting finance-related targets
    create-link-from turtle 9 ; cyber war - by attacking the financial system as a strategy for financial disruption
    
    create-link-to turtle 0 ; can be a source of geostrategic disruption: UTOW link
    
     ]

end






to calculate-statistics
  
  ask turtles 
  [ set in-degree count my-in-links
    set out-degree count my-out-links ]
  
  set-current-plot "In Degree Distribution"
  histogram [in-degree] of turtles
  
  set-current-plot "Out Degree Distribution"
  histogram [out-degree] of turtles
  
end   
@#$#@#$#@
GRAPHICS-WINDOW
814
10
1574
671
37
31
10.0
1
10
1
1
1
0
1
1
1
-37
37
-31
31
0
0
1
ticks
30.0

BUTTON
624
404
687
437
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
215
162
505
380
In Degree Distribution
degree
frequency
0.0
10.0
0.0
4.0
true
false
"" ""
PENS
"default" 1.0 1 -16777216 true "" ""

PLOT
506
162
798
380
Out Degree Distribution
degree
frequency
0.0
10.0
0.0
4.0
true
false
"" ""
PENS
"default" 1.0 1 -16777216 true "" ""

SLIDER
38
254
130
287
b
b
0
4
4
0.01
1
NIL
HORIZONTAL

SLIDER
39
303
131
336
epsilon
epsilon
0
1
0.1
0.01
1
NIL
HORIZONTAL

PLOT
215
10
794
160
Number of Occurrences
NIL
NIL
0.0
10.0
0.0
8.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles"

BUTTON
621
458
763
491
NIL
play-quantum-game
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
27
173
199
206
updating-frequency
updating-frequency
0
100000
100000
1000
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This is a risk quantum simulator that addresses the evolution of geostrategic disruption by cyber threat dynamics applying the concepts laid out in the article:


Gon_alves (2012), Risk Mathematics and Quantum Games on Quantum Risk Structures - A Nuclear War Scenario Game, arXiv:1211.6683 [physics.soc-ph] (http://arxiv.org/abs/1211.6683).


See also the related models:

Gon_alves, C.P. 2012. _Risk Simulator I - Nuclear War_. CQSSRM - _Risk Simulator_ (http://modelingcommons.org/browse/one_model/3470#model_tabs_browse_discuss)


The risk web is based upon the WEF Risks 2012 Report and the article:

Gon_alves (2012), Risk Governance - A Framework for Risk Science-Based Decision Support Systems, http://papers.ssrn.com/sol3/papers.cfm?abstract_id=2085482

However, a few extra elements and links are added to the web, that are found relevant from the perspective of cyber threat risk evaluation.


The model draws, first, the morphic web of risk situations and then introduces the evolutionary scenario dynamics, based upon the quantum theoretical approach to risk mathematics introduced in arXiv:1211.6683 [physics.soc-ph] as explained in the next section on the conceptual overview of the model.



## CONCEPTUAL OVERVIEW

Risk mathematics can be approached foundationally from "morphic web theory", a morphic web is a network of morphisms, where by a morphism it is understood a directional relation that goes from an origin object to a target object, that is, under the morphism, an origin object is linked to a target object by a morphic connection that goes from the origin to the target. While mathematical categories are morphic webs not all morphic webs are mathematical categories (Gon_alves, 2012)

There are ten risk situations addressed in the current model's morphic web:

S0 : geostrategic disruption
S1 : hacktivism
S2 : leakism
S3 : cyber attacks
S4 : critical systems failure
S5 : massive incident of data fraud or theft
S6 : massive digital misinformation
S7 : terrorism
S8 : failure of diplomatic conflict resolution
S9 : cyber war

These ten risk situations will compose the up to object web for constructing up to object scenarios that is, scenarios that may lead to geostrategic disruption events.

Besides these ten risk situations, five more risk situations are added to build the after object scenarios, that is, scenarios that take place after geostrategic disruption events (some of the linkages of the next five additional risk situations will also be a part of the up to object risk web): 

S10 : social and political infrastructures disruption
S11 : armed forces and internal security disruption
S12 : intelligence infrastructure disruption
S13 : business structures disruption
S14 : financial disruption

The connections are addressed, in terms of the basic influences, in the form of programming notes added to the up to object and after object risk webs' Netlogo programming procedures.

These programming notes may be useful in addressing static scenario analysis based on the current Netlogo model.

For the dynamical scenario analysis, we work with a quantum game, such that, at each round of the game, each systemic situation is characterized by a qubit:

	|Sj,t> = psi(j,t,0)|0> + psi(j,t,1)|1>

where |0> encodes the non-occurrence of the risk situation and |1> encodes the occurrence of the risk situation.

We follow here the "weak" many worlds interpretation, addressed in arXiv:1211.6683 [physics.soc-ph], with one world in act and the squared modulus of the quantum amplitudes being interpreted as the proportion of possible world configurations in which a corresponding scenario occurs (a scenario is defined as a configuration |s1,s2,...,sj,...,s9> with sj = 0,1), leading to a fitness measure over possible world configurations and to the assumption that one configuration takes place in act, with probability measurable as numerically coincident with the fitness.

Transition between two quantum game rounds is locally given by the action of the quantum gate:

	U(t) = U1(t)U2(t)

with:

	U1(t) := psi(j,t,0)(|0><0| - |1><1|) + psi(j,t,1)(|0><1| + |1><0|)

	U2(t) := psi(j,t-1,0)(|0><0| - |1><1|) + psi(j,t-1,1)(|0><1| + |1><0|)

where psi(j,t,0) and psi(j,t,1) are real-valued and lie in the unit interval [0,1], obeying the following relations:

	psi(j,t,0) = sqrt(1 - |psi(j,t,1)|^2)

	psi(j,t,1) = F[psi(j,t-1,1)]

where F(.) is the coupled lattice map:

	F[(psi,j,t-1,1)] = (1 - epsilon) M(t) + epsilon * h(t)

	M(t) = b * psi(j,t-1,1) * (1 - psi(j,t-1,1))

with h(t) representing the mean quantum amplitude of the risk situations that are at the origin of the j-th risk situation.

Due to the structure of U(t), the resulting quantum game dynamics leads to the coupled logistic dynamics being implemented by the quantum computation at the level of the sequence of quantum amplitudes.

The user can control coupled map parameters through the corresponding sliders "b" and "epsilon". An additional updating frequency slider allows the user to slow down each model_s steps so that one can better visualize the evolution of the unfolding scenarios.

As each threat increases in probability of occurrence (see the explanation above as well as the next section's references for a proper interpretation of probabilities), the circle corresponding to the event starts to grow, whenever the threat takes place the circle turns from blue color to red.



## CREDITS AND REFERENCES


The main reference for the current work is the article that provides the quantum theoretical background for the approach followed here:

Gon_alves, C.P. (2012). _Risk Mathematics and Quantum Games on Quantum Risk Structures - A Nuclear War Scenario Game_ arXiv:1211.6683 physics.soc-ph.

The current model is also an integrating part of the research and teaching umbrella project under development by the author at Instituto Superior de Ci_ncias Sociais e Pol_ticas (ISCSP), Technical University of Lisbon:

COMPLEX QUANTUM SYSTEMS SCIENCE AND RISK MATHEMATICS (CQSSRM)
URL: https://sites.google.com/site/quantumcomplexity/

For academic reference the model should be quoted as:

Gon_alves, C.P. 2012. _Risk Simulator II - Cyber Threats_. CQSSRM - _Risk Simulator_.


For the scenario analysis process, the user may also consult the two references:

_Risk Governance - A Framework for Risk Science-Based Decision Support Systems_, 2012, Gon_alves, C.P., http://papers.ssrn.com/sol3/papers.cfm?abstract_id=2085482

"An_lise de Cen_rios e Risco", 2012, Gon_alves, C.P. (Scenario analysis and Risk, text in Portuguese) 
https://sites.google.com/site/quantumcomplexity/analise-de-cenarios-e-risco
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
