turtles-own [shares money my-price news-sensitivity traded?]
globals [ stock-price up-down-history price-history]

to setup
  clear-all
  set-default-shape turtles "Person"
  crt population
  ask turtles [
    set xcor random-xcor
    set ycor random-ycor
    set shares 1
    set money 10000
    set my-price 50 + random 30
    set news-sensitivity random-normal 1 0
  ]
  set stock-price mean [my-price] of turtles
  set up-down-history n-values 10 [0]
  set price-history []
  if show-my-price? [
    ask turtles [set label my-price]
  ]
end

to go
  ask turtles [ set traded? false ]
  ;;find a partner for this round
  ask turtles [pair-up]
  ;;if layout animation is on, move toward your partner
  if do-layout? [
    repeat 20 [layout-spring turtles links .1 .5 .1] 
  ]
  ;;trade for this round
  ask turtles [
    ;;if the endowment-effect is on, some turtles will refuse to trade each turn
    if endowment-effect? [
      if random 100 < endowment-frequency [
        set traded? true
      ]] 
    trade
    update-my-price
    ask other turtles [ update-my-price ]
    do-plots
    ]
  ask links [die]
  tick
end

to pair-up
  if count link-neighbors = 0 [
    create-link-with one-of other turtles with [
    count link-neighbors = 0] [set color red]
  ]

end

to trade 
  if not traded? [
    ;;do the transaction
    let trade-partner one-of link-neighbors
    let offer-price my-price
    let counter-price [my-price] of trade-partner
    ;;if your offer is higher than partner's price, 
    ;;and you have at least one share,
    ;;you try to sell to your partner
    if offer-price > counter-price [
      ask trade-partner [ try-to-sell-to myself offer-price ]
      ]
    ;;if your offer is lower than partner's price, 
    ;;your partner tries to sell to you
    if offer-price + 1 <= counter-price [
      try-to-sell-to trade-partner (offer-price + 1)
     ]
    ;;if offer-price = counter-price, no shares exchanged
    ;;each turtle can only trade once per round
    ;;then, they must form new links with new trade-partners
    set traded? true
    ask link-neighbors [ set traded? true ]
  ]
    
end

;;general selling procedure, the turtle with the 
;;lower price tries to sell to his trade partner
to try-to-sell-to [ buyer buying-price ]
  if shares > 0 [
    if [money] of buyer > buying-price [
      set money money + buying-price
      set shares shares - 1
      ask buyer [ set money money - buying-price ]
      ask buyer [ set shares shares + 1 ]
      
      ;;create a list reflecting the movement of the stock-price
      if buying-price > stock-price [
        set up-down-history fput 1 up-down-history
      ]
      if buying-price < stock-price [
        set up-down-history fput -1 up-down-history
      ]
      if buying-price = stock-price [
        set up-down-history fput 0 up-down-history
      ]
      
      if length up-down-history > 100 [
        set up-down-history sublist up-down-history 0 99
      ]
      ;;each time a transaction happens, the stock-price is updated
      set stock-price buying-price
      set price-history fput stock-price price-history
  ;    do-plots
    ]]
end

to update-my-price
  if stock-price < 1 [
    set my-price my-price + 1
  ]
  if react-to-news? [
    let good-news random 5
    let bad-news random -5 
    let news good-news + bad-news
    set my-price my-price + news * news-sensitivity 
  ]
  if apparent-trends? [
    let last5 sublist up-down-history 0 5
    let last10 sublist up-down-history 0 10
    if sum last5 = 5 [
      if random 100 < trend-spotting-prob [
        set my-price my-price + 5
      ]]
    if sum last5 = -5 [
      if random 100 < trend-spotting-prob [ 
        set my-price my-price - 5
      ]] 
    ;;put some downward pressure on the price if it is stagnant
    if mean last10 = 0 [
      if random 100 < trend-spotting-prob [ 
        set my-price my-price - 1
      ]]]
 
  if bandwagon-effect? [
    let neighbor-price [my-price] of one-of other turtles
    if random 100 < bandwagon-strength [
    set my-price neighbor-price 
  ]]
end
  

to do-plots
  set-current-plot "current-price"
  set-current-plot-pen "Price" 
  plot stock-price 
  set-current-plot "share-distribution"
  set-current-plot-pen "default"
  histogram [shares] of turtles   
end
@#$#@#$#@
GRAPHICS-WINDOW
590
15
1020
466
10
10
20.0
1
10
1
1
1
0
1
1
1
-10
10
-10
10
0
0
1
ticks

BUTTON
5
15
71
48
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
175
15
238
48
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
5
95
177
128
Population
Population
0
200
100
2
1
NIL
HORIZONTAL

BUTTON
80
15
165
48
go-once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
245
240
345
285
stock-price
round stock-price
2
1
11

PLOT
15
290
345
472
current-price
Trades
Price
0.0
10.0
0.0
100.0
true
false
PENS
"default" 1.0 0 -16777216 true
"Price" 1.0 0 -16777216 true

PLOT
15
135
240
285
share-distribution
shares
turtles
0.0
50.0
0.0
100.0
true
false
PENS
"default" 1.0 1 -16777216 true

SWITCH
5
55
129
88
do-layout?
do-layout?
1
1
-1000

SWITCH
135
55
293
88
show-my-price?
show-my-price?
1
1
-1000

SLIDER
375
365
555
398
trend-spotting-prob
trend-spotting-prob
0
100
50
1
1
NIL
HORIZONTAL

SWITCH
375
180
526
213
react-to-news?
react-to-news?
0
1
-1000

SWITCH
375
220
525
253
apparent-trends?
apparent-trends?
0
1
-1000

SWITCH
375
260
555
293
endowment-effect?
endowment-effect?
1
1
-1000

SWITCH
375
300
555
333
bandwagon-effect?
bandwagon-effect?
0
1
-1000

SLIDER
375
405
555
438
endowment-frequency
endowment-frequency
0
100
10
1
1
NIL
HORIZONTAL

SLIDER
375
445
557
478
bandwagon-strength
bandwagon-strength
0
100
30
1
1
NIL
HORIZONTAL

@#$#@#$#@
WHAT IS IT?
-----------
This is a simplified model of stock trading.  In the model, agents take turns pairing up and trading stocks.  Each agent has beliefs about how much the stock is worth, in addition to knowledge of the last price it sold for. A simple set of rules determines whether the agents sell stocks to one another on a given turn, and the selling price. The goal to see what kinds of endogenous conditions can cause extreme variation in the stock price.  In real life, these extreme variations are sometimes called stock bubbles.  Therefore, almost all fluctuation in the stock price is due to agents reacting to each other's actions, and to movements and patterns that the agents detect in the price itself.  The exception to this rule is the 'news' feature, which is the only "outside" mechanism affecting the stock price.  As agents trade with each other turn by turn, they constantly update their individual beliefs about the stock price. 


This model attempts to examine how a stock price can change based only on the aggregate effects of individual interactions.  In real markets, a bubble and the subsequent crash are usually attributed to some combination of speculation, misinformation, and cognitive bias.  The implicit assumption is that when the price quickly rises by one hundred percent or more, and then falls rapidly to the original level or below, this rapid and extreme fluctuation represents a false belief about what the asset is "really" worth. Famous bubbles include the recent housing bubble, but there are examples reaching as far back as the 18th century South Sea Shipping Company stock bubble.  People scoff at those caught up in the speculation, wondering how--knowing what they know about markets--anyone could honestly think the asset's value could rise so quickly and dramatically.  But if people are not using outside information about the world to determine what the asset worth in comparison to other assets, how does the price change so much?  Modern behavioral economists attribute much of this speculative behavior to groupthink, bandwagon effects, endowment effects, and other cognitive biases.  This model asks whether these extreme price fluctuations can be replicated using endogenous factors that imitate real-life cognitive biases. 


HOW IT WORKS
------------
During set-up, each agent is given some shares, some money, a price (the price they currently believe the stock to be worth), and a news-sensitivity.

The action of the model takes place during trading turns.  At the beginning of each turn, each agent creates a link with another agent how has not yet traded for that turn. Then, the agents attempt to trade with one another.  One agent (randomly chosen from the pair) offers to buy one share from the other agent.

Rules for trading:

If both agents have at least one share and sufficient money to trade, then

1.  The offering agent offers to buy a share for his price (my-price).
2.  If the offering agent's price is higher than his partner's price, the offering agent exchanges money (equal the offering price) for a share of the trade partner's stock.
3.  If the offering agent's price is lower than his partner's price, the partner counters, offering $1 more than the original offer, and exchanges his money for one share of the offering agent's stock. 
4.  If both agents have the same my-price, no shares are exchanged.  
5.  Both agents set their traded? value to true for this turn. 

After each transaction, the stock-price is updated to reflect the latest sale price.  Once all the pairs have finished trading, the links are broken, all agents set their traded? values to false, and a new round is begun.  

When agents are not trading, they observe the stock-price's movement and use it, as well as other information, to update their my-price value.  As many agents constantly update their beliefs about what the stock is worth, different fluctuation patterns in stock-price patterns emerge.

Rules for updating my-price: 

1.  If the endowment effect is turned on (endowment-effect? = true), agents have a certain (user-selected) probability of refusing to trade for a given turn.
2.  If news is turned on (react-to-news? = true), adjust my-price up or down depending on the magnitude of the news and my news-sensitivity.
3.  If the agents are trying to spot trends (apparent-trends? = true), adjust my-price upward if the stock-price has risen several times in a row and down if the stock-price has fallen several times in a row.  
4.  If the bandwagon effect is turned on (bandwagon-effect? = true), then some turtles will pick another turtle to set their my-price equal to.


HOW TO USE IT
-------------
The setup button creates the specified number of turtles.  do-layout? and show-my-price? are optional settings that can be turned on to improve the model's animation, or turned off to increase running speed.  do-layout? shows the turtles moving around the view as they pair up and trade.  show-my-price? creates a label displaying each individual turtle's my-price. 

The population slider specifies the number of turtles created at setup.  The switches react-to-news?, apparent-trends?, endowment-effect?, and bandwagon-effect? each control a different strategy that the turtles use to update their my-price as they trade.  These switches can all be turned on, or they can be turned on in any combination to observe the different effects.  See the HOW IT WORKS section and the procedures tab for more information about these strategies.  

Each strategy switch, other than react-to-news?, has a corresponding slider to control the strength of its effect:

- trend-spotting-prob determines the probability that a given agent will notice each trend. 
- endowment-frequency determines how often an agent will refuse to trade in a each trading round
- bandwagon-stength determines how likely it is that an agent sets his my-price equal to another agent's my-price in a given trading turn.

The share-distribution plot gives a histogram plotting the number of turtles possessing a given number of shares.  


THINGS TO NOTICE
----------------
There are two main ways to judge what is going on in the model.  First, there is the share distribution plot.  This plot shows how evenly distributed the shares are across all the people in the model.  Most sets of parameters tend toward a very uneven distribution - many people with no shares and a few with most of the shares.  

Second, there is the stock price plot.  It is easy to judge visually when something that could be characterized as a bubble has occurred.  Notice that, as in real life, it is only possible to define a give time span as a bubble after it has 'burst.'


THINGS TO TRY
-------------
See what happens to the stock-price and the share-distribution as you turn on different combinations of switches.  For each effect, try moving the sliders for a strong effect or a weak effect.  

For a more stable stock-price, try turning on only react-to-news? and bandwagon-effect?  
To see some big fluctuations that look like bubbles, try turning on only react-to-news? and apparent-trends? and setting trend-spotting-prob around the mid-range.


EXTENDING THE MODEL
-------------------
This model assumes some fixed values for the magnitudes of agents' my-price adjustments. To make the model more realistic, try having the agents react in percentages of the stock price, rather than in fixed dollar amounts.  

Also, the model sometimes allows the stock price to fall below zero.  This does not present a problem for analyzing price fluctuations, but for aesthetic purposes, try preventing the stock price from falling below zero.  

Currently, some of the global variables can only be adjusted in the procedures tab. Sliders for money, my-price, and news-sensitivity could be added.  I refrained from adding this to keep the model simpler.  


NETLOGO FEATURES
----------------
To implement trend-spotting by the agents, I needed them to have a 'memory' of the stock-price movement.  This is the list up-down-history.  It keeps track of whether the stock-price goes up or down at each trade.  The agents use this list to react to trends. To analyze the results of the model in BehaviorSpace, I also needed a history of the actual prices.  This is the list price-history.  After each trade, the stock-price is recorded in this list. 


RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.


CREDITS AND REFERENCES
----------------------
Thanks to Forrest and Winston for all help, both with programming problems and modeling decisions.  

http://modelingcommons.org/browse/one_model/3029

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment1" repetitions="2" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>mean price-history</metric>
    <metric>max price-history</metric>
    <metric>min price-history</metric>
    <metric>stock-price</metric>
    <enumeratedValueSet variable="show-my-price?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="do-layout?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="bandwagon-effect?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="apparent-trends?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="react-to-news?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="endowment-effect?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Population">
      <value value="100"/>
    </enumeratedValueSet>
    <steppedValueSet variable="trend-spotting-prob" first="10" step="10" last="90"/>
  </experiment>
  <experiment name="bandwagon-strength_exp" repetitions="3" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>mean price-history</metric>
    <metric>max price-history</metric>
    <metric>min price-history</metric>
    <metric>max price-history - mean price-history</metric>
    <metric>stock-price</metric>
    <enumeratedValueSet variable="show-my-price?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="do-layout?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="bandwagon-effect?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="react-to-news?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="apparent-trends?">
      <value value="true"/>
    </enumeratedValueSet>
    <steppedValueSet variable="bandwagon-strength" first="10" step="10" last="70"/>
    <enumeratedValueSet variable="endowment-effect?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Population">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="trend-spotting-prob">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="endowment-frequency">
      <value value="10"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment2" repetitions="2" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>mean price-history</metric>
    <metric>max price-history</metric>
    <metric>min price-history</metric>
    <metric>stock-price</metric>
    <enumeratedValueSet variable="show-my-price?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="do-layout?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="bandwagon-effect?">
      <value value="false"/>
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="apparent-trends?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="react-to-news?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="endowment-effect?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Population">
      <value value="100"/>
    </enumeratedValueSet>
    <steppedValueSet variable="trend-spotting-prob" first="10" step="10" last="90"/>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
