globals [ available-roles ]
breed [ patterns pattern ]
breed [ students student ]


students-own
[
  user-id
  step-size
  angle
  my-role
]

to startup
  setup
  hubnet-set-client-interface "COMPUTER" []
  hubnet-reset
  set available-roles
  ( list
      (list "square"          30 red "red square" )
      (list "triangle"        30 blue "blue triangle")
      (list "triangle"        30 orange "orange triangle" )
      (list "medium triangle" 30 pink "pink triangle")
      (list "triangle"        60 yellow "yellow triangle")
      (list "triangle"        60 green "green triangle" )
      (list "rhombus"         30 violet "purple rhombus") )
end

to setup
  cp
  cd
  clear-output
  ask students
  [
    set step-size 1
    hubnet-send user-id "step-size" step-size
  ]
end

to go
  every 0.1
  [
    if solved?
    [
      user-message "you win!"
      stop
    ]
    listen-clients
  ]
end

to-report solved?
  report count patterns with [ matching-turtle-here? ] = count patterns
end

to-report matching-turtle-here?
  let ts other turtles in-radius 2
  if count ts != 1
  [ report false ]
  let other-guy one-of ts
  ifelse shape = "square"
  [ report shape = [shape] of other-guy and abs(heading mod 90 - [heading] of other-guy mod 90) <= 1 ]
  [ report shape = [shape] of other-guy and abs(heading - [heading] of other-guy) <= 1 ]
end

;;
;; HubNet Procedures
;;

to listen-clients
  while [ hubnet-message-waiting? ]
  [
    hubnet-fetch-message
    ifelse hubnet-enter-message?
    [ create-new-student ]
    [
      ifelse hubnet-exit-message?
      [ remove-student ]
      [ ask students with [user-id = hubnet-message-source]
        [ execute-command hubnet-message-tag ]
      ]
    ]
  ]
end

to create-new-student
  if length available-roles > 0
  [
    create-students 1
    [
      set user-id hubnet-message-source
      set step-size 1
      set angle 45
      send-info-to-clients
      let role one-of available-roles
      set shape item 0 role
      set size item 1 role
      set color item 2 role
      set my-role item 3 role
      hubnet-send user-id "You are the:" item 3 role
      set available-roles remove role available-roles
    ]
  ]
end

to remove-student
  ask students with [user-id = hubnet-message-source]
  [
    set available-roles lput (list shape size color my-role) available-roles
    die
  ]
end

to execute-command [command]
  if command = "step-size"
  [
    set step-size hubnet-message
    stop
  ]
  if command = "angle"
  [
    set angle hubnet-message
    stop
  ]
  if command = "up"
  [ set ycor ycor + step-size
    send-info-to-clients
    stop ]
  if command = "down"
  [ set ycor ycor - step-size
    send-info-to-clients
    stop ]
  if command = "right"
  [ set xcor xcor + step-size
    send-info-to-clients
    stop ]
  if command = "left"
  [ set xcor xcor - step-size
    send-info-to-clients
    stop ]
  if command = "rotate right"
  [ rt angle
    send-info-to-clients
    stop ]
  if command = "rotate left"
  [ lt angle
    send-info-to-clients
    stop ]
  if command = "flip"
  [ if shape = "rhombus"
      [set shape "rhombus backwards"]
    if shape = "rhombus backwards"
      [set shape "rhombus" ]
  ]
end

to send-info-to-clients
  hubnet-send user-id "location" (word "(" pxcor "," pycor ")")
  hubnet-send user-id "heading" heading
end

to chicken
  cd
  no-display
  stamp-tile ["medium triangle" 30 270 16.2 21.3]
  stamp-tile ["triangle" 30 90 -21.4 25]
  stamp-tile ["square" 30 45 -18.9 18.8]
  stamp-tile ["triangle" 60 45 12.6 0]
  stamp-tile ["triangle" 60 135 -12.6 0]
  stamp-tile ["triangle" 30 90 -9 -12.3]
  stamp-tile ["rhombus" 30 135 6.3 -12.3]
  display
end

to polygon-1
  cd
  no-display
  stamp-tile ["triangle" 30 225 5 -9.8]
  stamp-tile ["triangle" 60 135 -14 8.9]
  stamp-tile ["triangle" 60 315 11.2 9]
  stamp-tile ["medium triangle" 30 315 -1.1 -3.5]
  stamp-tile ["rhombus" 30 45 -13.7 2.7]
  stamp-tile ["triangle" 30 315 -20.1 15.2]
  stamp-tile ["square" 30 315 17.5 -9.8]
  display
end

to rectangle
  cd
  no-display
  stamp-tile ["triangle" 30 225 6.2 -4.6]
  stamp-tile ["triangle" 60 315 0 13.95]
  stamp-tile ["triangle" 60 135 -0.1 13.9]
  stamp-tile ["square" 30 45 6.2 -17.2]
  stamp-tile ["medium triangle" 30 315 -0.1 1.45]
  stamp-tile ["rhombus backwards" 30 45 -6.4 -11]
  stamp-tile ["triangle" 30 315 -6.3 -17.2]
  display
end

to stamp-tile [tile]
  create-patterns 1
  [
    set color gray
    set shape item 0 tile
    set size item 1 tile
    set heading item 2 tile
    set xcor item 3 tile
    set ycor item 4 tile
  ]
end

to import-puzzle [filename]
  cd
  no-display
  file-open filename
  while [ not file-at-end? ]
  [
    stamp-tile file-read
  ]
  file-close
  display
end

to export-puzzle [filename]
    file-open filename
    ask turtles [ file-write (list shape size heading xcor ycor) ]
    file-close
end

to show-puzzle
  ask turtles [ print (list shape size heading xcor ycor) ]
end


@#$#@#$#@
GRAPHICS-WINDOW
231
10
646
446
40
40
5.0
1
10
1
1
1
0
0
0
1
-40
40
-40
40
0
1
1
ticks

CC-WINDOW
5
460
655
555
Command Center
0

BUTTON
34
51
105
84
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
107
51
178
84
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

CHOOSER
34
108
172
153
puzzle
puzzle
"chicken" "polygon-1" "rectangle"
0

BUTTON
38
155
169
188
NIL
run puzzle
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

@#$#@#$#@
VERSION
-------
$Id: Tangrams.nlogo 37529 2008-01-03 20:38:02Z craig $


WHAT IS IT?
-----------
A template that can be used to create simple Disease-like HubNet activities with verbose comments.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

medium triangle
true
0
Polygon -7500403 true true 60 60 60 240 240 240

rhombus
true
0
Polygon -7500403 true true 15 195 195 195 285 105 105 105

rhombus backwards
true
0
Polygon -7500403 true true 285 195 105 195 15 105 195 105

square
true
0
Polygon -7500403 true true 150 60 60 150 150 240 240 150

triangle
true
0
Polygon -7500403 true true 150 60 150 240 60 150

triangle2
true
0
Polygon -7500403 true true 150 60 60 150 150 240 150 150

@#$#@#$#@
NetLogo 4.0alpha2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
BUTTON
85
134
147
167
up
NIL
NIL
1
T
OBSERVER
NIL
I

BUTTON
85
200
148
233
down
NIL
NIL
1
T
OBSERVER
NIL
K

BUTTON
147
167
210
200
right
NIL
NIL
1
T
OBSERVER
NIL
L

BUTTON
23
167
85
200
left
NIL
NIL
1
T
OBSERVER
NIL
J

MONITOR
118
23
205
72
location
NIL
0
1

BUTTON
122
296
217
329
rotate right
NIL
NIL
1
T
OBSERVER
NIL
NIL

BUTTON
13
296
108
329
rotate left
NIL
NIL
1
T
OBSERVER
NIL
NIL

MONITOR
73
335
154
384
heading
NIL
1
1

MONITOR
28
23
115
72
You are the:
NIL
3
1

INPUTBOX
49
73
189
133
step-size
1
1
0
Number

INPUTBOX
45
234
185
294
angle
45
1
0
Number

VIEW
244
10
649
415
40
40
5.0
1
10
1
1
1
0
0
0
1
-40
40
-40
40

BUTTON
68
390
160
423
flip
NIL
NIL
1
T
OBSERVER
NIL
NIL

@#$#@#$#@
