breed [circles circle] ; the turtles being selected
breed [sides side]     ; the four sides of the selection rectangle

globals [
  current-state ; "not-started", "selecting", "waiting-to-drag", "dragging"
  select-x      ; coordinates for the start of the select box
  select-y
  drag-x        ; coordinates for the start of a drag operation
  drag-y
  selected      ; agentset of currently selected circles
]

turtles-own [ location
]

to clear
	clear-all ;clears the wold
  import-drawing "grid.png"
  set current-state "not-started"
    set-default-shape circles "person"
end

to setup
  clear-all
  import-drawing "grid.png"
  set current-state "not-started"
  set-default-shape circles "person"
  set-default-shape turtles "box"
  set-default-shape sides "line"
  create-circles number-of-performers [
    set color black
    setxy random 10 random 10
  ]
  ask circles [
    if distance (patch 0 0) < 10 [forward 1.75 ]
  ]
  ; initially, no turtles are selected
  set selected no-turtles
  reset-ticks
end

to go
  ; we use a different procedure depending on which state we're in
  ; the procedures will update the `current-state` to the next value as the user clicks
  (ifelse
    (current-state = "not-started")     [ start-selecting ]
    (current-state = "selecting")       [ handle-selecting ]
    (current-state = "waiting-to-drag") [ handle-waiting ]
    (current-state = "dragging")        [ handle-drag ]
  )
end

to synch-radius-sideline
  ask circles at-points [[0 16] [0 15] [0 14] [0 13] [0 12] [0 11] [0 10] [0 9] [0 8] [0 7] [0 6] [0 5] [0 4] [0 3] [0 2] [0 1] [0 0] [0 -1] [0 -2] [0 -3] [0 -4] [1 16] [1 15] [1 14] [1 12] [1 11] [1 10] [1 9] [1 8] [1 7] [1 6] [1 5] [1 4] [1 3] [1 2] [1 1] [1 0] [1 -1] [1 -2] [1 -3] [1 -4] [-1 16] [-1 15] [-1 14] [-1 12] [-1 11] [-1 10] [-1 9] [-1 8] [-1 7] [-1 6] [-1 5] [-1 4] [-1 3] [-1 2] [-1 1] [-1 0] [-1 -1] [-1 -2] [-1 -3] [-1 -4] [2 16] [2 15] [2 14] [2 13] [2 12] [2 11] [2 10] [2 9] [2 8] [2 7] [2 6] [2 5] [2 4] [2 3] [2 2] [2 1] [2 0] [2 -1] [2 -2] [2 -3] [2 -4] [-2 16] [-2 15] [-2 14] [-2 13] [-2 12] [-2 11] [-2 10] [-2 9] [-2 8] [-2 7] [-2 6] [-2 5] [-2 4] [-2 3] [-2 2] [-2 1] [-2 0] [-2 -1] [-2 -2] [-2 -3] [-2 -4] [-3 16] [-3 15] [-3 14] [-3 13] [-3 12] [-3 11] [-3 10] [-3 9] [-3 8] [-3 7] [-3 6] [-3 5] [-3 4] [-3 3] [-3 2] [-3 1] [-3 0] [-3 -1] [-3 -2] [-3 -3] [-3 -4] [3 16] [3 15] [3 14] [3 13] [3 12] [3 11] [3 10] [3 9] [3 8] [3 7] [3 6] [3 5] [3 4] [3 3] [3 2] [3 1] [3 0] [3 -1] [3 -2] [3 -3] [3 -4] [4 16] [4 15] [4 14] [4 13] [4 12] [4 11] [4 10] [4 9] [4 8] [4 7] [4 6] [4 5] [4 4] [4 3] [4 2] [4 1] [4 0] [4 -1] [4 -2] [4 -3] [4 -4] [-4 16] [-4 15] [-4 14] [-4 13] [-4 12] [-4 11] [-4 10] [-4 9] [-4 8] [-4 7] [-4 6] [-4 5] [-4 4] [-4 3] [-4 2] [-4 1] [-4 0] [-4 -1] [-4 -2] [-4 -3] [-4 -4] [5 16] [5 15] [5 14] [5 13] [5 12] [5 11] [5 10] [5 9] [5 8] [5 7] [5 6] [5 5] [5 4] [5 3] [5 2] [5 1] [5 0] [5 -1] [5 -2] [5 -3] [5 -4] [-5 16] [-5 15] [-5 14] [-5 13] [-5 12] [-5 11] [-5 10] [-5 9] [-5 8] [-5 7] [-5 6] [-5 5] [-5 4] [-5 3] [-5 2] [-5 1] [-5 0] [-5 -1] [-5 -2] [-5 -3] [-5 -4] [6 16] [6 15] [6 14] [6 13] [6 12] [6 11] [6 10] [6 9] [6 8] [6 7] [6 6] [6 5] [6 4] [6 3] [6 2] [6 1] [6 0] [6 -1] [6 -2] [6 -3] [-6 16] [-6 15] [-6 14] [-6 13] [-6 12] [-6 11] [-6 10] [-6 9] [-6 8] [-6 7] [-6 6] [-6 5] [-6 4] [-6 3] [-6 2] [-6 1] [-6 0] [-6 -1] [-6 -2] [-6 -3] [7 16] [7 15] [7 14] [7 13] [7 12] [7 11] [7 10] [7 9] [7 8] [7 7] [7 6] [7 5] [7 4] [7 3] [7 2] [7 1] [7 0] [7 -1] [7 -2] [7 -3] [-7 16] [-7 15] [-7 14] [-7 13] [-7 12] [-7 11] [-7 10] [-7 9] [-7 8] [-7 7] [-7 6] [-7 5] [-7 4] [-7 3] [-7 2] [-7 1] [-7 0] [-7 -1] [-7 -2] [-7 -3] [8 16] [8 15] [8 14] [8 13] [8 12] [8 11] [8 10] [8 9] [8 8] [8 7] [8 6] [8 5] [8 4] [8 3] [8 2] [8 1] [8 0] [8 -1] [8 -2] [8 -3] [-8 16] [-8 15] [-8 14] [-8 13] [-8 12] [-8 11] [-8 10] [-8 9] [-8 8] [-8 7] [-8 6] [-8 5] [-8 4] [-8 3] [-8 2] [-8 1] [-8 0] [-8 -1] [-8 -2] [-8 -3] [9 16] [9 15] [9 14] [9 13] [9 12] [9 11] [9 10] [9 9] [9 8] [9 7] [9 6] [9 5] [9 4] [9 3] [9 2] [9 1] [9 0] [9 -1] [9 -2] [-9 16] [-9 15] [-9 14] [-9 13] [-9 12] [-9 11] [-9 10] [-9 9] [-9 8] [-9 7] [-9 6] [-9 5] [-9 4] [-9 3] [-9 2] [-9 1] [-9 0] [-9 -1] [-9 -2] [10 16] [10 15] [10 14] [10 13] [10 12] [10 11] [10 10] [10 9] [10 8] [10 7] [10 6] [10 5] [10 4] [10 3] [10 2] [10 1] [10 0] [10 -1] [10 -2] [-10 16] [-10 15] [-10 14] [-10 13] [-10 12] [-10 11] [-10 10] [-10 9] [-10 8] [-10 7] [-10 6] [-10 5] [-10 4] [-10 3] [-10 2] [-10 1] [-10 0] [-10 -1] [-10 -2] [11 16] [11 15] [11 14] [11 13] [11 12] [11 11] [11 10] [11 9] [11 8] [11 7] [11 6] [11 5] [11 4] [11 3] [11 2] [11 1] [11 0] [11 -1] [-11 16] [-11 15] [-11 14] [-11 13] [-11 12] [-11 11] [-11 10] [-11 9] [-11 8] [-11 7] [-11 6] [-11 5] [-11 4] [-11 3] [-11 2] [-11 1] [-11 0] [-11 -1] [12 16] [12 15] [12 14] [12 13] [12 12] [12 11] [12 10] [12 9] [12 8] [12 7] [12 6] [12 5] [12 4] [12 3] [12 2] [12 1] [12 0] [12 -1] [-12 16] [-12 15] [-12 14] [-12 13] [-12 12] [-12 11] [-12 10] [-12 9] [-12 8] [-12 7] [-12 6] [-12 5] [-12 4] [-12 3] [-12 2] [-12 1] [-12 0] [-12 -1] [13 16] [13 15] [13 14] [13 13] [13 12] [13 11] [13 10] [13 9] [13 8] [13 7] [13 6] [13 5] [13 4] [13 3] [13 2] [13 1] [13 0] [13 -1] [-13 16] [-13 15] [-13 14] [-13 13] [-13 12] [-13 11] [-13 10] [-13 9] [-13 8] [-13 7] [-13 6] [-13 5] [-13 4] [-13 3] [-13 2] [-13 1] [-13 0] [-13 -1] [14 16] [14 15] [14 14] [14 13] [14 12] [14 11] [14 10] [14 9] [14 8] [14 7] [14 6] [14 5] [14 4] [14 3] [14 2] [14 1] [14 0] [14 -1] [-14 16] [-14 15] [-14 14] [-14 13] [-14 12] [-14 11] [-14 10] [-14 9] [-14 8] [-14 7] [-14 6] [-14 5] [-14 4] [-14 3] [-14 2] [-14 1] [-14 0] [-14 -1] [15 16] [15 15] [15 14] [15 13] [15 12] [15 11] [15 10] [15 9] [15 8] [15 7] [15 6] [15 5] [15 4] [15 3] [15 2] [15 1] [15 0] [15 -1] [-15 16] [-15 15] [-15 14] [-15 13] [-15 12] [-15 11] [-15 10] [-15 9] [-15 8] [-15 7] [-15 6] [-15 5] [-15 4] [-15 3] [-15 2] [-15 1] [-15 0] [-15 -1] [16 16] [16 15] [16 14] [16 13] [16 12] [16 11] [16 10] [16 9] [16 8] [16 7] [16 6] [16 5] [16 4] [16 3] [16 2] [16 1] [16 0] [16 -1] [-16 16] [-16 15] [-16 14] [-16 13] [-16 12] [-16 11] [-16 10] [-16 9] [-16 8] [-16 7] [-16 6] [-16 5] [-16 4] [-16 3] [-16 2] [-16 1] [-16 0] [-16 -1] [17 16] [17 15] [17 14] [17 13] [17 12] [17 11] [17 10] [17 9] [17 8] [17 7] [17 6] [17 5] [17 4] [17 3] [17 2] [17 1] [17 0] [-17 16] [-17 15] [-17 14] [-17 13] [-17 12] [-17 11] [-17 10] [-17 9] [-17 8] [-17 7] [-17 6] [-17 5] [-17 4] [-17 3] [-17 2] [-17 1] [-17 0] [18 16] [18 15] [18 14] [18 13] [18 12] [18 11] [18 10] [18 9] [18 8] [18 7] [18 6] [18 5] [18 4] [18 3] [18 2] [18 1] [18 0] [-18 16] [-18 15] [-18 14] [-18 13] [-18 12] [-18 11] [-18 10] [-18 9] [-18 8] [-18 7] [-18 6] [-18 5] [-18 4] [-18 3] [-18 2] [-18 1] [-18 0] [19 16] [19 15] [19 14] [19 13] [19 12] [19 11] [19 10] [19 9] [19 8] [19 7] [19 6] [19 5] [-19 16] [-19 15] [-19 14] [-19 13] [-19 12] [-19 11] [-19 10] [-19 9] [-19 8] [-19 7] [-19 6] [-19 5] [20 16] [20 15] [20 14] [20 13] [20 12] [20 11] [20 10] [20 9] [20 8] [20 7] [20 6] [20 5] [-20 16] [-20 15] [-20 14] [-20 13] [-20 12] [-20 11] [-20 10] [-20 9] [-20 8] [-20 7] [-20 6] [-20 5] [21 16] [21 15] [21 14] [21 13] [21 12] [21 11] [21 10] [-21 16] [-21 15] [-21 14] [-21 13] [-21 12] [-21 11] [-21 10] [-22 16] [-22 15] [22 16] [22 15]] [
    set color green
    ]
end

to synch-radius-back-hash
  ask circles at-points [[0 15] [0 14] [0 13] [0 12] [0 11] [0 10] [0 9] [0 8] [0 7] [0 6] [0 5] [0 4] [0 3] [0 2] [0 1] [0 0] [0 -1] [0 -2] [0 -3] [0 -4] [0 -5] [0 -6] [0 -7] [0 -8] [0 -9] [0 -10] [0 -11] [0 -12] [0 -13] [0 -14] [0 -15] [0 -16] [1 15] [1 14] [1 13] [1 12] [1 11] [1 10] [1 9] [1 8] [1 7] [1 6] [1 5] [1 4] [1 3] [1 2] [1 1] [1 0] [1 -1] [1 -2] [1 -3] [1 -4] [1 -5] [1 -6] [1 -7] [1 -8] [1 -9] [1 -11] [1 -10] [1 -12] [1 -13] [1 -14] [1 -15] [1 -16] [-1 15] [-1 14] [-1 13] [-1 12] [-1 11] [-1 10] [-1 9] [-1 8] [-1 7] [-1 6] [-1 5] [-1 4] [-1 3] [-1 2] [-1 1] [-1 0] [-1 -1] [-1 -2] [-1 -3] [-1 -4] [-1 -5] [-1 -6] [-1 -7] [-1 -8] [-1 -9] [-1 -10] [-1 -11] [-1 -12] [-1 -13] [-1 -14] [-1 -15] [-1 -16] [2 15] [2 14] [2 13] [2 12] [2 11] [2 10] [2 9] [2 8] [2 7] [2 6] [2 5] [2 4] [2 3] [2 2] [2 1] [2 0] [2 -1] [2 -2] [2 -3] [2 -4] [2 -5] [2 -6] [2 -7] [2 -8] [2 -9] [2 -10] [2 -11] [2 -12] [2 -13] [2 -14] [2 -15] [2 -16] [-2 15] [-2 14] [-2 13] [-2 12] [-2 11] [-2 10] [-2 9] [-2 8] [-2 7] [-2 6] [-2 5] [-2 4] [-2 3] [-2 2] [-2 1] [-2 0] [-2 -1] [-2 -2] [-2 -3] [-2 -4] [-2 -5] [-2 -6] [-2 -7] [-2 -8] [-2 -9] [-2 -10] [-2 -11] [-2 -12] [-2 -13] [-2 -14] [-2 -15] [-2 -16] [3 15] [3 14] [3 13] [3 12] [3 11] [3 10] [3 9] [3 8] [3 7] [3 6] [3 5] [3 4] [3 3] [3 2] [3 1] [3 0] [3 -1] [3 -2] [3 -3] [3 -4] [3 -5] [3 -6] [3 -7] [3 -8] [3 -9] [3 -10] [3 -11] [3 -12] [3 -13] [3 -14] [3 -15] [-3 15] [-3 14] [-3 13] [-3 12] [-3 11] [-3 10] [-3 9] [-3 8] [-3 7] [-3 6] [-3 5] [-3 4] [-3 3] [-3 2] [-3 1] [-3 0] [-3 -1] [-3 -2] [-3 -3] [-3 -4] [-3 -5] [-3 -6] [-3 -7] [-3 -8] [-3 -9] [-3 -10] [-3 -11] [-3 -12] [-3 -13] [-3 -14] [-3 -15] [4 15] [4 14] [4 13] [4 12] [4 11] [4 10] [4 9] [4 8] [4 7] [4 6] [4 5] [4 4] [4 3] [4 2] [4 1] [4 0] [4 -1] [4 -2] [4 -3] [4 -4] [4 -5] [4 -6] [4 -7] [4 -8] [4 -9] [4 -10] [4 -11] [4 -12] [4 -13] [4 -14] [4 -15] [-4 15] [-4 14] [-4 13] [-4 12] [-4 11] [-4 10] [-4 9] [-4 8] [-4 7] [-4 6] [-4 5] [-4 4] [-4 3] [-4 2] [-4 1] [-4 0] [-4 -1] [-4 -2] [-4 -3] [-4 -4] [-4 -5] [-4 -6] [-4 -7] [-4 -8] [-4 -9] [-4 -10] [-4 -11] [-4 -12] [-4 -13] [-4 -14] [-4 -15] [5 15] [5 14] [5 13] [5 12] [5 11] [5 10] [5 9] [5 8] [5 7] [5 6] [5 5] [5 4] [5 3] [5 2] [5 1] [5 0] [5 -1] [5 -2] [5 -3] [5 -4] [5 -5] [5 -6] [5 -7] [5 -8] [5 -9] [5 -10] [5 -11] [5 -12] [5 -13] [5 -14] [-5 15] [-5 14] [-5 13] [-5 12] [-5 11] [-5 10] [-5 9] [-5 8] [-5 7] [-5 6] [-5 5] [-5 4] [-5 3] [-5 2] [-5 1] [-5 0] [-5 -1] [-5 -2] [-5 -3] [-5 -4] [-5 -5] [-5 -6] [-5 -7] [-5 -8] [-5 -9] [-5 -10] [-5 -11] [-5 -12] [-5 -13] [-5 -14] [6 15] [6 14] [6 13] [6 12] [6 11] [6 10] [6 9] [6 8] [6 7] [6 6] [6 5] [6 4] [6 3] [6 2] [6 1] [6 0] [6 -1] [6 -2] [6 -3] [6 -4] [6 -5] [6 -6] [6 -7] [6 -8] [6 -9] [6 -10] [6 -11] [6 -12] [6 -13] [6 -14] [-6 15] [-6 14] [-6 13] [-6 12] [-6 11] [-6 10] [-6 9] [-6 8] [-6 7] [-6 6] [-6 5] [-6 4] [-6 3] [-6 2] [-6 1] [-6 0] [-6 -1] [-6 -2] [-6 -3] [-6 -4] [-6 -5] [-6 -6] [-6 -7] [-6 -8] [-6 -9] [-6 -10] [-6 -11] [-6 -12] [-6 -13] [-6 -14] [7 15] [7 14] [7 13] [7 12] [7 11] [7 10] [7 9] [7 8] [7 7] [7 6] [7 5] [7 4] [7 3] [7 2] [7 1] [7 0] [7 -1] [7 -2] [7 -3] [7 -4] [7 -5] [7 -6] [7 -7] [7 -8] [7 -9] [7 -10] [7 -11] [7 -12] [7 -13] [7 -14] [-7 15] [-7 14] [-7 13] [-7 12] [-7 11] [-7 10] [-7 9] [-7 8] [-7 7] [-7 6] [-7 5] [-7 4] [-7 3] [-7 2] [-7 1] [-7 0] [-7 -1] [-7 -2] [-7 -3] [-7 -4] [-7 -5] [-7 -6] [-7 -7] [-7 -8] [-7 -9] [-7 -10] [-7 -11] [-7 -12] [-7 -13] [-7 -14] [8 15] [8 14] [8 13] [8 12] [8 11] [8 10] [8 9] [8 8] [8 7] [8 6] [8 5] [8 4] [8 3] [8 2] [8 1] [8 0] [8 -1] [8 -2] [8 -3] [8 -4] [8 -5] [8 -6] [8 -7] [8 -8] [8 -9] [8 -10] [8 -11] [8 -12] [8 -13] [8 -14] [-8 15] [-8 14] [-8 13] [-8 12] [-8 11] [-8 10] [-8 9] [-8 8] [-8 7] [-8 6] [-8 5] [-8 4] [-8 3] [-8 2] [-8 1] [-8 0] [-8 -1] [-8 -2] [-8 -3] [-8 -4] [-8 -5] [-8 -6] [-8 -7] [-8 -8] [-8 -9] [-8 -10] [-8 -11] [-8 -12] [-8 -13] [-8 -14] [9 15] [9 14] [9 13] [9 12] [9 11] [9 10] [9 9] [9 8] [9 7] [9 6] [9 5] [9 4] [9 3] [9 2] [9 1] [9 0] [9 -1] [9 -2] [9 -3] [9 -4] [9 -5] [9 -6] [9 -7] [9 -8] [9 -9] [9 -10] [9 -11] [9 -12] [9 -13] [9 -14] [-9 15] [-9 14] [-9 13] [-9 12] [-9 11] [-9 10] [-9 9] [-9 8] [-9 7] [-9 6] [-9 5] [-9 4] [-9 3] [-9 2] [-9 1] [-9 0] [-9 -1] [-9 -2] [-9 -3] [-9 -4] [-9 -5] [-9 -6] [-9 -7] [-9 -8] [-9 -9] [-9 -10] [-9 -11] [-9 -12] [-9 -13] [-9 -14] [10 15] [10 14] [10 13] [10 12] [10 11] [10 10] [10 9] [10 8] [10 7] [10 6] [10 5] [10 4] [10 3] [10 2] [10 1] [10 0] [10 -1] [10 -2] [10 -3] [10 -4] [10 -5] [10 -6] [10 -7] [10 -8] [10 -9] [10 -10] [10 -11] [10 -12] [-10 15] [-10 14] [-10 13] [-10 12] [-10 11] [-10 10] [-10 9] [-10 8] [-10 7] [-10 6] [-10 5] [-10 4] [-10 3] [-10 2] [-10 1] [-10 0] [-10 -1] [-10 -2] [-10 -3] [-10 -4] [-10 -5] [-10 -6] [-10 -7] [-10 -8] [-10 -9] [-10 -10] [-10 -11] [-10 -12] [11 15] [11 14] [11 13] [11 12] [11 11] [11 10] [11 9] [11 8] [11 7] [11 6] [11 5] [11 4] [11 3] [11 2] [11 1] [11 0] [11 -1] [11 -2] [11 -3] [11 -4] [11 -5] [11 -6] [11 -7] [11 -8] [11 -9] [11 -10] [11 -11] [11 -12] [-11 15] [-11 14] [-11 13] [-11 12] [-11 11] [-11 10] [-11 9] [-11 8] [-11 7] [-11 6] [-11 5] [-11 4] [-11 3] [-11 2] [-11 1] [-11 0] [-11 -1] [-11 -2] [-11 -3] [-11 -4] [-11 -5] [-11 -6] [-11 -7] [-11 -8] [-11 -9] [-11 -10] [-11 -11] [-11 -12] [12 15] [12 14] [12 13] [12 12] [12 11] [12 10] [12 9] [12 8] [12 7] [12 6] [12 5] [12 4] [12 3] [12 2] [12 1] [12 0] [12 -1] [12 -2] [12 -3] [12 -4] [12 -5] [12 -6] [12 -7] [12 -8] [12 -9] [12 -10] [12 -11] [12 -12] [-12 15] [-12 14] [-12 13] [-12 12] [-12 11] [-12 10] [-12 9] [-12 8] [-12 7] [-12 6] [-12 5] [-12 4] [-12 3] [-12 2] [-12 1] [-12 0] [-12 -1] [-12 -2] [-12 -3] [-12 -4] [-12 -5] [-12 -6] [-12 -7] [-12 -8] [-12 -9] [-12 -10] [-12 -11] [-12 -12] [13 15] [13 14] [13 13] [13 12] [13 11] [13 10] [13 9] [13 8] [13 7] [13 6] [13 5] [13 4] [13 3] [13 2] [13 1] [13 0] [13 -1] [13 -2] [13 -3] [13 -4] [13 -5] [13 -6] [13 -7] [13 -8] [13 -9] [13 -10] [13 -11] [13 -12] [-13 15] [-13 14] [-13 13] [-13 12] [-13 11] [-13 10] [-13 9] [-13 8] [-13 7] [-13 6] [-13 5] [-13 4] [-13 3] [-13 2] [-13 1] [-13 0] [-13 -1] [-13 -2] [-13 -3] [-13 -4] [-13 -5] [-13 -6] [-13 -7] [-13 -8] [-13 -9] [-13 -10] [-13 -11] [-13 -12] [14 15] [14 14] [14 13] [14 12] [14 11] [14 10] [14 9] [14 8] [14 7] [14 6] [14 5] [14 4] [14 3] [14 2] [14 1] [14 0] [14 -1] [14 -2] [14 -3] [14 -4] [14 -5] [14 -6] [14 -7] [14 -8] [14 -9] [14 -10] [14 -11] [14 -12] [-14 15] [-14 14] [-14 13] [-14 12] [-14 11] [-14 10] [-14 9] [-14 8] [-14 7] [-14 6] [-14 5] [-14 4] [-14 3] [-14 2] [-14 1] [-14 0] [-14 -1] [-14 -2] [-14 -3] [-14 -4] [-14 -5] [-14 -6] [-14 -7] [-14 -8] [-14 -9] [-14 -10] [-14 -11] [-14 -12] [15 15] [15 14] [15 13] [15 12] [15 11] [15 10] [15 9] [15 8] [15 7] [15 6] [15 5] [15 4] [15 3] [15 2] [15 1] [15 0] [15 -1] [15 -2] [15 -3] [15 -4] [15 -5] [15 -6] [15 -7] [15 -8] [15 -9] [15 -10] [15 -11] [-15 15] [-15 14] [-15 13] [-15 12] [-15 11] [-15 10] [-15 9] [-15 8] [-15 7] [-15 6] [-15 5] [-15 4] [-15 3] [-15 2] [-15 1] [-15 0] [-15 -1] [-15 -2] [-15 -3] [-15 -4] [-15 -5] [-15 -6] [-15 -7] [-15 -8] [-15 -9] [-15 -10] [-15 -11] [16 15] [16 14] [16 13] [16 12] [16 11] [16 10] [16 9] [16 8] [16 7] [16 6] [16 5] [16 4] [16 3] [16 2] [16 1] [16 0] [16 -1] [16 -2] [16 -3] [16 -4] [16 -5] [16 -6] [16 -7] [16 -8] [16 -9] [16 -10] [-16 15] [-16 14] [-16 13] [-16 12] [-16 11] [-16 10] [-16 9] [-16 8] [-16 7] [-16 6] [-16 5] [-16 4] [-16 3] [-16 2] [-16 1] [-16 0] [-16 -1] [-16 -2] [-16 -3] [-16 -4] [-16 -5] [-16 -6] [-16 -7] [-16 -8] [-16 -9] [-16 -10] [17 15] [17 14] [17 13] [17 12] [17 11] [17 10] [17 9] [17 8] [17 7] [17 6] [17 5] [17 4] [17 3] [17 2] [17 1] [17 0] [17 -1] [17 -2] [17 -3] [17 -4] [17 -5] [17 -6] [17 -7] [17 -8] [-17 15] [-17 14] [-17 13] [-17 12] [-17 11] [-17 10] [-17 9] [-17 8] [-17 7] [-17 6] [-17 5] [-17 4] [-17 3] [-17 2] [-17 1] [-17 0] [-17 -1] [-17 -2] [-17 -3] [-17 -4] [-17 -5] [-17 -6] [-17 -7] [-17 -8] [18 15] [18 14] [18 13] [18 12] [18 11] [18 10] [18 9] [18 8] [18 7] [18 6] [18 5] [18 4] [18 3] [18 2] [18 1] [18 0] [18 -1] [18 -2] [18 -3] [18 -4] [18 -5] [18 -6] [18 -7] [-18 15] [-18 14] [-18 13] [-18 12] [-18 11] [-18 10] [-18 9] [-18 8] [-18 7] [-18 6] [-18 5] [-18 4] [-18 3] [-18 2] [-18 1] [-18 0] [-18 -1] [-18 -2] [-18 -3] [-18 -4] [-18 -5] [-18 -6] [-18 -7] [19 15] [19 14] [19 13] [19 12] [19 11] [19 10] [19 9] [19 8] [19 7] [19 6] [19 5] [19 4] [19 3] [19 2] [19 1] [19 0] [19 -1] [19 -2] [19 -3] [19 -4] [-19 15] [-19 14] [-19 13] [-19 12] [-19 11] [-19 10] [-19 9] [-19 8] [-19 7] [-19 6] [-19 5] [-19 4] [-19 3] [-19 2] [-19 1] [-19 0] [-19 -1] [-19 -2] [-19 -3] [-19 -4] [20 15] [20 14] [20 13] [20 12] [20 11] [20 10] [20 9] [20 8] [20 7] [20 6] [20 5] [20 4] [20 3] [20 2] [20 1] [20 0] [-20 15] [-20 14] [-20 13] [-20 12] [-20 11] [-20 10] [-20 9] [-20 8] [-20 7] [-20 6] [-20 5] [-20 4] [-20 3] [-20 2] [-20 1] [-20 0] [21 15] [21 14] [21 13] [21 12] [21 11] [21 10] [21 9] [21 8] [21 7] [21 6] [21 5] [21 4] [21 3] [-21 15] [-21 14] [-21 13] [-21 12] [-21 11] [-21 10] [-21 9] [-21 8] [-21 7] [-21 6] [-21 5] [-21 4] [-21 3] [22 15] [22 14] [22 13] [22 12] [22 11] [22 10] [22 9] [22 8] [22 7] [22 6] [-22 15] [-22 14] [-22 13] [-22 12] [-22 11] [-22 10] [-22 9] [-22 8] [-22 7] [-22 6]] [
    set color green
    ]
end

to synch-radius-performer
  ask turtle 0 [
    ask other turtles in-radius 22 [
    set color green
    ]
]
end

to play-radius-sideline
  ask circles at-points [[0 16] [0 15] [0 14] [0 13] [0 12] [1 16] [2 16] [3 16] [4 16] [-1 16] [-2 16] [-3 16] [-4 16]] [
    set color blue
  ]
end

to play-radius-back-hash
  ask circles at-points [[0 6] [0 5] [0 4] [0 3] [0 2] [0 7] [0 8] [0 9] [0 10] [1 6] [2 6] [3 6] [4 6] [-1 6] [-2 6] [-3 6] [-4 6]] [
    set color blue
  ]
end

to play-radius-performer
  ask turtle 0 [
    ask other turtles in-radius 5 [
      set color blue
    ]
  ]
end

to timing-source
  if select-timing-source = "met-behind-performer" [
    create-turtles 1 [
      set color red
      set size .8
      move-to turtle 0
    ]
  ]
    if select-timing-source = "back-sideline-metronome" [
    create-turtles 1 [
      set color red
      set size .8
      setxy 0 16
    ]
  ]
    if select-timing-source = "back-hash-metronome" [
      create-turtles 1 [
      set color red
      set size .8
      setxy 0 6
    ]
  ]
end

to distance-between
  ask turtles [
    if not any? turtles-on neighbors [
    set color orange
  ]
  ]
end

to start-selecting
  if mouse-down? [
    ; on the first click we see, we record the mouse position as the start of selection
    set select-x mouse-xcor
    set select-y mouse-ycor
    set current-state "selecting"
  ]
end

to handle-selecting
  ifelse mouse-down? [
    ; we keep updating the selection box as long as the mouse is down
    select select-x select-y mouse-xcor mouse-ycor
  ][
    ; user was selecting, but let off the mouse button
    ifelse not any? selected [
      ; if nothing was selected in the box, return to the not-started state
      deselect
      set current-state "not-started"
    ] [
      ; else we are ready to drag
      set current-state "waiting-to-drag"
    ]
  ]
  display
end

to handle-waiting
  if mouse-down? [
    ; on the first click after the selection
    ; check if we're inside or outside the box
    ifelse selected? mouse-xcor mouse-ycor [
      ; inside the box, set the starting drag coordinates
      set drag-x mouse-xcor
      set drag-y mouse-ycor
      set current-state "dragging"
    ] [
      ; clicked outside the select box, return to the "selecting" state
      start-selecting
    ]
  ]
end

to handle-drag
  ifelse mouse-down? [
    let new-x mouse-xcor
    let new-y mouse-ycor
    ; we need to move both the selected turtles and the sides
    ; of the selection rectangle by the same amount that the
    ; mouse has moved.  we do this by subtracting the current
    ; mouse coordinates from the previous mouse coordinates
    ; and adding the results to the coordinates of the turtles
    ; and sides.
    ask selected
    [
      setxy xcor + new-x - drag-x
      ycor + new-y - drag-y
    ]
    ask sides
    [
      setxy xcor + new-x - drag-x
      ycor + new-y - drag-y
    ]
    ; update the drag coordinates for the next time through
    ; if the user keeps the mouse button down
    set drag-x new-x
    set drag-y new-y
    display
  ] [
    ; user was dragging, but let off the mouse button
    ; wait for them to click again
    set current-state "waiting-to-drag"
  ]
end

to deselect
  ask sides [ die ]
  ask selected [ set color black ]
  set selected no-turtles
end

to select [x1 y1 x2 y2] ; x1 y1 is initial corner and x2 y2 is current corner
  deselect ; kill old selection rectangle
  make-side x1 y1 x2 y1
  make-side x1 y1 x1 y2
  make-side x1 y2 x2 y2
  make-side x2 y1 x2 y2
  set selected circles with [selected? xcor ycor]
  ask selected [ set color red ]
end

to make-side [x1 y1 x2 y2]
  ; for each side, one thin line shape is created at the mid point of each segment
  ; of the bounding box and scaled to the proper length
  create-sides 1 [
    set color gray
    setxy (x1 + x2) / 2
          (y1 + y2) / 2
    facexy x1 y1
    set size 2 * distancexy x1 y1
  ]
end

; helper procedure that determines whether a point is
; inside the selection rectangle
to-report selected? [x y]
  let y-max max [ycor] of sides  ; largest ycor is where the top is
  let y-min min [ycor] of sides  ; smallest ycor is where the bottom is
  let x-max max [xcor] of sides  ; largest xcor is where the right side is
  let x-min min [xcor] of sides  ; smallest xcor is where the left side is
  ; report whether the input coordinates are within the rectangle
  report x >= x-min and x <= x-max and
         y >= y-min and y <= y-max
end



; Public Domain:
; To the extent possible under law, Uri Wilensky has waived all
; copyright and related or neighboring rights to this model.
@#$#@#$#@
GRAPHICS-WINDOW
997
26
1988
567
-1
-1
16.12121212121212
1
10
1
1
1
0
0
0
1
-30
30
-16
16
0
0
1
ticks
30.0

BUTTON
25
171
88
204
clear
clear
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
117
325
256
358
move performers
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
25
325
91
358
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
268
321
388
366
NIL
current-state
17
1
11

TEXTBOX
26
243
502
327
After pressing setup and move performers, you can select performers by dragging a selection rectangle around them. \n\nOnce performers are selected they will turn red. You then move them by dragging them. Click \"move performers\" again to stop moving performers.
11
0.0
1

SLIDER
125
172
323
205
number-of-performers
number-of-performers
0
450
365.0
1
1
NIL
HORIZONTAL

TEXTBOX
26
217
385
239
Select \"clear\" and then set the slider to the number of performers.
11
0.0
1

TEXTBOX
23
22
506
164
To start with NetLogo-generated performers, begin by selecting \"clear.\"\n\nIf you have an existing drill set saved as an image file (.jpg or .png), please save it to your desktop. Then, move to the \"Code\" tab at the top of NetLogo and change the file name to match your file using the following steps: \n1) Locate \"to clear\"\n2) Find \"import-drawing\"\n3) Change the file name in quotation marks to the title of your drill image file.\n4) Test by hitting enter. NetLogo will let you know if it cannot locate the local file, and it will provide you with the pathway it is attempting to use.
11
0.0
1

CHOOSER
10
453
220
498
select-timing-source
select-timing-source
"back-sideline-metronome" "back-hash-metronome" "met-behind-performer"
0

BUTTON
231
454
443
499
create timing source
timing-source
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
27
377
498
433
Select your timing source and create a red box where the timing source will be located. When selecting \"met-behind-performer,\" a metronome will be assigned to one of the performers. You can move this performer where your intended timing source will be, and the metronome will follow if you click \"create timing source\" a second time.
11
0.0
1

BUTTON
16
532
249
565
synchronization radius for back sideline
synch-radius-sideline
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
16
570
236
603
synchronization radius for back hash
synch-radius-back-hash
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
15
610
294
643
synchronization radius for met behind performer
synch-radius-performer
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
9
438
43
456
Step 1
11
0.0
1

TEXTBOX
232
437
273
455
Step 2
11
0.0
1

TEXTBOX
16
516
302
534
Step 3 (Green performers synchronize with the met)
11
0.0
1

TEXTBOX
308
513
534
531
Step 4 (Blue performers play with the met)
11
0.0
1

BUTTON
309
531
495
564
playing radius for back sideline
play-radius-sideline
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
309
568
499
601
playing radius for back hash
play-radius-back-hash
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
309
607
545
640
playing radius for met behind performer
play-radius-performer
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
560
511
971
546
Step 5 (Orange performers are the furthest from any timing source or co-performer and may need individualized assistance with timing strategies)
11
0.0
1

BUTTON
560
552
840
585
furthest distance
distance-between
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This is a model that allows users to create marching band drill formations and experiment with ensemble synchronization strategies through metronome placement in different areas of the field. The effect on performer synchronization and listening strategies are shown in the difference between the performer synchronization radius (e.g., listening to the met) and the performer play radius (e.g., playing directly along with the met). 
## HOW IT WORKS

Users will have to upload a .png file of a drill formation from PyWare charts, or use the blank .png provided. 

To start with NetLogo-generated performers, begin by selecting "clear."

If you have an existing drill set saved as an image file (.jpg or .png), please save it to your desktop. Then, move to the "Code" tab at the top of NetLogo and change the file name to match your file using the following steps: 
1) Locate "to clear"
2) Find "import-drawing"
3) Change the file name in quotation marks to the title of your drill image file.
4) Test by hitting enter. NetLogo will let you know if it cannot locate the local file, and it will provide you with the pathway it is attempting to use.

Use the slider to select the number of performers. If you have a drill chart ready, select 1 so that you can experiment with which performer to place the metronome behind. 

To generate your selected number of performers, press "setup." To move performers around, click "move performers" and use your mouse or trackpad to drag them around the field. 

Select your timing source and create a red box where the timing source will be located. When selecting "met-behind-performer," a metronome will be assigned to one of the performers. You can move this performer where your intended timing source will be, and the metronome will follow if you click "create timing source" a second time.

## HOW TO USE IT

This model is scaled to a standard football field that is 300 feet by 160 feet. If you find that the scale is visually incorrect, check the Settings tab and make sure the dimensions are the following: max-pxcor 30 and max-pycor 16. Un-check "world wraps vertically" and "world wraps horizontally."

## THINGS TO NOTICE

When selecting "met behind performer," NetLogo will arbitrarily assign the metronome to a turtle (performer). You can click and drag the turtle and select "met behind performer" a second time so that the metronome follows the turtle after selection. 

The synchronizing with the met radius is 110 feet, or a delay of 100ms (Repp and Su 2013). The playing with the met radius is 22 feet, or a sound delay of 20ms (Sparks 2016). 

Green performers can synchronize with the met (e.g., listen for the count-off or to prepare to play). Blue performers can play along with the met with a negligible effect on perceived delay as long as they remain within the radius. Orange performers are a significant distance from either the timing source or co-performers, and these performers may need individualized strategies for timing coordination.

## THINGS TO TRY

First, try the steps in order as indicated with the text boxes. Then, experiment with metronome placement and the subsequent changes on the synchronization and playing in time radius.

## EXTENDING THE MODEL

An extended model will consider sources of error like metronome cable quality, performer demand, and strength of metric line in the part of the performer who is standing in front of the metronome. Future models will also account for timing situations on the move as drill formations take shape. 

## NETLOGO FEATURES

This model uses the in-radius primitive as well as a series of primitives that allow users to click and drag performers into place. 

## RELATED MODELS

Mouse Drag Multiple Example
Sound Machines

## CREDITS AND REFERENCES

If you mention this model or the NetLogo software in a publication, include the following citations. 

For the model itself: 
Bowden, Sara. 2024. NetLogo Marching Band Metronome model. https://modelingcommons.org/browse/one_model/7354#model_tabs_browse_info. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL. 

Please cite the NetLogo software as: 
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL. 
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.4.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
