 extensions [ gogo ]
globals [
  serial-port
  speed-out                                                    ;; globals for monitors
  speed-out2
  slide
]
turtles-own [ speed speed-other max-speed ]
breed [ player-cars player-car ]
breed [ other-cars other-car ]

;;;;;;;;;;;;;;;;;;;;;;
;; Setup procedures ;;
;;;;;;;;;;;;;;;;;;;;;;
to setup
  clear-all
  check-for-gogo
  if Choose-Track = "Ring" [                                   ;; load maps
    import-pcolors "ringtrack.png"
  ]
  if Choose-Track = "Square" [
    import-pcolors "squaretrack.png"
  ]
  if Choose-Track = "Hard" [
    import-pcolors "hardtrack.png"
  ]
  
  ask patches with [ pcolor = 0.3 ] [                           ;; tweak patch colors so they're easier to identify
    set pcolor black
  ]
  ask patches with [ pcolor = 64.4 ] [
    set pcolor green
  ]
  
  set-traction
  
;; make halfway line
;;  ask patches with [pxcor < -220 and abs pycor <= 1 and pcolor = black] [
;;    set pcolor yellow - 4
;;  ]

  ask patches with [pxcor > 200 and abs pycor <= 1 and pcolor = black] [   ;; make finishing line
    set pcolor yellow
  ]
;; make road
;;  ask patches with [ pcolor = black ]
;;    [ set pcolor random white ]

   make-cars
;; make-grass
   if View3D? [                                                   ;; 3D view switch
    ifelse first-person? 
      [ ride player-car 0 ]
      [ follow player-car 0 ]
   ]
end

to check-for-gogo
   if gogo-attached? = true [
     if gogo:open? = false                                        ;; set up gogo board
      [ set serial-port user-one-of "Select a port:" gogo:ports
        gogo:open serial-port
        repeat 5
        [ if not gogo:ping
        [ user-message "The GoGo Board is not responding." ] ]
        gogo:talk-to-output-ports [ "a" "b" "c" "d" ] ]
   ]
end
 
to make-cars
  create-player-cars 1 [                                       ;; set up the player's car
    set size 20
    set shape "car"
    set heading 0
    set color blue
    set xcor max-pxcor * 0.85
    set ycor 5
    set speed 0
  ]

  create-other-cars 5 [                                        ;; set up the competition
    set size 20
    set shape "car"
    set heading 0
    set color red
    move-to one-of patches with [ pcolor = black and pycor > 1 and pycor < 30  and pxcor > 225 and pxcor < 300]    
    set speed-other 1.4
  ]
end

to make-grass
  ask n-of 300 patches with [ pcolor = green ]                 ;; make grass to help visualize in 3D view
    [ sprout 1 [
      set shape "plant"
      set color green + 2
      set size 20 ] ]
end

to set-traction                                                ;; add a slide factor based on weather
  if Weather = "Sunny" [
    set slide 0
  ]
  if Weather = "Rain" [
    set slide 3
  ]
  if Weather = "Snow" [
    set slide 5
  ]
  if Weather = "Random" [                                      ;; set chooser to one of the other weather types
    set Weather one-of [ "Sunny" "Rain" "Snow" ]
    set-traction
  ]
end

  

;;;;;;;;;;;;;;;;;;;
;; go procedures ;;
;;;;;;;;;;;;;;;;;;;
to go
  ask turtles [
    if [pcolor] of patch-here = yellow                            ;; stop if you cross the yellow line --not working...
      [ set speed 0                                               ;; need to make one for other-car and player-car
        set shape "face happy"
        user-message "You won!  Press 'halt' to play again!"
      ]
  ]
  ask player-cars [
    let car-ahead one-of other turtles-on patches in-cone 10 30
    set max-speed velocity-factor * 2.5
    if [pcolor] of patch-ahead 1 = green                          ;; if the pach ahead is grass, report a crash and kill car
      [ set speed 0 
        set shape "x"
        user-message "You crashed! Press 'halt' and try again!"
      ]
  if gogo-attached? = true [
    ifelse gogo:sensor 1 > 1000                                   ;; sensor reads over 1000 when untouched
      [ set speed speed - 0.03 ]                                  ;; slows down when sensor 1 isn't pressed
      [ set speed speed - 0.03 + ( ( 1 + acceleration-factor ) / gogo:sensor 1 ) ]        ;; speed up when pressing sensor 1
    if gogo:sensor 2 < 1000
      [ set speed speed - ( ( 10 - slide ) / gogo:sensor 2 ) ]        ;; sensor 2 brakes if pressed
  ]
    if speed < 0
      [ set speed 0 ]                                             ;; keeps speed from going negative
    if speed > max-speed [                          ;; sets max-velocity relative to velocity factor
      set speed max-speed
    ]
    if car-ahead != nobody [
      set speed speed - 4
    ]
    fd speed                                                      ;; moves
    set speed-out speed                                           ;; sets speedometer monitor (may remove)
  ]
  ask other-cars [                                                ;; auto acceleration for other-car
    let car-ahead one-of other turtles-on patches in-cone 10 30   ;; looks for cars ahead
    if [pcolor] of patch-ahead 1 = green                          ;; if the pach ahead is grass, report a crash and stop the race
      [ set speed 0 
        set shape "x" 
        die ]
    set speed-other speed-other + 0.1                             ;; gradually speeds up
    if speed-other > 6 [                                          ;; sets a max speed of 6...may need tweaked
      set speed-other 6
    ]
    if speed-other < 0 [                                          ;; keeps speed from going negative
      set speed-other 0
    ]
    ifelse [pcolor] of patch-left-and-ahead 15 15 = green [       ;; looks forward and left for grass...
      fd ( .5 + slide ) rt ( random-float 30 - slide ) ]          ;; turns slightly right if it sees grass...slide due to traction
      [ ifelse [pcolor] of patch-right-and-ahead 15 15 = green [  ;; looks forward and right for grass...
      fd ( .5 + slide ) lt ( random-float 30 - slide ) ]          ;; turns slightly left if it sees grass...slide due to traction
        [ ifelse car-ahead != nobody [                            ;; if car ahead slow way down
            set speed-other speed-other - 4 fd .5 ]
      [ fd speed-other                                            ;; moves
        set speed-out2 speed-other ]                              ;; sets speed-out2 monitor (may remove once debugged)
  ] ] ]
  tick
end

;;;;;;;;;;;;;;;;;;;;;
;; button commands ;;
;;;;;;;;;;;;;;;;;;;;;
to speed-up
  ask player-cars [
    set speed speed + 0.1
  ]
end

to slow-down
  ask player-cars [
    set speed speed - 0.2
  ]
end

to turn-left
  ask player-cars [
    fd ( slide + speed ) left 15 - slide
  ]
end

to turn-right
  ask player-cars [
    fd ( slide + speed) right 15 - slide
  ]
end

  
@#$#@#$#@
GRAPHICS-WINDOW
264
15
915
447
320
200
1.0
1
10
1
1
1
0
1
1
1
-320
320
-200
200
0
0
1
ticks

BUTTON
68
311
134
344
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
90
362
182
395
NIL
Speed-up
NIL
1
T
OBSERVER
NIL
W
NIL
NIL

BUTTON
90
397
182
430
NIL
Slow-down
NIL
1
T
OBSERVER
NIL
S
NIL
NIL

BUTTON
24
378
87
411
Left
turn-left
NIL
1
T
OBSERVER
NIL
A
NIL
NIL

BUTTON
185
380
249
413
Right
turn-right
NIL
1
T
OBSERVER
NIL
D
NIL
NIL

BUTTON
140
311
203
344
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SWITCH
53
84
208
117
first-person?
first-person?
1
1
-1000

MONITOR
410
454
504
499
Speedometer
speed-out
2
1
11

CHOOSER
61
121
199
166
Choose-Track
Choose-Track
"Ring" "Square" "Hard"
0

SWITCH
53
47
208
80
View3D?
View3D?
1
1
-1000

MONITOR
268
454
406
499
other-speed
mean [speed-out2] of other-cars
17
1
11

CHOOSER
62
172
200
217
Weather
Weather
"Random" "Sunny" "Rain" "Snow"
0

SWITCH
53
10
208
43
gogo-attached?
gogo-attached?
0
1
-1000

SLIDER
10
227
182
260
velocity-factor
velocity-factor
0
10 - acceleration-factor
7
1
1
NIL
HORIZONTAL

SLIDER
10
268
182
301
acceleration-factor
acceleration-factor
0
10 - velocity-factor
3
1
1
NIL
HORIZONTAL

TEXTBOX
193
244
267
289
Combined total cannot exceed 10
11
0.0
1

@#$#@#$#@
WHAT IS IT?
-----------
This section could give a general understanding of what the model is trying to show or explain.


HOW IT WORKS
------------
This section could explain what rules the agents use to create the overall behavior of the model.


HOW TO USE IT
-------------
This section could explain how to use the model, including a description of each of the items in the interface tab.


THINGS TO NOTICE
----------------
This section could give some ideas of things for the user to notice while running the model.


THINGS TO TRY
-------------
This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.


EXTENDING THE MODEL
-------------------
This section could give some ideas of things to add or change in the procedures tab to make the model more complicated, detailed, accurate, etc.


NETLOGO FEATURES
----------------
This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.


RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.


CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1beta3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
