breed [persons person]   ;; people of society
breed [charities charity] ;; charity orgs
directed-link-breed [ sadaqah-links sadaqah-link]  ;; links from rich peolpe (benefactors) to charity organizations (beneficiaries)
directed-link-breed [ allocation-links allocation-link] ;; links from charity organizations (beneficiaries) to the needy
persons-own [ money ]    ;; money of people
charities-own [resources]  ;; resources of charity org
globals [

Bottom-50%-agentset ;; population of all persons of  five low deciles

 ;; economic deciles
decile-1
decile-2
decile-3
decile-4
decile-5
decile-6
decile-7
decile-8
decile-9
decile-10

;; classes
low-class
middle-class
high-class

;; Gini and lorenz
gini-index-reserve
lorenz-points

;; Ratio for each decile population
ratio-a
ratio-b
ratio-c
ratio-d

return-list  ;; A list for when systems go to critical stages
]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Setup Procedure
to setup
  clear-all
  ;; patches
  if specified-random-seed? [ random-seed specified-seed]  ;; seed od experimentation
  resize-world 0 555 0 600   ;; size of world view
  set-patch-size 1
  ask patches [ set pcolor cyan + 3]
  ;; create a number of persons
 create-persons num-of-people [
    ifelse initial-equal-money? [ set money money-amount ] [set money random money-amount]
      set shape one-of ["woman" "person"]
      recolor
      set size 12
 ;; visualize the persons from up to down in ascending order of money
      setxy random-xcor money
      ]
 ;; create charity organizations
    create-charities num-of-charities [

    ifelse sadaqah?
     [set resources 0] ;; set it 0 and resource from highest deciles
    [set resources (total-money / 5)] ;; one-fifth of total money of population
     setxy (random-float 1 * max-pxcor) (0.95 * max-pycor)
     set shape "house"
     set color green
     set size 15
]

set Bottom-50%-agentset min-n-of (count persons * 0.50) persons [ money ]

;; computation of economic deciles
  decile-compuation

;; classess for calculating lorenz curve
set low-class count persons with [ money >= 0 and money < (0.34 * total-money)]
set middle-class count persons with [ money >= 34 and money < (57 * total-money) ]
set high-class count persons with [ money >= 57 and money <= total-money]

;; Lorenz and Gini
  update-lorenz-and-gini

;; ratios
set ratio-a 0
set ratio-b 0
set ratio-c 0
set ratio-d 0
;; list of times when the economic system goes to a critical stage
set return-list []

reset-ticks
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Go Procedure
to go
 if ticks = tick-threshold [ stop]  ;; threshold of exprimentation

clear-links
;; transact and then update your location
  ask persons with [ floor(money) > 0 ] [ transact ]

;; prevent money of turtles from moving too far to the up
  ask persons [ if  floor(money) <= max-pycor [ set ycor floor(money) ] ]

;; setting global variables for bottom %50 agentsets
set Bottom-50%-agentset min-n-of (count persons * 0.50) persons [ money ]

;; computation of economic deciles for following procedures
 decile-compuation

;; the mechanism for operationalization of charity organizations

  ifelse charity-operation? [ if top-10%-money >= (bottom-50%-money - (critical-threshold))  ;;the  critical indicator

  [ output-print ticks  set return-list lput ticks return-list   ifelse sadaqah? [fill-the-gap-with-sadaqah]  [fill-the-gap-without-sadaqah]

    ]  ;; computation of economic deciles for when charities come to scene

]
   [if top-10%-money >= (bottom-50%-money - (critical-threshold)) [output-print ticks ] ]

;;; switchs for computation of classes for Lorens and Gini

 if compute-class? [
set low-class count persons with [ money >= 0 and money < (0.34 * total-money)]
set middle-class count persons with [ money >= 34 and money < (57 * total-money) ]
set high-class count persons with [ money >= 57 and money <= total-money]
  ]

 if compute-lorenz-and-gini? [update-lorenz-and-gini]

  tick

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; helper procedures;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;Transact
to transact
  ;; give a unit of money to another person
  set money money - 1
  ask one-of other persons [ set money money + 1 ]
  recolor
end

to recolor  ;; change color according to money amount
  set color scale-color black money 100 0
end

;;;;;;;;;;;;;;;;;;;;;;;Computation of deciles
to decile-compuation
let pop count persons
let sorted-pop-based-on-money sort-by [ [i j] -> [money] of i < [money] of j ] persons
   ;; for positions
let p1 (0.10 * pop)
let p2 (0.20 * pop)
let p3 (0.30 * pop)
let p4 (0.40 * pop)
let p5 (0.50 * pop)
let p6 (0.60 * pop)
let p7 (0.70 * pop)
let p8 (0.80 * pop)
let p9 (0.90 * pop)
let p10 (1 * pop)
    ;; for sublists
let b1 sublist sorted-pop-based-on-money 0  p1
let b2 sublist sorted-pop-based-on-money p1  p2
let b3 sublist sorted-pop-based-on-money p2  p3
let b4 sublist sorted-pop-based-on-money p3  p4
let b5 sublist sorted-pop-based-on-money p4  p5
let b6 sublist sorted-pop-based-on-money p5  p6
let b7 sublist sorted-pop-based-on-money p6  p7
let b8 sublist sorted-pop-based-on-money p7  p8
let b9 sublist sorted-pop-based-on-money p8  p9
let b10 sublist sorted-pop-based-on-money p9  p10


set decile-1 turtle-set b1
set decile-2 turtle-set b2
set decile-3 turtle-set b3
set decile-4 turtle-set b4
set decile-5 turtle-set b5
set decile-6 turtle-set b6
set decile-7 turtle-set b7
set decile-8 turtle-set b8
set decile-9 turtle-set b9
set decile-10 turtle-set b10
end

to-report money-of-decile-one
  report sum [money] of decile-1
end

to-report money-of-decile-two
  report sum [money] of decile-2
end

to-report money-of-decile-three
  report sum [money] of decile-3
end

to-report money-of-decile-four
  report sum [money] of decile-4
end

to-report money-of-decile-five
  report sum [money] of decile-5
end

to-report money-of-decile-six
  report sum [money] of decile-6
end

to-report money-of-decile-seven
  report sum [money] of decile-7
end

to-report money-of-decile-eight
  report sum [money] of decile-8
end

to-report money-of-decile-nine
  report sum [money] of decile-9
end

to-report money-of-decile-ten
  report sum [money] of decile-10
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;resorce allocation

;; when charities dont have independent resources and do resourcing based on money of the highest decile (sadaqah)

to fill-the-gap-with-sadaqah
;; In each tick,  take money frome rihest person of decile 10 and allocate resource to poorest person of lowest 5 deciles
  if allocation-strategy? = "s-one" [ ask charities
    [ help-with-sadaqah max-n-of 1 decile-10 [money] no-turtles no-turtles no-turtles no-turtles no-turtles  min-n-of 1 Bottom-50%-agentset [money] ] ]

;; In each tick, take money from all persons of decile 10 and  randomly allocate it to 20% of lowest 5 deciles

  if allocation-strategy? = "s-two" [

    let a ((percentage-of-decile-10 / 100) * count decile-10)
    let w ((percentage-of-five-lower-deciles / 100) * count Bottom-50%-agentset)

    ask charities  [ help-with-sadaqah n-of (a) decile-10  no-turtles no-turtles no-turtles no-turtles no-turtles  n-of(w) Bottom-50%-agentset    ]
  ]
;;;
  if allocation-strategy? = "s-three" [
      let a ((percentage-of-decile-10 / 100) * count decile-10)
      let b ((percentage-of-decile-9 / 100) * count decile-9)
      let c ((percentage-of-decile-8 / 100) * count decile-8)

      let aa ((percentage-of-decile-1 / 100) * count decile-1)
      let bb ((percentage-of-decile-2 / 100) * count decile-2)
      let cc ((percentage-of-decile-3 / 100) * count decile-3)

ask charities  [ help-with-sadaqah n-of(a) decile-10  n-of(b) decile-9  n-of(c) decile-8  n-of(aa) decile-1  n-of(bb) decile-2   n-of(bb) decile-3   no-turtles ]

  ]
end

;; when charities have independent resources

to fill-the-gap-without-sadaqah
  ;;;;;;; strategies of  resource allocation to lower income deciles (lower 5 deciles)
  ;; In each tick,  allocate resource to poorest person of lower 5 deciles and subtract its resources by one unit
  if allocation--strategy? = "ws-one" [ ask charities [ if resources >= 1 [
    help-without-sadaqah no-turtles no-turtles no-turtles no-turtles no-turtles no-turtles  min-n-of 1 Bottom-50%-agentset [money]
    set resources resources - 1] ] ]

  ;; In each tick,  allocate resource to all of lowest 5 deciles and subtract its resources by number of lowest 5 deciles persons
  if allocation--strategy? = "ws-two" [ ask charities [ if resources >= 1 [
    help-without-sadaqah no-turtles no-turtles no-turtles no-turtles no-turtles no-turtles  Bottom-50%-agentset

    set resources resources - (count Bottom-50%-agentset) ]]]
end

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;help with sadaqah

to help-with-sadaqah [ decile10  decile9  decile8    decile1  decile2  decile3  five-lower-deciles]
  ;;;; benfactor deciles
     let rich-target-10 decile10
     let rich-target-9 decile9
     let rich-target-8 decile8

  ;;;;; the needful deciles
      let bottom50%-target  five-lower-deciles
      let poor-target-1 decile1
      let poor-target-2 decile2
      let poor-target-3 decile3
 ;;;; the ratios of subtraction

  if rich-target-10 != no-turtles and bottom50%-target != no-turtles [ set
   ratio-a ( count rich-target-10 / count bottom50%-target) ;; for strategy 2
  ]
  if rich-target-10 != no-turtles and poor-target-1 != no-turtles [
    set  ratio-b ( count rich-target-10  / count poor-target-1) ;; for strategy 3
  ]

  if rich-target-9 != no-turtles and poor-target-2 != no-turtles [
   set ratio-c ( count rich-target-9  / count poor-target-2) ;; for strategy 3
    ]

    if rich-target-8 != no-turtles and poor-target-3 != no-turtles [
   set ratio-d ( count rich-target-8  / count poor-target-3) ;; for strategy 3
    ]

;;;;; benefactors

if  rich-target-10 != no-turtles  [

if show-help? [ ifelse count rich-target-10 = 1 [ask rich-target-10 [create-sadaqah-link-to myself[set color red set thickness 3]]]
      [ask rich-target-10 [create-sadaqah-link-to myself [set color red set thickness 2]]]  ]

ask rich-target-10 [set money money - 1]
]

if  rich-target-9 != no-turtles  [

if show-help? [ ifelse count rich-target-9 = 1 [ask rich-target-9 [create-sadaqah-link-to myself[set color blue set thickness 3]]]
      [ask rich-target-9 [create-sadaqah-link-to myself [set color blue set thickness 2]]]  ]

ask rich-target-9 [set money money - 1]
]

if  rich-target-8 != no-turtles  [

if show-help? [ ifelse count rich-target-8 = 1 [ask rich-target-8 [create-sadaqah-link-to myself[set color yellow set thickness 3]]]
      [ask rich-target-8 [create-sadaqah-link-to myself [set color yellow set thickness 2]]]  ]

ask rich-target-8 [set money money - 1]
]

;;;;;the needful deciles

if  bottom50%-target != no-turtles [

if show-help? [ ifelse count bottom50%-target = 1 [create-allocation-link-to one-of bottom50%-target [set color green set thickness 2]]
      [create-allocation-links-to bottom50%-target [set color green]] ]

ask bottom50%-target [set money money + ratio-a ]
]


if  poor-target-1 != no-turtles [

if show-help? [ ifelse count poor-target-1 = 1[create-allocation-link-to one-of poor-target-1 [set color green set thickness 2]]
      [create-allocation-links-to poor-target-1 [set color green]] ]

ask poor-target-1 [set money money + ratio-b ]
]

if  poor-target-2 != no-turtles [

if show-help? [ ifelse count poor-target-2 = 1 [create-allocation-link-to one-of poor-target-2 [set color green set thickness 2]]
      [create-allocation-links-to poor-target-2 [set color green]] ]

ask poor-target-2 [set money money + ratio-c ]
]

 if  poor-target-3 != no-turtles [

if show-help? [ ifelse count poor-target-3 = 1 [create-allocation-link-to one-of poor-target-3 [set color green set thickness 2]]
      [create-allocation-links-to poor-target-3 [set color green]] ]

ask poor-target-3 [set money money + ratio-d ]
]


end
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;help without sadaqah
to help-without-sadaqah [ decile10  decile9  decile8    decile1  decile2  decile3  five-lower-deciles]

  let bottom50%-target five-lower-deciles

  if  bottom50%-target != no-turtles [

if show-help? [ ifelse count bottom50%-target = 1 [create-allocation-link-to one-of bottom50%-target [set color green set thickness 2]]
      [create-allocation-links-to bottom50%-target [set color green]] ]

ask bottom50%-target [set money money + 1 ]
]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; reporters

 ;; report total ealth of population
to-report total-money
  report sum [money] of persons
end
  ;; report the money of top 10
to-report top-10%-money
  report sum [ money ] of decile-10
end
  ;; report the money of bottom 50
to-report bottom-50%-money
  report sum [ money ] of Bottom-50%-agentset
end

;;;;; critical value

to-report difference
  let diff (bottom-50%-money - top-10%-money)
  report diff
end

to-report one-thousandth-of-diff
let diffth  (difference / 1000)
 report diffth
end

;;;;;; Lorenz curve and Gini Coefficient
to update-lorenz-and-gini
let sorted-moneys sort [money] of persons
let all-money sum sorted-moneys
let money-sum-so-far 0
let index 0
set gini-index-reserve 0
set lorenz-points []

  ;; now actually plot the Lorenz curve -- along the way, we also
  ;; calculate the Gini index.
  ;; (see the Info tab for a description of the curve and measure)
  repeat num-of-people [
    set money-sum-so-far (money-sum-so-far + item index sorted-moneys)
    set lorenz-points lput ((money-sum-so-far / total-money) * 100) lorenz-points
    set index (index + 1)
    set gini-index-reserve
      gini-index-reserve +
      (index / num-of-people) -
      (money-sum-so-far / all-money)
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
12
10
576
620
-1
-1
1.0
1
10
1
1
1
0
0
0
1
0
555
0
600
1
1
1
ticks
30.0

BUTTON
1693
348
1782
381
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1794
348
1879
381
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
598
13
961
207
Money distribution
Money
Frequency of people
0.0
500.0
0.0
40.0
true
false
"" ""
PENS
"current" 5.0 1 -10899396 true "" "set-plot-y-range 0 50\nhistogram [ money ] of persons"

MONITOR
1360
110
1540
155
money of bottom 50%
bottom-50%-money
1
1
11

MONITOR
1360
62
1540
107
money of top 10%
top-10%-money
1
1
11

PLOT
969
13
1334
207
Money by percent
NIL
NIL
0.0
10.0
0.0
10000.0
true
true
"" ""
PENS
"top 10%" 1.0 0 -7500403 true "" "plot top-10%-money"
"bottom 50%" 1.0 0 -13345367 true "" "plot bottom-50%-money"

MONITOR
1359
209
1539
254
indep resources of charities
sum [resources] of charities
17
1
11

CHOOSER
1668
704
1951
749
allocation-strategy?
allocation-strategy?
"s-one" "s-two" "s-three"
2

SWITCH
1693
386
1878
419
charity-operation?
charity-operation?
0
1
-1000

MONITOR
1361
14
1540
59
Total money of population
total-money
17
1
11

SWITCH
1698
306
1881
339
sadaqah?
sadaqah?
0
1
-1000

SWITCH
1698
185
1878
218
initial-equal-money?
initial-equal-money?
0
1
-1000

SLIDER
1697
148
1878
181
money-amount
money-amount
0
500
100.0
10
1
NIL
HORIZONTAL

SLIDER
1695
110
1877
143
num-of-people
num-of-people
0
2000
500.0
50
1
NIL
HORIZONTAL

SLIDER
1697
265
1877
298
num-of-charities
num-of-charities
0
5
1.0
1
1
NIL
HORIZONTAL

SWITCH
1695
430
1879
463
show-help?
show-help?
0
1
-1000

PLOT
595
217
1337
443
Difference
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
" diff-value in 1/1000 " 1.0 0 -16777216 true "" "plot one-thousandth-of-diff"
"critical-threshold in 1/1000" 1.0 0 -2674135 true "set-plot-y-range -10 30\nset-plot-y-range -10 30" "plot-pen-reset\nplotxy 0 (critical-threshold / 1000)\nplotxy plot-x-max (critical-threshold / 1000)"

SLIDER
1695
225
1877
258
critical-threshold
critical-threshold
-20000
20000
0.0
100
1
NIL
HORIZONTAL

MONITOR
1359
159
1541
204
NIL
difference
17
1
11

PLOT
295
797
576
957
Gini vs time
Time
Gini Coefficient
0.0
10.0
0.0
1.0
true
false
"set-plot-x-range 0 plot-x-max\n\nset-plot-y-range 0 1" ""
PENS
"default" 1.0 0 -13345367 true "" "plot (gini-index-reserve / num-of-people) / 0.5"

PLOT
15
794
290
960
Lorenz Curve
Pop %
Wealth %
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Lorenz" 1.0 0 -2674135 true "" "plot-pen-reset\nset-plot-pen-interval 100 / num-of-people\nplot 0\nforeach lorenz-points plot"
"equal" 100.0 0 -16777216 true "plot 0\nplot 100" ""

PLOT
12
626
576
791
class histogram
classes
persons
0.0
10.0
0.0
10.0
true
false
"set-plot-y-range 0 num-of-people " ""
PENS
"default" 1.0 1 -16777216 true "" "plot-pen-reset\nset-plot-pen-color red\nplot low-class\nset-plot-pen-color green\nplot middle-class\nset-plot-pen-color blue\nplot high-class"

INPUTBOX
1695
471
1878
531
tick-threshold
4575.0
1
0
Number

PLOT
790
455
1332
690
deciles histogram
NIL
NIL
0.0
10.0
0.0
20.0
true
false
"set-plot-y-range 0 num-of-people " ""
PENS
"default" 1.0 1 -16777216 true "" "plot-pen-reset\nset-plot-pen-color red\nplot money-of-decile-one\nset-plot-pen-color green\nplot money-of-decile-two\nset-plot-pen-color blue\nplot money-of-decile-three\nset-plot-pen-color pink\nplot money-of-decile-four\nset-plot-pen-color magenta\nplot money-of-decile-five\nset-plot-pen-color violet\nplot money-of-decile-six\nset-plot-pen-color sky\nplot money-of-decile-seven\nset-plot-pen-color cyan\nplot money-of-decile-eight\nset-plot-pen-color orange\nplot money-of-decile-nine\nset-plot-pen-color black\nplot money-of-decile-ten"

OUTPUT
594
466
774
692
12

SWITCH
1695
533
1879
566
compute-class?
compute-class?
0
1
-1000

SWITCH
1695
570
1879
603
compute-lorenz-and-gini?
compute-lorenz-and-gini?
0
1
-1000

MONITOR
1551
12
1661
57
mean of money
mean [money] of persons
17
1
11

MONITOR
1551
62
1663
107
variance
variance [money] of persons
17
1
11

MONITOR
1550
117
1664
162
SD
standard-deviation [money] of persons
17
1
11

MONITOR
1373
398
1463
443
NIL
count decile-1
17
1
11

MONITOR
1373
443
1463
488
NIL
count decile-2
17
1
11

MONITOR
1373
498
1463
543
NIL
count decile-3
17
1
11

MONITOR
1372
549
1462
594
NIL
count decile-4
17
1
11

MONITOR
1373
599
1463
644
NIL
count decile-5
17
1
11

MONITOR
1475
399
1565
444
NIL
count decile-6
17
1
11

MONITOR
1475
445
1565
490
NIL
count decile-7
17
1
11

MONITOR
1473
499
1563
544
NIL
count decile-8
17
1
11

MONITOR
1472
549
1562
594
NIL
count decile-9
17
1
11

MONITOR
1472
599
1561
644
NIL
count decile-10
17
1
11

SWITCH
1694
10
1881
43
specified-random-seed?
specified-random-seed?
0
1
-1000

INPUTBOX
1694
45
1880
105
specified-seed
3000.0
1
0
Number

SLIDER
1671
785
1959
818
percentage-of-decile-10
percentage-of-decile-10
10
100
100.0
10
1
%
HORIZONTAL

TEXTBOX
1767
764
1982
790
benefactors
11
0.0
1

SLIDER
1671
824
1956
857
percentage-of-decile-9
percentage-of-decile-9
10
100
60.0
10
1
%
HORIZONTAL

SLIDER
1671
861
1956
894
percentage-of-decile-8
percentage-of-decile-8
10
100
40.0
10
1
%
HORIZONTAL

SLIDER
1674
938
1959
971
percentage-of-decile-1
percentage-of-decile-1
10
100
100.0
10
1
%
HORIZONTAL

SLIDER
1674
975
1959
1008
percentage-of-decile-2
percentage-of-decile-2
10
100
60.0
10
1
%
HORIZONTAL

SLIDER
1677
1014
1962
1047
percentage-of-decile-3
percentage-of-decile-3
10
100
40.0
10
1
%
HORIZONTAL

SLIDER
1677
1054
1961
1087
percentage-of-five-lower-deciles
percentage-of-five-lower-deciles
10
100
20.0
10
1
%
HORIZONTAL

TEXTBOX
1768
917
2018
947
needful targets
11
0.0
1

TEXTBOX
1600
630
2022
664
Parameters for resource allocation by charity organization(s)
15
0.0
1

TEXTBOX
1762
670
1912
689
 (I) with sadaqah
14
0.0
1

TEXTBOX
1770
1115
1920
1133
(II) without sadaqah
14
0.0
1

CHOOSER
1674
1155
1960
1200
allocation--strategy?
allocation--strategy?
"ws-one" "ws-two"
1

TEXTBOX
1545
795
1695
813
For strategies 2 & 3
11
0.0
1

TEXTBOX
1547
834
1697
852
For strategy 3
11
0.0
1

TEXTBOX
1547
876
1697
894
For strategy 3
11
0.0
1

TEXTBOX
1548
944
1698
962
For strategy 3
11
0.0
1

TEXTBOX
1546
990
1696
1008
For strategy 3
11
0.0
1

TEXTBOX
1548
1030
1698
1048
For strategy 3
11
0.0
1

TEXTBOX
1549
1067
1699
1085
For strategy 2
11
0.0
1

TEXTBOX
1542
722
1692
740
strategies 1, 2 & 3
11
0.0
1

TEXTBOX
1550
1169
1700
1187
Strategies 1 & 2
11
0.0
1

MONITOR
1364
263
1543
308
NIL
return-list
17
1
11

MONITOR
1362
317
1543
362
frequency of return periods
length return-list
17
1
11

TEXTBOX
623
447
749
484
Number of Critical Times
10
0.0
1

@#$#@#$#@
## WHAT IS IT?

As an extension of the simple economy model of Uri Wilensky (2011), This model has been developed to show and explain following issues:

1: How does the economic inequaliy emerge in an economic system?

2: How does sadaqah as an voulntary charity in Islam help reducing this emergent inequality?

3: As entities that receive sadagah from benefactors and allocate it to the needy, how can charity organizations affect the alleviation of the emergent economic inequality?

In this model, each human agent has a tendency towards giving one unit of money to another one (at a random manner), each agent does it until its money gets finished. According to statsitistical mechanics, the interaction of agents gradually widens the distance between five lower decils (bottom 50%) and higest decile (top 10%). When the total amount of top 10% becomes more than or equal to  that of bottom 50%, this causes the economic system to go to a critical stage. In such a situation, if there are some charity organizations, they come to scene to help lower economic deciles and economic system to exit the critical stage. Thes entities have two different ways of financing as follows:

1: They have an independent money (in this simulation, one-fifth of total money of all agents)

2: They receive the Islamic charity (sadaqah) that some of agents give and allocate it to lower deciles.
 
When charities have the first way of resourcing, all of them can just take one of two following strategies for allocating resources among the needy agents: 

    1) When the system goes to a critical stage, they hlep the poorest agent ( by one unit of money) in each time step until the system exits the critical stage.

    2)  When the system goes to a critical stage, they hlep bottom 50%  (by one unit of money for each one) in each time step until the system exits the critical stage.
 
When charities have the second way of resourcing, all of them can just take one of two following strategies for allocating resources among the needy agents 

    1) When the system goes to a critical stage, just the richest agnet gives sadaqah ( a unit of money) to the charity entity and it allocates it to the poorest agent

    2) When the system goes to a critical stage, just c% of richest decile  gives sadaqah (a unit of money by each agent) to the charity entity and it allocates it randomly to d% of the bottom 50%.

    3) When the system goes to a critical stage, just k% of decile-10 (top 10%), p% of decile-9 and v% of dfecile-8 give sadaqah (a unit of money by eah person) to the charity entity and it allocates it as following:

     sadaqah paid by k% of decile-10 is allocated to x% of decile-1
     sadaqah paid by p% of decile-9 is allocated to y% of decile-2
     sadaqah paid by v% of decile-8 is allocated to z% of decile-3

## HOW TO USE IT

"setup Button" is for model setup.

"go button" is to run the model.

"sepcified-random-seed switch"  is On when a seed can be specified for a specific experimentation and is Off when the system is randomly simulated in each run.

"specified-seed input" is to receive the seed when the sepcified-random-seed switch is On.

"num-of-people slider" is for determining the number of human agents before any run.

"money-amount slider" is for determining the money amount of human agents before any run.

"initial-eqaul-money switch" is  On when all agents have the same amount of money in the begining and is Off when all agents dont have the same amount of money in the begining.

"critical-threshold slider" is for determining the critical point before any run (when the difference between total money of top 10% and that of bottom 50% becomes equal to more than this point, the economic system goes to a critical stage).

"num-of-charities slider" is for determining the number of charity entities before any run.

"sadaqah switch"  is On when people of the socity tends to pay sadaqah in critical stage of econmoy and is off when no agent pays sadaqah in such a stage.

"tick-threshold input" is for determining the time of run stop.

"compute-class switch" is On for computing the classes otherwise off.This slider has been taken from wealth distribution model of uri Wilensky (1998) .

"compute-Lorenz-and-Gini switch" is On for computing Gini coefficient and Lorenz curve otherwise off.This slider has been taken from wealth distribution model of uri Wilensky (1998). 

When people give sadaqah, allocation strategies and related parameters are as follows:
 
"allocation-strategy? chooser" includes: 

       s-one: when the system goes to a critical stage, just the richest agnet gives sadaqah (a unit of money) to the charity entity and it allocates it to the poorest agent.

       s-two: when the system goes to a critical stage, just c% of richest decile  gives sadaqah ( a unit of money by each agent ) to the charity entity and it allocates it randomly to d% of the bottom 50%.

       s-three: when the system goes to a critical stage, just k% of decile-10 (top 10%), p% of decile-9 and v% of dfecile-8 give sadaqah (a unit of money by eah person) to the charity entity that allocates it as following:

     sadaqah paid by k% of decile-10 is allocated to x% of decile-1
     sadaqah paid by p% of decile-9 is allocated to y% of decile-2
     sadaqah paid by v% of decile-8 is allocated to z% of decile-3

"percentage-of-decile-10 slider" is for determining the number of members of decile-10 participating in paying sadaqah to charity entities.

"percentage-of-decile-9 slider" is for determining the number of members of decile-9 participating in paying sadaqah to charity entities.

"percentage-of-decile-8 slider" is for determining the number of members of decile-8 participating in paying sadaqah to charity entities.

"percentage-of-decile-1 slider" is for determining the number of members of decile-1 receiving the sadaqah from charity entities.

"percentage-of-decile-2 slider" is for determining the number of members of decile-2 receiving the sadaqah from charity entities.

"percentage-of-decile-3 slider" is for determining the number of members of decile-3 receiving the sadaqah from charity entities.

"percentage-of-five-lower-deciles slider" is for determining the number of members of five-lower-deciles receiving the sadaqah from charity entities.

When people dont give sadaqah, allocation strategies and related parameters are as follows:
 
"allocation-strategy? chooser" includes: 

       ws-one: When the system goes to a critical stage, charities hlep the poorest agent (by one unit of money) in each time step until the system exits the critical stage.

       ws-one: When the system goes to a critical stage, charities hlep bottom 50% (by one unit of money for each one) in each time step until the system exits the critical stage.

## THINGS TO NOTICE

Gini coefficient and Lorenz curve are technically used for distribution of wealth or income. This model deals with distribution of money so It is unnecessary to use these switches for simulation.In addition, they can majorly slow the operation of model runs when lots af human agents and high amount of money are used in simulations.

## EXTENDING THE MODEL


Some new agents and beghavioral rules can be added to make this model more realistic some of which are as following: 

1- Human agents can directly give and receive sadaqah

2- Other phenomena such as distribution of wealth and income can be simulated

3- other economic reule of Islam such as Zakat and so on can be added to the model

4- Some features such as educational level and tendency to entrepreneurship can be added to agents to enable them to interact productively.
 
5- Some new agents such as venture capital funds, banks and so on can be added to the model to make the economic system more interactive. One instance for this can be venture capital funds set a priority for entrepreneurial eduacted agents living in  poor deciles of the society. 


## RELATED MODELS

Simple Economy

Wealth Distribution.

## CREDITS AND REFERENCES
  
The author and domain experts who participated in developing this model can be contacted by following emails:

Hossein Sabzian, PhD student, IUST, hossein_sabzian@pgre.iust.ac.ir

Alireza Aliahmadi, Professor, IUST, aliahmadia@iust.ac.ir

Adel Azar, Professor, TMU, AZARA@modares.ac.ir

Madjid Mirzaeei, Assistant professor, KNTU, majidmirza@ut.ac.ir


 * Wilensky, U. (2011).  NetLogo Simple Economy model.  http://ccl.northwestern.edu/netlogo/models/SimpleEconomy.  Center for Connected Learning and Computer-Based Modeling, Northwestern Institute on Complex Systems, Northwestern University, Evanston, IL.

 * Dragulescu, A. & V.M. Yakovenko, V.M. (2000). Statistical Mechanics of Money. European Physics Journal B.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

woman
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 135 75 270 105 270 135 270 150 270 165 270 195 270 225 270 180 135 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.1
@#$#@#$#@
resize-world 0 500 0 500 setup ask turtles [ set size 5 ] repeat 150 [ go ]
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="100000"/>
    <exitCondition>top-10%-money &gt; bottom-50%-money</exitCondition>
    <metric>top-10%-money</metric>
    <metric>bottom-50%-money</metric>
    <enumeratedValueSet variable="charity-institution?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
