globals [ ethUsd reserveEth reserveAcd totalLockedAcd interestPool earnedInterest totalSupply
  ethUsdRates
  floatingAcd ; not locked or in reserve, in circulation
]
breed [loans loan]
breed [deposits deposit]
deposits-own [depositAmount start term maturity interestPt interestAmount]
loans-own [loanAmount disbursedAmount interestAmount interestPt collateral start term maturity ]

to startup
  setup
end

to setup
  clear-all
  read-ethUsdRates
  if startRatesIndex - 1 >= length ethUsdRates [
    user-message  (word "startRatesIndex " startRatesIndex " must be lower than size of historic ethUsdRates of " length ethUsdRates)
  ]
  if endRatesIndex > length ethUsdRates [
    user-message  (word "startRatesIndex  " startRatesIndex " is higher than size of historic ethUsdRates of " length ethUsdRates)
  ]
  if startRatesIndex >= endRatesindex [
    user-message  (word "startRatesIndex " startRatesIndex " must be lower than endRatesIndex " endRatesIndex)
  ]
  set ethUsd item startRatesIndex ethUsdRates
  set earnedInterest initEarnedInterest
  set reserveAcd initReserveAcd
  set reserveEth initReserveEth
  set totalSupply initEarnedInterest + initReserveAcd
  set-default-shape loans "sheep"
  set-default-shape deposits "star"
  reset-ticks
end

to go
  if ticks + 1 > endRatesIndex - startRatesIndex [
    stop
  ]
  set ethUsd item (ticks + startRatesIndex) ethUsdRates
  place-deposits
    output-print (word "Total supply: " totalSupply " ReserveAcd: " reserveAcd " totalLockedAcd: " totalLockedAcd " reserveEth: " reserveEth " interestPool: " interestPool " earnedInterest: " earnedInterest)
  buy-or-sell-acd
   output-print (word "Total supply: " totalSupply " ReserveAcd: " reserveAcd " totalLockedAcd: " totalLockedAcd " reserveEth: " reserveEth " interestPool: " interestPool " earnedInterest: " earnedInterest)
  release-deposits
    output-print (word "Total supply: " totalSupply " ReserveAcd: " reserveAcd " totalLockedAcd: " totalLockedAcd " reserveEth: " reserveEth " interestPool: " interestPool " earnedInterest: " earnedInterest)
  get-loans
    output-print (word "Total supply: " totalSupply " ReserveAcd: " reserveAcd " totalLockedAcd: " totalLockedAcd " reserveEth: " reserveEth " interestPool: " interestPool " earnedInterest: " earnedInterest)
  payback-loans
    output-print (word "Total supply: " totalSupply " ReserveAcd: " reserveAcd " totalLockedAcd: " totalLockedAcd " reserveEth: " reserveEth " interestPool: " interestPool " earnedInterest: " earnedInterest)   tick
end

to place-deposits
  ifelse acdDepositInterestPt > usdDepositMktInterestPt [
    ; anything between 1 ACD and the amount availabel in earnedInterest (but max maxDepositAmount and what is available in reserve)
    let _depositNet round((random earnedInterest ) / ( acdDepositInterestPt / 100)) + 1
    if _depositNet > maxDepositAmount [ set _depositNet maxDepositAmount ]
    if _depositNet > reserveAcd [set _depositNet reserveAcd]
    let _depositAmount round( _depositNet * (1 + acdDepositInterestPt / 100))

    ifelse _depositAmount > 0 [
      let _interestAmount _depositAmount - _depositNet

      create-deposits 1
      [
        set heading 180
        setxy (floor( (who ) / (max-pycor + 1 ) ) ) (who mod (max-pycor + 1 ) )
        set color green
        set depositAmount _depositAmount
        set interestPt acdDepositInterestPt
        set interestAmount _interestAmount
        set term depositTerm
        set start ticks
        set maturity start + term
        output-print (word "Tick #" ticks " - New deposit #" who " depositAmount: " depositAmount "ACD _depositNet: "  _depositNet "ACD."
          " acdDepositInterestPt: " acdDepositInterestPt " interestAmount: " _interestAmount
          " term: " term " maturity: " maturity)
      ]

      buy-acd-from-reserve _depositNet ; buys acd from reserve to deposit

      set earnedInterest earnedInterest - _interestAmount
      set totalLockedAcd totalLockedAcd + _depositAmount
    ] [
       output-print (word "Tick #" ticks " - not enough earnedInterest or reserveAcd to deposit " _depositAmount "ACD _depositNet: "  _depositNet "ACD. reserveAcd: " reserveAcd " earnedInterest: " earnedInterest)
    ]
  ] [
    output-print (word "Tick #" ticks " - usd interest is higher or equal to ACD interest, noone deposits ACD")
  ]
end

to buy-or-sell-acd
  let acdSellAmount random(1) * chanceToSellAcd / 100 * floatingAcd
  let acdBuyAmount random(1) * chanceToBuyAcd / 100 * reserveAcd ;  we assume that the max demand is what we have in reserve, if it's more then ppl will get a loan (or go to secondary mkt)
  let amount 0
  ifelse acdSellAmount > acdBuyAmount [
    set amount acdSellAmount - acdBuyAmount
    buy-eth-from-reserve amount
    set floatingAcd floatingAcd - amount
  ] [
    set amount acdBuyAmount - acdSellAmount
    buy-acd-from-reserve amount
    set floatingAcd floatingAcd + amount
  ]
  output-print (word "Tick #" ticks " - buy-or-sell-acd floatingAcd: " floatingAcd
          " amount: " amount "ACD acdSellAmount: " acdSellAmount "ACD acdBuyAmount:  "acdBuyAmount
          " ethUsd: " ethUsd " chanceToSellAcd:" chanceToSellAcd "% chanceToBuyAcd: " "% reserveAcd: " reserveAcd "ACD floatingAcd: " floatingAcd "ACD")
end

to release-deposits
  ask deposits with [ maturity = ticks ] [
    output-print (word "Tick #" ticks " - deposit #" who " release " depositAmount "ACD")

    let ethValue (depositAmount / ethUsd)
    if ethValue > reserveEth [
      user-message  (word "Not enough ETH in reserve to convert the released " depositAmount "ACD to ETH after loan disbursement. reserveEth: " reserveEth "ETH")
    ]
    set reserveEth reserveEth - ethValue ; immediatety buys ETH with ACD released
    set reserveAcd reserveAcd + depositAmount
    set totalLockedAcd totalLockedAcd - depositAmount
    set color white
  ]
end

to get-loans
    let _disbursedAmount round((random (reserveEth * ethUsd) ))
    if _disbursedAmount > maxLoanAmount [ set _disbursedAmount maxLoanAmount ]
    ifelse _disbursedAmount > 0 [
      let _collateral round(_disbursedAmount / ( loanCollateralRatio / 100) / ethUsd )
      let _loanAmount round(_disbursedAmount *  (1 + acdLoanInterestPt / 100))
      let _interestAmount (_loanAmount - _disbursedAmount)
      create-loans 1
      [
        set heading 180
        setxy (floor( (who ) / (max-pycor + 1 ) ) ) (who mod (max-pycor + 1 ) )
        set color green
        set loanAmount _loanAmount
        set disbursedAmount _disbursedAmount
        set interestAmount _interestAmount
        set interestPt acdLoanInterestPt
        set collateral _collateral
        set term loanTerm
        set start ticks
        set maturity start + term
        output-print (word "Tick #" ticks " - New loan #" who " loanAmount: " loanAmount
          " disbursedAmount: " disbursedAmount " interestPt: " interestPt " interestAmount: " interestAmount
          " term: " term " maturity: " maturity " loanCollateralRatio: " loanCollateralRatio " collateral: " _collateral
          " ethUsd: " ethUsd)
      ]
      let ethValue (_disbursedAmount / ethUsd)
      if ethValue > reserveEth [
        user-message  (word "Not enough eth in reserve to convert disbursedAmount " _disbursedAmount "ACD to ETH after loan disbursement. reserveEth: " reserveEth "ETH")
      ]
      set totalSupply totalSupply + _loanAmount
      set reserveEth reserveEth - ethValue ; immediatly sell disbursed ACD for ETH through reserve
      set reserveAcd reserveAcd + _disbursedAmount
      set interestPool interestPool + _interestAmount

    ] [
       output-print (word "Tick #" ticks " - reserveEth is 0, no new loan")
    ]
end

to payback-loans
  ask loans with [ maturity = ticks ] [
    ifelse random(100) >= forgottenLoanRate [
      ifelse collateral > (loanAmount / ethUsd) [
        output-print (word "Tick #" ticks " - Repay loan #" who " loanAmount: " loanAmount
          " disbursedAmount: " disbursedAmount " interestPt: " interestPt " interestAmount: " interestAmount
          " term: " term " maturity: " maturity " loanCollateralRatio: " loanCollateralRatio " collateral: " collateral
          " ethUsd: " ethUsd)

        if (reserveAcd < loanAmount) [
          user-message  (word "Not enough ACD to buy for loan repayment. reserveACD: " reserveAcd " loanAmount: " loanAmount)
        ]
        set reserveEth reserveEth + (loanAmount / ethUsd) ; buying Acd with ETH from reserve to repay
        set reserveAcd reserveAcd - loanAmount
        set interestPool interestPool - interestAmount
        set earnedInterest earnedInterest + interestAmount
        set totalSupply totalSupply - loanAmount
        set collateral 0
        set color white
      ]
      [
         collect-loan red; didn't worth to repay
      ]
    ] [
      collect-loan red + 3 ; forgot to repay
    ]
  ]
end

to collect-loan [ markColor ] ; turtle context
  let toCollect loanAmount * (1 + defaultingLoanFeePt / 100) / ethUsd
  if toCollect > collateral [ set toCollect collateral]
  output-print (word "Tick #" ticks " - loans #" who " default collecting " toCollect "ETH from " collateral
    "ETH collateralAcdValue: " (collateral * ethUsd) " loanAmount: " loanAmount)
  set reserveEth reserveEth + toCollect
  set interestPool interestPool - interestAmount
  set reserveAcd reserveAcd + interestAmount
  set collateral 0
  set color markColor
end

to buy-acd-from-reserve [amount]
  if reserveAcd - amount < 0 [ user-message (word "not enough Acd in reserve to buy acd. reserveAcd: " reserveAcd " amount:" amount "ACD")]
  set reserveEth reserveEth + (amount / ethUsd)
  set reserveAcd reserveAcd - amount
end

to buy-eth-from-reserve [amount]
  let ethValue amount / ethUsd
  if reserveEth - ethValue < 0 [ user-message (word "not enough Eth in reserve to sell acd. reserveEth: " reserveEth " amount:" amount "Acd ethValue:" ethValue "ETH")]
  set reserveEth reserveEth - (amount / ethUsd)
  set reserveAcd reserveAcd + amount
end

to intervene-buyAcd ; buy back from acd reserve with eth reserve
  let ethValue reserveConvertAmount / ethUsd
  if ethValue > reserveEth [
    user-message (word "not enough Eth in reserve. reserveEth: " reserveEth)
    stop
  ]
  set reserveEth reserveEth - ethValue
  set reserveAcd reserveAcd + reserveConvertAmount
  output-print (word "Tick #" ticks " - MANUAL INTERVENTION buyBackEth ethValue(sold): " ethValue "ETH reserveConvertAmount (bought): " reserveConvertAmount "ACD " )
  stop
end

to intervene-buyEth ;
   if reserveConvertAmount > reserveAcd [
    user-message (word "not enough ACD in reserve. reserveAcd: " reserveAcd)
    stop
  ]
  let ethValue reserveConvertAmount / ethUsd
  set reserveEth reserveEth + ethValue
  set reserveAcd reserveAcd - reserveConvertAmount
  output-print (word "Tick #" ticks " - MANUAL INTERVENTION buyBackEth ethValue(bought): " ethValue "ETH reserveConvertAmount(sold): " reserveConvertAmount "ACD " )
  stop
end

to read-ethUsdRates
  set ethUsdRates [
  0.753325
0.701897
0.708448
1.07
1.22
1.83
1.83
1.69
1.57
1.2
1.09
1.26
1.46
1.4
1.38
1.35
1.23
1.14
1.16
1.15
1.19
1.18
1.32
1.36
1.35
1.29
1.26
1.27
1.34
1.3
1.25
1.24
1.21
1.17
0.982978
1.04
0.936003
0.875622
0.94441
0.907175
0.874231
0.853685
0.882391
0.938445
0.919047
0.901796
0.893406
0.81361
0.736223
0.785964
0.720839
0.582886
0.661146
0.738644
0.690215
0.678574
0.687171
0.668379
0.628643
0.650645
0.609388
0.621716
0.650628
0.627857
0.634963
0.62603
0.607655
0.522968
0.561878
0.536495
0.547178
0.517734
0.489014
0.434829
0.447329
0.567702
0.539657
0.56359
0.616039
0.731317
0.869641
1
1.21
1.04
0.916627
1.06
0.989789
1.01
0.89905
0.895637
0.926032
0.927974
1.03
0.999278
0.934348
0.791829
0.895711
0.904096
0.888812
0.906368
0.928962
1.01
0.993319
0.955532
0.92492
0.97614
0.968018
0.946969
0.900191
0.863537
0.884183
0.867951
0.915703
0.878614
0.873119
0.8748
0.82121
0.812143
0.840041
0.862438
0.8355
0.811264
0.822118
0.792167
0.840396
0.929762
0.976973
0.952884
0.993022
1.01
0.991182
0.940701
0.920127
0.908072
0.903885
0.900771
0.864202
0.858077
0.863262
0.870363
0.854603
0.856365
0.845005
0.873054
0.911958
0.933542
0.948024
0.937124
0.971905
0.95448
0.950176
0.95086
0.942005
0.986789
0.986833
0.999231
1.06
1.14
1.13
1.19
1.21
1.22
1.33
1.43
1.37
1.53
1.55
1.5
1.97
2.14
2.5
2.28
2.39
2.53
2.49
2.45
2.31
2.21
2.44
2.53
2.58
2.54
2.53
2.96
3.18
4.04
4.44
6.01
5.55
5.39
5.24
5.29
4.32
3.76
4.4
4.74
4.34
4.65
5.62
5.59
6.24
6.1
5.92
6.43
6.47
6.34
7.65
8.47
9.29
10.41
11
11.38
9.55
9.85
11.9
11.3
11.08
13.53
14.47
12.45
13.01
12.52
11.08
11
10.53
10.32
11.86
11.27
12.42
11.23
10.74
10.97
10.42
11.67
11.66
11.95
11.4
11.66
11.6
11.62
11.16
10.44
10.69
10.07
9.72
9.15
8.94
8.64
7.44
8.04
8.39
8.24
8.61
9.31
9.04
8.71
8.47
8.1
7.82
8.29
8
7.55
7.4
7.76
7.17
7.46
8.81
8.85
10.16
9.31
9.41
9.83
9.35
9.37
9.48
9.3
9.36
10
10.06
10.51
10.24
9.96
11.17
12.2
13.56
14.77
13.64
14.02
14.29
13.46
12.73
12.53
12.43
11.3
11.89
12.35
12.73
14.08
14
13.74
13.85
13.74
13.97
13.93
14.51
14.42
14.4
13.91
14.19
15.74
17.6
18.89
18.35
20.59
15.38
11.33
12.23
11.84
13.31
13.1
13.68
14.33
14.28
13.85
13.88
12.18
12.61
12.46
12.2
12.13
11.72
11.47
10.61
10.53
10.11
11.39
10.97
10.95
10.46
10.52
10.5
11.51
11.95
11.65
11.16
11.03
11.62
12.45
12.65
14.66
14.3
12.75
13.84
11.99
12.97
12.84
12.79
12.46
11.88
10.94
8.79
10.29
11.04
10.93
10.88
10.91
11.25
12.24
12.14
11.69
11.78
11.57
11.19
11.22
11.14
10.75
10.76
10.75
11.25
11.18
11.12
11.03
11.04
11.36
11.3
11.15
10.93
10.98
11.23
11.67
11.99
12.11
11.76
11.68
11.72
11.69
11.55
11.35
11.65
12.17
11.64
11.89
11.92
11.92
11.94
12.56
12.7
12.43
13.19
14.43
13.77
13.25
13.33
12.88
13.1
12.82
13.1
13.27
13.07
13.22
13.17
13.2
13.45
13.28
13.04
12.85
12.67
12.22
12.05
11.76
11.79
11.93
11.96
11.94
11.98
11.95
12.01
12.59
12.02
12.1
12.18
12.07
12.04
11.97
11.41
11.53
11.5
11.09
10.44
11.18
11
10.77
10.75
10.8
11.09
11
10.87
10.81
10.83
10.66
10.52
10.29
9.88
10.1
9.97
10.22
10.06
9.99
9.48
9.66
9.58
9.62
9.91
9.84
9.23
9.4
9.33
9
8.72
8.17
8.59
8.45
7.76
7.92
7.44
6.82
7.87
8.38
8.23
8.45
8.13
8.19
8.52
8.42
8.27
7.83
7.86
7.88
7.87
7.64
7.66
7.91
7.58
7.17
7.27
7.18
7.27
7.17
7.52
8.28
8.16
7.97
8.17
8.38
9.73
11.25
10.25
10.25
9.87
10.29
10.33
10.55
9.72
9.86
9.77
9.65
9.9
9.64
10.3
10.23
10.4
10.6
10.91
10.7
10.82
10.63
10.57
10.59
10.54
10.56
10.48
10.57
10.73
10.73
10.82
11.11
11.43
11.35
11.39
11.52
11.43
11.03
11.28
11.35
11.4
11.27
13.03
12.92
12.9
12.68
12.81
12.76
12.43
12.67
12.6
13.12
13.07
13.55
14.52
15.4
15.82
17.35
19.03
19.46
18.62
19.3
19.61
18.89
16.65
17.75
19.33
21.47
23.44
28.59
28.65
35.06
46.35
46.83
34.16
44.74
43.39
43.15
42.34
43.68
53.11
51.25
50.52
49.67
50.77
53.13
52.21
50.04
50.7
48.75
44.36
44.64
45.3
43.24
42.16
44.31
43.27
43.44
43.41
46.29
50.22
47.57
49.1
48.72
48.3
50.71
48.31
49.67
48.22
48.55
48.49
50.03
49.89
52.72
62.17
70.16
68.38
79.02
76.3
77.26
79.72
96.98
94.4
97.81
94.01
91.42
91.16
89.52
89.88
88.66
90.84
90.79
92.41
89.44
89.86
96.91
129.53
126.52
157.94
174.26
181.95
190.05
174.45
160.4
157.76
170.51
194.91
231.91
230.67
222.24
223.78
224.38
245.33
248.46
264.47
258.07
261.67
281.74
337.67
340.61
401.49
397.54
359.05
361.93
370.23
379.41
371.46
370.06
359
336.87
336.37
341.74
323.7
303.25
272.69
293.09
327.93
302.88
294.92
274.6
287.99
282.9
273.3
268.77
270.55
245.99
251.7
242.14
215.36
197.4
230.77
209.73
199.66
170.66
157.36
193.42
234.39
199.7
227.26
218.31
229.48
225.95
224.71
206.71
203.95
204.32
193.12
205.79
197.98
203.87
226.77
219.95
225.34
223.07
256.51
261.57
269.18
296.77
296.03
295.89
308.86
310.6
298.06
300.1
289.82
302.27
301.46
295.59
297.47
301.43
321.59
314.79
317.52
325.61
331.92
333.88
347.89
347.75
370.67
378.49
383.04
387.74
348.98
347.48
295.17
312.99
334.34
329.43
296.5
294.4
288.75
294.53
291.46
277.11
213.91
250.46
246.52
251.75
293.5
282.8
283.74
258.58
264.31
286.17
282.48
292.33
287.44
306.47
299.15
291.47
301.46
302.34
297.48
292.46
292.66
295.86
308.59
311.12
308.61
297.39
299.87
303.46
304.14
338.76
339.63
336.6
333.38
317.08
314.32
308.09
304.01
300.19
295.45
286.95
298.33
297.93
296.53
297.42
296.3
305.09
307.75
305.88
291.69
287.43
305.71
300.47
296.26
298.89
294.66
309.07
320.88
299.25
314.68
307.91
316.72
337.63
333.36
330.92
332.39
347.61
354.39
366.73
360.4
380.65
410.17
474.91
466.28
471.33
480.36

  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
410
241
886
489
-1
-1
11.42
1
10
1
1
1
0
1
1
1
0
40
0
20
1
1
1
ticks
30.0

BUTTON
5
13
71
46
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
79
13
142
46
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
8
57
192
90
initReserveAcd
initReserveAcd
0
1000000
23669.0
1
1
NIL
HORIZONTAL

SLIDER
1
197
205
230
usdDepositMktInterestPt
usdDepositMktInterestPt
0
20
0.53
0.01
1
%
HORIZONTAL

SLIDER
0
237
204
270
acdDepositInterestPt
acdDepositInterestPt
0
30
8.73
0.01
1
%
HORIZONTAL

SLIDER
211
57
390
90
initEarnedInterest
initEarnedInterest
0
1000000
10000.0
1
1
NIL
HORIZONTAL

SLIDER
-1
278
205
311
depositTerm
depositTerm
0
100
20.0
1
1
NIL
HORIZONTAL

PLOT
893
10
1234
168
ACD
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"earnedInterest" 1.0 0 -13210332 true "" "plot earnedInterest"
"interestPool" 1.0 0 -7500403 true "" "plot interestPool"

PLOT
892
330
1247
494
ETH
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"reserveEth" 1.0 0 -16777216 true "" "plot reserveEth"
"totalCollateralEth" 1.0 0 -1664597 true "" "plot sum [collateral] of loans"

SLIDER
214
237
394
270
acdLoanInterestPt
acdLoanInterestPt
0
100
16.0
0.1
1
%
HORIZONTAL

SLIDER
214
279
395
312
loanTerm
loanTerm
0
100
15.0
1
1
NIL
HORIZONTAL

SLIDER
213
199
394
232
loanCollateralRatio
loanCollateralRatio
1
100
60.0
1
1
%
HORIZONTAL

SLIDER
277
12
398
45
endRatesIndex
endRatesIndex
1
843
843.0
1
1
NIL
HORIZONTAL

PLOT
409
10
884
235
ACd
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"totalLockedAcd" 1.0 0 -955883 true "" "plot totalLockedAcd"
"totalSupply" 1.0 0 -13210332 true "" "plot totalSupply"
"reserveAcd" 1.0 0 -7500403 true "" "plot reserveAcd"
"reserveEthInUsd" 1.0 0 -2674135 true "" "plot reserveEth * ethUsd"
"totalEthCollateralInUsd" 1.0 0 -6459832 true "" "plot (sum [collateral] of loans) * ethUsd"

SLIDER
211
95
391
128
forgottenLoanRate
forgottenLoanRate
0
100
0.5
0.1
1
%
HORIZONTAL

SLIDER
214
316
398
349
defaultingLoanFeePt
defaultingLoanFeePt
0
100
10.6
0.1
1
%
HORIZONTAL

SLIDER
212
159
393
192
maxLoanAmount
maxLoanAmount
0
100000
2000.0
1
1
NIL
HORIZONTAL

SLIDER
3
159
204
192
maxDepositAmount
maxDepositAmount
0
100000
1000.0
1
1
NIL
HORIZONTAL

INPUTBOX
18
334
167
394
reserveConvertAmount
10000.0
1
0
Number

BUTTON
6
397
184
430
Convert ETH to ACD in reserve
intervene-buyAcd
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
892
169
1238
329
ETH/USD
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"ethUsd" 1.0 0 -2674135 true "" "plot ethUsd"

SLIDER
10
96
193
129
initReserveEth
initReserveEth
0
10000
0.0
1
1
NIL
HORIZONTAL

SLIDER
226
414
398
447
chanceToSellAcd
chanceToSellAcd
0
100
50.0
0.1
1
%
HORIZONTAL

SLIDER
226
455
398
488
chanceToBuyAcd
chanceToBuyAcd
0
100
50.0
0.1
1
%
HORIZONTAL

TEXTBOX
224
395
374
413
Not working yet:
11
0.0
1

BUTTON
6
433
185
466
Convert ACD to ETH in reserve
intervene-buyEth
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
146
11
273
44
startRatesIndex
startRatesIndex
0
842
496.0
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
