;                                                                                                                                                                    SEA = 104
;                                                                                                                                                                    LAND = 62
;                                                                                                                                                                    LAVA = ORANGE
;                                                                                                                                                                    ROCKS = GREY
;                                                                                                                                                                    DESERT = 43
;                                                                                                                                                                    UI = BLACK
;                                                                                                                                                                    UI BORDER = 2

globals [health sticks a1 a2 chosen rocks toolcost gold tool elife dmg range worth1 delay waittime mxcor mycor sec min1 hour sec1 min2]
patches-own [pop pop2]
turtles-own [worth]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;SETUP
to setup
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;MAP MAKING
  ca
  ask patches [
    set pcolor 104
    set pop pcolor
    set pcolor black + 0.01
  ]
  while [count patches with [pop = 62] < 28000] [
    ask one-of patches with [pop = 104] [
      set pop 62
      ask patches in-radius (random 10 + 7) [
        set pop 62
      ]
    ]
  ]
  ask n-of 60 patches with [pop = 62] [
    set pop grey
    ask patches in-radius 4 with [pop = 62] [
      set pop grey
    ]
  ]
  ask n-of 10 patches with [pop = grey] [
    ask patches in-radius (random 5 + 8) with [pop != 104 and pop != orange] [
      set pop grey
    ]
  ]
  ask n-of 10 patches with [pop = 62] [
    set pop orange 
    ask patches in-radius (random 3 + 3) with [pop = 62 or pop = grey] [
      set pop orange
    ]
  ]
  ask patches with [pop = orange] [
    if count neighbors4 with [pop = 104] > 0 [
      set pop grey
    ]
  ]
  ask n-of 10 patches with [pop = 62] [
    set pop 43
    ask patches in-radius (random 10 + 7) with [pop = 62] [
      set pop 43
    ]
  ]
  ask n-of 50 patches with [count patches in-radius 3 with [pop != grey] = 0] [
    set pop yellow
  ]
  ask one-of patches with [pop = grey] [
    set pop 104
    ask neighbors [
      set pop yellow
    ]
  ]
  ask n-of 3 patches with [pop = 62] [
    ask neighbors [
      ask neighbors [
        set pop grey
      ]
    ]
    set pop brown
    ask neighbors [
      set pop brown
    ]
    ask one-of patches in-radius 2 with [pop = grey] [
      set pop brown
    ]
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;BUTTONS, ETC.
  ask patches with [pxcor < -131] [
    set pcolor black
    set pop pcolor
  ]
  ask patches with [pxcor = -131] [
    set pcolor 2
    set pop pcolor
  ]
  ask patches with [pycor < -45 and pxcor > 126] [
    set pcolor 2
    set pop pcolor
  ]
  ask patches with [pycor < -46 and pxcor > 127] [
    set pcolor black
    set pop pcolor
  ]
  ask patches with [pycor = 38 and pxcor <= -131] [
    set pcolor 2
    set pop pcolor
  ]
  ask patches with [pycor = -55 and pxcor <= -131] [
    set pcolor 2
    set pop pcolor
  ]
  ask patches with [pycor = 67] [
    set pcolor 2
    set pop pcolor
  ]
  ask patches with [pxcor <= -133 and pycor <= 36 and pycor >= 30 and pxcor > -150] [
    set pcolor white
    set pop pcolor
    set pcolor lime
  ]
  ask patches with [pxcor <= -133 and pycor <= 28 and pycor >= 22 and pxcor > -150] [
    set pcolor white + 0.01
    set pop pcolor
  ]
  ask patches with [pxcor <= -133 and pycor <= 20 and pycor >= 14 and pxcor > -150] [
    set pcolor pink
    set pop pcolor
  ]
  ask patches with [pxcor < -131 and pycor <= 6 and pycor >= 3] [
    set pcolor black + 0.015
    set pop pcolor
  ]
  ask patches with [pxcor < -131 and pycor <= 2 and pycor >= 0] [
    set pcolor black + 0.02
    set pop pcolor
  ]
  ask patches with [pxcor < -131 and pycor <= -1 and pycor >= -3] [
    set pcolor black + 0.025
    set pop pcolor
  ]
  ask patches with [pxcor < -131 and pycor <= -4 and pycor >= -6] [
    set pcolor black + 0.03
    set pop pcolor
  ]
  ask patches with [pxcor < -131 and pycor <= -7 and pycor >= -9] [
    set pcolor black + 0.035
    set pop pcolor
  ]
  ask patches with [pxcor < -131 and pycor <= -10 and pycor >= -12] [
    set pcolor black + 0.04
    set pop pcolor
  ]
  ask patches with [pxcor < -131 and pycor <= -13 and pycor >= -15] [
    set pcolor black + 0.045
    set pop pcolor
  ]
  ask patches with [pxcor < -131 and pycor <= -16 and pycor >= -18] [
    set pcolor black + 0.05
    set pop pcolor
  ]
  ask patches with [pxcor >= 130 and pycor = 60] [
    set pcolor 2
    set pop pcolor
  ]
  ask patches with [pxcor = 130 and pycor >= 60] [
    set pcolor 2
    set pop pcolor
  ]
  ask patches with [pxcor > 130 and pycor > 60] [
    set pcolor black
    set pop pcolor
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;TREES
  ask n-of 200 patches with [pop = 62] [
    sprout 1 [
      set shape "tree"
      set color lime
      set size 3
      ht
    ]
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PLAYER
  crt 1 [
    set shape "turtle"
    set color white
    while [pop = 104 or pop = grey or pop = orange or pop = black or pop = 2] [
      setxy random-xcor random-ycor
    ]
    set size 5
    set heading 0
    let name user-input "Name your turtle."
    set label name
    set label-color black
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;ENEMIES
  set worth1 2
  set elife 5
  crt 5 [
    set shape "enemy"
    set size 4.5
    setxy random-xcor random-ycor
    while [pop = 104 or pop = grey or pop = orange or pop = black or pop = 2 or xcor <= -131] [
      setxy random-xcor random-ycor
    ]
    set heading 0
    set label elife
    set label-color black
    set worth label
    ht
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;MOUSE AIM
  set elife 8
  crt 1 [
    set shape "aim"
    set size 3.5
    set color red
    set heading 0
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;MOUSE LABELMAKER
  crt 1 [
    set size 0.0000000001
    set heading 0
  ]
  ask patches [
    set pop2 pop
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;GLOBALS
  set health 10
  set a1 ""
  set a2 ""
  set toolcost 6
  set gold 10
  set tool 0
  set range 15
  set dmg 1
  set delay 1
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;TREES IN RADIUS FOR EMERGANCIES
  ask turtles with [shape = "turtle"] [
    ask n-of 5 patches in-radius 7 with [pop != 104 and pop != grey and pxcor > -131 and pop != orange] [
      sprout 1 [
        set shape "tree"
        set color lime
        set size 3
        ht
      ]
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;GO
to go
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;SETUP
  while [count turtles = 0] [
    setup
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;DISCOVERING MAP
  ask turtles with [shape = "turtle"] [
    ask patches in-radius 7 [
      if pcolor != lime and pcolor != brown [
        set pcolor pop
      ]
    ]
    ask turtles in-radius 7 [
      st
    ]
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;MOUSE FOLLOWING
  ask turtles with [shape = "aim"] [
    setxy mouse-xcor mouse-ycor
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;INFO
  ask patch -133 44 [
    set plabel word "Health- " health
    set plabel-color green
  ]
  ask patch -133 11 [
    set plabel "GOLD-"
    set plabel-color yellow
  ]
  ask patch -133 8 [
    set plabel gold
    set plabel-color yellow
  ]
  ask patch -133 40 [
    set plabel word "Found- " word round ((count patches with [pcolor != black + 0.01 and pop != black and pop != 2] / 37407) * 100) "%"
    set plabel-color violet
  ]  
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;DEATH RED PATCHES
  if health <= 0 [
    ask patches [
      set pcolor red
      set plabel ""
      ask patch 0 0 [
        set plabel "YOU DIED!"
        set plabel-color black
      ]
      ask turtles with [shape = "tree" or shape = "turtle" or shape = "enemy" or shape = "aim" or shape = "default"] [
        die
      ]
    ]
    ifelse user-yes-or-no? "Restart?" = true [
      setup
    ]
    [
      ca
      stop
    ]
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;TURTLES HIDING
  ask turtles with [shape != "aim" and shape != "default"] [
    ifelse pcolor = black + 0.01 [
      ht
    ]
    [
      st
    ]
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;DIFFERENT PROCEDURES
  choosematerial
  LvlUpTool
  wiggle
  shoot
  enemyspawn
  enemyattack
  ExplainGains
  gametime
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;INFO
  ask patch -134 -61 [
    set plabel a1
  ]
  ask patch -134 -65 [
    set plabel a2
  ]
  ask patch -134 -57 [
    set plabel "UPDATES-"
  ]
  ask patch -132 4 [
    ifelse tool > 0 [
      set plabel "AXE"
      set plabel-color blue
    ]
    [
      set plabel "?"
      set plabel-color blue
    ]
  ]
  ask patch -132 1 [
    ifelse tool > 1 [
      set plabel "PICKAXE"
      set plabel-color blue
    ]
    [
      set plabel "?"
      set plabel-color blue
    ]
  ]
  ask patch -132 -2 [
    ifelse tool > 2 [
      set plabel "HARD THROW"
      set plabel-color blue
    ]
    [
      set plabel "?"
      set plabel-color blue
    ]
  ]
  ask patch -132 -5 [
    ifelse tool > 3 [
      set plabel "DRILL"
      set plabel-color blue
    ]
    [
      set plabel "?"
      set plabel-color blue
    ]
  ]
  ask patch -132 -8 [
    ifelse tool > 4 [
      set plabel "STEEL"
      set plabel-color blue
    ]
    [
      set plabel "?"
      set plabel-color blue
    ]
  ]
  ask patch -132 -11 [
    ifelse tool > 5 [
      set plabel "100 mph"
      set plabel-color blue
    ]
    [
      set plabel "?"
      set plabel-color blue
    ]
  ]
  ask patch -132 -14 [
    ifelse tool > 6 [
      set plabel "DIAMOND"
      set plabel-color blue
    ]
    [
      set plabel "?"
      set plabel-color blue
    ]
  ]
  ask patch -132 -17 [
    ifelse tool > 7 [
      set plabel "SLEEK SPEAR"
      set plabel-color blue
    ]
    [
      set plabel "?"
      set plabel-color blue
    ]
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;TIMER
  ifelse sec < 10 [
    set sec1 word "0" sec
  ]
  [
    set sec1 sec
  ]
  ifelse min1 < 10 [
    set min2 word "0"min1
  ]
  [
    set min2 min1
  ]
  ask patch 149 64 [
    set plabel word hour word " : " word min2 word " : " sec1
    set plabel-color white
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;WEAPON DELAY
  every 0.1 [
    if waittime > 0 [
      set waittime waittime - 0.1
    ]
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;MOUSE LABELMAKER FOLLOWING
  ask turtles with [shape = "aim"] [
    set mxcor xcor
    set mycor ycor
  ]
  ask turtles with [shape = "default"] [
    ifelse mxcor + 35 >= 150 [
      setxy mxcor mycor
    ]
    [
      setxy (mxcor + 35) mycor
    ]
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;UPGRADE BUTTON LABELS
  ask patch -134 35 [
    set plabel "STICKS-"
    set plabel-color black
  ]
  ask patch -134 32 [
    set plabel sticks
    set plabel-color black
  ]
  ask patch -134 27 [
    set plabel "ROCKS-"
    set plabel-color black
  ]
  ask patch -134 24 [
    set plabel rocks
    set plabel-color black
  ]
  ask patch -133 19 [
    set plabel "NEW ABILITY"
    set plabel-color black
  ]
  ask patch -134 16 [
    set plabel toolcost
    set plabel-color black
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;FORWARD
to fd1
  ask turtles with [shape = "turtle"] [
    set heading 0
    fd 1
    if pcolor = grey or pcolor = 104 or pcolor = black or pcolor = 2 or pcolor = yellow [
      bk 1
    ]
    if pcolor = orange [
      bk 2
      set health health - 1
      set a2 a1
      set a1 "-1 Health"
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;RIGHT
to rt1
  ask turtles with [shape = "turtle"] [
    set heading 90
    fd 1
    if pcolor = grey or pcolor = 104 or pcolor = black or pcolor = 2 or pcolor = yellow [
      bk 1
    ]
    if pcolor = orange [
      bk 2
      set health health - 1
      set a2 a1
      set a1 "-1 Health"
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;LEFT
to lt1
  ask turtles with [shape = "turtle"] [
    set heading 270
    fd 1
    if pcolor = grey or pcolor = 104 or pcolor = black or pcolor = 2 or pcolor = yellow [
      bk 1
    ]
    if pcolor = orange [
      bk 2
      set health health - 1
      set a2 a1
      set a1 "-1 Health"
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;BACK
to bk1
  ask turtles with [shape = "turtle"] [
    set heading 180
    fd 1
    if pcolor = grey or pcolor = 104 or pcolor = black or pcolor = 2 or pcolor = yellow [
      bk 1
    ]
    if pcolor = orange [
      bk 2
      set health health - 1
      set a2 a1
      set a1 "-1 Health"
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;TAKE
to take
  ask turtles with [shape = "turtle"] [
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;TREES
    if any? turtles with [shape = "tree"] in-radius 2 and tool > 0 [
      ask one-of turtles with [shape = "tree"] in-radius 2 [
        set sticks sticks + 1
        set a2 a1
        set a1 "+1 Stick"
        die
      ]
    ]
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;ROCKS
    fd 1
    ifelse pcolor = grey and tool > 1 [
      set pcolor 62
      set rocks rocks + 1
      set a2 a1
      set a1 "+1 Rock"
      ask patch-here [
        ifelse pop2 != grey [
          set pcolor pop2
          set pop pop2
        ]
        [
          set pop 62
        ]
      ]
      bk 1
    ]
    [
      bk 1
    ]
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PLACED STICKS
    fd 1
    ifelse pcolor = brown and tool > 0 [
      ifelse pop != brown [
        set pcolor pop
        set sticks sticks + 1
        set a2 a1
        set a1 "+1 Stick"
        bk 1
      ]
      [
        set pop 62
        set pcolor pop
        set sticks sticks + 1
        set a2 a1
        set a1 "+1 Stick"
        bk 1
      ]
    ]
    [
      bk 1
    ]
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;GOLD
    fd 1
    ifelse pcolor = yellow and tool > 3 [
      set pop 62
      let z random 2 + 1
      set gold gold + z
      set a2 a1
      set a1 word "+" word z " Gold"
      bk 1
    ]
    [
      bk 1
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;USE MATERIAL
to use
  ask turtles with [shape = "turtle"] [
    fd 1
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;STICKS
    if chosen = 0 [
      ifelse pcolor != grey and pcolor != orange and pcolor != black and sticks > 0 and pcolor != 2 and pcolor != brown [
        set pcolor brown
        bk 1
        set sticks sticks - 1
      ]
      [
        bk 1
      ]
    ]
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;ROCKS
    if chosen = 1 [
      ifelse pcolor != grey and pcolor != orange and pcolor != black and rocks > 0 and pcolor != 2 [
        set pcolor grey
        ask patch-here [
          set pop grey
        ]
        bk 1
        set rocks rocks - 1
      ]
      [
        bk 1
      ]
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;CHOOSING MATERIAL
to choosematerial
  ask patch mouse-xcor mouse-ycor [
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;STICKS
    if pcolor = white and mouse-down? [
      ask patches with [pcolor = lime] [
        set pcolor pop
      ]
      ask patches with [pcolor = white] [
        set pcolor lime
      ]
      set chosen 0
    ]
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;ROCKS
    if pcolor = white + 0.01 and mouse-down? [
      ask patches with [pcolor = lime] [
        set pcolor pop
      ]
      ask patches with [pcolor = white + 0.01] [
        set pcolor lime
      ]
      set chosen 1
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;SAVING GAME
to save
  if user-yes-or-no? "Do you want to save your game?" = true [
    export-world user-new-file
    user-message "Game saved."
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;IMPORTING SAVE
to open-save
  if user-yes-or-no? "Do you want to import a save file?" = true [
    import-world user-file
    user-message "Save imported. If you have not done so, press PLAY to begin."
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;LEVEL UP TOOL
to LvlUpTool
  ask patch mouse-xcor mouse-ycor [
    if pcolor = pink and mouse-down? [
      ifelse toolcost <= gold [
        set gold gold - toolcost
        set toolcost ((toolcost * 2) + 5)
        set tool tool + 1
        set a2 a1
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;AXE
        if tool = 1 [
          set a1 "+ Axe"
        ]
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PICKAXE
        if tool = 2 [
          set a1 "+ Pickaxe"
        ]
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;HARD THROW
        if tool = 3 [
          set a1 "+ Hard Throw"
          set range 20
          set delay 0.8
        ]
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;DRILL
        if tool = 4 [
          set a1 "+ Drill"
        ]
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;STEEL
        if tool = 5 [
          set a1 "+ Steel"
          set dmg 2
        ]
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;100 MPH
        if tool = 6 [
          set a1 "+ 100 mph"
          set delay 0.6
        ]
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;DIAMOND
        if tool = 7 [
          set a1 "+ Diamond"
          set dmg 3
        ]
        ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;SLEEK SPEAR
        if tool = 8 [
          set a1 "+ Sleek Spear"
          set range 35
        ]
        wait 0.5
      ]
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;IF NOT ENOUGH MONEY
      [
        user-message "You need more gold!"
      ]
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;ENEMY WIGGLE
to wiggle
  every 0.09 [
    ask turtles with [shape = "enemy"] [
      if any? turtles in-radius 15 with [shape = "turtle"] [
        face one-of turtles in-radius 15 with [shape = "turtle"]
      ]
      fd 0.4
      ifelse pop2 = grey or pop2 = 104 or pop2 = black or pop2 = 2 or pop2 = orange or pop2 = yellow [
        bk 1
        rt 90
      ]
      [
        rt random 91 - 45
      ]
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;SHOOT
to shoot
  ask patch mouse-xcor mouse-ycor [
    if mouse-down? and pcolor != black + 0.01 and pcolor != black and pcolor != 2 and pcolor != lime and pcolor != white and pcolor != white + 0.01 and pcolor != pink and waittime <= 0 [
      ask turtles with [shape = "turtle"] [
        hatch 1 [
          set shape "spear"
          set size 3
          facexy mouse-xcor mouse-ycor
          set label ""
          set waittime delay
          repeat range [
            wait 0.01
            fd 0.5 
            if pcolor = grey or pcolor = black + 0.01 or pcolor = black or pcolor = 2 [
              die
            ]
            if any? turtles in-radius 2 with [shape = "enemy"] [
              ask turtles in-radius 2 with [shape = "enemy"] [
                set label label - dmg
              ]
              die
            ]
          ]
          die
        ]
      ]
    ]
  ]
  
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;SPAWNING ENEMIES
to enemyspawn
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;IF NOT ENOUGH ENEMIES, CREATE MORE
  if count turtles with [shape = "enemy"] <= 5 [
    crt 1 [
      set shape "enemy"
      set size 4.5
      setxy random-xcor random-ycor
      ifelse count patches with [pcolor = black + 0.01 and pop2 != 104] > 0 [
        while [pop = 104 or pop = grey or pop = orange or pop = black or pop = 2 or pcolor != black + 0.01 or xcor <= -131] [
          setxy random-xcor random-ycor
        ]
      ]
      [
        while [pop = 104 or pop = grey or pop = orange or pop = black or pop = 2 or xcor <= -131] [
          setxy random-xcor random-ycor
        ]
      ]
      set heading 0
      set label elife
      set label-color black
      set worth label
      ht
      set elife elife + 3
    ]
  ]
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;ENEMY DEATHS AND GAINS
  ask turtles with [shape = "enemy"] [
    if label <= 0 [
      set gold gold + round (worth / 3)
      set a2 a1
      set a1 word "+" word round (worth / 3) " Gold"
      let y random 2
      if y > 0 [
        set health health + y
        set a2 a1
        set a1 word "+" word y " Health"
      ]
      die
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;ENEMY ATTACKING YOU
to enemyattack
  ask turtles with [shape = "enemy"] [
    if any? turtles in-radius 2 with [shape = "turtle"] [
      set health health - round (label / 2)
      set a2 a1
      set a1 word "-" word round (label / 2) " Health"
      bk 2
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;EXPLAIN GAINS
to explainGains
  ask patch mouse-xcor mouse-ycor [
    ifelse pcolor = 0.015 or pcolor = 0.02 or pcolor = 0.025 or pcolor = 0.03 or pcolor = 0.035 or pcolor = 0.04 or pcolor = 0.045 or pcolor = 0.05 [
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;AXE
      if pcolor = 0.015 [
        ask turtles with [shape = "default"] [
          ifelse tool > 0 [
            set label "Ability to mine wood and trees."
          ]
          [
            set label "?                                         "
          ]
        ]
      ]
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;PICKAXE
      if pcolor = 0.02 [
        ask turtles with [shape = "default"] [
          ifelse tool > 1 [
            set label "Ability to mine stone.            "
          ]
          [
            set label "?                                         "
          ]
        ]
      ]
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;HARD THROWS
      if pcolor = 0.025 [
        ask turtles with [shape = "default"] [
          ifelse tool > 2 [
            set label "Less delay and better range"
          ]
          [
            set label "?                                         "
          ]
        ]
      ]
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;DRILL
      if pcolor = 0.03 [
        ask turtles with [shape = "default"] [
          ifelse tool > 3 [
            set label "Ability to mine gold blocks  "
          ]
          [
            set label "?                                         "
          ]
        ]
      ]
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;STEEL
      if pcolor = 0.035 [
        ask turtles with [shape = "default"] [
          ifelse tool > 4 [
            set label "Steel spearhead, more damage"
          ]
          [
            set label "?                                         "
          ]
        ]
      ]
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;100 MPH
      if pcolor = 0.04 [
        ask turtles with [shape = "default"] [
          ifelse tool > 5 [
            set label "Less delay                            "
          ]
          [
            set label "?                                         "
          ]
        ]
      ]
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;DIAMOND
      if pcolor = 0.045 [
        ask turtles with [shape = "default"] [
          ifelse tool > 6 [
            set label "Diamond-tipped spear, more damage"
          ]
          [
            set label "?                                         "
          ]
        ]
      ]
      ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;SLEEK SPEAR
      if pcolor = 0.05 [
        ask turtles with [shape = "default"] [
          ifelse tool > 7 [
            set label "Less air resistance = more range"
          ]
          [
            set label "?                                         "
          ]
        ]
      ]
    ]
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;BLANK LABEL
    [
      ask turtles with [shape = "default"] [
        set label ""
      ]
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;TIMER
to gametime
  every 1 [
    set sec sec + 1
    if sec = 60 [
      set min1 min1 + 1
      set sec 0
      if min1 = 60 [
        set hour hour + 1
        set min1 0
      ]
    ]
  ]
end





































@#$#@#$#@
GRAPHICS-WINDOW
8
10
1523
716
150
67
5.0
1
14
1
1
1
0
0
0
1
-150
150
-67
67
0
0
1
ticks
30.0

BUTTON
8
10
109
43
PLAY/PAUSE
go
T
1
T
OBSERVER
NIL
P
NIL
NIL
1

BUTTON
8
43
109
76
RESET
ca
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
1433
610
1488
643
Forward
fd1
NIL
1
T
OBSERVER
NIL
W
NIL
NIL
1

BUTTON
1461
643
1516
676
Right
rt1
NIL
1
T
OBSERVER
NIL
D
NIL
NIL
1

BUTTON
1406
643
1461
676
Left
lt1
NIL
1
T
OBSERVER
NIL
A
NIL
NIL
1

BUTTON
1433
676
1488
709
Back
bk1
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

BUTTON
8
109
109
142
TAKE (;)
take
NIL
1
T
OBSERVER
NIL
;
NIL
NIL
1

BUTTON
8
76
109
109
USE (')
use
NIL
1
T
OBSERVER
NIL
'
NIL
NIL
1

BUTTON
109
10
172
43
Save
save
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
172
10
272
43
Import Save
open-save
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

aim
false
0
Circle -2674135 false false 15 15 270
Circle -2674135 false false 105 105 88
Line -2674135 false 300 150 0 150
Line -2674135 false 150 0 150 300
Line -2674135 false 105 105 120 120
Line -2674135 false 105 195 120 180
Line -2674135 false 195 105 180 120
Line -2674135 false 195 195 180 180

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -2674135 false false -1 -1 301

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

enemy
false
0
Polygon -2674135 true false 105 75 90 60 105 30 105 60 135 75
Polygon -2674135 true false 195 75 210 60 195 30 195 60 165 75
Polygon -13840069 true false 165 60 135 60 105 75 90 105 90 135 105 165 135 180 165 180 195 165 210 135 210 105 195 75
Polygon -13840069 true false 195 75 240 105 255 150 270 165 270 180 240 180 240 165 240 150 225 120 210 120
Polygon -13840069 true false 105 75 60 105 45 150 30 165 30 180 60 180 60 165 60 150 75 120 90 120
Circle -1 true false 105 75 30
Circle -1 true false 165 75 30
Circle -16777216 true false 172 84 16
Line -16777216 false 176 71 156 81
Line -16777216 false 124 71 144 81
Circle -16777216 true false 112 84 16
Polygon -1 true false 120 150 135 135 165 135 180 150 120 150
Line -16777216 false 135 135 135 150
Line -16777216 false 135 150 150 135
Line -16777216 false 150 135 165 150
Line -16777216 false 165 150 165 135
Polygon -16777216 false false 135 135 120 150 180 150 165 135
Circle -10899396 true false 141 111 18
Polygon -13840069 true false 180 150 195 165 195 195 210 195 210 210 165 210 165 180 150 165
Polygon -13840069 true false 120 150 105 165 105 195 90 195 90 210 135 210 135 180 150 165

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

spear
true
1
Rectangle -6459832 true false 135 45 150 300
Polygon -7500403 true false 135 45 130 28 142 2 156 29 150 45

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
