globals [
  days            ;; a list of the dates of all 365 days in the year
  successes       ;; how many ticks had at least one duplicate birthday
  lysuccesses
]

turtles-own [
  birthday        ;; this turtle's birthday as a number from 0 to 364
  lybirthday      ;; this turtle's birthday as a number from 0 to 365
]

to setup
  clear-all
  set successes 0
  ;; create lists of each month and the number of days in each month
  ;; then iterate through the two lists and expand into a single list
  ;; of every day of the year
  let months ["January" "February" "March" "April" "May" "June" "July"
              "August" "September" "October" "November" "December"]
  let month-lengths [31 28 31 30 31 30 31 31 30 31 30 31]
  ;; now build up the list of all the day names in the year
  set days []
  ;; sets ?1 equal each month name and ?2 to the number of days in that month
  (foreach months month-lengths
  [ ;; use "sentence" to repeatedly glue lists together, so we wind
    ;; up with one big list
    set days (sentence days make-month ?1 ?2)
  ])
  reset-ticks
end

to leapyear
    clear-all
  set successes 0
  ;; create lists of each month and the number of days in each month
  ;; then iterate through the two lists and expand into a single list
  ;; of every day of the year
  let months ["January" "February" "March" "April" "May" "June" "July"
              "August" "September" "October" "November" "December"]
  let month-lengths [31 29 31 30 31 30 31 31 30 31 30 31]
  ;; now build up the list of all the day names in the year
  set days []
  ;; sets ?1 equal each month name and ?2 to the number of days in that month
  (foreach months month-lengths
  [ ;; use "sentence" to repeatedly glue lists together, so we wind
    ;; up with one big list
    set days (sentence days make-month ?1 ?2)
  ])

  reset-ticks
end


;; this procedure generates all of the day names within a month
to-report make-month [month month-length]
  ;; use n-values to generate a list of the numbers from 1 to
  ;; the end of the month
  let day-numbers n-values month-length [? + 1]
  ;; now glue onto the month name each number
  report map [(word month " " ?)] day-numbers
end

to go
  ;; kill off the turtles from the last round
  clear-turtles
  ;; populate the room with new turtles
  make-turtles
  ;; arrange the turtles in order by birthday
  sort-turtles
  ;; turn turtles with matching birthdays green
  show-matches
  ;; keep track of cumulative results
  if any? turtles with [color = green]
    [ set successes successes + 1 ]
  if any? turtles with [color = red]
    [ set lysuccesses lysuccesses + 1 ]
  tick
end

to make-turtles
  ;; ask the patches along the right edge of the world
  ;; to each sprout a turtle
  ask patches with [pxcor = max-pxcor]
  [
    sprout 1
    [
      set heading 90
      set color blue + 3
      ;; pick a random birthday (a number from 0 to 364)
      set birthday random length days
      ;; we use "word" to add some spaces onto the end
      ;; of the turtle's labels, otherwise the label
      ;; would visually overlap the turtle.  ITEM
      ;; is used to look up our day name in the list
      ;; of all day names.
       set label word (item birthday days) "        "
      set lybirthday 60
     ]
   ]
end

to sort-turtles
  ;; sort-by takes an agentset and returns a sorted list
  let sorted sort-on [birthday] turtles
  ;; finally, we position each turtle according to its position
  ;; in the sorted list
  ask turtles
    [ set ycor max-pycor - position self sorted ]
end

to show-matches
  ;; if there are any turtles with the same birthday
  ;; show it.
  ask turtles
    [ if any? other turtles with [birthday = [birthday] of myself]
        [ set color green
          set label-color green ] ]
  ask turtles
    [ if any? other turtles with [birthday = [lybirthday] of myself]
        [ set color red
          set label-color red ] ]
end


; Copyright 2004 Uri Wilensky.
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
152
10
432
731
4
11
30.0
1
16
1
1
1
0
0
1
1
-4
4
-11
11
1
1
1
ticks
2.0

BUTTON
25
105
123
138
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
25
35
123
68
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
20
145
129
190
success rate
word\n  (precision\n    (successes / ticks * 100)\n    1)\n  \"%\"
1
1
11

BUTTON
25
70
123
103
go once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
439
15
604
48
setup with Leap Years
leapyear
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
457
54
588
99
February 29th Rate
word\n  (precision\n    (lysuccesses / ticks * 100)\n    1)\n  \"%\"
17
1
11

@#$#@#$#@
## WHAT IS IT?

In a room of 23 people, what are the chances that some two of them will have the same birthday?

Make your best guess, then run the model and see how often it happens.

## HOW IT WORKS

Each turtle is randomly assigned a birthday.  If a turtle has the same birthday as another turtle in the room, it turns green.

The model doesn't take leap years into account (there are no February 29th birthdays).

## HOW TO USE IT

Press SETUP to initialize the model.

Press GO ONCE to generate a single room full of people.

Press GO to repeatedly generate many rooms full of people.  The SUCCESS RATE monitor will show what percentage of those rooms had at least one matching birthday.

## THINGS TO NOTICE

Is the success rate higher or lower than you expected?

## THINGS TO TRY

To try a room with more people in it, edit the view and increase max-pycor.

How many people need to be in the room before the chance of a matching birthday is at least 90%?  (Is this higher or lower than you expected?)

Can you work out mathematically what the odds should be?  (Hint: start by considering the odds when the number of people is small.)

## EXTENDING THE MODEL

Include leap year birthdays in the list of possibilities.

## REFLECTION

The change that I was able to make from exploring the model was that I was able to get the program to keep track of the rate at which someone in a room of 24 people will have a birthday on the 60th day of the year, if every year was a leap year. What I learned from exploring this model that conditional probability is hard to program when taken outside of a purely math context. Applying it physically within the realm of this program was much more difficult that I thought it would be, but it also allowed me to look at the step by step process through which conditional probabilities are calculated. I also thought it was an interesting representation of a phenomenon that most people would not think to be as common as it actually is. However, in my exprience this "birthday" phenomenon has happened on more than one occasion and probably more often than I will ever know.

## NETLOGO FEATURES

This model uses lists a lot, including list primitives such as `map`, `foreach`, `item`, `position`, `sentence`, and `sort-by`.  Lists are used mostly to make the model display actual day names, instead of just numbers from 0 to 364.  Lists are also used when sorting the turtles by birthday.

## RELATED MODELS

The ProbLab suite of models, in the Mathematics/Probability section, contains many explorations of basic questions about probability and statistics.

## HOW TO CITE

If you mention this model or the NetLogo software in a publication, we ask that you include the citations below.

For the model itself:

* Wilensky, U. (2004).  NetLogo Birthdays model.  http://ccl.northwestern.edu/netlogo/models/Birthdays.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

Please cite the NetLogo software as:

* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

## COPYRIGHT AND LICENSE

Copyright 2004 Uri Wilensky.

![CC BY-NC-SA 3.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Uri Wilensky at uri@northwestern.edu.

This model was created as part of the projects: PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT. The project gratefully acknowledges the support of the National Science Foundation (REPP & ROLE programs) -- grant numbers REC #9814682 and REC-0126227.

<!-- 2004 -->
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.2.1
@#$#@#$#@
setup
go
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
